<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<style>
  #page-wrap { width: 100%;margin: 0 auto;padding: 20px; }

  textarea { border: 0; font: 14px Georgia, Serif; overflow: hidden; resize: none; }
  table { border-collapse: collapse; }
  table td, table th { border-bottom: 1px solid #cecece!important;border:none; padding:15px 10px; color: #333;font-size: 14px;}

  #header { 
    height: 50px;
    width: 100%;
    margin: 20px 0;
    background: #e60003;
    text-align: center;
    color: white;
    font: bold 15px Helvetica, Sans-Serif;
    text-decoration: uppercase;
    letter-spacing: 3px;
    padding: 14px;
    font-size: 20px;
  }
  #header1 {
    height: 35px;
    width: 100%;
    margin: 20px 0;
    background: #eee;
    text-align: center;
    color: black;
    font: normal 15px Helvetica, Sans-Serif;
    text-decoration: uppercase;
    letter-spacing: 3px;
    padding: 8px;
    font-size: 16px;
}

  #address { width: 250px; height: 150px; float: left; }
  #customer { overflow: hidden; }

  #logo { text-align: center; position: relative; margin: 25px auto; border: 1px solid #fff; max-width: 540px; max-height: 100px; overflow: hidden; }
  #logo img{width:100%;}
  #student-img-wrap{
    font-size: 20px;
    font-weight: bold;
    float: left;
    border: 1px solid #cecece;
    margin-right: 20px;
  }
  #customer-title {font-size: 20px; font-weight: bold; float: left;}

  #meta { margin-top: 1px; width: 400px; float: right; }
  #meta td { text-align: right;  }
  #meta td.meta-head { 
    text-align: left;
    font-weight: 600;
    font-size: 16px;
    padding-bottom: 16px;
    padding-top: 10px; 
  }
  #meta td textarea { width: 100%; height: 20px; text-align: right; }
  .fz-14{
    font-size:14px;
  }

  #items { clear: both; width: 100%; margin: 30px 0 0 0; border: 1px solid #cecece; }
  #items th { 
    background: #eeeeee;
    padding: 15px 10px;
    color: #000;
    font-size: 14px;
    text-transform: uppercase;
    font-weight: 600;
    border: 1px solid #cecece;
    border-bottom: 1px solid #cecece!important;
    width: 50%;
  }
  #items textarea { width: 80px; height: 50px; }
  #items tr.item-row td { border: 0; vertical-align: top; }
  #items td.description { width: 300px; }
  #items td.item-name { width: 175px; }
  #items td.description textarea, #items td.item-name textarea { width: 100%; }
  #items td.total-line { border-right: 0; text-align: right; }
  #items td.total-value { border-left: 0; padding: 10px; }
  #items td.total-value textarea { height: 20px; background: none; }
  #items td.balance { background: #eee; }
  #items td.blank { border: 0; }

  #terms { text-align: center; margin: 20px 0 0 0; }
  #terms h5 { text-transform: uppercase; font: 13px Helvetica, Sans-Serif; letter-spacing: 10px; border-bottom: 1px solid black; padding: 0 0 8px 0; margin: 0 0 8px 0; }
  #terms textarea { width: 100%; text-align: center;}

  textarea:hover, textarea:focus, #items td.total-value textarea:hover, #items td.total-value textarea:focus, .delete:hover { background-color:#EEFF88; }
  .grade-table{
    border: 2px dashed #76c06c!important;
    margin: 0!important;
  }
  .grade-table th{
    text-align:center;
    background: #fff0d0!important;
  }
  .grade-table td{
    text-align:center;
    width: 50%;
    background: #fffaee;
  }
  @media only screen and (max-width: 600px) {
    #header { 
      font-size:14px;
    }
    #student-img-wrap{
      float: none;
    margin: 0 auto;
    text-align: center;
    }
    #meta {
      width: 100%;
    }
  }
  @media print {
    .panel_s .panel-body{padding:0!important;}
    #page-wrap{padding:10px!important;}
    #logo{margin: 5px auto!important;}
    #logo img {
        width: 40%!important;
    }
    #header{
        background-color: #e60003!important;
        -webkit-print-color-adjust: exact; 
        color: white!important;
        margin:5px 0!important;
        height:40px!important;
        font-size:16px!important;
        padding:8px!important;
    }
    #meta td.meta-head {
        text-align: left!important;
        font-weight: 600!important;
        font-size: 14px!important;
        padding-bottom: 5px!important;
        padding-top: 5px!important;
    }
    .client-profile-image-thumb{
        height: 120px!important;
        width: 120px!important;
    }
    #items th{
        padding: 6px 6px!important;
        font-size:13px!important;
    }
    table td{
        padding: 6px 6px!important;
        font-size:12px!important;
    }
    .footer{display:none!important;}
    .grade-table th{
        background-color:#fff0d0!important;
        -webkit-print-color-adjust: exact; 
    }
  }
</style>
<div class="panel_s">
  <div class="panel-body">
    <div id="container">
      <div id="page-wrap">
        <textarea id="header">PROGRESS REPORT SHEET</textarea>

        <div id="identity">
          <div id="logo">
            <img id="image" src="https://theisb.in/wp-content/uploads/elementor/thumbs/School-Logo-2-osn98oms7a00ae3gwtrsnujhe9yg93zyqrghs17jls.png" alt="logo" class="logo" />
          </div>
        </div>

        <div style="clear:both"></div>

        <div id="customer">
          <div id="student-img-wrap">
            <img src="<?php echo contact_profile_image_url($contact->id,'thumb'); ?>" class="client-profile-image-thumb">
          </div>
          <div class="table-responsive">
            <table id="meta">
              <tr>
                <td class="meta-head">Name</td>
                <?php
                    if($sutudentdata->middlename == '')
                    {
                        ?>
                            <td class="fz-14"><?= $sutudentdata->firstname.' '.$sutudentdata->lastname; ?></td>
                        <?php
                    }
                    else
                    {
                        ?>
                            <td class="fz-14"><?= $sutudentdata->firstname.' '.$sutudentdata->middlename.' '.$sutudentdata->lastname; ?></td>
                        <?php
                    }
                ?>
              </tr>
              <tr>
                <td class="meta-head">Class</td>
                <td class="fz-14"><?= $sutudentdata->Class; ?></td>
              </tr>
              <tr>
                <td class="meta-head">Academic Year</td>
                <td class="fz-14">2020-21</td>
              </tr>
            </table>
          </div>
        </div>

        <table id="items" class="grade-table">
            <?php
                if($terms_result)
                {
                    $sn = 1;
                    foreach($terms_result as $rr)
                    {
                        ?>
                            <tr>
                                <th>
                                    <?php
                                        if($rr->exam_id == 'Assessment_1')
                                            echo 'Assessment - I';
                                        elseif($rr->exam_id == 'Assessment_2')
                                            echo 'Assessment - II';
                                        else
                                            echo 'Half - Yearly Assessment';
                                    ?>
                                 </th>
                                <th>Grade</th>
                            </tr>
                        <?php
                        foreach($subject_result as $r)
                        {
                            if($rr->id == $r->result_id)
                            {
                                ?>
                                    <tr class="item-row">
                                        <td><?= $r->subject_id; ?></td>
                                        <td><?= $r->grad_id; ?></td>
                                    </tr>
                                <?php
                            }
                        }
                        $sn++;
                    }
                }
                else
                {
                    ?>
                        <tr>
                            <td valign="top" colspan="2" class="dataTables_empty">No result found</td>
                        </tr>
                    <?php
                }
            ?>
        </table>
        <textarea id="header1">Grade Descriptors</textarea>
        <table id="items" class="grade-table">
          <tr>
            <th colspan="2">Scholastic Achievement Grade</th>
          </tr>
          <tr class="item-row">
            <td class="fz-14"><b>Marks Range</b></td>
            <td class="fz-14"><b>Grade</b></td>
          </tr>
          <?php
            if($sutudentdata->Class == 'Nursery' || $sutudentdata->Class == 'Playgroup' || $sutudentdata->Class == 'LKG' || $sutudentdata->Class == 'UKG' )
            {
                ?>
                    <tr class="item-row">
                        <td>41-50 </td>
                        <td>A1</td>
                    </tr>
                    <tr class="item-row">
                        <td>31-40 </td>
                        <td>A2</td>
                    </tr>
                    <tr class="item-row">
                        <td>21-30 </td>
                        <td>B1</td>
                    </tr>
                    <tr class="item-row">
                        <td>1-20 </td>
                        <td>B2</td>
                    </tr>
                <?php
            }
            elseif($grad_list)
            {
                foreach($grad_list as $rrr)
                {
                    ?>
                        <tr class="item-row">
                            <td><?= $rrr->percent; ?></td>
                            <td><?= $rrr->name; ?></td>
                        </tr>
                    <?php
                }
            }
            else
            {
                ?>
                    <tr class="odd"><td valign="top" colspan="2" class="dataTables_empty">No result found</td></tr>
                <?php
            }
          ?>
        </table>
      </div>
    </div>
  </div>
</div>
