<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
   <div class="content">
      <?php echo form_open($this->uri->uri_string(),array('id'=>'article-form')); ?>
      <div class="row">
         <div class="col-md-8 col-md-offset-2">
            <div class="panel_s">
               <div class="panel-body">
                  <h4 class="no-margin">
                     <?php echo $title; ?>
                  </h4>
                    <?php if(isset($article)){ ?>
                    <p>
                     <small>
                     <?php echo _l('article_total_views'); ?>: <?php echo total_rows(db_prefix().'views_tracking',array('rel_type'=>'kb_article','rel_id'=>$article->transport_id)); ?>
                     </small>
                     <?php if(has_permission('transport','','create')){ ?>
                     <a href="<?php echo admin_url('transport/article'); ?>" class="btn btn-success pull-right"><?php echo _l($_text.' new article'); ?></a>
                     <?php } ?>
                     <?php if(has_permission('transport','','delete')){ ?>
                     <a href="<?php echo admin_url('transport/delete_article/'.$article->transport_id); ?>" class="btn btn-danger _delete pull-right mright5"><?php echo _l('delete'); ?></a>
                     <?php } ?>
                    <div class="clearfix"></div>
                    </p>
                    <?php } ?>
                    <hr class="hr-panel-heading" />
                    <div class="clearfix"></div>
                    <?php $value = (isset($article) ? $article->route_name : ''); ?>
                    <?php $attrs = (isset($article) ? array() : array('autofocus'=>true)); ?>
                    <?php echo render_input('route_name','Route Name',$value,'text',$attrs); ?>
                    <div class="form-group">
                        <label>Vehicle</label>
                        <select class="form-control" name="vehicle_id" required>
                            <option value=""></option>
                            <?php
                                if($vehicle_result)
                                {
                                    foreach($vehicle_result as $rrr)
                                    {
                                        ?>
                                            <option <?= ($article->vehicle_id == $rrr->vehicle_id)?"selected":""; ?> value="<?= $rrr->vehicle_id; ?>"><?= $rrr->vehicle_type; ?></option>
                                        <?php
                                    }
                                }
                            ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Route Number</label>
                        <select class="form-control" name="route_id" required onChange="showArea(this.value)">
                            <option value=""></option>
                            <?php
                                if($route_result)
                                {
                                    foreach($route_result as $rrr)
                                    {
                                        ?>
                                            <option <?= ($article->route_id == $rrr->route_id)?"selected":""; ?> value="<?= $rrr->route_id; ?>"><?= $rrr->route_number; ?></option>
                                        <?php
                                    }
                                }
                            ?>
                        </select>
                    </div>
                    <div class="form-group routearea" style="display:none;">
                        <?php
                            if($route_result)
                            {
                                foreach($route_result as $rrr)
                                {
                                    ?>
                                        <p id="showarea_<?= $rrr->route_id; ?>" class="areahide"><b>Area: </b><?= $rrr->route_area; ?></p>
                                    <?php
                                }
                            }
                        ?>
                    </div>
                    <div class="form-group">
                        <label>Driver Name</label>
                        <input type="text" class="form-control" value="<?= (isset($article) ? $article->driver_name : '')?>" name="driver_name">
                    </div>
                    <div class="form-group">
                        <label>Driver Contact number</label>
                        <input type="number" class="form-control" value="<?= (isset($article) ? $article->driver_contact : '')?>" name="driver_contact">
                    </div>
                </div>
            </div>
         </div>
         <?php if((has_permission('transport','','create') && !isset($article)) || has_permission('transport','','edit') && isset($article)){ ?>
         <div class="btn-bottom-toolbar btn-toolbar-container-out text-right">
            <button type="submit" class="btn btn-info pull-right"><?php echo _l('submit'); ?></button>
         </div>
         <?php } ?>
      </div>
      <?php echo form_close(); ?>
   </div>
</div>
<?php init_tail(); ?>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    function showArea(id)
    {
          if(id)
          {
              $('.routearea').css('display','block');
              $('.areahide').hide();
              $('#showarea_'+id).show();
          }
          else
          {
              $('.routearea').hide();
              $('.areahide').hide();
          }
    }
</script>
</body>
</html>
