<?php

defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = [
    'route_name',
    'route_id',
    'vehicle_id',
    'driver_name',
    'driver_contact',
    'active',
    ];

$sIndexColumn = 'transport_id';
$sTable       = db_prefix().'transport';

$result  = data_tables_init($aColumns, $sIndexColumn, $sTable, [], [], ['transport_id']);
$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];
    
    $row[] = '<a href="' . admin_url('transport/article/' . $aRow['transport_id']) . '" class="mbot10 display-block">' . $aRow['route_name'] . '</a>';
    
    $row[] = routename($aRow['route_id']);
    $row[] = vehiclename($aRow['vehicle_id']);
    $row[] = $aRow['driver_name'];
    $row[] = $aRow['driver_contact'];

    $options = icon_btn('transport/article/' . $aRow['transport_id'], 'pencil-square-o');
    $row[]   = $options .= icon_btn('transport/delete/' . $aRow['transport_id'], 'remove', 'btn-danger _delete');

    $output['aaData'][] = $row;
}
