<?php
    //error_reporting(-1);
	//ini_set('display_errors', 1);
defined('BASEPATH') or exit('No direct script access allowed');
 
$hasPermissionEdit   = has_permission('timetable', '', 'edit');
$hasPermissionDelete = has_permission('timetable', '', 'delete');
$tasksPriorities     = get_tasks_priorities();

$aColumns = [
    '1', // bulk actions
     'timetable_id',
    'class_id',
    'status'
];



$sIndexColumn = 'timetable_id';
$sTable       = db_prefix() . 'timetable';

$where = [];
$join  = [];

//include_once(APPPATH . 'views/admin/tables/includes/timetable_filter.php');
 
$custom_fields = get_table_custom_fields('timetable');

foreach ($custom_fields as $key => $field) {
    $selectAs = (is_cf_date($field) ? 'date_picker_cvalue_' . $key : 'cvalue_' . $key);
    array_push($customFieldsColumns, $selectAs);
    array_push($aColumns, '(SELECT value FROM ' . db_prefix() . 'customfieldsvalues WHERE ' . db_prefix() . 'customfieldsvalues.relid=' . db_prefix() . 'tasks.id AND ' . db_prefix() . 'customfieldsvalues.fieldid=' . $field['id'] . ' AND ' . db_prefix() . 'customfieldsvalues.fieldto="' . $field['fieldto'] . '" LIMIT 1) as ' . $selectAs);
}
 

$aColumns = hooks()->apply_filters('tasks_table_sql_columns', $aColumns);

// Fix for big queries. Some hosting have max_join_limit
if (count($custom_fields) > 4) {
    @$this->ci->db->query('SET SQL_BIG_SELECTS=1');
}
$result  = data_tables_init($aColumns, $sIndexColumn, $sTable, [], $where,[ '(SELECT attachment_key FROM ' . db_prefix() . 'files WHERE rel_type= "timetable" AND  rel_id=' . db_prefix() . 'timetable.timetable_id) as attachment_key']);
  
$output  = $result['output'];
$rResult = $result['rResult'];
 
foreach ($rResult as $aRow) {
     
    $row = [];

    $row[] = '<div class="checkbox"><input type="checkbox" value="' . $aRow['timetable_id'] . '"><label></label></div>';
 
    
    $outputName = '';

    if ($aRow['not_finished_timer_by_current_staff']) {
        $outputName .= '<span class="pull-left text-danger"><i class="fa fa-clock-o fa-fw"></i></span>';
    }

    $outputName .= '<a href="#" onclick="edit_task(' . $aRow['timetable_id'] . '); return false">' . classname($aRow['class_id']) . '</a>';
   
    $href_url = site_url('download/file/taskattachment/'. $aRow['attachment_key']);  

    $outputName .= '<div class="row-options">';

    $class = 'text-success bold';
   

    if ($hasPermissionEdit) {
      //  $outputName .= '<a href="#" onclick="edit_task(' . $aRow['timetable_timetable_id'] . '); return false">' . _l('edit') . '</a>';
    }

    if ($hasPermissionDelete) {
        $outputName .= '<a href="' . admin_url('timetable/delete_timetable/' . $aRow['timetable_id']) . '" class="text-danger _delete task-delete">' . _l('delete') . '</a>';
    }
    $outputName .= '</div>';

    $row[] = $outputName;
 
   // $row[] = classname($aRow['class_timetable_id']);

    $row[] = '<a href="'.$href_url.'" target="blank" class="text-danger ">' . _l('Download') . '</a>';
     
    $row['DT_RowClass'] = 'has-row-options';

    $row = hooks()->apply_filters('tasks_table_row_data', $row, $aRow);

    $output['aaData'][] = $row;
}
