<?php

defined('BASEPATH') or exit('No direct script access allowed');
$this->contact_tbl =  $this->ci->db->escape_str($contact_tbl);
$this->academic_session =  $this->ci->db->escape_str($academic_session);
$this->start_date =  $this->ci->db->escape_str($start_date);
$this->end_date =  $this->ci->db->escape_str($end_date);
$aColumns = [
    'tbltc_requests.id',
    db_prefix().'contacts'.$this->contact_tbl.'.userid as userid',
    'firstname',
    'middlename',
    'lastname',
    'email',
    db_prefix().'contacts'.$this->contact_tbl.'.phonenumber as phonenumber',
    db_prefix().'contacts'.$this->contact_tbl.'.active',
    db_prefix().'contacts'.$this->contact_tbl.'.datecreated as datecreated',
];

$sIndexColumn = 'userid';
$sTable       = db_prefix().'contacts'.$this->contact_tbl;

$join = [
    'RIGHT JOIN '.db_prefix().'tc_requests ON '.db_prefix().'tc_requests.student_id='.db_prefix().'contacts'.$this->contact_tbl.'.userid'
];

$where = [];
array_push($where, 'AND tbltc_requests.created_at>"'.$this->start_date.'"');
array_push($where, 'AND tbltc_requests.created_at<"'.$this->end_date.'"');

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [
    db_prefix().'contacts'.$this->contact_tbl.'.id as contact_id',
	'tblcontacts'.$this->contact_tbl.'.firstname',
	'tblcontacts'.$this->contact_tbl.'.middlename',
	'tblcontacts'.$this->contact_tbl.'.lastname',
	'tblcontacts'.$this->contact_tbl.'.Class',
	'tblcontacts'.$this->contact_tbl.'.Campus',
	'tblcontacts'.$this->contact_tbl.'.Father_Name',
	'tblcontacts'.$this->contact_tbl.'.Father_Mobile',
	'tblcontacts'.$this->contact_tbl.'.userid',
	'tbltc_requests.id',
	'tbltc_requests.date_of_application_for_tc',
	'tbltc_requests.created_at',
	'tbltc_requests.academic_year',
	'tbltc_requests.status'
],'',[],' ORDER BY  '.db_prefix().'tc_requests.id DESC');
$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];
    
    $row[] = '<a href="javascript:void(0);" onclick="studentProfileApplyTC('.$aRow['userid'].')">'.$aRow['firstname'].' '.$aRow['middlename'].' '.$aRow['lastname'].'</a>';
    $row[] = $aRow['Class'];
    $row[] = $aRow['Campus'];
    $row[] = $aRow['Father_Name'];
    $row[] = $aRow['Father_Mobile'];
    $row[] = _d($aRow['created_at']);
	if($aRow['status'] == 0)
	{
		$row[] = '<span class="label label-default inline-block pointer">Pending</span>';		
	}
	elseif($aRow['status'] == 1)
	{
		$academic_year = strtotime($aRow['academic_year']);
		$row[] = '<span class="label label-success inline-block pointer">Approved</span> <span class="label label-warning inline-block pointer" onclick="tcPrintPreview('.$aRow['id'].','.$aRow['userid'].')">Print</span>';			
	}
	elseif($aRow['status'] == 2)
	{
		$row[] = '<span class="label label-warning inline-block pointer">Re-Submit</span>';			
	}
    $output['aaData'][] = $row;
}
