<?php

defined('BASEPATH') or exit('No direct script access allowed');

$hasPermissionDelete = has_permission('payments', '', 'delete');

$aColumns = [
    db_prefix() . 'student_fees_deposit.id as id',
    'package_id',
    'userid',
    'deposit_date',
    'payment_mode',
    'check_no',
    'fees_type',
    'deposit_amount',
    'installment',
    'note',
    ];

$join = [];

$where = [];
if ($clientid != '') {
    array_push($where, 'AND ' . db_prefix() . 'student_fees_deposit.userid=' . $this->ci->db->escape_str($clientid));
}

$sIndexColumn = 'id';
$sTable       = db_prefix() . 'student_fees_deposit';

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, ['id']);

$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];
    
    //$row[] = '<a href="'.admin_url().'clients/client/'.$clientid.'?group=paymentReceipt">Respt'.$aRow['id'].'</a>';

    $row[] = packagename($aRow['package_id']);
    $row[] = _d($aRow['deposit_date']);
    if($aRow['payment_mode'] == 'cheque')
    {
        $row[] = $aRow['payment_mode'].' / '.$aRow['check_no'];
    }
    else
    {
        $row[] = $aRow['payment_mode'];
    }
    $row[] = $aRow['fees_type'];
    $row[] = $aRow['deposit_amount'];
    $row[] = $aRow['installment'];
    $row[] = '<span class="label label-success  s-status invoice-status-2">Paid</span>';

    $output['aaData'][] = $row;
}
