<?php

defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = [
    '1',
    db_prefix().'contacts.userid as userid',
    'firstname',
    'middlename',
    'lastname',
    'email',
    db_prefix().'contacts.phonenumber as phonenumber',
    db_prefix().'contacts.active',
    db_prefix().'contacts.datecreated as datecreated',
];

$sIndexColumn = 'userid';
$sTable       = db_prefix().'contacts';

$join = [
    'RIGHT JOIN '.db_prefix().'student_package ON '.db_prefix().'student_package.userid='.db_prefix().'contacts.userid',
    'RIGHT JOIN '.db_prefix().'student_fees_deposit ON '.db_prefix().'student_fees_deposit.userid='.db_prefix().'contacts.userid'
];

$where = [];
array_push($where, 'AND management_status=2');

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [
    db_prefix().'contacts.id as contact_id',db_prefix().'student_package.deposit_amount as damount',db_prefix().'student_fees_deposit.createddate as createddate',db_prefix().'student_fees_deposit.deposit_amount as deposit_amount',db_prefix().'student_fees_deposit.id as sfid',
    'Campus','Shift','Class','Mother_Mobile','Father_Name','Emergency_Conatact_Mobile','lastname','registration_id','management_status','accounted_message','management_id','management_update_date','package_amount','fees_type'
],'',[],' ORDER BY  '.db_prefix().'student_fees_deposit.id DESC'); 
$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];
    
    $row[] = $aRow['firstname'].' '.$aRow['middlename'].' '.$aRow['lastname'];
    $row[] = $aRow['Class'];
    $row[] = $aRow['Father_Name'];
    $row[] = $aRow['Mother_Mobile'];
    $row[] = get_staff_full_name($aRow['management_id']);
    $row[] = _d($aRow['management_update_date']);
    $row[] = ucfirst($aRow['fees_type']);
    $row[] = $aRow['package_amount'];
    $row[] = $aRow['damount'];
    $row[] = $aRow['deposit_amount'];
    if($aRow['management_status'] == 0)
    {
        $option = '<div class="resid'.$aRow['sfid'].'"><button type="button" class="btn btn-primary mr-1" onclick="feeSubmit('.$aRow['userid'].','.$aRow['sfid'].')">Approval</button>';
        $row[] = $option .= '<button type="button" class="btn btn-warning" data-toggle="modal" data-target="#resumit" onclick="reSubmit('.$aRow['userid'].','.$aRow['sfid'].')">Resubmit</button></div>';
    }
    else if($aRow['management_status'] == 1)
    {
        $row[] = '<button type="button" data-toggle="tooltip" data-title="'.get_staff_full_name($aRow['management_id']).' '.$aRow['management_update_date'].'" data-original-title="" title="" class="btn btn-success">Approved</button>';
    }
    else
    {
        $row[] = '<div class="resid'.$aRow['sfid'].'" data-toggle="modal" data-target="#resumit" onclick="reSubmit('.$aRow['userid'].','.$aRow['sfid'].')"><button type="button" data-toggle="tooltip" data-title="'.get_staff_full_name($aRow['management_id']).' '.$aRow['management_update_date'].'" data-original-title="" title="" class="btn btn-info">Resubmited</button></div>';
    }
    $output['aaData'][] = $row;
}
