<?php

defined('BASEPATH') or exit('No direct script access allowed');
$this->contact_tbl =  $this->ci->db->escape_str($contact_tbl);
$this->academic_session =  $this->ci->db->escape_str($academic_session);
$tc_status =  $this->ci->db->escape_str($tc_status);
$aColumns = [
    'tbltc_requests.id',
    db_prefix().'contacts'.$this->contact_tbl.'.userid as userid',
    'firstname',
    'middlename',
    'lastname',
    'email',
    db_prefix().'contacts'.$this->contact_tbl.'.phonenumber as phonenumber',
    db_prefix().'contacts'.$this->contact_tbl.'.active',
    db_prefix().'contacts'.$this->contact_tbl.'.datecreated as datecreated',
];

$sIndexColumn = 'userid';
$sTable       = db_prefix().'contacts'.$this->contact_tbl;

$join = [
    'RIGHT JOIN '.db_prefix().'tc_requests ON '.db_prefix().'tc_requests.student_id='.db_prefix().'contacts'.$this->contact_tbl.'.userid'
];

$where = [];
//array_push($where, 'AND ('.db_prefix().'tc_requests.academic_year="'.$this->academic_session.'")');
//array_push($where, 'AND ('.db_prefix().'tc_requests.status="'.$tc_status.'")');

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [
    db_prefix().'contacts'.$this->contact_tbl.'.id as contact_id',
	'tblcontacts'.$this->contact_tbl.'.firstname',
	'tblcontacts'.$this->contact_tbl.'.middlename',
	'tblcontacts'.$this->contact_tbl.'.lastname',
	'tblcontacts'.$this->contact_tbl.'.Class',
	'tblcontacts'.$this->contact_tbl.'.Campus',
	'tblcontacts'.$this->contact_tbl.'.Father_Name',
	'tblcontacts'.$this->contact_tbl.'.Mother_Name',
	'tblcontacts'.$this->contact_tbl.'.Father_Mobile',
	'tblcontacts'.$this->contact_tbl.'.userid',
	'tbltc_requests.id',
	'tbltc_requests.date_of_application_for_tc',
	'tbltc_requests.academic_year',
	'tbltc_requests.status',
	'tbltc_requests.updated_at as updated_at'
],'',[],' ORDER BY  '.db_prefix().'tc_requests.id DESC');
$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];
    
    $row[] = '<a href="javascript:void(0);" onclick="studentProfileApplyTC('.$aRow['userid'].')">#'.$aRow['id'].'</a>';
    $row[] = '<a href="javascript:void(0);" onclick="studentProfileApplyTC('.$aRow['userid'].')">'.$aRow['firstname'].' '.$aRow['middlename'].' '.$aRow['lastname'].'</a>';
    $row[] = $aRow['Class'];
    $row[] = $aRow['Campus'];
    $row[] = $aRow['Father_Name'];
    $row[] = $aRow['Mother_Name'];
    $row[] = $aRow['Father_Mobile'];
    $row[] = _d($aRow['date_of_application_for_tc']);
	
	$sday = date('Y-m-d');
	$eday = _d($aRow['date_of_application_for_tc']);
	$date1 = new DateTime($sday);
	$date2 = new DateTime($eday);
	$days  = $date2->diff($date1)->format('%a');
	
	if($aRow['status'] == 0)
	{
		$row[] = '';
		//$row[] = '<span class="label label-default inline-block pointer">Pending</span>';		
		$row[] = 'Pending From - '.$days.' Days';
	}
	elseif($aRow['status'] == 1)
	{
		$row[] = _d($aRow['updated_at']);		
		$academic_year = strtotime($aRow['academic_year']);
		$row[] = '<span class="label label-success inline-block pointer">Approved</span>';			
	}
	elseif($aRow['status'] == 2)
	{
		$row[] = '';
		$row[] = '<span class="label label-warning inline-block pointer">Re-Submit</span>';			
	}
	if($aRow['status'] == 0)
	{
		$row[] = '<span class="label label-default inline-block pointer">Pending</span>';		
	}
	elseif($aRow['status'] == 1)
	{
		$academic_year = strtotime($aRow['academic_year']);
		$row[] = '<span class="label label-warning inline-block pointer" onclick="tcPrintPreview('.$aRow['id'].','.$aRow['userid'].')">Print</span>';			
	}
    $output['aaData'][] = $row;
}
