<?php

defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = [
    'heading',
    'start_date',
    'end_date',
    ];

$sIndexColumn = 'id';
$sTable       = db_prefix().'master_important_reminder';

$result  = data_tables_init($aColumns, $sIndexColumn, $sTable, [], [], ['id']);
$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];
    
    $row[] = '<a href="' . admin_url('importantReminder/add/' . $aRow['id']) . '" class="mbot10 display-block">' . $aRow['heading'] . '</a>';
    $row[] = _d($aRow['start_date']);
    //$row[] = _d($aRow['end_date']);

    $rem = strtotime($aRow['end_date']) - time();
    $day = floor($rem / 86400);
    $hr  = floor(($rem % 86400) / 3600);
    $min = floor(($rem % 3600) / 60);
    $sec = ($rem % 60);
    /*
    if($day) echo "$day Days ";
    if($hr) echo "$hr Hours ";
    if($min) echo "$min Minutes ";
    if($sec) echo "$sec Seconds ";
    echo "Remaining...";
    */
    $row[] = _d($aRow['end_date']);
    $row[] = "<span class='label label-danger'>".$day ." Days</span>";
    $options = icon_btn('importantReminder/add/' . $aRow['id'], 'pencil-square-o');
    $row[]   = $options .= icon_btn('importantReminder/delete_importantreminder/' . $aRow['id'], 'remove', 'btn-danger _delete');

    $output['aaData'][] = $row;
}
