<?php

defined('BASEPATH') or exit('No direct script access allowed');

$hasPermissionDelete = has_permission('customers', '', 'delete');

$custom_fields = get_table_custom_fields('customers');
$this->ci->db->query("SET sql_mode = ''");
$this->contact_tbl =  $this->ci->db->escape_str($contact_tbl);
$aColumns = [
    '1',
    db_prefix().'contacts'.$this->contact_tbl.'.userid as userid',
    
    'firstname',
    'email',
    db_prefix().'contacts'.$this->contact_tbl.'.phonenumber as phonenumber',
    db_prefix().'contacts'.$this->contact_tbl.'.active',
    '(SELECT GROUP_CONCAT(name SEPARATOR ",") FROM '.db_prefix().'customer_groups JOIN '.db_prefix().'customers_groups ON '.db_prefix().'customer_groups.groupid = '.db_prefix().'customers_groups.id WHERE customer_id = '.db_prefix().'contacts'.$this->contact_tbl.'.userid ORDER by name ASC) as customerGroups'
];

$sIndexColumn = 'userid';
$sTable       = db_prefix().'contacts'.$this->contact_tbl;
$where        = [];
// Add blank where all filter can be stored
$filter = [];

// $join = [
//     'RIGHT JOIN '.db_prefix().'contacts'.$this->contact_tbl.' ON '.db_prefix().'contacts'.$this->contact_tbl.'.userid='.db_prefix().'clients.userid AND '.db_prefix().'contacts'.$this->contact_tbl.'.is_primary=1',
// ];

foreach ($custom_fields as $key => $field) {
    $selectAs = (is_cf_date($field) ? 'date_picker_cvalue_' . $key : 'cvalue_' . $key);
    array_push($customFieldsColumns, $selectAs);
    array_push($aColumns, 'ctable_' . $key . '.value as ' . $selectAs);
 //   array_push($join, 'LEFT JOIN '.db_prefix().'customfieldsvalues as ctable_' . $key . ' ON '.db_prefix().'clients.userid = ctable_' . $key . '.relid AND ctable_' . $key . '.fieldto="' . $field['fieldto'] . '" AND ctable_' . $key . '.fieldid=' . $field['id']);
}

$join = hooks()->apply_filters('customers_table_sql_join', $join);
 

if ($this->ci->input->post('campus_Elite')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Campus="Elite Campus")');
}
if ($this->ci->input->post('campus_Premium')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Campus="Premium Campus")');
}
if ($this->ci->input->post('campus_World')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Campus="World School")');
}

if ($this->ci->input->post('shift_Morning')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Shift="Morning")');
}

if ($this->ci->input->post('shift_Afternoon')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Shift="Afternoon")');
}

if ($this->ci->input->post('class_1')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Class="Playgroup")');
}

if ($this->ci->input->post('class_2')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Class="Nursery")');
}

if ($this->ci->input->post('class_3')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Class="LKG")');
}

if ($this->ci->input->post('class_4')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Class="UKG")');
}

if ($this->ci->input->post('class_5')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Class="Class I")');
}

if ($this->ci->input->post('class_6')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Class="Class II")');
}

if ($this->ci->input->post('class_7')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Class="Class III")');
}

if ($this->ci->input->post('class_8')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Class="Class IV")');
}

if ($this->ci->input->post('class_9')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Class="Class V")');
}

if ($this->ci->input->post('class_10')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Class="Class VI")');
}

if ($this->ci->input->post('class_11')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Class="Class VII")');
}

if ($this->ci->input->post('class_12')) {
    array_push($where, 'AND '.db_prefix().'contacts'.$this->contact_tbl.'.userid IN (SELECT userid FROM '.db_prefix().'contacts'.$this->contact_tbl.' WHERE Class="Class VIII")');
}

 
$aColumns = hooks()->apply_filters('customers_table_sql_columns', $aColumns);

// Fix for big queries. Some hosting have max_join_limit
if (count($custom_fields) > 4) {
    @$this->ci->db->query('SET SQL_BIG_SELECTS=1');
}

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [
    db_prefix().'contacts'.$this->contact_tbl.'.id as contact_id',
    'Campus','Shift','Class','Mother_Mobile','Father_Name','Emergency_Conatact_Mobile','lastname','registration_id','Father_Mobile',
]);

$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];

    // Bulk actions
    $row[] = '<div class="checkbox"><input type="checkbox" value="' . $aRow['userid'] . '"><label></label></div>';
    // User id
    $row[] = $aRow['userid'];
 
    $isPerson = false;

  
    $url = admin_url('clients/client/' . $aRow['userid']);
    $url_ = 'javascript:void(0)';

    if ($isPerson && $aRow['contact_id']) {
        $url .= '?contactid=' . $aRow['contact_id'];
    }

   // $company = '<a href="' . $url . '">' . $company . '</a>';
    $company = '<a href="' . $url_ . '" data-toggle="modal" data-target="#student-profile" onclick="studentDetails('.$aRow['userid'].')">' . $aRow['firstname'] . ' ' . $aRow['lastname']  . '</a>';

    $company .= '<div class="row-options">';
    
    $company .= '<a style="cursor: pointer!important;" data-toggle="modal" data-target="#student-profile" onclick="studentDetails('.$aRow['userid'].')">' . _l('view') . '</a>';

    if ($aRow['registration_confirmed'] == 0 && is_admin()) {
        $company .= ' | <a href="' . admin_url('clients/confirm_registration/' . $aRow['userid']) . '" class="text-success bold">' . _l('confirm_registration') . '</a>';
    }
     
    if ($hasPermissionDelete) {
        $company .= ' | <a href="' . admin_url('clients/delete/' . $aRow['userid']) . '" class="text-danger _delete">' . _l('delete') . '</a>';
    }

    $company .= '</div>';

    $row[] = $company;
      
    // Toggle active/inactive customer
    $toggleActive = '<div class="onoffswitch" data-toggle="tooltip" data-title="' . _l('customer_active_inactive_help') . '">
    <input type="checkbox"' . ($aRow['registration_confirmed'] == 0 ? ' disabled' : '') . ' data-switch-url="' . admin_url() . 'clients/change_client_status" name="onoffswitch" class="onoffswitch-checkbox" id="' . $aRow['userid'] . '" data-id="' . $aRow['userid'] . '" ' . ($aRow[db_prefix().'clients.active'] == 1 ? 'checked' : '') . '>
    <label class="onoffswitch-label" for="' . $aRow['userid'] . '"></label>
    </div>';

    // For exporting
    $toggleActive .= '<span class="hide">' . ($aRow[db_prefix().'clients.active'] == 1 ? _l('is_active_export') : _l('is_not_active_export')) . '</span>';

   /* $row[] = $toggleActive; */

    // Customer groups parsing
    $groupsRow = '';
    if ($aRow['customerGroups']) {
        $groups = explode(',', $aRow['customerGroups']);
        foreach ($groups as $group) {
            $groupsRow .= '<span class="label label-default mleft5 inline-block customer-group-list pointer">' . $group . '</span>';
        }
    }

  /*  $row[] = $groupsRow; */
  $row[] = $aRow['registration_id'];
  $row[] = $aRow['Father_Name'];
  
  if( $aRow['Father_Mobile'] == $aRow['Emergency_Conatact_Mobile'] )
  {
      $row[] = $aRow['Father_Mobile'].', '.$aRow['Mother_Mobile'];
  }
  else{
      $row[] = $aRow['Father_Mobile'].', '.$aRow['Mother_Mobile'].', '.$aRow['Emergency_Conatact_Mobile'];
  }
  
  $row[] = $aRow['Class'];
  $row[] = '<span class="label label-default mleft5 inline-block customer-group-list pointer">' . $aRow['Campus'] . '</span>';
  $row[] = $aRow['Shift'];
  
  //$row[] = $toggleActive;

   /* $row[] = _dt($aRow['datecreated']); */

    // Custom fields add values
    /*
    foreach ($customFieldsColumns as $customFieldColumn) {
        $row[] = (strpos($customFieldColumn, 'date_picker_') !== false ? _d($aRow[$customFieldColumn]) : $aRow[$customFieldColumn]);
    }
    */

    $row['DT_RowClass'] = 'has-row-options';

    if ($aRow['registration_confirmed'] == 0) {
        $row['DT_RowClass'] .= ' alert-info requires-confirmation';
        $row['Data_Title']  = _l('customer_requires_registration_confirmation');
        $row['Data_Toggle'] = 'tooltip';
    }

    $row = hooks()->apply_filters('customers_table_row_data', $row, $aRow);

    $output['aaData'][] = $row;
}
