<?php

defined('BASEPATH') or exit('No direct script access allowed');
 
$hasPermissionEdit   = has_permission('books', '', 'edit');
$hasPermissionDelete = has_permission('books', '', 'delete');
$tasksPriorities     = get_tasks_priorities();

$aColumns = [
    '1', // bulk actions
    db_prefix() . 'books.id as id',
    db_prefix() . 'books.book_name as book_name',
    'class_id',
    'subject_id',
    'file_url',
    'status'
];



$sIndexColumn = 'id';
$sTable       = db_prefix() . 'books';

$where = [];
$join  = [];

include_once(APPPATH . 'views/admin/tables/includes/books_filter.php');
 
$custom_fields = get_table_custom_fields('books');

foreach ($custom_fields as $key => $field) {
    $selectAs = (is_cf_date($field) ? 'date_picker_cvalue_' . $key : 'cvalue_' . $key);
    array_push($customFieldsColumns, $selectAs);
    array_push($aColumns, '(SELECT value FROM ' . db_prefix() . 'customfieldsvalues WHERE ' . db_prefix() . 'customfieldsvalues.relid=' . db_prefix() . 'tasks.id AND ' . db_prefix() . 'customfieldsvalues.fieldid=' . $field['id'] . ' AND ' . db_prefix() . 'customfieldsvalues.fieldto="' . $field['fieldto'] . '" LIMIT 1) as ' . $selectAs);
}
 

$aColumns = hooks()->apply_filters('tasks_table_sql_columns', $aColumns);

// Fix for big queries. Some hosting have max_join_limit
if (count($custom_fields) > 4) {
    @$this->ci->db->query('SET SQL_BIG_SELECTS=1');
}
$result  = data_tables_init($aColumns, $sIndexColumn, $sTable, [], $where,[ '(SELECT attachment_key FROM ' . db_prefix() . 'files WHERE rel_type= "books" AND  rel_id=' . db_prefix() . 'books.id) as attachment_key']);
  
$output  = $result['output'];
$rResult = $result['rResult'];
 
foreach ($rResult as $aRow) {
     
    $row = [];

    $row[] = '<div class="checkbox"><input type="checkbox" value="' . $aRow['id'] . '"><label></label></div>';
 
    
    $outputName = '';

    if ($aRow['not_finished_timer_by_current_staff']) {
        $outputName .= '<span class="pull-left text-danger"><i class="fa fa-clock-o fa-fw"></i></span>';
    }

     $outputName .= '<a href="#" onclick="edit_task(' . $aRow['id'] . '); return false">' . $aRow['book_name'] . '</a>';
    
    if ($aRow['book_name']) {
        $relName = $aRow['book_name'];

        $link = $aRow['book_name'];

     //   $outputName .= '<span class="hide"> - </span><a class="text-muted task-table-related" data-toggle="tooltip" title="' . _l('task_related_to') . '" href="' . $link . '">' . $relName . '</a>';
    }
     
    $href_url = site_url('download/file/taskattachment/'. $aRow['attachment_key']);  

    $outputName .= '<div class="row-options">';

    $class = 'text-success bold';
   

    if ($hasPermissionEdit) {
      //  $outputName .= '<a href="#" onclick="edit_task(' . $aRow['id'] . '); return false">' . _l('edit') . '</a>';
    }

    if ($hasPermissionDelete) {
        $outputName .= '<a href="' . admin_url('books/delete_task/' . $aRow['id']) . '" class="text-danger _delete task-delete">' . _l('delete') . '</a>';
    }
    $outputName .= '</div>';

    $row[] = $outputName;
 
    $row[] = classname($aRow['class_id']);

    $row[] = subjectname($aRow['subject_id']);
    
    $row[] = $aRow['file_url'];
  
    $row[] = '<a href="'.$href_url.'" target="blank" class="text-danger ">' . _l('Download') . '</a>';
     
    $row['DT_RowClass'] = 'has-row-options';

    $row = hooks()->apply_filters('tasks_table_row_data', $row, $aRow);

    $output['aaData'][] = $row;
}
