<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
   <div class="content">
      <?php echo form_open($this->uri->uri_string(),array('id'=>'article-form')); ?>
      <div class="row">
         <div class="col-md-8 col-md-offset-2">
            <div class="panel_s">
               <div class="panel-body">
                  <h4 class="no-margin">
                     <?php echo $title; ?>
                  </h4>
                    <?php if(isset($article)){ ?>
                    <p class="hide">
                     <small>
                     <?php echo _l('article_total_views'); ?>: <?php echo total_rows(db_prefix().'views_tracking',array('rel_type'=>'kb_article','rel_id'=>$article->importantReminder_id)); ?>
                     </small>
                     <?php if(has_permission('importantReminder','','create')){ ?>
                     <a href="<?php echo admin_url('importantReminder/article'); ?>" class="btn btn-success pull-right"><?php echo _l($_text.' new article'); ?></a>
                     <?php } ?>
                     <?php if(has_permission('importantReminder','','delete')){ ?>
                     <a href="<?php echo admin_url('importantReminder/delete_article/'.$article->importantReminder_id); ?>" class="btn btn-danger _delete pull-right mright5"><?php echo _l('delete'); ?></a>
                     <?php } ?>
                    <div class="clearfix"></div>
                    </p>
                    <?php } ?>
                    <hr class="hr-panel-heading" />
                    <div class="clearfix"></div>
                    
                    <div class="form-group">
				       <?= _l('Academic Year'); ?>
				       <select class="form-control" name="academic_year">
				           <option value=""></option>
				           <option <?= ($article->academic_year == "2019-20")?"selected":""; ?> value="2019-20">2019-20</option>
				           <option <?= ($article->academic_year == "2020-21")?"selected":""; ?> value="2020-21">2020-21</option>
				           <option <?= ($article->academic_year == "2021-22")?"selected":""; ?> value="2021-22">2021-22</option>
				           <option <?= ($article->academic_year == "2022-23")?"selected":""; ?> value="2022-23">2022-23</option>
				           <option <?= ($article->academic_year == "2023-24")?"selected":""; ?> value="2023-24">2023-24</option>
				           <option <?= ($article->academic_year == "2024-25")?"selected":""; ?> value="2024-25">2024-25</option>
				           <option <?= ($article->academic_year == "2025-26")?"selected":""; ?> value="2025-26">2025-26</option>
				       </select>
				   </div>
				   <div class="form-group">
				       <?= _l('Particulars'); ?>
				       <input type="text" autocomplete="off" class="form-control" value="<?= (isset($article) ? $article->particular : '')?>" name="particular">
				   </div>
				   <div class="form-group">
				       <?= _l('One Time Payment'); ?>
				       <input type="text" autocomplete="off" class="form-control" value="<?= (isset($article) ? $article->one_time_payment : '')?>" name="one_time_payment">
				   </div>
				   <div class="form-group">
				       <?= _l('Two Installments'); ?>
				       <input type="text" autocomplete="off" class="form-control" value="<?= (isset($article) ? $article->two_installments : '')?>" name="two_installments">
				   </div>
				   <div class="form-group">
				       <?= _l('Shift'); ?>
				       <select class="form-control" name="shift">
				           <option value=""></option>
				           <option <?= ($article->shift == "Morning")?"selected":""; ?> value="Morning">Morning</option>
				           <option <?= ($article->shift == "Afternoon")?"selected":""; ?> value="Afternoon">Afternoon</option>
				       </select>
				   </div>
                </div>
            </div>
         </div>
         <?php if((has_permission('schoolfees','','create') && !isset($article)) || has_permission('schoolfees','','edit') && isset($article)){ ?>
         <div class="btn-bottom-toolbar btn-toolbar-container-out text-right">
            <button type="submit" class="btn btn-info pull-right"><?php echo _l('submit'); ?></button>
         </div>
         <?php } ?>
      </div>
      <?php echo form_close(); ?>
   </div>
</div>
<?php init_tail(); ?>
</body>
</html>
