<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
   <div class="content">
      <?php echo form_open($this->uri->uri_string(),array('id'=>'article-form')); ?>
      <div class="row">
         <div class="col-md-8 col-md-offset-2">
            <div class="panel_s">
               <div class="panel-body">
                  <h4 class="no-margin">
                     <?php echo $title; ?>
                  </h4>
                    <?php if(isset($article)){ ?>
                    <p class="hide">
                    <!--
                     <small>
                     <?php echo _l('article_total_views'); ?>: <?php echo total_rows(db_prefix().'views_tracking',array('rel_type'=>'kb_article','rel_id'=>$article->id)); ?>
                     </small>
                    -->
                     <?php if(has_permission('packageMaster','','create')){ ?>
                     <a href="<?php echo admin_url('packageMaster/add'); ?>" class="btn btn-success pull-right"><?php echo _l($_text.' new'); ?></a>
                     <?php } ?>
                     <?php if(has_permission('packageMaster','','delete')){ ?>
                     <a href="<?php echo admin_url('packageMaster/delete_article/'.$article->id); ?>" class="btn btn-danger _delete pull-right mright5"><?php echo _l('delete'); ?></a>
                     <?php } ?>
                    <div class="clearfix"></div>
                    </p>
                    <?php } ?>
                    <hr class="hr-panel-heading" />
                    <div class="clearfix"></div>
                    <?php $value = (isset($article) ? $article->name : ''); ?>
                    <?php $attrs = (isset($article) ? array() : array('autofocus'=>true)); ?>
                    <?php echo render_input('name','Name',$value,'text',$attrs); ?>
                    <div class="form-group">
                        <label>Payment Type</label>
                        <select class="form-control" name="payment_type" required id="payment_type" onchange="selectInstallment()">
                            <option value=""></option>
                            <?php
                                if($paymenttype_result)
                                {
                                    foreach($paymenttype_result as $rrr)
                                    {
                                        ?>
                                            <option <?= ($article->payment_type == $rrr->id)?"selected":""; ?> value="<?= $rrr->id; ?>"><?= $rrr->name; ?></option>
                                        <?php
                                    }
                                }
                            ?>
                        </select>
                    </div>
                    <div class="form-group inst" style="display:<?= ($article->payment_type == 5)?"block":"none"; ?>;">
                        <label>Installment</label>
                        <input type="number" name="installment" class="form-control" id="installment" onkeyup="setInstalment()" value="<?= (isset($article) ? $article->installment : 1)?>">
                    </div>
                    <div class="row form-group">
                        <div class="col-md-6">
                            <label>Class From</label>
                            <select class="form-control" name="class_from_id" required>
                                <option value=""></option>
                                <?php
                                    if($class_result)
                                    {
                                        foreach($class_result as $rrr)
                                        {
                                            ?>
                                                <option <?= ($article->class_from_id == $rrr->class_id)?"selected":""; ?> value="<?= $rrr->class_id; ?>"><?= $rrr->name; ?></option>
                                            <?php
                                        }
                                    }
                                ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label>Class To</label>
                            <select class="form-control" name="class_to_id" required>
                                <option value=""></option>
                                <?php
                                    if($class_result)
                                    {
                                        foreach($class_result as $rrr)
                                        {
                                            ?>
                                                <option <?= ($article->class_to_id == $rrr->class_id)?"selected":""; ?> value="<?= $rrr->class_id; ?>"><?= $rrr->name; ?></option>
                                            <?php
                                        }
                                    }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="row form-group">
                        <div class="col-md-6">
                            <label>Shift</label>
                            <select class="form-control" name="shift" required>
                                <option value=""></option>
                                <option <?= ($article->shift == 'Morning')?"selected":""; ?> value="Morning">Morning</option>
                                <option <?= ($article->shift == 'Afternoon')?"selected":""; ?> value="Afternoon">Afternoon</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label>Amount</label>
                            <input type="text" class="form-control" value="<?= (isset($article) ? $article->amount : '')?>" id="amount" onkeyup="enteramount();" name="amount">
                            <input type="number" class="form-control hide" value="<?= (isset($article) ? $article->amount : '')?>" id="tamount">
                        </div>
                    </div>
                </div>
            </div>
         </div>
         <?php if((has_permission('package_master','','create') && !isset($article)) || has_permission('package_master','','edit') && isset($article)){ ?>
         <div class="btn-bottom-toolbar btn-toolbar-container-out text-right">
            <button type="submit" class="btn btn-info pull-right"><?php echo _l('submit'); ?></button>
         </div>
         <?php } ?>
      </div>
      <?php echo form_close(); ?>
   </div>
</div>
<?php init_tail(); ?>
<script>
    function selectInstallment()
    {
        var inst = $('#payment_type option:selected').text();
        if(inst == 'Regular Installments')
        {
            $('.inst').css('display','block');
            setInstalment();
        }
        else
        {
            $('.inst').css('display','none');
            var tamount = $('#tamount').val();
            $('#amount').val(tamount);  
        }
		/*
        var fee_scheme = $('#payment_type option:selected').val();
        if(fee_scheme == '50')
        {
            $('.inst').css('display','block');
            setInstalment();
        }
        else
        {
            $('.inst').css('display','none');
            var tamount = $('#tamount').val();
            $('#amount').val(tamount);  
        }*/
    }
    
    function enteramount()
    {
        var amount = $('#amount').val();
        $('#tamount').val(amount);  
    }
    enteramount();
    function setInstalment()
    {
        var installment = $('#installment').val();
        if(installment != '')
        {
            var amount = $('#amount').val();
            var f_amount = amount / installment;
            f_amount = f_amount.toFixed(2);
            $('#amount').val(f_amount);
        }
        else
        {
            var tamount = $('#tamount').val();
            $('#amount').val(tamount);  
        }
    }
</script>
</body>
</html>
