<?php

defined('BASEPATH') or exit('No direct script access allowed');

$table_data = [
    _l('Class'),
    _l('Subject'),
    _l('Date/time Section A'),
    _l('Meeting ID Section A'),
    _l('Meeting Password Section A'),
    _l('Date/time Section B'),
    _l('Meeting ID Section B'),
    [
        'name'     => _l('Meeting Password Section B'),
        'th_attrs' => ['class' => 'duedate'],
    ],
    _l('Action'),

];

array_unshift($table_data, [
    'name'     => '<span class="hide"> - </span><div class="checkbox mass_select_all_wrap"><input type="checkbox" id="mass_select_all" data-to-table="tasks"><label></label></div>',
    'th_attrs' => ['class' => (isset($bulk_actions) ? '' : 'not_visible')],
]);

$custom_fields = get_custom_fields('books', [
    'show_on_table' => 1,
]);

foreach ($custom_fields as $field) {
    array_push($table_data, $field['name']);
}

$table_data = hooks()->apply_filters('tasks_table_columns', $table_data);

render_datatable($table_data, 'tasks', [], [
        'data-last-order-identifier' => 'tasks',
        'data-default-order'         => get_table_last_order('tasks'),
]);
