<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
   <div class="content">
      <?php echo form_open($this->uri->uri_string(),array('id'=>'article-form')); ?>
      <div class="row">
         <div class="col-md-8 col-md-offset-2">
            <div class="panel_s">
               <div class="panel-body">
                  <h4 class="no-margin">
                     <?php echo $title; ?>
                  </h4>
                    <?php if(isset($article)){ ?>
                    <p class="hide">
                     <small>
                     <?php echo _l('article_total_views'); ?>: <?php echo total_rows(db_prefix().'views_tracking',array('rel_type'=>'kb_article','rel_id'=>$article->importantReminder_id)); ?>
                     </small>
                     <?php if(has_permission('importantReminder','','create')){ ?>
                     <a href="<?php echo admin_url('importantReminder/article'); ?>" class="btn btn-success pull-right"><?php echo _l($_text.' new article'); ?></a>
                     <?php } ?>
                     <?php if(has_permission('importantReminder','','delete')){ ?>
                     <a href="<?php echo admin_url('importantReminder/delete_article/'.$article->importantReminder_id); ?>" class="btn btn-danger _delete pull-right mright5"><?php echo _l('delete'); ?></a>
                     <?php } ?>
                    <div class="clearfix"></div>
                    </p>
                    <?php } ?>
                    <hr class="hr-panel-heading" />
                    <div class="clearfix"></div>
                    <div class="form-group">
				       <label><?= _l('Heads'); ?></label>
				       <input type="text" class="form-control" value="<?= (isset($article) ? $article->heading : '')?>" name="heading">
				   </div>
				   <div class="form-group">
				       <label><?= _l('Start Date'); ?></label>
				       <input type="text" class="form-control datepicker" value="<?= (isset($article) ? $article->start_date : '')?>" name="start_date">
				   </div>
				   <div class="form-group">
				       <label><?= _l('Expiry Date'); ?></label>
				       <input type="text" class="form-control datepicker" value="<?= (isset($article) ? $article->end_date : '')?>" name="end_date">
				   </div>
                </div>
            </div>
         </div>
         <?php if((has_permission('important','','create') && !isset($article)) || has_permission('important','','edit') && isset($article)){ ?>
         <div class="btn-bottom-toolbar btn-toolbar-container-out text-right">
            <button type="submit" class="btn btn-info pull-right"><?php echo _l('submit'); ?></button>
         </div>
         <?php } ?>
      </div>
      <?php echo form_close(); ?>
   </div>
</div>
<?php init_tail(); ?>
</body>
</html>
