<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
	<div class="content">
		<div class="row">
			<div class="col-md-12">
				<div class="panel_s">
					<div class="panel-body">
						<h4 class="customer-profile-group-heading"><?= _l($title); ?></h4>
						<hr class="hr-panel-heading" />
						<?php render_datatable(array(
							_l('Student Name'),
							_l('Class'),
							_l('Father Name'),
							_l('Father Mobile'),
							_l('Payment Mode'),
							_l('Package Amount'),
							_l('Deposit Amount'),
							_l('Today Amount'),
							_l('options')
							),'dayPayList'); 
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="resumit" tabindex="-1" role="dialog" aria-labelledby="resumitLabel">
    <div class="modal-dialog" role="document">
        <?php echo form_open(admin_url('dayPayList/setStatus'),array('id'=>'resumitform')); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="resumitLabel">Resubmit</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <lable class="bold">Enter your message</lable>
                        <textarea class="textarea-2 form-control" name="re_message"></textarea>
                        <input type="text" class="form-control hide" name="sid" id="sid">
                        <input type="text" class="form-control hide" name="sfid" id="sfid">
                    </div>
                    <button group="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                    <button group="button" class="btn btn-info">Submit</button>
                </div>
            </div>
        <?php echo form_close(); ?>
    </div>
</div>
<?php init_tail(); ?>
	<script>
		initDataTable('.table-dayPayList', window.location.href, [1], [1]);
		
		function reSubmit(user, sfid){
		    //appValidateForm($('#resumitform'),{sid:'required',re_message:'required'});
		    $('#sid').val(user);
		    $('#sfid').val(sfid);
        }
        
        window.addEventListener('load',function(){
           appValidateForm($('#resumitform'), {
                sid:'required',
                re_message:'required'
            }, manage_student_fees);
        });
        function manage_student_fees(form) {
            var sfid_ = $('#sfid').val();
            var data = $(form).serialize();
            var url = form.action;
            $.post(url, data).done(function(response) {
                response = JSON.parse(response);
                if (response.success == true) {
                    alert_float('success', response.message);
                    $('#resumitform')[0].reset();
                    $('.close').click();
                    $('.resid'+sfid_).html('<button type="button" class="btn btn-default">Pending</button>');
                }
                else
                {
                    alert_float('warning', response.message);
                }
            });
            return false;
        }
	</script>
</body>
</html>
