<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<style>
	.mt-40{margin-top:40px;}
	.mb-40{margin-bottom:40px;}
	form{max-width:1000px;margin:0 auto;}
	.fz-14{font-size:14px;}
	.switch-button {
  display: inline-block;
  border-radius: 50px;
  background-color: #b3b3b3;
  width: 60px;
  height: 27px;
  padding: 4px;
  position: relative;
  overflow: hidden;
  vertical-align: middle;
}
.switch-button input[type=checkbox] {
  display: block;
  opacity: 0;
    position: absolute;
    z-index: 1;
    cursor: pointer;
    width: 56px;
    height: 15px;
}
.switch-button label {
  border-radius: 50%;
  -webkit-box-shadow: 0 0 1px 1px #fff inset;
  box-shadow: 0 0 1px 1px #FFF inset;
  background-color: #ffffff;
  margin: 0;
  height: 19px;
  width: 19px;
  z-index: 1;
  display: inline-block;
  cursor: pointer;
  background-clip: padding-box;
}
.switch-button label:before {
  position: absolute;
  font-size: 0.8462rem;
  font-weight: 600;
  z-index: 0;
  content: "Male";
  right: 0;
  display: block;
  width: 100%;
  height: 100%;
  line-height: 27px;
  top: 0;
  text-align: right;
  padding-right: 10px;
  color: #000000;
}
.switch-button input[type=checkbox]:checked + span {
  background-color: #ee4247;
  display: block;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  padding: 4px;
}
.switch-button input[type=checkbox]:checked + span label {
  float: right;
  border-color: #fe4d8e;
}
.switch-button input[type=checkbox]:checked + span label:before {
	position: absolute;
    font-size: .9rem;
    font-weight: 600;
    z-index: 0;
    content: "Female";
    color: #000000;
    left: 0;
    text-align: left;
    padding-left: 9px;
}
.switch-button.switch-button-yesno label:before {
  content: "NO";
}
.switch-button.switch-button-yesno input[type=checkbox]:checked + span label:before {
  content: "YES";
}
.switch-button.switch-button-sm {
  height: 24px;
  width: 65px;
  line-height: 20px;
}
.switch-button.switch-button-sm label {
  height: 16px;
  width: 16px;
}
.switch-button.switch-button-sm label:before {
  line-height: 25px;
}
.custom-radios div {
  display: inline-block;
  margin-right: 5px;
  position:relative;
}
.custom-radios input[type=radio] {
  display: block;
   opacity: 0;
    position: absolute;
    z-index: 1;
    cursor: pointer;
    width: 20px;
    height: 15px;
}
.custom-radios input[type=radio] + label {
  color: #333;
  font-family: Arial, sans-serif;
  font-size: 14px;
}
.custom-radios input[type=radio] + label span {
  display: inline-block;
  width: 20px;
  height: 20px;
  margin: -1px 4px 0 0;
  vertical-align: middle;
  cursor: pointer;
  border-radius: 5px;
  border: 2px solid #FFFFFF;
  box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.33);
  background-repeat: no-repeat;
  background-position: center;
  text-align: center;
  line-height: 14px;
}
.custom-radios input[type=radio] + label span img {
  opacity: 0;
  transition: all 0.3s ease;
}
.custom-radios input[type=radio]#color-1 + label span {
  background-color: #2ecc71;
}
.custom-radios input[type=radio]#color-2 + label span {
  background-color: #3498db;
}
.custom-radios input[type=radio]#color-3 + label span {
  background-color: #f1c40f;
}
.custom-radios input[type=radio]#color-4 + label span {
  background-color: #e74c3c;
}
.custom-radios input[type=radio]#color-5 + label span {
  background-color: #ffdd81;
}
.custom-radios input[type=radio]:checked + label span img {
  opacity: 1;
  width: 80%;
}
</style>
<h4 class="customer-profile-heading text-center text-uppercase"><?php echo _l('Transfer Certificate'); ?></h4>
<?php echo form_open_multipart(admin_url('dashboard/updateTCDetails/'.$sid),array('autocomplete'=>'off', 'id' => 'transferCertificateForm')); ?>
	<div class="row">
		<div class="col-md-6">
			<div class="form-group">
				<?= _l('Upload TC Application'); ?><span class="text-danger">*</span>
				<?php 
					if($tc_details)
					{
						$filename = $this->db->order_by('id', 'desc')->get_where(db_prefix().'files', array('rel_id' => $tc_details->id, 'rel_type' => 'tc_application'))->row('file_name');
						?>
							<input type="file" name="tc_application" class="form-control" />							
						<?php
					}
					else
					{
						?>
							<input type="file" name="tc_application" required class="form-control" />
						<?php
					}
				?>
			</div>
		</div>
		<?php
			if($tc_details)
			{
				if($filename)
				{
					?>
						<div class="col-md-6">
							<div class="form-group">
								<?= _l('Uploaded TC'); ?><br>
								<a href="<?= base_url().'uploads/tc_application/'.$tc_details->id.'/'.$filename; ?>" target="_blank"><i class="fa fa-file-pdf-o fa-2x" aria-hidden="true"></i> <b><?= $filename; ?></b></a>
							</div>
						</div>
					<?php
				}
			}
		?>
		<!--
		<div class="col-md-6">
			<div class="form-group">
				<?= _l('Apply Date'); ?><span class="text-danger">*</span>
				<input type="text" name="apply_date" autocomplete="off" value="<?= $tc_details->apply_date; ?>" class="form-control datepicker" />
			</div>
		</div>
		-->
	</div>
	<!--
	<div class="row">
		<div class="col-md-12">
			<div class="form-group">
				<?= _l('Reason'); ?>
				<input type="text" name="reason" class="form-control" value="<?= $tc_details->reason; ?>" />
			</div>
		</div>
	</div>
	-->
	<div class="row form-group">
		<div class="col-md-6">
			<label><b>Certificate number: TheISB/TC<span class="text-danger">*</span></b></label>                    
			<input type="text" id="certificate_number" name="certificate_number" autocomplete="off" value="<?= $tc_details->certificate_number; ?>" class="form-control" />
		</div>
		<div class="col-md-6">
			<label><b>Pupil's scholar number:<span class="text-danger">*</span></b></label>                    
			<input id="scholar_number" name="scholar_number" autocomplete="off" value="<?= $tc_details->scholar_number; ?>" class="form-control" />
		</div>
	</div>
	<div class="row form-group">
		<div class="col-md-4">
			<label><b>Name of pupil</b></label>                    
			<input id="student_name" readonly value="<?= $student_details->firstname.' '.$student_details->middlename.' '.$student_details->lastname; ?>" class="form-control" />
		</div>
		<div class="col-md-4">
			<label><b>Father's name</b></label>                    
			<input id="father_name" readonly value="<?= $student_details->Father_Name; ?>" class="form-control" />
		</div>
		<div class="col-md-4">
			<label><b>Mother's name</b></label>                    
			<input id="mother_name" readonly value="<?= $student_details->Mother_Name; ?>" class="form-control" />
		</div>
	</div>
	<div class="row form-group">
		<div class="col-md-2">
			<label><b>Nationality</b></label>                    
			<input id="nationality" name="nationality" readonly value="<?= ($student_details->Nationality != "")?$student_details->Nationality:"Indian"; ?>" class="form-control" />
		</div>
		<div class="col-md-2">
			<label><b>Gender</b></label><br>                    
			<div class="switch-button switch-button-sm">
				<?php
					if($tc_details)
					{
						?>
							<input type="checkbox" name="gender" <?= ($tc_details->gender == "Male")?"":"checked"; ?> id="gender" />
						<?php
					}
					else
					{
						?>
							<input type="checkbox" name="gender" <?= ($student_details->Gender == "Male")?"":"checked"; ?> id="gender" />
						<?php
					}
				?>
        		<span><label for="gender"></label></span>
      		</div>
		</div>
		<div class="col-md-4">
			<label><b>Caste/Sub-Caste:</b></label><br>  
			<div class="custom-radios">
				<?php
					if($tc_details)
					{
						?>
							<div>
								<input type="radio" id="color-1" name="student_caste" value="General" <?= ($tc_details->student_caste == "General")?"checked":""; ?>>
								<label for="color-1">
									<span>
										<img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/242518/check-icn.svg" alt="Checked Icon" />
									</span>
									General
								</label>
							</div>    
							<div>
								<input type="radio" id="color-2" name="student_caste" value="SC" <?= ($tc_details->student_caste == "SC")?"checked":""; ?>>
								<label for="color-2">
									<span>
										<img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/242518/check-icn.svg" alt="Checked Icon" />
									</span>
									SC
								</label>
							</div>
							<div>
								<input type="radio" id="color-3" name="student_caste" value="ST" <?= ($tc_details->student_caste == "ST")?"checked":""; ?>>
								<label for="color-3">
									<span>
										<img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/242518/check-icn.svg" alt="Checked Icon" />
									</span>
									ST
								</label>
							</div>
							<div>
								<input type="radio" id="color-4" name="student_caste" value="OBC" <?= ($tc_details->student_caste == "OBC")?"checked":""; ?>>
								<label for="color-4">
									<span>
										<img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/242518/check-icn.svg" alt="Checked Icon" />
									</span>
									OBC
								</label>
							</div>
							<div>
								<input type="radio" id="color-5" name="student_caste" value="NA" <?= ($tc_details->student_caste == "NA")?"checked":""; ?>>
								<label for="color-5">
									<span>
										<img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/242518/check-icn.svg" alt="Checked Icon" />
									</span>
									NA
								</label>
							</div>
						<?php
					}
					else
					{
						?>
							<div>
								<input type="radio" id="color-1" name="student_caste" value="General" <?= ($student_details->Caste == "General")?"checked":""; ?>>
								<label for="color-1">
									<span>
										<img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/242518/check-icn.svg" alt="Checked Icon" />
									</span>
									General
								</label>
							</div>    
							<div>
								<input type="radio" id="color-2" name="student_caste" value="SC" <?= ($student_details->Caste == "SC")?"checked":""; ?>>
								<label for="color-2">
									<span>
										<img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/242518/check-icn.svg" alt="Checked Icon" />
									</span>
									SC
								</label>
							</div>
							<div>
								<input type="radio" id="color-3" name="student_caste" value="ST" <?= ($student_details->Caste == "ST")?"checked":""; ?>>
								<label for="color-3">
									<span>
										<img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/242518/check-icn.svg" alt="Checked Icon" />
									</span>
									ST
								</label>
							</div>
							<div>
								<input type="radio" id="color-4" name="student_caste" value="OBC" <?= ($student_details->Caste == "OBC")?"checked":""; ?>>
								<label for="color-4">
									<span>
										<img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/242518/check-icn.svg" alt="Checked Icon" />
									</span>
									OBC
								</label>
							</div>
							<div>
								<input type="radio" id="color-5" name="student_caste" value="NA" <?= ($student_details->Caste == "NA")?"checked":""; ?>>
								<label for="color-5">
									<span>
										<img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/242518/check-icn.svg" alt="Checked Icon" />
									</span>
									NA
								</label>
							</div>
						<?php
					}
				?>
			</div>
		</div>
		<?php
			if($tc_details)
			{
				?>
					<div class="col-md-4">
						<label><b>Any other</b></label>
						<input type="text" id="any_other_student_caste" autocomplete="off" name="any_other_student_caste" class="form-control" value="<?= $tc_details->any_other_student_caste; ?>"/>
					</div>
				<?php
			}
			else
			{
				?>
					<div class="col-md-4">
						<label><b>Any other</b></label>
						<input type="text" id="any_other_student_caste" autocomplete="off" name="any_other_student_caste" class="form-control" value="<?= $student_details->Caste; ?>"/>
					</div>
				<?php
			}
		?>
	</div>
	<div class="row form-group">
		<div class="col-md-12">
			<label class="fz-14"><b>Date & class of first admission in the School: </b></label>                    
		</div>
		<div class="col-md-6">
			<label><b>Date<span class="text-danger">*</span></b></label>
			<div class="input-group">
  				<input id="date_first_admission_in_the_school" name="date_first_admission_in_the_school" value="<?= $tc_details->date_first_admission_in_the_school; ?>" class="form-control datepicker" type="text" aria-describedby="date_first_admission_in_the_school-addon2">
				<span class="input-group-addon" id="date_first_admission_in_the_school-addon2"><i class="fa fa-calendar" aria-hidden="true"></i></span>
			</div>
		</div>
		<div class="col-md-6">
			<label><b>Class<span class="text-danger">*</span></b></label>    
			<select class="form-control selectpicker" id="class_first_admission_in_the_school" name="class_first_admission_in_the_school">
				<option value=""></option>
				<?php
					if($class_list)
					{
						foreach($class_list as $cal)
						{
							?>
								<option value="<?= str_replace('Class ','',$cal->name); ?>" <?= ($tc_details->class_first_admission_in_the_school == str_replace('Class ','',$cal->name))?"selected":"";?>><?= str_replace('Class ','',$cal->name); ?></option>
							<?php
						}
					}
				?>
			</select>
		</div>
	</div>
	<div class="row form-group">
		<div class="col-md-6">
			<label><b>Date of birth (In Figures)<span class="text-danger">*</span></b></label>  
			<div class="input-group">
				<?php
					if($tc_details)
					{
						?>
							<input id="date_of_birth_in_figure" name="date_of_birth_in_figure" value="<?= $tc_details->date_of_birth_in_figure; ?>" class="form-control datepicker" type="text" aria-describedby="date_of_birth_in_figure-addon2">
						<?php
					}
					else
					{
						?>
							<input id="date_of_birth_in_figure" name="date_of_birth_in_figure" value="<?= $student_details->Date_of_Birth; ?>" class="form-control datepicker" type="text" aria-describedby="date_of_birth_in_figure-addon2">
						<?php
					}
				?>
				<span class="input-group-addon" id="date_of_birth_in_figure-addon2"><i class="fa fa-calendar" aria-hidden="true"></i></span>
			</div>
		</div>
		<div class="col-md-6">
			<label><b>(In Words)<span class="text-danger">*</span></b></label>  
			<input id="date_of_birth_in_words" name="date_of_birth_in_words" value="<?= $tc_details->date_of_birth_in_words; ?>" class="form-control"/>
		</div>
	</div>
	<div class="row form-group">
		<div class="col-md-6">
			<label><b>Class in which pupil last studied (In Figures)<span class="text-danger">*</span></b></label>  
			<input id="class_in_which_pupil_last_studied_in_figures" value="<?= $tc_details->class_in_which_pupil_last_studied_in_figures; ?>" name="class_in_which_pupil_last_studied_in_figures" class="form-control" />
		</div>
		<div class="col-md-6">
			<label><b>(In Words)<span class="text-danger">*</span></b></label>                    
			<input id="class_in_which_pupil_last_studied_in_words" value="<?= $tc_details->class_in_which_pupil_last_studied_in_words; ?>" name="class_in_which_pupil_last_studied_in_words" class="form-control" />
		</div>
	</div>
	<div class="row form-group">
		<div class="col-md-12">
			<label class="fz-14"><b>Last examination given by pupil:</b></label>                    
		</div>
		<div class="col-md-4">
			<label><b>Class<span class="text-danger">*</span></b></label>                    
			<input id="last_exam_given_class" name="last_exam_given_class" value="<?= $tc_details->last_exam_given_class; ?>" class="form-control" />
		</div>
		<div class="col-md-4">
			<label><b>Academic year<span class="text-danger">*</span></b></label>                    
			<input id="last_exam_given_academic_year" name="last_exam_given_academic_year" value="<?= $tc_details->last_exam_given_academic_year; ?>" class="form-control" />
		</div>
		<div class="col-md-4">
			<label><b>Result<span class="text-danger">*</span></b></label>                    
			<input id="last_exam_given_result" name="last_exam_given_result" value="<?= $tc_details->last_exam_given_result; ?>" class="form-control" />
		</div>
	</div>
	<div class="row form-group">
		<div class="col-md-6">
			<label><b>Class Studied</b></label>      
			<select class="form-control selectpicker" id="class_studied" name="class_studied" onchange="classSubjectList(this.value)">
				<option value=""></option>
				<?php
				
					if($class_list)
					{
						foreach($class_list as $cal)
						{
				// 			if($student_details->classId <= $cal->class_id)
				// 			{
								if($cal->class_id == 13 || $cal->class_id == 14)
								{
									?>
										<option value="<?= $cal->name; ?>" <?= ($tc_details->class_studied == $cal->name)?"selected":"";?>><?= $cal->name; ?></option>
									<?php	
								}
								else
								{
									?>
										<option value="<?= $cal->name; ?>" <?= ($tc_details->class_studied == $cal->name)?"selected":"";?>><?= $cal->name; ?></option>
									<?php									
								}
							//}
						}
					}
				?>	
			</select>
		</div>
		<div class="col-md-6">
			<label><b>Subjects Studied</b></label>      
			<select class="form-control selectpicker" multiple id="subjects_studied" name="subjects_studied[]">
				<option value="" disabled></option>		
				<?php
					$subjectsStudiedArr = [];
					if($tc_details)
					{
						$subjectsStudiedArr = explode(',',$tc_details->subjects_studied);
					}
					if($subject_list)
					{
						foreach($subject_list as $sub)
						{
							if($sub->name != 'Life Skills')
							{
								if($sub->name == 'G.K.')
								{
									if(in_array('General Knowledge' ,$subjectsStudiedArr))
									{
										?>
											<option value="General Knowledge" selected>General Knowledge</option>
										<?php
									}
									else
									{
										?>
											<option value="General Knowledge">General Knowledge</option>
										<?php
									}									
								}
								else
								{
									if(in_array($sub->name ,$subjectsStudiedArr))
									{
										?>
											<option value="<?= $sub->name; ?>" selected><?= $sub->name; ?></option>
										<?php
									}
									else
									{
										?>
											<option value="<?= $sub->name; ?>"><?= $sub->name; ?></option>
										<?php
									}									
								}
							}
						}
					}
				?>	
			</select>
		</div>
	</div>
	<div class="row form-group">
		<div class="col-md-4">
			<label class="fz-14"><b>Whether qualified for promotion to higher class</b></label>  
			<input id="whether_qualified_for_promotion_to_higher_class" name="whether_qualified_for_promotion_to_higher_class" value="<?= $tc_details->whether_qualified_for_promotion_to_higher_class; ?>" class="form-control" />
		</div>
		<div class="col-md-4">
			<label><b>If Yes to which class (In Figures)<span class="text-danger">*</span></b></label>  
			<input id="whether_qualified_for_promotion_to_higher_class_in_figures" name="whether_qualified_for_promotion_to_higher_class_in_figures" value="<?= $tc_details->whether_qualified_for_promotion_to_higher_class_in_figures; ?>" class="form-control" />
		</div>
		<div class="col-md-4">
			<label><b>(In Words)<span class="text-danger">*</span></b></label>                    
			<input id="whether_qualified_for_promotion_to_higher_class_in_words" name="whether_qualified_for_promotion_to_higher_class_in_words" value="<?= $tc_details->whether_qualified_for_promotion_to_higher_class_in_words; ?>" class="form-control" />
		</div>
	</div>
	<div class="row form-group">
		<div class="col-md-6">
			<label><b>Total number of working days of school<span class="text-danger">*</span></b></label>                    
			<input id="total_number_of_working_days_of_school" name="total_number_of_working_days_of_school" value="<?= $tc_details->total_number_of_working_days_of_school; ?>" class="form-control" />
		</div>
		<div class="col-md-6">
			<label><b>Total number of working days present<span class="text-danger">*</span></b></label>                    
			<input id="total_number_of_working_days_present" name="total_number_of_working_days_present" value="<?= $tc_details->total_number_of_working_days_present; ?>" class="form-control" />
		</div>
	</div>
	<div class="row form-group">
		<div class="col-md-12">
			<label><b>Extra-Curricular Activities in Which the pupil has taken part in</b></label>  
		</div>
		<div class="col-md-4">                 
			<!--
			<input id="extra_curricular_activities_1" name="extra_curricular_activities_1" placeholder="Activity 1" value="<?= $tc_details->extra_curricular_activities_1; ?>" class="form-control" />
			-->
			<select class="form-control" id="extra_curricular_activities_1" name="extra_curricular_activities_1">
				<option value="">Select activity 1</option>
				<option value="Yoga" <?= ($tc_details->extra_curricular_activities_1 == "Yoga")?"selected":""; ?>>Yoga</option>
				<!--<option value="Art & Craft" <?= ($tc_details->extra_curricular_activities_1 == "Art & Craft")?"selected":""; ?>>Art & Craft</option>
				<option value="Dance" <?= ($tc_details->extra_curricular_activities_1 == "Dance")?"selected":""; ?>>Dance</option>
				<option value="Music" <?= ($tc_details->extra_curricular_activities_1 == "Music")?"selected":""; ?>>Music</option>
				<option value="Physical Education" <?= ($tc_details->extra_curricular_activities_1 == "Physical Education")?"selected":""; ?>>Physical Education</option>-->
			</select>
		</div>
		<div class="col-md-4">                 
			<!--<input id="extra_curricular_activities_2" name="extra_curricular_activities_2" placeholder="Activity 2" value="<?= $tc_details->extra_curricular_activities_2; ?>" class="form-control" />-->
			<select class="form-control" id="extra_curricular_activities_2" name="extra_curricular_activities_2">
				<option value="">Select activity 2</option>
				<option value="Art & Craft" <?= ($tc_details->extra_curricular_activities_2 == "Art & Craft")?"selected":""; ?>>Art & Craft</option>
			</select>
		</div>
		<div class="col-md-4">                 
			<!--<input id="extra_curricular_activities_3" name="extra_curricular_activities_3" placeholder="Activity 3" value="<?= $tc_details->extra_curricular_activities_3; ?>" class="form-control" />-->
			<select class="form-control" id="extra_curricular_activities_3" name="extra_curricular_activities_3">
				<option value="">Select activity 3</option>
				<option value="Dance" <?= ($tc_details->extra_curricular_activities_3 == "Dance")?"selected":""; ?>>Dance</option>
			</select>
		</div>
	</div>
	<div class="row form-group">
	    <div class="col-md-4">                 
			<!--<input id="extra_curricular_activities_4" name="extra_curricular_activities_4" placeholder="Activity 4" value="<?= $tc_details->extra_curricular_activities_4; ?>" class="form-control" />-->
			<select class="form-control" id="extra_curricular_activities_4" name="extra_curricular_activities_4">
				<option value="">Select activity 4</option>
				<option value="Music" <?= ($tc_details->extra_curricular_activities_4 == "Music")?"selected":""; ?>>Music</option>
			</select>
		</div>
		<div class="col-md-4">                 
			<!--<input id="extra_curricular_activities_5" name="extra_curricular_activities_5" placeholder="Activity 5" value="<?= $tc_details->extra_curricular_activities_5; ?>" class="form-control" />-->
			<select class="form-control" id="extra_curricular_activities_5" name="extra_curricular_activities_5" placeholder="Activity 5">
				<option value="">Select activity 5</option>				
				<option value="Physical Education" <?= ($tc_details->extra_curricular_activities_5 == "Physical Education")?"selected":""; ?>>Physical Education</option>
			</select>
		</div>
	</div>
	<div class="row form-group">
		<div class="col-md-12">
			<label><b>General conduct of pupil<span class="text-danger">*</span></b></label>                    
			<input id="general_conduct_of_pupil" name="general_conduct_of_pupil" value="<?= $tc_details->general_conduct_of_pupil; ?>" class="form-control" />
		</div>
	</div>
	<div class="row form-group">
		<div class="col-md-6">
			<label><b>Date of application for transfer certificate<span class="text-danger">*</span></b></label>                    
			<div class="input-group">
  				<input id="date_of_application_for_tc" name="date_of_application_for_tc" value="<?= $tc_details->date_of_application_for_tc; ?>" class="form-control datepicker" type="text" aria-describedby="basic-addon2">
				<span class="input-group-addon" id="basic-addon2"><i class="fa fa-calendar" aria-hidden="true"></i></span>
			</div>
		</div>
		<div class="col-md-6">
			<label><b>Month up to which the pupil has paid school dues<span class="text-danger">*</span></b></label>                    
			<input id="month_upto_which_the_pupil_has_paid_school_dues" name="month_upto_which_the_pupil_has_paid_school_dues" value="<?= $tc_details->month_upto_which_the_pupil_has_paid_school_dues; ?>" class="form-control" />
		</div>
	</div>
	<div class="row form-group">
		<div class="col-md-12">
			<label><b>Any other remarks (If any)</b></label>                    
			<textarea id="any_other_remarks" name="any_other_remarks" class="form-control"><?= $tc_details->any_other_remarks; ?></textarea>
		</div>
	</div>
	<div class="row form-group">
		<div class="col-md-6">
			<label><b>Date of issue of transfer certificate<span class="text-danger">*</span></b></label>                    
			<div class="input-group">
  				<input id="date_of_issue_of_tc" name="date_of_issue_of_tc" value="<?= $tc_details->date_of_issue_of_tc; ?>" class="form-control datepicker" type="text" aria-describedby="date_of_issue_of_tc-addon2">
				<span class="input-group-addon" id="date_of_issue_of_tc-addon2"><i class="fa fa-calendar" aria-hidden="true"></i></span>
			</div>
		</div>
	</div>
	<hr>
	<div class="row form-group">
        <div class="col-md-12">
            <button group="button" class="btn btn-danger pull-right mbot15">Save</button>            
        </div>
    </div>
<?php echo form_close(); ?>
<script>
	init_datepicker();
		
	$('.selectpicker').selectpicker('refresh');	
</script>