<script>  
    /* ID Card model list */
    function idCardList(id)
    {
		var table = $('.table-idCardList').DataTable();
			table.destroy();
		var tAPI = initDataTable('.table-idCardList', '<?= admin_url() ?>dashboard/idCardList', [1], [1]); 
		tAPI.ajax.reload();
    }
	
	/* Id Card Edit Function */
	function idCardEditFunction()
	{
		$('.sid-card').removeAttr('disabled','disabled');
		$('#idcardedit_btn').css('display','none');
		$('#idcardupdate_btn').css('display','block');
	}
	
	/* ID card text update */
	function changeIDText(tid)
	{
		var text_content = $('#'+tid).val();
		$('.'+tid).text(text_content);
	}
	
	/* ID card text update */
	function changeIDCardText(tid, tval)
	{
		if(tval == 'Morning')
		{
			$('.idcard-campus').css('background-color','#e5060c');
		}
		if(tval == 'Afternoon')
		{
			$('.idcard-campus').css('background-color','#000000');
		}
		if(tval == 'Elite Campus')
		{
			$('.card').css('background-color','#f7dbe9');
		}
		if(tval == 'Premium Campus')
		{
			$('.card').css('background-color','#fffbd8');
		}
		if(tval == 'World School')
		{
			$('.card').css('background-color','#d4eefb');
		}
		var text_content = $('#'+tid).val();
		$('.'+tid).text(text_content);
	}
	
	var idCardImgPreview = function(event) {
		var output = document.getElementById('output');
		output.src = URL.createObjectURL(event.target.files[0]);
		output.onload = function() {
			URL.revokeObjectURL(output.src) // free memory
		}
	};
	
	function studentIDCardPrint(sid) {
        var url = admin_url+'dashboard/studentIDCardPrint/'+sid;
        $("<iframe>")                             // create a new iframe element
            .hide()                               // make it invisible
            .attr("src", url) // point the iframe to the page you want to print
            .appendTo("body");                    // add iframe to the DOM to cause it to load the page

    }
	
	function studentPickupCardPrint(sid) {
        var url = admin_url+'dashboard/studentPickupCardPrint/'+sid;
        $("<iframe>")                             // create a new iframe element
            .hide()                               // make it invisible
            .attr("src", url) // point the iframe to the page you want to print
            .appendTo("body");                    // add iframe to the DOM to cause it to load the page

    }
	
	window.addEventListener('load',function(){
        appValidateForm($('#studentIDCardForm'), {
			firstname: 'required',
			lastname: 'required',
			profile_image:{extension: "png,jpg,jpeg,gif,pdf"},
			Gender: 'required',
			Father_Mobile: 'required',
			Mother_Name: 'required',
			Mother_Mobile: 'required',
			student_address: 'required',
			Campus: 'required',
			Shift: 'required',
			Mode_of_Transport: 'required',
			Bus_No: 'required',
			Bus_Stop: 'required',
			Father_Name: 'required'
        }, manage_id_card_request);  
    });
    function manage_id_card_request(form) {
		var formURL = form.action;
		var formData = new FormData($(form)[0]);
		$.ajax({
			type: $(form).attr('method'),
			data: formData,
			mimeType: $(form).attr('enctype'),
			contentType: false,
			cache: false,
			processData: false,
			url: formURL
		}).done(function(response) {
			response = JSON.parse(response);
			if (response.success == true) {
                alert_float('success', response.message);
				studentDetailsIDCard(response.sid);
				$('.sid-card').attr('disabled','disabled');
				$('#idcardedit_btn').css('display','block');
				$('#idcardupdate_btn').css('display','none');
            }
			else
			{
				alert_float('warning', response.message);
			}
		}).fail(function(error) {
			alert_float('danger', JSON.parse(error.responseText));
		});		
        return false;
    }
</script>