<!DOCTYPE html>

<head>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Day Book</title>
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style type="text/css">
        .d-block {
            display: block;
        }

        body {
            margin: 0;
            padding: 0;
            background-color: #EDEDED;
            font-size: 13px;
            color: #444;
            font-family: 'Roboto', sans-serif;
            padding-top: 75px;
        }

        table,
        tr,
        td,
        th {
            margin: 0;
            padding: 0;
        }

        img {
            border: none;
        }

        a {
            text-decoration: none;
            cursor: pointer !important;
        }

        table[class="outer-tbl"] {
            width: 768px !important;
            margin: 0px auto !important;

        }

        p {

            padding: 0;
            margin: 0px;
        }

        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {
            margin: 0 0 5px 0;
        }

        img[class="main-image"] {
            width: 100% !important;
        }

        div[class="foot-items"] {
            padding: 0 190px;
        }

        table[class="full-wid"] {
            width: 100%;
        }

        a[class="hide"] {
            display: inline;
        }

        @media only screen and (max-width:767px) {
            body {
                padding: 0;
            }

            a[class="hide"] {
                display: none !important;
            }

            table[class="outer-tbl"] {
                width: 320px !important;
                margin-top: 0 !important;
                margin-bottom: 0 !important;
            }

            div[class="foot-items"] {
                max-width: 290px
            }

            td[class="logo"] {
                padding: 20px 0 !important;
            }

            td[class="text"] {
                padding: 5px 0 2px 0 !important;
            }

            td[class="footer"] {
                padding: 15px 0 !important;
            }

            td[class="botm"] {
                padding: 0 0 15px 0 !important;
            }

            td[class="less-wid"] {
                font-size: 13px;
                padding: 10px !important;
            }

            td[class="pad-top"] {
                padding-top: 10px !important;
            }

            p {
                margin-top: 10px !important;
            }

            p[class="rdlinht"] {
                line-height: 15px !important;
            }

            p[class="cnteimg"] {
                margin: 20px 0 0 0 !important;
            }

            img[class="main-image"] {
                width: 100% !important;
                margin: 0;
                padding: 0;
            }

            p[class="pre"] {
                padding: 0 10px !important;
            }

            td[class="pad-l-r-b"] {
                padding: 0 15px 30px !important;
            }

            td[class="pad-l-r"] {
                padding: 0 !important;
            }

            td[class="content"] {
                padding: 20px 20px !important;
            }

            div[class="foot-items"] {
                padding: 0 10px;
            }
        }

        /* header top */
		.table-header-price {
			margin-bottom: 5px;
		}
        .table-header-price tbody tr td .table-header-price-box {
            display: flex;
            background: #ffffff;
            padding: 7px;
            margin: 0 1px;
            align-items: center;
            border: 1px solid #e0e0e0;
            border-bottom: 2px solid #e0e0e0;
            border-radius: 4px;
        }

        .table-header-price tbody tr td .table-header-price-box img {
            margin-right: 6px;
            width: 24px;
        }

        .table-header-price tbody tr td .table-header-price-box h4 {
            margin: 0px 0 0px 0;
            font-size: 14px;
            color: #08aaf5;
            text-align: left;
            font-weight: 500;
        }

        .table-header-price tbody tr td .table-header-price-box p {
            margin: 0px;
            text-align: -webkit-auto;
            font-size: 13px;
            color: #757575;
        }

        /* body */
        table.table-body-price {
            width: 100%;
            text-align: left;
            margin-bottom: 10px;
        }

        .table-body-price thead tr th {
            background: #f6f8fa;
            padding: 10px 15px;
            border-right: 1px solid #d9ecff;
            border-top: 1px solid #d9ecff;
        }

        .table-body-price tbody tr td {
            padding: 6px 15px;
            border-top: 1px solid #ebf5ff;
        }
    </style>
</head>

<body style="margin: 0;	padding: 0; background-color:#EDEDED; font-size:13px; color:#444; padding-top:70px; padding-bottom:70px;">
    <table cellspacing="0" cellpadding="0" align="center" width="768" class="outer-tbl" style="margin:0 auto;">
        <tr>
            <td class="pad-l-r-b" style="background-color:#d5d5d5; padding: 0 20px 20px;">
                <table cellpadding="0" cellspacing="0" class="full-wid">
                    <tr>
                        <td style="padding:10px 0; text-align:right;" align="right"></td>
                    </tr>
                </table>
                <table cellpadding="0" cellspacing="0" style="width:100%; background-color:#FFFFFF; border-radius:4px;">
                    <tr>
                        <td>
                            <table border="0" style="margin:0; width:100%" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td class="logo" style="padding: 10px 10px 0; text-align: center; background: #f1f1f1;">

                                        <img src="<?php echo base_url(); ?>/assets/images/school-logo-2.png" width="200px" alt="" title="" />
                                        <h2>Daily Fees Report</h2>
                                        <span class="d-block text-center">
                                            <h2 style="font-size: 16px; margin-bottom: 10px; display: inline-block; padding: 15px; border: 1px solid #f1f1f1;">Today's total fees report of - <span style="font-weight: 800; color: #07a7f4; border-bottom: 1px solid #07a7f4;"><?php echo $t_all; ?> INR</span> / <span style="    font-weight: 800; color: #07a7f4; border-bottom: 1px solid #07a7f4;"><?php echo $student_count; ?> Students</span>
                                            	<p style="margin-top: 10px;">Date: <?php echo $search_date; ?></p>
                                            </h2>

                                        </span>

                                        <span class="d-block" style="width: 96%; padding: 0 10px; margin: 0 auto;">
                                            <table class="table-header-price" style="width: 100%;">
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            <span class="table-header-price-box">
                                                                <img src="<?php echo base_url(); ?>assets/images/svg-icons/cash.svg" alt="">
                                                                <span>
                                                                    <h4>Cash</h4>
                                                                    <p><?php echo $cash; ?></p>
                                                                </span>
                                                            </span>
                                                        </td>

                                                        <td>
                                                            <span class="table-header-price-box">
                                                                <img src="<?php echo base_url(); ?>assets/images/svg-icons/cheque.svg" alt="">
                                                                <span>
                                                                    <h4>Cheque</h4>
                                                                    <p><?php echo $cheque; ?></p>
                                                                </span>
                                                            </span>
                                                        </td>

                                                        <td>
                                                            <span class="table-header-price-box">
                                                                <img src="<?php echo base_url(); ?>assets/images/svg-icons/dd.svg" alt="">
                                                                <span>
                                                                    <h4>DD</h4>
                                                                    <p><?php echo $dd; ?></p>
                                                                </span>
                                                            </span>
                                                        </td>

                                                        <td>
                                                            <span class="table-header-price-box">
                                                                <img src="<?php echo base_url(); ?>assets/images/svg-icons/upi.svg" alt="">
                                                                <span>
                                                                    <h4>UPI</h4>
                                                                    <p><?php echo $upi; ?></p>
                                                                </span>
                                                            </span>
                                                        </td>

                                                        <td>
                                                            <span class="table-header-price-box">
                                                                <img src="<?php echo base_url(); ?>assets/images/svg-icons/online.svg" alt="">
                                                                <span>
                                                                    <h4>Online</h4>
                                                                    <p><?php echo $online; ?></p>
                                                                </span>
                                                            </span>
                                                        </td>

                                                        <td>
                                                            <span class="table-header-price-box">
                                                                <img src="<?php echo base_url(); ?>assets/images/svg-icons/imps.svg" alt="">
                                                                <span>
                                                                    <h4>IMPS</h4>
                                                                    <p><?php echo $IMPS; ?></p>
                                                                </span>
                                                            </span>
                                                        </td>

                                                        <td>
                                                            <span class="table-header-price-box">
                                                                <img src="<?php echo base_url(); ?>assets/images/svg-icons/card.svg" alt="">
                                                                <span>
                                                                    <h4>Card</h4>
                                                                    <p><?php echo $card; ?></p>
                                                                </span>
                                                            </span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </span>
                                    </td>
                                </tr>
                                <!-- row end -->

                                <tr>
                                    <table class="table-body-price" cellspacing="0" cellpadding="0">
                                        <thead>
                                            <tr>
                                                <th>Student Name</th>
                                                <th>Class</th>
                                                <th>Shift</th>
                                                <th>Campus</th>
                                                <th>Father Name </th>
                                                <th>Mother Name </th>
                                                <th>Father Mobile </th>
                                                <th>Mother Mobile </th>
                                                <th>Login Details </th>
                                                <th>Academic Year</th>                                                
                                                <th>Date</th>
                                                <th>Amount</th>
                                                 <th>Mode</th>
                                                <th>Transaction ID/Cheque NO </th>
                                                <th>Note</th>
                                              
                                                <th>Accountant Name</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                                if(!empty($fees_records)){
                                                    foreach($fees_records as $f_val) {
                                                       $year =   explode("-",$f_val->academic_year);
                                                       $ct = '(Due)';
                                                       if($year[0]==date('Y')){
                                                            $ct=  '(Current Year)';
                                                        }
                                                                
                                                        ?>
                                                            <tr>
                                                                <td><?php echo $f_val->student_name; ?></td>
                                                                <td><?php echo $f_val->Class; ?></td>
                                                                <td><?php echo $f_val->Shift; ?></td>
                                                                <td><?php echo $f_val->Campus; ?></td>
                                                                
                                                                <td><?php echo $f_val->Father_Name; ?></td>                                                                   
                                                                <td><?php echo $f_val->Mother_Name; ?></td>
                                                                <td><?php echo $f_val->Father_Mobile; ?></td>                                                                   
                                                                <td><?php echo $f_val->Mother_Mobile; ?></td>
                                                                <td>
                                                                    <p><b>ID: </b><?php echo $f_val->email; ?>   </p>
                                                                    <p><b>Password: </b><?php echo $f_val->paa; ?>   </p>
                                                                         
                                                                </td>
                                                                <td><?php echo $f_val->academic_year.$ct; ?>
                                                                
                                                                </td>
                                                                <td><span style="white-space: nowrap;"><?php echo date('d-m-Y', strtotime($f_val->deposit_date)); ?></span></td>
                                                                <td><?php echo $f_val->deposit_amount; ?></td>
                                                                <td><?php echo strtoupper($f_val->payment_mode); ?></td>
                                                              
                                                                <td><?php echo $f_val->payment_mode=='cheque' ? 'Cheque N0:'.$f_val->check_no  : strtoupper($f_val->dd_upi_online); ?></td>
                                                                  <td><?php echo $f_val->note; ?></td>
                                                                <td><?php echo get_staff_full_name($f_val->accounted_id); ?></td>
                                                            </tr>
                                                        <?php
                                                    }
                                                }
                                                else{
                                                    ?>
                                                        <tr>
                                                            <td colspan="7">No Records Found...</td>
                                                        </tr>
                                                    <?php
                                                }
                                            ?>
                                        </tbody>
                                    </table>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>

</html>