<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
    <div id="wrapper">
    	<div class="content">
    		<div class="row">
    			<div class="col-md-12">
    				<div class="panel_s">
    					<div class="panel-body">
    						<div class="tab-content">
    							<h4 class="customer-profile-group-heading"><?= $title; ?></h4>
        						<div class="clearfix"></div>
        						<div class="row mbot15 hide">
                                    <div class="col-md-12">
                                        <h4 class="no-margin"><?php echo _l($heading_text.' Summary'); ?></h4>
                                    </div>
                                    <div class="col-md-4 col-xs-6 border-right">
                                        <h3 class="bold"><?php echo $total_student; ?></h3>
                                        <span class="text-dark"><?php echo _l(' Total number of students'); ?></span>
                                    </div>
                                    <div class="col-md-4 col-xs-6 border-right">
                                        <h3 class="bold"><?php echo $pending_result ?></h3>
                                        <span class="text-warning"><?php echo _l($heading_text.' Pending'); ?></span>
                                    </div>
                                    <div class="col-md-4 col-xs-6 border-right">
                                        <h3 class="bold"><?php echo $completed_result; ?></h3>
                                        <span class="text-success"><?php echo _l($heading_text.' Completed'); ?></span>
                                    </div>
                                </div>
        						<div class="row">
        						    <div class="col-md-5">
        						        <h5 class="title">Select Class</h5>
        						        <select class="form-control" name="classid" id="classid">
        						            <option value=""></option>
        						            <?php
        						                if($class_list)
        						                {
        						                    foreach($class_list as $res)
        						                    {
        						                        ?>
        						                            <option value="<?= str_replace(' ','_',$res->name); ?>" <?= ($classname == $res->name)?"selected":""; ?>><?= $res->name; ?></option>
        						                        <?php
        						                    }
        						                }
        						            ?>
        						        </select>
        						    </div>
        				        </div>
        				        <hr class="hr-panel-heading" />
        						<div class="clearfix"></div>
        						<div class="row">
        						    <div class="col-md-12">
                        				<h4 class="customer-profile-group-heading"><?= _l(str_replace('_',' ',$classname)); ?></h4>
                						<hr class="hr-panel-heading" />
                						<?php render_datatable(array(
                							_l('Student Name'),
                							_l('Father Name'),
                							_l('Campus'),
                							_l('Shift'),
                							_l('options')
                							),'certificates_studentlist'); 
                						?>
                        			</div>
        						</div>
                            </div>
    					</div>
    				</div>
    			</div>
    		</div>
    	</div>
    </div>
<?php init_tail(); ?>
<script>
    initDataTable('.table-certificates_studentlist', window.location.href, [1], [1]);

    $(function(){
      // bind change event to select
      $('#classid').on('change', function () {
          var url = $(this).val(); // get selected value
          if (url) { // require a URL
            var rurl = '<?= admin_url()?>certificates/studentList/'+url;
              window.location = rurl; // redirect
          }
          return false;
      });
    });
    
    function getSubjectList(uid, cid, rid)
    {
        var str = "cid="+cid+"&uid="+uid+"&rid="+rid+"&"+csrfData['token_name']+"="+csrfData['hash'];
	    $.ajax({
	        url: '<?= admin_url()?>certificates/getSubjectList',
	        type: 'POST',
	        data: str,
	        //dataType: 'json',
	        cache: false,
	        success: function(resp){
	            if(resp)
	            {
	                $('.resmodal').html(resp);
	            }
	            else
	            {
	                $('.resmodal').html('<p>Record not found</p>');
	            }
	        }
	    });
    }
</script>
<!-- Modal -->
    <div class="modal fade" id="resultModalCenter" tabindex="-1" role="dialog" aria-labelledby="resultModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="resultModalCenterTitle">Certificates</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="resmodal">
                    </div>
                </div>
            </div>
        </div>
    </div>
<!--// -->
</body>
</html>
