<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Subject_master_model extends App_Model
{
    /**
     * Add new employee role
     * @param mixed $data
     */
    public function add($data)
    {
        $this->db->insert(db_prefix() . 'master_subject', $data);
        $insert_id = $this->db->insert_id();

        if ($insert_id) {
            log_activity('New Subject Added [ID: ' . $insert_id . '.' . $data['name'] . ']');

            return $insert_id;
        }

        return false;
    }

    /**
     * Update employee Post
     * @param  array $data Post data
     * @param  mixed $id   Post id
     * @return boolean
     */
    public function update($data, $id)
    {
        $this->db->where('subject_id', $id);
        $this->db->update(db_prefix() . 'master_subject', $data);

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
        }
/*
        if ($update_staff_permissions == true) {
            $this->load->model('staff_model');

            $staff = $this->staff_model->get('', [
                'role' => $id,
            ]);

            foreach ($staff as $member) {
                if ($this->staff_model->update_permissions($permissions, $member['staffid'])) {
                    $affectedRows++;
                }
            }
        }
*/
        if ($affectedRows > 0) {
            log_activity('subject Updated [ID: ' . $id . ', Name: ' . $data['name'] . ']');

            return true;
        }

        return false;
    }

    /**
     * Get employee Post by id
     * @param  mixed $id Optional Post id
     * @return mixed     array if not id passed else object
     */
    public function get($id = '')
    {
        if (is_numeric($id)) {

            $this->db->where('subject_id', $id);

            $Post              = $this->db->get(db_prefix() . 'master_subject')->row();
            
            return $Post;
        }

        return $this->db->get(db_prefix() . 'master_subject')->result_array();
    }

    /**
     * Delete employee role
     * @param  mixed $id role id
     * @return mixed
     */
    public function delete($id)
    {
        $current = $this->get($id);

        $affectedRows = 0;
        $this->db->where('subject_id', $id);
        $this->db->delete(db_prefix() . 'master_subject');

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
        }

        if ($affectedRows > 0) {
            log_activity('subject Deleted [ID: ' . $id);

            return true;
        }

        return false;
    }

    public function get_contact_permissions($id)
    {
        $this->db->where('userid', $id);

        return $this->db->get(db_prefix() . 'contact_permissions')->result_array();
    }

    public function get_role_staff($role_id)
    {
        $this->db->where('role', $role_id);

        return $this->db->get(db_prefix() . 'staff')->result_array();
    }
}
