<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
		$this->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'ONLY_FULL_GROUP_BY', ''))");
    }

    /**
     * @return array
     * Used in home dashboard page
     * Return all upcoming events this week
     */
    public function get_upcoming_events()
    {
        $this->db->where('(start BETWEEN "' . date('Y-m-d', strtotime('monday this week')) . '" AND "' . date('Y-m-d', strtotime('sunday this week')) . '")');
        $this->db->where('(userid = ' . get_staff_user_id() . ' OR public = 1)');
        $this->db->order_by('start', 'desc');
        $this->db->limit(6);

        return $this->db->get(db_prefix() . 'events')->result_array();
    }

    /**
     * @param  integer (optional) Limit upcoming events
     * @return integer
     * Used in home dashboard page
     * Return total upcoming events next week
     */
    public function get_upcoming_events_next_week()
    {
        $monday_this_week = date('Y-m-d', strtotime('monday next week'));
        $sunday_this_week = date('Y-m-d', strtotime('sunday next week'));
        $this->db->where('(start BETWEEN "' . $monday_this_week . '" AND "' . $sunday_this_week . '")');
        $this->db->where('(userid = ' . get_staff_user_id() . ' OR public = 1)');

        return $this->db->count_all_results(db_prefix() . 'events');
    }

    /**
     * @param  mixed
     * @return array
     * Used in home dashboard page, currency passed from javascript (undefined or integer)
     * Displays weekly payment statistics (chart)
     */
    public function get_weekly_payments_statistics($currency)
    {
        $all_payments                 = [];
        $has_permission_payments_view = has_permission('payments', '', 'view');
        $this->db->select(db_prefix() . 'invoicepaymentrecords.id, amount,' . db_prefix() . 'invoicepaymentrecords.date');
        $this->db->from(db_prefix() . 'invoicepaymentrecords');
        $this->db->join(db_prefix() . 'invoices', '' . db_prefix() . 'invoices.id = ' . db_prefix() . 'invoicepaymentrecords.invoiceid');
        $this->db->where('YEARWEEK(tblinvoicepaymentrecords.date) = YEARWEEK(CURRENT_DATE)');
        $this->db->where('' . db_prefix() . 'invoices.status !=', 5);
        if ($currency != 'undefined') {
            $this->db->where('currency', $currency);
        }

        if (!$has_permission_payments_view) {
            $this->db->where('invoiceid IN (SELECT id FROM ' . db_prefix() . 'invoices WHERE addedfrom=' . get_staff_user_id() . ')');
        }

        // Current week
        $all_payments[] = $this->db->get()->result_array();
        $this->db->select(db_prefix() . 'invoicepaymentrecords.id, amount,' . db_prefix() . 'invoicepaymentrecords.date');
        $this->db->from(db_prefix() . 'invoicepaymentrecords');
        $this->db->join(db_prefix() . 'invoices', '' . db_prefix() . 'invoices.id = ' . db_prefix() . 'invoicepaymentrecords.invoiceid');
        $this->db->where('YEARWEEK(tblinvoicepaymentrecords.date) = YEARWEEK(CURRENT_DATE - INTERVAL 7 DAY) ');

        $this->db->where('' . db_prefix() . 'invoices.status !=', 5);
        if ($currency != 'undefined') {
            $this->db->where('currency', $currency);
        }
        // Last Week
        $all_payments[] = $this->db->get()->result_array();

        $chart = [
            'labels'   => get_weekdays(),
            'datasets' => [
                [
                    'label'           => _l('this_week_payments'),
                    'backgroundColor' => 'rgba(37,155,35,0.2)',
                    'borderColor'     => '#84c529',
                    'borderWidth'     => 1,
                    'tension'         => false,
                    'data'            => [
                        0,
                        0,
                        0,
                        0,
                        0,
                        0,
                        0,
                    ],
                ],
                [
                    'label'           => _l('last_week_payments'),
                    'backgroundColor' => 'rgba(197, 61, 169, 0.5)',
                    'borderColor'     => '#c53da9',
                    'borderWidth'     => 1,
                    'tension'         => false,
                    'data'            => [
                        0,
                        0,
                        0,
                        0,
                        0,
                        0,
                        0,
                    ],
                ],
            ],
        ];


        for ($i = 0; $i < count($all_payments); $i++) {
            foreach ($all_payments[$i] as $payment) {
                $payment_day = date('l', strtotime($payment['date']));
                $x           = 0;
                foreach (get_weekdays_original() as $day) {
                    if ($payment_day == $day) {
                        $chart['datasets'][$i]['data'][$x] += $payment['amount'];
                    }
                    $x++;
                }
            }
        }

        return $chart;
    }

    public function projects_status_stats()
    {
        $this->load->model('projects_model');
        $statuses = $this->projects_model->get_project_statuses();
        $colors   = get_system_favourite_colors();

        $chart = [
            'labels'   => [],
            'datasets' => [],
        ];

        $_data                         = [];
        $_data['data']                 = [];
        $_data['backgroundColor']      = [];
        $_data['hoverBackgroundColor'] = [];
        $_data['statusLink']           = [];


        $has_permission = has_permission('projects', '', 'view');
        $sql            = '';
        foreach ($statuses as $status) {
            $sql .= ' SELECT COUNT(*) as total';
            $sql .= ' FROM ' . db_prefix() . 'projects';
            $sql .= ' WHERE status=' . $status['id'];
            if (!$has_permission) {
                $sql .= ' AND id IN (SELECT project_id FROM ' . db_prefix() . 'project_members WHERE staff_id=' . get_staff_user_id() . ')';
            }
            $sql .= ' UNION ALL ';
            $sql = trim($sql);
        }

        $result = [];
        if ($sql != '') {
            // Remove the last UNION ALL
            $sql    = substr($sql, 0, -10);
            $result = $this->db->query($sql)->result();
        }

        foreach ($statuses as $key => $status) {
            array_push($_data['statusLink'], admin_url('projects?status=' . $status['id']));
            array_push($chart['labels'], $status['name']);
            array_push($_data['backgroundColor'], $status['color']);
            array_push($_data['hoverBackgroundColor'], adjust_color_brightness($status['color'], -20));
            array_push($_data['data'], $result[$key]->total);
        }

        $chart['datasets'][]           = $_data;
        $chart['datasets'][0]['label'] = _l('home_stats_by_project_status');

        return $chart;
    }

    public function leads_status_stats()
    {
        $chart = [
            'labels'   => [],
            'datasets' => [],
        ];

        $_data                         = [];
        $_data['data']                 = [];
        $_data['backgroundColor']      = [];
        $_data['hoverBackgroundColor'] = [];
        $_data['statusLink']           = [];

        $result = get_leads_summary();

        foreach ($result as $status) {
            if (!isset($status['junk']) && !isset($status['lost'])) {
                if ($status['color'] == '') {
                    $status['color'] = '#737373';
                }
                array_push($chart['labels'], $status['name']);
                array_push($_data['backgroundColor'], $status['color']);
                array_push($_data['statusLink'], admin_url('leads?status=' . $status['id']));
                array_push($_data['hoverBackgroundColor'], adjust_color_brightness($status['color'], -20));
                array_push($_data['data'], $status['total']);
            }
        }

        $chart['datasets'][] = $_data;

        return $chart;
    }

    /**
     * Display total tickets awaiting reply by department (chart)
     * @return array
     */
    public function tickets_awaiting_reply_by_department()
    {
        $this->load->model('departments_model');
        $departments = $this->departments_model->get();
        $colors      = get_system_favourite_colors();
        $chart       = [
            'labels'   => [],
            'datasets' => [],
        ];

        $_data                         = [];
        $_data['data']                 = [];
        $_data['backgroundColor']      = [];
        $_data['hoverBackgroundColor'] = [];

        $i = 0;
        foreach ($departments as $department) {
            if (!is_admin()) {
                if (get_option('staff_access_only_assigned_departments') == 1) {
                    $staff_deparments_ids = $this->departments_model->get_staff_departments(get_staff_user_id(), true);
                    $departments_ids      = [];
                    if (count($staff_deparments_ids) == 0) {
                        $departments = $this->departments_model->get();
                        foreach ($departments as $department) {
                            array_push($departments_ids, $department['departmentid']);
                        }
                    } else {
                        $departments_ids = $staff_deparments_ids;
                    }
                    if (count($departments_ids) > 0) {
                        $this->db->where('department IN (SELECT departmentid FROM ' . db_prefix() . 'staff_departments WHERE departmentid IN (' . implode(',', $departments_ids) . ') AND staffid="' . get_staff_user_id() . '")');
                    }
                }
            }
            $this->db->where_in('status', [
                1,
                2,
                4,
            ]);

            $this->db->where('department', $department['departmentid']);
            $total = $this->db->count_all_results(db_prefix() . 'tickets');

            if ($total > 0) {
                $color = '#333';
                if (isset($colors[$i])) {
                    $color = $colors[$i];
                }
                array_push($chart['labels'], $department['name']);
                array_push($_data['backgroundColor'], $color);
                array_push($_data['hoverBackgroundColor'], adjust_color_brightness($color, -20));
                array_push($_data['data'], $total);
            }
            $i++;
        }

        $chart['datasets'][] = $_data;

        return $chart;
    }

    /**
     * Display total tickets awaiting reply by status (chart)
     * @return array
     */
    public function tickets_awaiting_reply_by_status()
    {
        $this->load->model('tickets_model');
        $statuses             = $this->tickets_model->get_ticket_status();
        $_statuses_with_reply = [
            1,
            2,
            4,
        ];

        $chart = [
            'labels'   => [],
            'datasets' => [],
        ];

        $_data                         = [];
        $_data['data']                 = [];
        $_data['backgroundColor']      = [];
        $_data['hoverBackgroundColor'] = [];
        $_data['statusLink']           = [];

        foreach ($statuses as $status) {
            if (in_array($status['ticketstatusid'], $_statuses_with_reply)) {
                if (!is_admin()) {
                    if (get_option('staff_access_only_assigned_departments') == 1) {
                        $staff_deparments_ids = $this->departments_model->get_staff_departments(get_staff_user_id(), true);
                        $departments_ids      = [];
                        if (count($staff_deparments_ids) == 0) {
                            $departments = $this->departments_model->get();
                            foreach ($departments as $department) {
                                array_push($departments_ids, $department['departmentid']);
                            }
                        } else {
                            $departments_ids = $staff_deparments_ids;
                        }
                        if (count($departments_ids) > 0) {
                            $this->db->where('department IN (SELECT departmentid FROM ' . db_prefix() . 'staff_departments WHERE departmentid IN (' . implode(',', $departments_ids) . ') AND staffid="' . get_staff_user_id() . '")');
                        }
                    }
                }

                $this->db->where('status', $status['ticketstatusid']);
                $total = $this->db->count_all_results(db_prefix() . 'tickets');
                if ($total > 0) {
                    array_push($chart['labels'], ticket_status_translate($status['ticketstatusid']));
                    array_push($_data['statusLink'], admin_url('tickets/index/' . $status['ticketstatusid']));
                    array_push($_data['backgroundColor'], $status['statuscolor']);
                    array_push($_data['hoverBackgroundColor'], adjust_color_brightness($status['statuscolor'], -20));
                    array_push($_data['data'], $total);
                }
            }
        }

        $chart['datasets'][] = $_data;

        return $chart;
    }
    
     /**
    *   @Function: Update agreements, image remove
    */
    public function delete_image($id)
    {
        $this->db->where('rel_id', $id);
        $this->db->where('rel_type', 'agreements');
        $attachment = $this->db->get(db_prefix() . 'files')->row();

        if ($attachment) {
            if (empty($attachment->external)) {
                $relPath  = 'uploads/agreements/' . $attachment->rel_id . '/';
                $fullPath = $relPath . $attachment->file_name;
                unlink($fullPath);
            }

            $this->db->where('id', $attachment->id);
            $this->db->delete(db_prefix() . 'files');
            if ($this->db->affected_rows() > 0) {
                $deleted = true;
            }
        }
        
        log_activity('Agreements Deleted [id: ' . $id . ']');
        return true;
    }
    
    /**
     * Add new article
     * @param array $data article data
     */
    public function addAgreement($data)
    {
        $this->db->insert(db_prefix() . 'student_agreements', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('New Agreements Added [id: ' . $insert_id . ']');
        }
        return $insert_id;
    }

    /**
     * Update article
     * @param  array $data article data
     * @param  mixed $id   id
     * @return boolean
     */
    public function updateAgreement($data, $id)
    {
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'student_agreements', $data);
        if ($this->db->affected_rows() > 0) {
            log_activity('Agreements Updated [id: ' . $id . ']');

            return true;
        }
        return false;
    }
    
    private function _get_query($param1 = NULL, $param2 = NULL)
    {           
    	$sql = array();
    	$f_sql = '';

		$date_timepicker_start   = $param2['date_timepicker_start'];
		$date_timepicker_end   = $param2['date_timepicker_end'];
		
		if(!empty($date_timepicker_start) && !empty($date_timepicker_end))
		{
			$sql[] = "a.deposit_date >= '".date('Y-m-d', strtotime($date_timepicker_start))."'";
			$sql[] = "a.deposit_date <= '".date('Y-m-d', strtotime($date_timepicker_end))."'";
		}
		elseif(!empty($date_timepicker_start) && empty($date_timepicker_end))
		{
			$sql[] = "a.deposit_date >= '".date('Y-m-d', strtotime($date_timepicker_start))."'";
			$sql[] = "a.deposit_date <= '".date('Y-m-d', strtotime($date_timepicker_start))."'";
		}
		elseif(empty($date_timepicker_start) && !empty($date_timepicker_end))
		{
			$sql[] = "a.deposit_date >= '".date('Y-m-d', strtotime($date_timepicker_end))."'";
			$sql[] = "a.deposit_date <= '".date('Y-m-d', strtotime($date_timepicker_end))."'";
		}
		else{
		    $sql[] = "a.deposit_date >= '".date('Y-m-d')."'";
			$sql[] = "a.deposit_date <= '".date('Y-m-d')."'";
		}
		
		if(!empty($param2['payment_mode_filter'])){
		    if($param2['payment_mode_filter'] != 'All'){
		        $sql[] = "a.payment_mode = '".$param2['payment_mode_filter']."'";
		    }
		}      
		$sql[] = "NOT ((b.Father_Mobile = '07582970904') OR (b.Father_Mobile = '9039524321'))";
		$order_by = 'a.deposit_date DESC';

		if(sizeof($sql) > 0)
		$f_sql = implode(' AND ', $sql);
		
		if($param1 == 'show_list' && isset($_POST["length"]) && $_POST["length"] != -1)  
       	{  
            $limit = $_POST['length'];
            $offset = $_POST['start'];
            if($f_sql)
            {
				return "SELECT a.*, CONCAT(b.firstname, ' ', b.middlename, ' ', b.lastname) as student_name,b.Father_Name,b.Mother_Name,b.Father_Mobile,b.Mother_Mobile,b.email,b.paa,a.dd_upi_online,a.note, b.Class, b.Shift , b.Campus  FROM (`tblstudent_fees_deposit` a) INNER JOIN `tblcontacts".$this->contact_tbl."` b ON `a`.`userid` = `b`.`userid`  WHERE  $f_sql AND `a`.`academic_year`='$this->academic_session' ORDER BY $order_by LIMIT $limit OFFSET $offset";
            }
            else
            {
				return "SELECT a.*, CONCAT(b.firstname, ' ', b.middlename, ' ', b.lastname) as student_name,b.Father_Name,b.Mother_Name,b.Father_Mobile,b.Mother_Mobile,b.email,b.paa,a.dd_upi_online,a.note, b.Class, b.Shift , b.Campus  FROM (`tblstudent_fees_deposit` a) INNER JOIN `tblcontacts".$this->contact_tbl."` b ON `a`.`userid` = `b`.`userid` where  `a`.`academic_year`='$this->academic_session' ORDER BY $order_by LIMIT $limit OFFSET $offset";		
            }
       	}  
       	else
       	{
       		if($f_sql)
            {
				return "SELECT a.*, CONCAT(b.firstname, ' ', b.middlename, ' ', b.lastname) as student_name,b.Father_Name,b.Mother_Name,b.Father_Mobile,b.Mother_Mobile,b.email,b.paa,a.dd_upi_online,a.note, b.Class, b.Shift  , b.Campus  FROM (`tblstudent_fees_deposit` a) INNER JOIN `tblcontacts".$this->contact_tbl."` b ON `a`.`userid` = `b`.`userid` WHERE  $f_sql AND  `a`.`academic_year`='$this->academic_session' ORDER BY $order_by";
            }
            else
            {
				return "SELECT a.*, CONCAT(b.firstname, ' ', b.middlename, ' ', b.lastname) as student_name,b.Father_Name,b.Mother_Name,b.Father_Mobile,b.Mother_Mobile,b.email,b.paa,a.dd_upi_online,a.note, b.Class, b.Shift , b.Campus  FROM (`tblstudent_fees_deposit` a) INNER JOIN `tblcontacts".$this->contact_tbl."` b ON `a`.`userid` = `b`.`userid` WHERE  `a`.`academic_year`='$this->academic_session'  ORDER BY $order_by";	
            }
       	}
    }

    function count_dayBookReport($post)
    {
       $query = $this->_get_query('count', $post);
       return $result = $this->db->query($query)->num_rows();
    }

    public function dayBookReport($post)
	{
		  $query = $this->_get_query('show_list', $post);
		 
		return $result = $this->db->query($query)->result();
	}
	
	
	
    public function totalDayBookN($type, $start_Date, $end_date){ 
        $contact_tbl_name = 'tblcontacts'.$this->contact_tbl;        
        $this->db->select('SUM(a.deposit_amount) as total_amount');
        $this->db->from('tblstudent_fees_deposit a');
        $this->db->join($contact_tbl_name.' b', 'a.userid=b.userid', 'inner');
        if(!empty($start_Date) && !empty($end_date))
		{
		    $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($start_Date)));
		    $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($end_date)));
		}
		elseif(!empty($start_Date) && empty($end_date))
		{
		    $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($start_Date)));
		    $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($start_Date)));
		}
		elseif(empty($start_Date) && !empty($end_date))
		{
		    $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($end_date)));
		    $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($end_date)));
		}
		else{
		    
		    $this->db->where('a.deposit_date >=', date('Y-m-d'));
		    $this->db->where('a.deposit_date <=', date('Y-m-d'));
		}
		if($type != 'All'){
		    $this->db->where('a.payment_mode', $type);
		}
		//$this->db->where('a.academic_year',$this->academic_session);
		$ignore = array('6264080852','07582970904','9039524321');
        $this->db->where_not_in('b.Father_Mobile', $ignore);
        $query = $this->db->get()->row();
        return  $query;
    }
    
    
    
    public function totalDayBookNStudentCount($type, $start_Date, $end_date){   
        $contact_tbl_name = 'tblcontacts'.$this->contact_tbl;      
        $this->db->select('a.*');
        $this->db->from('tblstudent_fees_deposit a');
        $this->db->join($contact_tbl_name.' b', 'a.userid=b.userid', 'inner');
        if(!empty($start_Date) && !empty($end_date))
		{
		    $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($start_Date)));
		    $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($end_date)));
		}
		elseif(!empty($start_Date) && empty($end_date))
		{
		    $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($start_Date)));
		    $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($start_Date)));
		}
		elseif(empty($start_Date) && !empty($end_date))
		{
		    $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($end_date)));
		    $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($end_date)));
		}
		else{
		    
		    $this->db->where('a.deposit_date >=', date('Y-m-d'));
		    $this->db->where('a.deposit_date <=', date('Y-m-d'));
		}
		if($type != 'All'){
		    $this->db->where('a.payment_mode', $type);
		}
		//$this->db->where('a.academic_year',$this->academic_session);
		$ignore = array('6264080852','07582970904','9039524321');
        $this->db->where_not_in('b.Father_Mobile', $ignore);
		$this->db->group_by('a.userid');
        $query = $this->db->get()->num_rows();
        return  $query;
    }
    
    
    
    public function totalDayBookNStudentFeesRecord($type, $start_Date, $end_date){
        $contact_tbl_name = 'tblcontacts'.$this->contact_tbl;        
        $this->db->select('a.*, CONCAT(b.firstname, b.middlename, b.lastname) as student_name,b.Father_Name,b.Mother_Name,b.Father_Mobile,b.Mother_Mobile,b.email, b.paa,a.dd_upi_online,a.note, b.Class, b.Shift, b.Campus');
        $this->db->from('tblstudent_fees_deposit a');
        $this->db->join($contact_tbl_name.' b', 'a.userid=b.userid', 'inner');
        if(!empty($start_Date) && !empty($end_date))
		{
		    $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($start_Date)));
		    $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($end_date)));
		}
		elseif(!empty($start_Date) && empty($end_date))
		{
		    $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($start_Date)));
		    $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($start_Date)));
		}
		elseif(empty($start_Date) && !empty($end_date))
		{
		    $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($end_date)));
		    $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($end_date)));
		}
		else{
		    
		    $this->db->where('a.deposit_date >=', date('Y-m-d'));
		    $this->db->where('a.deposit_date <=', date('Y-m-d'));
		}
		$this->db->where('a.academic_year',$this->academic_session);
		$ignore = array('6264080852','07582970904','9039524321');
        $this->db->where_not_in('b.Father_Mobile', $ignore);

		if($type != 'All'){
		    $this->db->where('a.payment_mode', $type);
		}
        $query = $this->db->get()->result();
        // echo $this->db->last_query();die;
        return  $query;
    }
    
	/* Day book export btn */
    public function totalDayBookNStudentFeesRecord_export($type, $start_Date, $end_date){
        $contact_tbl_name = 'tblcontacts'.$this->contact_tbl;        
        $this->db->select('a.*, CONCAT(b.firstname, b.middlename, b.lastname) as student_name,b.Father_Name,b.Mother_Name,b.Father_Mobile,b.Mother_Mobile,b.email, b.paa,a.dd_upi_online,a.note, b.Class, b.Shift, b.Campus');
        $this->db->from('tblstudent_fees_deposit a');
        $this->db->join($contact_tbl_name.' b', 'a.userid=b.userid', 'inner');
        if(!empty($start_Date) && !empty($end_date))
		{
		    $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($start_Date)));
		    $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($end_date)));
		}
		elseif(!empty($start_Date) && empty($end_date))
		{
		    $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($start_Date)));
		    $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($start_Date)));
		}
		elseif(empty($start_Date) && !empty($end_date))
		{
		    $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($end_date)));
		    $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($end_date)));
		}
		else{
		    
		    $this->db->where('a.deposit_date >=', date('Y-m-d'));
		    $this->db->where('a.deposit_date <=', date('Y-m-d'));
		}
		//$this->db->where('a.academic_year',$this->academic_session);
		$ignore = array('6264080852','07582970904','7582970904','9039524321');
        $this->db->where_not_in('b.Father_Mobile', $ignore);

		if($type != 'All'){
		    $this->db->where('a.payment_mode', $type);
		}
        $query = $this->db->get()->result_array();
        // echo $this->db->last_query();die;
        return  $query;
    }

	/* exportPackageStudent export btn */
    public function exportPackageStudent_export(){
        $contact_tbl_name = 'tblcontacts'.$this->contact_tbl;        
        $this->db->select('a.name as pname, a.amount as pamount, CONCAT(b.firstname, b.middlename, b.lastname) as student_name,b.Father_Name,b.Mother_Name,b.Father_Mobile,b.Mother_Mobile,b.email, b.paa, b.Class, b.Shift, b.Campus');
        $this->db->from($contact_tbl_name.' b');
        $this->db->join('tblstudent_package c', 'c.userid=b.userid', 'RIGHT');
        $this->db->join('tblmaster_package a', 'a.id=c.package_id', 'RIGHT');
        
		//$this->db->where('c.package_year',$this->academic_session);
		$this->db->group_by('b.userid');
		$ignore = array('6264080852','07582970904','7582970904','9039524321');
		$packageid = array('1','2','9','10','26','27','50','51');
        $this->db->where_not_in('b.Father_Mobile', $ignore);
        $this->db->where_in('c.package_id', $packageid);

        $query = $this->db->get()->result_array();
        return  $query;
    }

	public function db_backup()
	{
		$fileName='db_backup.zip';
		$this->load->dbutil();

		// Backup your entire database and assign it to a variable
		$backup = $this->dbutil->backup();

		// Load the file helper and write the file to your server
		$this->load->helper('file');
		write_file(base_url().'downloads/'.$fileName, $backup);

		// Load the download helper and send the file to your desktop
		$this->load->helper('download');
		force_download($fileName, $backup);
	}


    /* Student Payment Report export btn */
    public function studentPaymentReport_export(){
        $contact_tbl_name = 'tblcontacts'.$this->contact_tbl;        
        $this->db->select('a.name as pname, c.package_amount as pamount, CONCAT(b.firstname, b.middlename, b.lastname) as student_name,b.Father_Name,b.Mother_Name,b.Father_Mobile,b.Mother_Mobile,b.email, b.Academic_Year,b.Admission_Year, b.Class, b.Shift, b.Campus, c.deposit_amount as damount');
        $this->db->from($contact_tbl_name.' b');
        $this->db->join('tblstudent_package c', 'c.userid=b.userid', 'LEFT');
        $this->db->join('tblmaster_package a', 'a.id=c.package_id', 'LEFT');
        
        $this->db->where('b.Academic_Year',$this->academic_session);
        $this->db->where('c.package_year',$this->academic_session);
        //$this->db->group_by('b.userid');
        $ignore = array('6264080852','07582970904','7582970904','9039524321');
        //$packageid = array('15');
        $packageid = array('1','2','9','10','26','27','50','51');
        $this->db->where_not_in('b.Father_Mobile', $ignore);
        $this->db->where_not_in('c.package_id', $packageid);
        $this->db->where('c.deposit_amount !=', 0);

        $query = $this->db->get()->result_array();
        return  $query;
    }

}
