<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Clients_model extends App_Model
{
    private $contact_columns;

    public function __construct()
    {
        parent::__construct();

        $this->contact_columns = hooks()->apply_filters('contact_columns', ['firstname', 'lastname', 'email', 'phonenumber', 'title', 'password', 'send_set_password_email', 'donotsendwelcomeemail', 'permissions', 'direction', 'invoice_emails', 'estimate_emails', 'credit_note_emails', 'contract_emails', 'task_emails', 'project_emails', 'ticket_emails', 'is_primary']);

        $this->load->model(['client_vault_entries_model', 'client_groups_model', 'statement_model']);
    }

    /**
     * Get client object based on passed clientid if not passed clientid return array of all clients
     * @param  mixed $id    client id
     * @param  array  $where
     * @return mixed
     */
    public function get($id = '', $where = [])
    {
        $this->db->select(implode(',', prefixed_table_fields_array(db_prefix() . 'clients')) . ',' . get_sql_select_client_company());

        $this->db->join(db_prefix() . 'countries', '' . db_prefix() . 'countries.country_id = ' . db_prefix() . 'clients.country', 'left');
        $this->db->join(db_prefix() . 'contacts'.$this->contact_tbl, '' . db_prefix() . 'contacts'.$this->contact_tbl.'.userid = ' . db_prefix() . 'clients.userid AND is_primary = 1', 'left');

        if ((is_array($where) && count($where) > 0) || (is_string($where) && $where != '')) {
            $this->db->where($where);
        }

        if (is_numeric($id)) {
            $this->db->where(db_prefix() . 'clients.userid', $id);
            $client = $this->db->get(db_prefix() . 'clients')->row();

            if ($client && get_option('company_requires_vat_number_field') == 0) {
                $client->vat = null;
            }

            $GLOBALS['client'] = $client;

            return $client;
        }

        $this->db->order_by('company', 'asc');

        return $this->db->get(db_prefix() . 'clients')->result_array();
    }

    /**
     * Get customers contacts
     * @param  mixed $customer_id
     * @param  array  $where       perform where in query
     * @return array
     */
    public function get_contacts($customer_id = '', $where = ['active' => 1])
    {
        $this->db->where($where);
        if ($customer_id != '') {
            $this->db->where('userid', $customer_id);
        }
        $this->db->order_by('is_primary', 'DESC');

        return $this->db->get(db_prefix() . 'contacts'.$this->contact_tbl)->result_array();
    }
    
     /**
     * Get customers contacts
     * @param  mixed $customer_id
     * @param  array  $where       perform where in query
     * @return array
     */
    public function get_all_contacts($customer_id = '')
    {
       
        if ($customer_id != '') {
            $this->db->where('userid', $customer_id);
        }
        $this->db->order_by('is_primary', 'DESC');

        return $this->db->get(db_prefix() . 'contacts'.$this->contact_tbl)->result_array();
    }

    /**
     * Get single contacts
     * @param  mixed $id contact id
     * @return object
     */
    public function get_contact($id)
    {
        $this->db->where('id', $id);

        return $this->db->get(db_prefix() . 'contacts'.$this->contact_tbl)->row();
    }
    
    /**
     * Get single contacts
     * @param  mixed $id contact id
     * @return object
     */
    public function parentDetailsUpdate($id, $post)
    {
        $this->db->where('userid',$id);
        $thsi->db->update(db_prefix().'contacts'.$this->contact_tbl,  $post);

        return true;
    }

    /**
     * @param array $_POST data
     * @param client_request is this request from the customer area
     * @return integer Insert ID
     * Add new client to database
     */
    public function add($data_, $client_or_lead_convert_request = false)
    {
        $data = array();
        $user_data = array();
        
        $data['company'] = @$data_['company'];
        if($data_['vat'] != '')
        {
            $data['vat'] = @$data_['vat'];
        }
        if($data_['phonenumber'] != '')
        {
            $data['phonenumber'] = @$data_['phonenumber'];
        }
        if($data_['website'] != '')
        {
            $data['website'] = @$data_['website'];
        }if($data_['default_currency'] != '')
        {
            $data['default_currency'] = @$data_['default_currency'];
        }
        if($data_['default_language'] != '')
        {
            $data['default_language'] = @$data_['default_language'];
        }
        if($data_['address'] != '')
        {
            $data['address'] = @$data_['address'];
        }
        if($data_['city'] != '')
        {
            $data['city'] = @$data_['city'];
        }
        if($data_['state'] != '')
        {
            $data['state'] = @$data_['state'];
        }
        if($data_['country'] != '')
        {
            $data['country'] = @$data_['country'];
        }
        
        if($data_['billing_street'] != '')
        {
            $data['billing_street'] = @$data_['billing_street'];
        }
        
        if($data_['billing_city'] != '')
        {
            $data['billing_city'] = @$data_['billing_city'];
        }
        
        if($data_['billing_state'] != '')
        {
            $data['billing_state'] = @$data_['billing_state'];
        }
        
        if($data_['billing_zip'] != '')
        {
            $data['billing_zip'] = @$data_['billing_zip'];
        }
        
        if($data_['billing_country'] != '')
        {
            $data['billing_country'] = @$data_['billing_country'];
        }
        if($data_['shipping_street'] != '')
        {
            $data['shipping_street'] = @$data_['shipping_street'];
        }
        if($data_['shipping_city'] != '')
        {
            $data['shipping_city'] = @$data_['shipping_city'];
        }
        if($data_['shipping_state'] != '')
        {
            $data['shipping_state'] = @$data_['shipping_state'];
        }
        if($data_['shipping_zip'] != '')
        {
            $data['shipping_zip'] = @$data_['shipping_zip'];
        }
        if($data_['shipping_country'] != '')
        {
            $data['shipping_country'] = @$data_['shipping_country'];
        }
        if($data_['zip_code'] != '')
        {
            $data['zip'] = @$data_['zip_code'];
        }
       // echo '<pre>'; print_r($data); die;
        
        /*
        //echo '<pre>'; print_r($data); die;
        $contact_data = [];
        foreach ($this->contact_columns as $field) {
            if (isset($data[$field])) {
                $contact_data[$field] = $data[$field];
                // Phonenumber is also used for the company profile
                if ($field != 'phonenumber') {
                    unset($data[$field]);
                }
            }
        }

        // From customer profile register
        if (isset($data['contact_phonenumber'])) {
            $contact_data['phonenumber'] = $data['contact_phonenumber'];
            unset($data['contact_phonenumber']);
        }

        if (isset($data['custom_fields'])) {
            $custom_fields = $data['custom_fields'];
            unset($data['custom_fields']);
        }

        if (isset($data['groups_in'])) {
            $groups_in = $data['groups_in'];
            unset($data['groups_in']);
        }

        $data = $this->check_zero_columns($data);
*/
        if (isset($data_['custom_fields'])) {
            $custom_fields = $data_['custom_fields'];
            unset($data_['custom_fields']);
        }

        if (isset($data_['groups_in'])) {
            $groups_in = $data_['groups_in'];
            unset($data_['groups_in']);
        }

        if($data['company'] == '')
        {
            $data['company'] = $data_['first_name'];
        }
        if($data['country'] == '')
        {
            $data['country'] = 102;
        }
    
        $data['datecreated'] = date('Y-m-d H:i:s');

        if (is_staff_logged_in()) {
            $data['addedfrom'] = get_staff_user_id();
        }
        
        // New filter action
       // $data = hooks()->apply_filters('before_client_added', $data);
//echo '<pre>'; print_r($data); die;
        $this->db->insert(db_prefix() . 'clients', $data);
//$sql = $this->db->last_query();
//echo ''; print_r($sql); die;
        $userid = $this->db->insert_id();
       //echo $userid;
        if ($userid) {
            
            $user_data['userid'] = $userid;
            if($data_['first_name'] != '')
            {
                $user_data['firstname'] = @$data_['first_name'];
            }
            if($data_['last_name'] != '')
            {
                $user_data['lastname'] = @$data_['last_name'];
            }
            if($data_['email'] != '')
            {
                $user_data['email'] = @$data_['email'];
            }
            if($data_['password'] != '')
            {
                $user_data['password'] = app_hash_password(@$data_['password']);
                $password_before_hash = @$data_['password'];
            }
            else
            {
                $password_before_hash = time();
                $user_data['password'] = app_hash_password($password_before_hash);
            }
           // echo '<pre>'; print_r($user_data); die;
            //$this->db->insert('tblcontacts', $user_data);
            $this->db->insert(db_prefix() . 'contacts'.$this->contact_tbl, $user_data);
            $contact_id = $this->db->insert_id();
            if ($user_data['email'] != '') {
                send_mail_template('customer_created_welcome_mail', $user_data['email'], $userid, $contact_id, $password_before_hash);
            }

            if (defined('CONTACT_REGISTERING')) {
                $this->send_verification_email($contact_id);
            }
            
            if (isset($custom_fields)) {
                $_custom_fields = $custom_fields;
                // Possible request from the register area with 2 types of custom fields for contact and for comapny/customer
                if (count($custom_fields) == 2) {
                    unset($custom_fields);
                    $custom_fields['customers']                = $_custom_fields['customers'];
                    $contact_data['custom_fields']['contacts'] = $_custom_fields['contacts'];
                } elseif (count($custom_fields) == 1) {
                    if (isset($_custom_fields['contacts'])) {
                        $contact_data['custom_fields']['contacts'] = $_custom_fields['contacts'];
                        unset($custom_fields);
                    }
                }
                handle_custom_fields_post($userid, $custom_fields);
            }
            /**
             * Used in Import, Lead Convert, Register
             */
            if ($client_or_lead_convert_request == true) {
                $contact_id = $this->add_contact($contact_data, $userid, $client_or_lead_convert_request);
            }
            if (isset($groups_in)) {
                foreach ($groups_in as $group) {
                    $this->db->insert(db_prefix() . 'customer_groups', [
                        'customer_id' => $userid,
                        'groupid'     => $group,
                    ]);
                }
            }

            $log = 'ID: ' . $userid;

            if ($log == '' && isset($contact_id)) {
                $log = get_contact_full_name($contact_id);
            }

            $isStaff = null;
            if (!is_client_logged_in() && is_staff_logged_in()) {
                $log .= ', From Staff: ' . get_staff_user_id();
                $isStaff = get_staff_user_id();
            }

            hooks()->do_action('after_client_added', $userid);

            log_activity('New Client Created [' . $log . ']', $isStaff);
        }

        return $userid;
    }


    /**
     * @param array $_POST data
     * @param client_request is this request from the customer area
     * @return integer Insert ID
     * Add new client to database
     */
    public function add_($data_, $client_or_lead_convert_request = false)
    {
        $contact_data = [];
        foreach ($this->contact_columns as $field) {
            if (isset($data[$field])) {
                $contact_data[$field] = $data[$field];
                // Phonenumber is also used for the company profile
                if ($field != 'phonenumber') {
                    unset($data[$field]);
                }
            }
        }

        // From customer profile register
        if (isset($data_['contact_phonenumber'])) {
            $contact_data['phonenumber'] = $data['contact_phonenumber'];
            unset($data_['contact_phonenumber']);
        }

        if (isset($data_['custom_fields'])) {
            $custom_fields = $data_['custom_fields'];
            unset($data_['custom_fields']);
        }

        if (isset($data_['groups_in'])) {
            $groups_in = $data_['groups_in'];
            unset($data_['groups_in']);
        }

        $data = $this->check_zero_columns($data);
        $company_data = array();
        if($data_['firstname'])
        {
            //$company_data['company'] = $data_['firstname'].' '.$data_['lastname'];
            if($data_['middlename'] == '')
            {
               $company_data['company'] = ucfirst(strtolower($data_['firstname'])).' '.ucfirst(strtolower($data_['lastname']));
            }
            else
            {
                $company_data['company'] = ucfirst(strtolower($data_['firstname'])).' '.ucfirst(strtolower($data_['middlename'])) .' '.ucfirst(strtolower($data_['lastname']));
            }
        }
        if($data_['Father_Mobile'])
        {
            $company_data['phonenumber'] = $data_['Father_Mobile'];
        }

        $company_data['datecreated'] = date('Y-m-d H:i:s');

        if (is_staff_logged_in()) {
            $company_data['addedfrom'] = get_staff_user_id();
        }

        // New filter action
        $company_data = hooks()->apply_filters('before_client_added', $company_data);

        $this->db->insert(db_prefix() . 'clients', $company_data);

        $userid = $this->db->insert_id();
        if ($userid) {
            if (isset($custom_fields)) {
                $_custom_fields = $custom_fields;
                // Possible request from the register area with 2 types of custom fields for contact and for comapny/customer
                if (count($custom_fields) == 2) {
                    unset($custom_fields);
                    $custom_fields['customers']                = $_custom_fields['customers'];
                    $contact_data['custom_fields']['contacts'] = $_custom_fields['contacts'];
                } elseif (count($custom_fields) == 1) {
                    if (isset($_custom_fields['contacts'])) {
                        $contact_data['custom_fields']['contacts'] = $_custom_fields['contacts'];
                        unset($custom_fields);
                    }
                }
                handle_custom_fields_post($userid, $custom_fields);
            }
            $contact_data = $data_;
            /**
             * Used in Import, Lead Convert, Register
             */
            if ($client_or_lead_convert_request == true) {
                $contact_id = $this->add_contact($contact_data, $userid, $client_or_lead_convert_request);
            }
            if (isset($groups_in)) {
                foreach ($groups_in as $group) {
                    $this->db->insert(db_prefix() . 'customer_groups', [
                        'customer_id' => $userid,
                        'groupid'     => $group,
                    ]);
                }
            }

            $log = 'ID: ' . $userid;

            if ($log == '' && isset($contact_id)) {
                $log = get_contact_full_name($contact_id);
            }

            $isStaff = null;
            if (!is_client_logged_in() && is_staff_logged_in()) {
                $log .= ', From Staff: ' . get_staff_user_id();
                $isStaff = get_staff_user_id();
            }

            hooks()->do_action('after_client_added', $userid);

            log_activity('New Client Created [' . $log . ']', $isStaff);
        }

        return $userid;
    }

    public function lastquery($data, $client_or_lead_convert_request = false)
    {
        
        $data2['param'] =  json_encode($data);
        $data2['last_q'] = $this->db->last_query();
        $this->db->insert(db_prefix() . 'client_faild_log', $data2);
        return true;
    }

    /**
     * @param  array $_POST data
     * @param  integer ID
     * @return boolean
     * Update client informations
     */
    public function update($data_, $id, $client_request = false)
    {
        //echo '<pre>'; print_r($data_); die; 
        $data = array();
        $user_data = array();
        if($data_['company'] != '')
        {
            $data['company'] = @$data_['company'];
        }
        
        if($data_['vat'] != '')
        {
            $data['vat'] = @$data_['vat'];
        }
        if($data_['phonenumber'] != '')
        {
            $data['phonenumber'] = @$data_['phonenumber'];
        }
        if($data_['website'] != '')
        {
            $data['website'] = @$data_['website'];
        }if($data_['default_currency'] != '')
        {
            $data['default_currency'] = @$data_['default_currency'];
        }
        if($data_['default_language'] != '')
        {
            $data['default_language'] = @$data_['default_language'];
        }
        if($data_['address'] != '')
        {
            $data['address'] = @$data_['address'];
        }
        if($data_['city'] != '')
        {
            $data['city'] = @$data_['city'];
        }
        if($data_['state'] != '')
        {
            $data['state'] = @$data_['state'];
        }
        if($data_['country'] != '')
        {
            $data['country'] = @$data_['country'];
        }
        
        if($data_['billing_street'] != '')
        {
            $data['billing_street'] = @$data_['billing_street'];
        }
        
        if($data_['billing_city'] != '')
        {
            $data['billing_city'] = @$data_['billing_city'];
        }
        
        if($data_['billing_state'] != '')
        {
            $data['billing_state'] = @$data_['billing_state'];
        }
        
        if($data_['billing_zip'] != '')
        {
            $data['billing_zip'] = @$data_['billing_zip'];
        }
        
        if($data_['billing_country'] != '')
        {
            $data['billing_country'] = @$data_['billing_country'];
        }
        if($data_['shipping_street'] != '')
        {
            $data['shipping_street'] = @$data_['shipping_street'];
        }
        if($data_['shipping_city'] != '')
        {
            $data['shipping_city'] = @$data_['shipping_city'];
        }
        if($data_['shipping_state'] != '')
        {
            $data['shipping_state'] = @$data_['shipping_state'];
        }
        if($data_['shipping_zip'] != '')
        {
            $data['shipping_zip'] = @$data_['shipping_zip'];
        }
        if($data_['shipping_country'] != '')
        {
            $data['shipping_country'] = @$data_['shipping_country'];
        }
        if($data_['zip_code'] != '')
        {
            $data['zip'] = @$data_['zip_code'];
        }
        
        if (isset($data_['update_all_other_transactions'])) {
            $update_all_other_transactions = true;
            unset($data_['update_all_other_transactions']);
        }

        if (isset($data_['update_credit_notes'])) {
            $update_credit_notes = true;
            unset($data_['update_credit_notes']);
        }

        $affectedRows = 0;
        if (isset($data_['custom_fields'])) {
            $custom_fields = $data_['custom_fields'];
            if (handle_custom_fields_post($id, $custom_fields)) {
                $affectedRows++;
            }
            unset($data_['custom_fields']);
        }

        if (isset($data_['groups_in'])) {
            $groups_in = $data_['groups_in'];
            unset($data_['groups_in']);
        }

        $data = $this->check_zero_columns($data);

        $data = hooks()->apply_filters('before_client_updated', $data, $id);
        if($data['company']==''){
            $data['company'] = @$data_['first_name'].' '.@$data_['last_name'];
        }
        $this->db->where('userid', $id);
        $this->db->update(db_prefix() . 'clients', $data);

        if($id)
        {
          if($data_['first_name'] != '')
            {
                $user_data['firstname'] = @$data_['first_name'];
            }
            if($data_['middlename'] != '')
            {
                $user_data['middlename'] = @$data_['middlename'];
            }
            else{
                $user_data['middlename'] = '';
            }
            if($data_['last_name'] != '')
            {
                $user_data['lastname'] = @$data_['last_name'];
            }
            if($data_['email'] != '')
            {
                $user_data['email'] = @$data_['email'];
            }            
            if($data_['Academic_Year'] != '')
            {
                $user_data['Academic_Year'] = @$data_['Academic_Year'];
            }
            if($data_['Shift'] != '')
            {
                $user_data['Shift'] = @$data_['Shift'];
            }
            if($data_['Gender'] != '')
            {
                $user_data['Gender'] = @$data_['Gender'];
            }
            if($data_['Class'] != '')
            {
                $user_data['Class'] = @$data_['Class'];
            }
            if($data_['subject_id'] != '')
            {
                $user_data['subject_id'] = @$data_['subject_id'];
            }
            else{
                $user_data['subject_id'] = 0;
            }
            if($data_['optional_subject'] != '')
            {
                $user_data['optional_subject'] = @$data_['optional_subject'];
            }
            else{
                $user_data['optional_subject'] = 0;
            }
            if($data_['Campus'] != '')
            {
                $user_data['Campus'] = @$data_['Campus'];
            }
            if($data_['Admission_Year'] != '')
            {
                $user_data['Admission_Year'] = @$data_['Admission_Year'];
            }
            if($data_['Date_of_Birth'] != '')
            {
                $user_data['Date_of_Birth'] = @$data_['Date_of_Birth'];
            }
            if($data_['Place_Of_Birth'] != '')
            {
                $user_data['Place_Of_Birth'] = @$data_['Place_Of_Birth'];
            }
            if($data_['Religion'] != '')
            {
                $user_data['Religion'] = @$data_['Religion'];
            }
            if($data_['Nationality'] != '')
            {
                $user_data['Nationality'] = @$data_['Nationality'];
            }
            if($data_['Caste'] != '')
            {
                $user_data['Caste'] = @$data_['Caste'];
            }
            if($data_['Mother_Tongue'] != '')
            {
                $user_data['Mother_Tongue'] = @$data_['Mother_Tongue'];
            }
            if($data_['Mother_Tongue'] != '')
            {
                $user_data['Mother_Tongue'] = @$data_['Mother_Tongue'];
            }   
            if($data_['Birth_Certificate'] != '')
            {
                $user_data['Birth_Certificate'] = @$data_['Birth_Certificate'];
            }
            if($data_['Aadhar_Card'] != '')
            {
                $user_data['Aadhar_Card'] = @$data_['Aadhar_Card'];
            }
            if($data_['Samagra_ID'] != '')
            {
                $user_data['Samagra_ID'] = @$data_['Samagra_ID'];
            }
            if($data_['student_address'] != '')
            {
                $user_data['student_address'] = @$data_['student_address'];
            }
            if($data_['payment_status'] != '')
            {
                $user_data['payment_status'] = @$data_['payment_status'];
            }
            /*
            if($data_['category'] != '')
            {
                $user_data['category'] = @$data_['category'];
            }
            */
            if($data_['bank_account_number'] != '')
            {
                $user_data['bank_account_number'] = @$data_['bank_account_number'];
            }
            if($data_['bank_name'] != '')
            {
                $user_data['bank_name'] = @$data_['bank_name'];
            }
            if($data_['IFSC_code'] != '')
            {
                $user_data['IFSC_code'] = @$data_['IFSC_code'];
            }
            if($data_['Date_of_Admission'] != '')
            {
                $user_data['Date_of_Admission'] = @$data_['Date_of_Admission'];
            }
            if($data_['TC'] != '')
            {
                $user_data['TC'] = @$data_['TC'];
            }   
            if($data_['caste_certificate'] != '')
            {
                $user_data['caste_certificate'] = @$data_['caste_certificate'];
            }            
            if($data_['zip_code'] != '')
            {
                $user_data['Pincode'] = @$data_['zip_code'];
            }          
            if($data_['scholar_no'] != '')
            {
                $user_data['scholar_no'] = @$data_['scholar_no'];
            }
            
            if($data_['password'] != '')
            {
                $user_data['password'] = app_hash_password(@$data_['password']);
                $password_before_hash = @$data_['password'];
                $user_data['last_password_change'] = date('Y-m-d H:i:s');
            }
            $user_data['updated_date'] = date('Y-m-d H:i:s');
            $user_data['portal_by'] = '1';
            $user_data['updated_ip'] = $this->input->ip_address();
            $this->db->where('userid', $id);
        	$this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, $user_data);  
        }

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
        }

        if (isset($update_all_other_transactions) || isset($update_credit_notes)) {
            $transactions_update = [
                    'billing_street'   => $data['billing_street'],
                    'billing_city'     => $data['billing_city'],
                    'billing_state'    => $data['billing_state'],
                    'billing_zip'      => $data['billing_zip'],
                    'billing_country'  => $data['billing_country'],
                    'shipping_street'  => $data['shipping_street'],
                    'shipping_city'    => $data['shipping_city'],
                    'shipping_state'   => $data['shipping_state'],
                    'shipping_zip'     => $data['shipping_zip'],
                    'shipping_country' => $data['shipping_country'],
                ];
            if (isset($update_all_other_transactions)) {

                // Update all invoices except paid ones.
                $this->db->where('clientid', $id);
                $this->db->where('status !=', 2);
                $this->db->update(db_prefix() . 'invoices', $transactions_update);
                if ($this->db->affected_rows() > 0) {
                    $affectedRows++;
                }

                // Update all estimates
                $this->db->where('clientid', $id);
                $this->db->update(db_prefix() . 'estimates', $transactions_update);
                if ($this->db->affected_rows() > 0) {
                    $affectedRows++;
                }
            }
            if (isset($update_credit_notes)) {
                $this->db->where('clientid', $id);
                $this->db->where('status !=', 2);
                $this->db->update(db_prefix() . 'creditnotes', $transactions_update);
                if ($this->db->affected_rows() > 0) {
                    $affectedRows++;
                }
            }
        }

        if (!isset($groups_in)) {
            $groups_in = false;
        }

        if ($this->client_groups_model->sync_customer_groups($id, $groups_in)) {
            $affectedRows++;
        }

        if ($affectedRows > 0) {
            hooks()->do_action('after_client_updated', $id);

            log_activity('Customer Info Updated [ID: ' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * Update contact data
     * @param  array  $data           $_POST data
     * @param  mixed  $id             contact id
     * @param  boolean $client_request is request from customers area
     * @return mixed
     */
    public function update_contact($data, $id, $client_request = false)
    {
        $affectedRows = 0;
        $contact      = $this->get_contact($id);
        if (empty($data['password'])) {
            unset($data['password']);
        } else {
            $data['paa']             = $data['password'];
            $data['password']             = app_hash_password($data['password']);
            $data['last_password_change'] = date('Y-m-d H:i:s');
        }

        $send_set_password_email = isset($data['send_set_password_email']) ? true : false;
        $set_password_email_sent = false;

        $permissions        = isset($data['permissions']) ? $data['permissions'] : [];
        $data['is_primary'] = isset($data['is_primary']) ? 1 : 0;

        // Contact cant change if is primary or not
        if ($client_request == true) {
            unset($data['is_primary']);
        }

        if (isset($data['custom_fields'])) {
            $custom_fields = $data['custom_fields'];
            if (handle_custom_fields_post($id, $custom_fields)) {
                $affectedRows++;
            }
            unset($data['custom_fields']);
        }

        if ($client_request == false) {
            $data['invoice_emails']     = isset($data['invoice_emails']) ? 1 :0;
            $data['estimate_emails']    = isset($data['estimate_emails']) ? 1 :0;
            $data['credit_note_emails'] = isset($data['credit_note_emails']) ? 1 :0;
            $data['contract_emails']    = isset($data['contract_emails']) ? 1 :0;
            $data['task_emails']        = isset($data['task_emails']) ? 1 :0;
            $data['project_emails']     = isset($data['project_emails']) ? 1 :0;
            $data['ticket_emails']      = isset($data['ticket_emails']) ? 1 :0;
        }

        $data = hooks()->apply_filters('before_update_contact', $data, $id);

        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, $data);

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
            if (isset($data['is_primary']) && $data['is_primary'] == 1) {
                $this->db->where('userid', $contact->userid);
                $this->db->where('id !=', $id);
                $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, [
                    'is_primary' => 0,
                ]);
            }
        }

        if ($client_request == false) {
            $customer_permissions = $this->roles_model->get_contact_permissions($id);
            if (sizeof($customer_permissions) > 0) {
                foreach ($customer_permissions as $customer_permission) {
                    if (!in_array($customer_permission['permission_id'], $permissions)) {
                        $this->db->where('userid', $id);
                        $this->db->where('permission_id', $customer_permission['permission_id']);
                        $this->db->delete(db_prefix() . 'contact_permissions');
                        if ($this->db->affected_rows() > 0) {
                            $affectedRows++;
                        }
                    }
                }
                foreach ($permissions as $permission) {
                    $this->db->where('userid', $id);
                    $this->db->where('permission_id', $permission);
                    $_exists = $this->db->get(db_prefix() . 'contact_permissions')->row();
                    if (!$_exists) {
                        $this->db->insert(db_prefix() . 'contact_permissions', [
                            'userid'        => $id,
                            'permission_id' => $permission,
                        ]);
                        if ($this->db->affected_rows() > 0) {
                            $affectedRows++;
                        }
                    }
                }
            } else {
                foreach ($permissions as $permission) {
                    $this->db->insert(db_prefix() . 'contact_permissions', [
                        'userid'        => $id,
                        'permission_id' => $permission,
                    ]);
                    if ($this->db->affected_rows() > 0) {
                        $affectedRows++;
                    }
                }
            }
            if ($send_set_password_email) {
                $set_password_email_sent = $this->authentication_model->set_password_email($data['email'], 0);
            }
        }

        if ($affectedRows > 0) {
            hooks()->do_action('contact_updated', $id, $data);
        }

        if ($affectedRows > 0 && !$set_password_email_sent) {
            log_activity('Contact Updated [ID: ' . $id . ']');

            return true;
        } elseif ($affectedRows > 0 && $set_password_email_sent) {
            return [
                'set_password_email_sent_and_profile_updated' => true,
            ];
        } elseif ($affectedRows == 0 && $set_password_email_sent) {
            return [
                'set_password_email_sent' => true,
            ];
        }

        return false;
    }

    /**
     * Add new contact
     * @param array  $data               $_POST data
     * @param mixed  $customer_id        customer id
     * @param boolean $not_manual_request is manual from admin area customer profile or register, convert to lead
     */
    public function add_contact($data, $customer_id, $not_manual_request = false)
    {
        $send_set_password_email = isset($data['send_set_password_email']) ? true : false;

        if (isset($data['custom_fields'])) {
            $custom_fields = $data['custom_fields'];
            unset($data['custom_fields']);
        }

        if (isset($data['permissions'])) {
            $permissions = $data['permissions'];
            unset($data['permissions']);
        }

        $data['email_verified_at'] = date('Y-m-d H:i:s');

        $send_welcome_email = true;

        if (isset($data['donotsendwelcomeemail'])) {
            $send_welcome_email = false;
        }

        if (defined('CONTACT_REGISTERING')) {
            $send_welcome_email = true;

            // Do not send welcome email if confirmation for registration is enabled
            if (get_option('customers_register_require_confirmation') == '1') {
                $send_welcome_email = false;
            }

            // If client register set this contact as primary
            $data['is_primary'] = 1;
            if (is_email_verification_enabled() && !empty($data['email'])) {
                // Verification is required on register
                $data['email_verified_at']      = null;
                $data['email_verification_key'] = app_generate_hash();
            }
        }

        if (isset($data['is_primary'])) {
            $data['is_primary'] = 1;
            $this->db->where('userid', $customer_id);
            $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, [
                'is_primary' => 0,
            ]);
        } else {
            $data['is_primary'] = 0;
        }

        $password_before_hash = '';
        $data['userid']       = $customer_id;
        if (isset($data['password'])) {
            $password_before_hash = $data['password'];
            $data['password']     = app_hash_password($data['password']);
            $data['paa']     = $data['password'];
        }

        $data['datecreated'] = date('Y-m-d H:i:s');

        if (!$not_manual_request) {
            $data['invoice_emails']     = isset($data['invoice_emails']) ? 1 :0;
            $data['estimate_emails']    = isset($data['estimate_emails']) ? 1 :0;
            $data['credit_note_emails'] = isset($data['credit_note_emails']) ? 1 :0;
            $data['contract_emails']    = isset($data['contract_emails']) ? 1 :0;
            $data['task_emails']        = isset($data['task_emails']) ? 1 :0;
            $data['project_emails']     = isset($data['project_emails']) ? 1 :0;
            $data['ticket_emails']      = isset($data['ticket_emails']) ? 1 :0;
        }

        $data['email'] = trim($data['email']);
        if($data['email'] == '')
        {
            if($data['Father_Mobile'] != '')
            {
                
                $data['email'] = strtolower(substr($data['firstname'], 0, 3)).''.substr($data['Father_Mobile'], -5);
            }
            elseif($data['Mother_Mobile'] != '')
            {
                $data['email'] = strtolower(substr($data['firstname'], 0, 3)).''.substr($data['Mother_Mobile'], -5);
            }
            else
            {
                $data['email'] = strtolower(substr($data['firstname'], 0, 3)).''.rand(1000,9999);
            }
            //$data['email'] = strtolower($data['firstname']).''.$data['Father_Mobile'].'@gmail.com';
        }
        $data['paa'] = strtolower($data['firstname'].'123');
        $data = hooks()->apply_filters('before_create_contact', $data);
        $data['classId']  = class_ID($data['Class']);
        
        $studentData['Form_No'] = @$data['Form_No'];
        $studentData['S_No'] = @$data['S_No'];
        $studentData['Date_of_Admission'] = @$data['Date_of_Admission'];
        $studentData['Recipt_No'] = @$data['Recipt_No'];
        $studentData['Form_No'] = @$data['Form_No'];
        $studentData['Admission_Year'] = @$data['Admission_Year'];
        $studentData['Campus'] = @$data['Campus'];
        $studentData['Old_student_New_student'] = @$data['Old_student_New_student'];
        $studentData['Shift'] = @$data['Shift'];
        $studentData['Class'] = @$data['Class'];
        $studentData['Academic_Year'] = @$data['Academic_Year'];
        $studentData['firstname'] = ucfirst(strtolower(@$data['firstname']));
        $studentData['middlename'] = ucfirst(strtolower(@$data['middlename']));
        $studentData['lastname'] = ucfirst(strtolower(@$data['lastname']));
        $studentData['Gender'] = @$data['Gender'];
        $studentData['Date_of_Birth'] = @$data['Date_of_Birth'];
        $studentData['Place_Of_Birth'] = @$data['Place_Of_Birth'];
        $studentData['Religion'] = @$data['Religion'];
        $studentData['Nationality'] = @$data['Nationality'];
        $studentData['Caste'] = @$data['Caste'];
        $studentData['Mother_Tongue'] = @$data['Mother_Tongue'];
        $studentData['Birth_Certificate'] = @$data['Birth_Certificate'];
        $studentData['Aadhar_Card'] = @$data['Aadhar_Card'];
        $studentData['Samagra_ID'] = @$data['Samagra_ID'];
        $studentData['TC'] = @$data['TC'];
        $studentData['House_No_And_Building'] = @$data['House_No_And_Building'];
        $studentData['Street'] = @$data['Street'];
        $studentData['Location_Area'] = @$data['Location_Area'];
        $studentData['City'] = @$data['City'];
        $studentData['Pincode'] = @$data['Pincode'];
        $studentData['State'] = @$data['State'];
        $studentData['Telephone'] = @$data['Telephone'];
        $studentData['Father_Mobile'] = @$data['Father_Mobile'];
        $studentData['Mother_Mobile'] = @$data['Mother_Mobile'];
        $studentData['Father_Email'] = @$data['Father_Email'];
        $studentData['Mother_Email'] = @$data['Mother_Email'];
        $studentData['Father_Name'] = ucfirst(strtolower(@$data['Father_Name']));
        $studentData['Father_Qualification'] = @$data['Father_Qualification'];
        $studentData['Father_Others_Qualification'] = @$data['Father_Others_Qualification'];
        $studentData['Father_Occupation'] = @$data['Father_Occupation'];
        $studentData['Name_Of_Employer'] = @$data['Name_Of_Employer'];
        $studentData['Father_Designation'] = @$data['Father_Designation'];
        $studentData['Mother_Name'] = ucfirst(strtolower(@$data['Mother_Name']));
        $studentData['Mother_Qualification'] = @$data['Mother_Qualification'];
        $studentData['Mother_Others_Qualification'] = @$data['Mother_Others_Qualification'];
        $studentData['Mother_Occupation'] = @$data['Mother_Occupation'];
        $studentData['Mother_Designation'] = @$data['Mother_Designation'];
        $studentData['Gaurdian_Name'] = @$data['Gaurdian_Name'];
        $studentData['Gaurdian_Qualification'] = @$data['Gaurdian_Qualification'];
        $studentData['Gaurdian_Occupation'] = @$data['Gaurdian_Occupation'];
        $studentData['Gaurdian_Name_Of_Employer'] = @$data['Gaurdian_Name_Of_Employer'];
        $studentData['Gaurdian_Designation'] = @$data['Gaurdian_Designation'];
        $studentData['Gaurdian_Mobile_no'] = @$data['Gaurdian_Mobile_no'];
        $studentData['Emergency_Communication_To'] = @$data['Emergency_Communication_To'];
        $studentData['Emergency_address'] = @$data['Emergency_address'];
        $studentData['Emergency_Conatact_Mobile'] = @$data['Emergency_Conatact_Mobile'];
        $studentData['Gaurdian_Address'] = @$data['Gaurdian_Address'];
        $studentData['Brother_Sister_Status'] = @$data['Brother_Sister_Status'];
        $studentData['Brother_Sister_Class'] = @$data['Brother_Sister_Class'];
        $studentData['Current_School_Name'] = @$data['Current_School_Name'];
        $studentData['Current_Class'] = @$data['Current_Class'];
        $studentData['Special_Learning_Need'] = @$data['Special_Learning_Need'];
        $studentData['Received_Special_Instruction'] = @$data['Received_Special_Instruction'];
        $studentData['Remark'] = @$data['Remark'];
        $studentData['email'] = @$data['email'];
        $studentData['paa'] = @$data['paa'];
        $studentData['password'] = app_hash_password(@$data['paa']);
        $studentData['user_transport_id'] = @$data['user_transport_id'];
        $studentData['classId'] = @$data['classId'];
        $studentData['payment_status'] = @$data['payment_status'];
        $studentData['datecreated'] = @$data['datecreated'];
        $studentData['is_primary'] = @$data['is_primary'];
        $studentData['email_verified_at'] = @$data['email_verified_at'];
        $studentData['userid'] = @$data['userid'];
        $reg2 = 'ISB1120';
        
        if($data['Class']=='Playgroup'){
            $CID ='01';
        }   

        if($data['Class']=='Nursery'){
            $CID ='02';
        } 


        if($data['Class']=='LKG'){
            $CID ='03';
        } 

        if($data['Class']=='UKG'){
            $CID ='04';
        } 

        if($data['Class']=='Class I'){
            $CID ='05';
        } 
        if($data['Class']=='Class II'){
            $CID ='06';
        }

        if($data['Class']=='Class III'){
            $CID ='07';
        }

        if($data['Class']=='Class IV'){
            $CID ='08';
        }
        if($data['Class']=='Class V'){
            $CID ='09';
        }

        if($data['Class']=='Class VI'){
            $CID ='10';
        }
        if($data['Class']=='Class VII'){
            $CID ='11';
        }   
        if($data['Class']=='Class VIII'){
            $CID ='12';
        }
        $resClass =  $this->db->order_by('id', 'desc')->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => $data['Class']))->row('registration_id');
        $resClass_ = substr($resClass, -3);
        $resClass_ = $resClass_ + 1;
        $invID = str_pad($resClass_, 3, '0', STR_PAD_LEFT);
        $reg = $reg2.$CID.$invID;
        
        $studentData['registration_id']  = $reg;
        $studentData['payment_status']  = 2;
        
        $this->db->insert(db_prefix() . 'contacts'.$this->contact_tbl, $studentData);
        $contact_id = $this->db->insert_id();
        
        //$sql = $this->db->last_query();
       // echo '<pre>'; print_r($data); echo '<br>';
        //echo '<pre>'; print_r($contact_id); die;     
        if ($contact_id) {
            if (isset($custom_fields)) {
                handle_custom_fields_post($contact_id, $custom_fields);
            }
            // request from admin area
            if (!isset($permissions) && $not_manual_request == false) {
                $permissions = [];
            } elseif ($not_manual_request == true) {
                $permissions         = [];
                $_permissions        = get_contact_permissions();
                $default_permissions = @unserialize(get_option('default_contact_permissions'));
                if (is_array($default_permissions)) {
                    foreach ($_permissions as $permission) {
                        if (in_array($permission['id'], $default_permissions)) {
                            array_push($permissions, $permission['id']);
                        }
                    }
                }
            }

            if ($not_manual_request == true) {
                // update all email notifications to 0
                $this->db->where('id', $contact_id);
                $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, [
                    'invoice_emails'     => 0,
                    'estimate_emails'    => 0,
                    'credit_note_emails' => 0,
                    'contract_emails'    => 0,
                    'task_emails'        => 0,
                    'project_emails'     => 0,
                    'ticket_emails'      => 0,
                ]);
            }
            foreach ($permissions as $permission) {
                $this->db->insert(db_prefix() . 'contact_permissions', [
                    'userid'        => $contact_id,
                    'permission_id' => $permission,
                ]);

                // Auto set email notifications based on permissions
                if ($not_manual_request == true) {
                    if ($permission == 6) {
                        $this->db->where('id', $contact_id);
                        $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, ['project_emails' => 1, 'task_emails' => 1]);
                    } elseif ($permission == 3) {
                        $this->db->where('id', $contact_id);
                        $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, ['contract_emails' => 1]);
                    } elseif ($permission == 2) {
                        $this->db->where('id', $contact_id);
                        $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, ['estimate_emails' => 1]);
                    } elseif ($permission == 1) {
                        $this->db->where('id', $contact_id);
                        $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, ['invoice_emails' => 1, 'credit_note_emails' => 1]);
                    } elseif ($permission == 5) {
                        $this->db->where('id', $contact_id);
                        $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, ['ticket_emails' => 1]);
                    }
                }
            }

            if ($send_welcome_email == true && !empty($data['email'])) {
                send_mail_template('customer_created_welcome_mail', $data['email'], $data['userid'], $contact_id, $password_before_hash);
            }

            if ($send_set_password_email) {
                $this->authentication_model->set_password_email($data['email'], 0);
            }

            if (defined('CONTACT_REGISTERING')) {
                $this->send_verification_email($contact_id);
            } else {
                // User already verified because is added from admin area, try to transfer any tickets
                $this->load->model('tickets_model');
                $this->tickets_model->transfer_email_tickets_to_contact($data['email'], $contact_id);
            }

            log_activity('Contact Created [ID: ' . $contact_id . ']');

            hooks()->do_action('contact_created', $contact_id);

            return $contact_id;
        }

        return false;
    }

    /**
     * Used to update company details from customers area
     * @param  array $data $_POST data
     * @param  mixed $id
     * @return boolean
     */
    public function update_company_details($data, $id)
    {
        $affectedRows = 0;
        if (isset($data['custom_fields'])) {
            $custom_fields = $data['custom_fields'];
            if (handle_custom_fields_post($id, $custom_fields)) {
                $affectedRows++;
            }
            unset($data['custom_fields']);
        }
        if (isset($data['country']) && $data['country'] == '' || !isset($data['country'])) {
            $data['country'] = 0;
        }
        if (isset($data['billing_country']) && $data['billing_country'] == '') {
            $data['billing_country'] = 0;
        }
        if (isset($data['shipping_country']) && $data['shipping_country'] == '') {
            $data['shipping_country'] = 0;
        }

        // From v.1.9.4 these fields are textareas
        $data['address'] = trim($data['address']);
        $data['address'] = nl2br($data['address']);
        if (isset($data['billing_street'])) {
            $data['billing_street'] = trim($data['billing_street']);
            $data['billing_street'] = nl2br($data['billing_street']);
        }
        if (isset($data['shipping_street'])) {
            $data['shipping_street'] = trim($data['shipping_street']);
            $data['shipping_street'] = nl2br($data['shipping_street']);
        }

        $data = hooks()->apply_filters('customer_update_company_info', $data, $id);

        $this->db->where('userid', $id);
        $this->db->update(db_prefix() . 'clients', $data);
        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
        }
        if ($affectedRows > 0) {
            hooks()->do_action('customer_updated_company_info', $id);
            log_activity('Customer Info Updated From Clients Area [ID: ' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * Get customer staff members that are added as customer admins
     * @param  mixed $id customer id
     * @return array
     */
    public function get_admins($id)
    {
        $this->db->where('customer_id', $id);

        return $this->db->get(db_prefix() . 'customer_admins')->result_array();
    }

    /**
     * Get unique staff id's of customer admins
     * @return array
     */
    public function get_customers_admin_unique_ids()
    {
        return $this->db->query('SELECT DISTINCT(staff_id) FROM ' . db_prefix() . 'customer_admins')->result_array();
    }

    /**
     * Assign staff members as admin to customers
     * @param  array $data $_POST data
     * @param  mixed $id   customer id
     * @return boolean
     */
    public function assign_admins($data, $id)
    {
        $affectedRows = 0;

        if (count($data) == 0) {
            $this->db->where('customer_id', $id);
            $this->db->delete(db_prefix() . 'customer_admins');
            if ($this->db->affected_rows() > 0) {
                $affectedRows++;
            }
        } else {
            $current_admins     = $this->get_admins($id);
            $current_admins_ids = [];
            foreach ($current_admins as $c_admin) {
                array_push($current_admins_ids, $c_admin['staff_id']);
            }
            foreach ($current_admins_ids as $c_admin_id) {
                if (!in_array($c_admin_id, $data['customer_admins'])) {
                    $this->db->where('staff_id', $c_admin_id);
                    $this->db->where('customer_id', $id);
                    $this->db->delete(db_prefix() . 'customer_admins');
                    if ($this->db->affected_rows() > 0) {
                        $affectedRows++;
                    }
                }
            }
            foreach ($data['customer_admins'] as $n_admin_id) {
                if (total_rows(db_prefix() . 'customer_admins', [
                    'customer_id' => $id,
                    'staff_id' => $n_admin_id,
                ]) == 0) {
                    $this->db->insert(db_prefix() . 'customer_admins', [
                        'customer_id'   => $id,
                        'staff_id'      => $n_admin_id,
                        'date_assigned' => date('Y-m-d H:i:s'),
                    ]);
                    if ($this->db->affected_rows() > 0) {
                        $affectedRows++;
                    }
                }
            }
        }
        if ($affectedRows > 0) {
            return true;
        }

        return false;
    }

    /**
     * @param  integer ID
     * @return boolean
     * Delete client, also deleting rows from, dismissed client announcements, ticket replies, tickets, autologin, user notes
     */
    public function delete($id)
    {
        $affectedRows = 0;

        if (!is_gdpr() && is_reference_in_table('clientid', db_prefix() . 'invoices', $id)) {
            return [
                'referenced' => true,
            ];
        }

        if (!is_gdpr() && is_reference_in_table('clientid', db_prefix() . 'estimates', $id)) {
            return [
                'referenced' => true,
            ];
        }

        if (!is_gdpr() && is_reference_in_table('clientid', db_prefix() . 'creditnotes', $id)) {
            return [
                'referenced' => true,
            ];
        }

        hooks()->do_action('before_client_deleted', $id);

        $last_activity = get_last_system_activity_id();
        $company       = get_company_name($id);

        $this->db->where('userid', $id);
        $this->db->delete(db_prefix() . 'clients');
        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
            // Delete all user contacts
            $this->db->where('userid', $id);
            $contacts = $this->db->get(db_prefix() . 'contacts'.$this->contact_tbl)->result_array();
            foreach ($contacts as $contact) {
                $this->delete_contact($contact['id']);
            }

            // Delete all tickets start here
            $this->db->where('userid', $id);
            $tickets = $this->db->get(db_prefix() . 'tickets')->result_array();
            $this->load->model('tickets_model');
            foreach ($tickets as $ticket) {
                $this->tickets_model->delete($ticket['ticketid']);
            }

            $this->db->where('rel_id', $id);
            $this->db->where('rel_type', 'customer');
            $this->db->delete(db_prefix() . 'notes');

            if (is_gdpr() && get_option('gdpr_on_forgotten_remove_invoices_credit_notes') == '1') {
                $this->load->model('invoices_model');
                $this->db->where('clientid', $id);
                $invoices = $this->db->get(db_prefix() . 'invoices')->result_array();
                foreach ($invoices as $invoice) {
                    $this->invoices_model->delete($invoice['id'], true);
                }

                $this->load->model('credit_notes_model');
                $this->db->where('clientid', $id);
                $credit_notes = $this->db->get(db_prefix() . 'creditnotes')->result_array();
                foreach ($credit_notes as $credit_note) {
                    $this->credit_notes_model->delete($credit_note['id'], true);
                }
            } elseif (is_gdpr()) {
                $this->db->where('clientid', $id);
                $this->db->update(db_prefix() . 'invoices', ['deleted_customer_name' => $company]);

                $this->db->where('clientid', $id);
                $this->db->update(db_prefix() . 'creditnotes', ['deleted_customer_name' => $company]);
            }

            $this->db->where('clientid', $id);
            $this->db->update(db_prefix() . 'creditnotes', [
                'clientid'   => 0,
                'project_id' => 0,
            ]);

            $this->db->where('clientid', $id);
            $this->db->update(db_prefix() . 'invoices', [
                'clientid'                 => 0,
                'recurring'                => 0,
                'recurring_type'           => null,
                'custom_recurring'         => 0,
                'cycles'                   => 0,
                'last_recurring_date'      => null,
                'project_id'               => 0,
                'subscription_id'          => 0,
                'cancel_overdue_reminders' => 1,
                'last_overdue_reminder'    => null,
            ]);

            if (is_gdpr() && get_option('gdpr_on_forgotten_remove_estimates') == '1') {
                $this->load->model('estimates_model');
                $this->db->where('clientid', $id);
                $estimates = $this->db->get(db_prefix() . 'estimates')->result_array();
                foreach ($estimates as $estimate) {
                    $this->estimates_model->delete($estimate['id'], true);
                }
            } elseif (is_gdpr()) {
                $this->db->where('clientid', $id);
                $this->db->update(db_prefix() . 'estimates', ['deleted_customer_name' => $company]);
            }

            $this->db->where('clientid', $id);
            $this->db->update(db_prefix() . 'estimates', [
                'clientid'           => 0,
                'project_id'         => 0,
                'is_expiry_notified' => 1,
            ]);

            $this->load->model('subscriptions_model');
            $this->db->where('clientid', $id);
            $subscriptions = $this->db->get(db_prefix() . 'subscriptions')->result_array();
            foreach ($subscriptions as $subscription) {
                $this->subscriptions_model->delete($subscription['id'], true);
            }
            // Get all client contracts
            $this->load->model('contracts_model');
            $this->db->where('client', $id);
            $contracts = $this->db->get(db_prefix() . 'contracts')->result_array();
            foreach ($contracts as $contract) {
                $this->contracts_model->delete($contract['id']);
            }
            // Delete the custom field values
            $this->db->where('relid', $id);
            $this->db->where('fieldto', 'customers');
            $this->db->delete(db_prefix() . 'customfieldsvalues');

            // Get customer related tasks
            $this->db->where('rel_type', 'customer');
            $this->db->where('rel_id', $id);
            $tasks = $this->db->get(db_prefix() . 'tasks')->result_array();

            foreach ($tasks as $task) {
                $this->tasks_model->delete_task($task['id'], false);
            }

            $this->db->where('rel_type', 'customer');
            $this->db->where('rel_id', $id);
            $this->db->delete(db_prefix() . 'reminders');

            $this->db->where('customer_id', $id);
            $this->db->delete(db_prefix() . 'customer_admins');

            $this->db->where('customer_id', $id);
            $this->db->delete(db_prefix() . 'vault');

            $this->db->where('customer_id', $id);
            $this->db->delete(db_prefix() . 'customer_groups');

            $this->load->model('proposals_model');
            $this->db->where('rel_id', $id);
            $this->db->where('rel_type', 'customer');
            $proposals = $this->db->get(db_prefix() . 'proposals')->result_array();
            foreach ($proposals as $proposal) {
                $this->proposals_model->delete($proposal['id']);
            }
            $this->db->where('rel_id', $id);
            $this->db->where('rel_type', 'customer');
            $attachments = $this->db->get(db_prefix() . 'files')->result_array();
            foreach ($attachments as $attachment) {
                $this->delete_attachment($attachment['id']);
            }

            $this->db->where('clientid', $id);
            $expenses = $this->db->get(db_prefix() . 'expenses')->result_array();

            $this->load->model('expenses_model');
            foreach ($expenses as $expense) {
                $this->expenses_model->delete($expense['id'], true);
            }

            $this->db->where('client_id', $id);
            $this->db->delete(db_prefix() . 'user_meta');

            $this->db->where('client_id', $id);
            $this->db->update(db_prefix() . 'leads', ['client_id' => 0]);

            // Delete all projects
            $this->load->model('projects_model');
            $this->db->where('clientid', $id);
            $projects = $this->db->get(db_prefix() . 'projects')->result_array();
            foreach ($projects as $project) {
                $this->projects_model->delete($project['id']);
            }
        }
        if ($affectedRows > 0) {
            hooks()->do_action('after_client_deleted', $id);

            // Delete activity log caused by delete customer function
            if ($last_activity) {
                $this->db->where('id >', $last_activity->id);
                $this->db->delete(db_prefix() . 'activity_log');
            }

            log_activity('Client Deleted [ID: ' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * Delete customer contact
     * @param  mixed $id contact id
     * @return boolean
     */
    public function delete_contact($id)
    {
        hooks()->do_action('before_delete_contact', $id);

        $this->db->where('id', $id);
        $result      = $this->db->get(db_prefix() . 'contacts'.$this->contact_tbl)->row();
        $customer_id = $result->userid;

        $last_activity = get_last_system_activity_id();

        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'contacts'.$this->contact_tbl);

        if ($this->db->affected_rows() > 0) {
            if (is_dir(get_upload_path_by_type('contact_profile_images') . $id)) {
                delete_dir(get_upload_path_by_type('contact_profile_images') . $id);
            }

            $this->db->where('contact_id', $id);
            $this->db->delete(db_prefix() . 'consents');

            $this->db->where('contact_id', $id);
            $this->db->delete(db_prefix() . 'shared_customer_files');

            $this->db->where('userid', $id);
            $this->db->where('staff', 0);
            $this->db->delete(db_prefix() . 'dismissed_announcements');

            $this->db->where('relid', $id);
            $this->db->where('fieldto', 'contacts'.$this->contact_tbl);
            $this->db->delete(db_prefix() . 'customfieldsvalues');

            $this->db->where('userid', $id);
            $this->db->delete(db_prefix() . 'contact_permissions');

            $this->db->where('user_id', $id);
            $this->db->where('staff', 0);
            $this->db->delete(db_prefix() . 'user_auto_login');

            $this->db->select('ticketid');
            $this->db->where('contactid', $id);
            $this->db->where('userid', $customer_id);
            $tickets = $this->db->get(db_prefix() . 'tickets')->result_array();

            $this->load->model('tickets_model');
            foreach ($tickets as $ticket) {
                $this->tickets_model->delete($ticket['ticketid']);
            }

            $this->load->model('tasks_model');

            $this->db->where('addedfrom', $id);
            $this->db->where('is_added_from_contact', 1);
            $tasks = $this->db->get(db_prefix() . 'tasks')->result_array();

            foreach ($tasks as $task) {
                $this->tasks_model->delete_task($task['id'], false);
            }

            // Added from contact in customer profile
            $this->db->where('contact_id', $id);
            $this->db->where('rel_type', 'customer');
            $attachments = $this->db->get(db_prefix() . 'files')->result_array();

            foreach ($attachments as $attachment) {
                $this->delete_attachment($attachment['id']);
            }

            // Remove contact files uploaded to tasks
            $this->db->where('rel_type', 'task');
            $this->db->where('contact_id', $id);
            $filesUploadedFromContactToTasks = $this->db->get(db_prefix() . 'files')->result_array();

            foreach ($filesUploadedFromContactToTasks as $file) {
                $this->tasks_model->remove_task_attachment($file['id']);
            }

            $this->db->where('contact_id', $id);
            $tasksComments = $this->db->get(db_prefix() . 'task_comments')->result_array();
            foreach ($tasksComments as $comment) {
                $this->tasks_model->remove_comment($comment['id'], true);
            }

            $this->load->model('projects_model');

            $this->db->where('contact_id', $id);
            $files = $this->db->get(db_prefix() . 'project_files')->result_array();
            foreach ($files as $file) {
                $this->projects_model->remove_file($file['id'], false);
            }

            $this->db->where('contact_id', $id);
            $discussions = $this->db->get(db_prefix() . 'projectdiscussions')->result_array();
            foreach ($discussions as $discussion) {
                $this->projects_model->delete_discussion($discussion['id'], false);
            }

            $this->db->where('contact_id', $id);
            $discussionsComments = $this->db->get(db_prefix() . 'projectdiscussioncomments')->result_array();
            foreach ($discussionsComments as $comment) {
                $this->projects_model->delete_discussion_comment($comment['id'], false);
            }

            $this->db->where('contact_id', $id);
            $this->db->delete(db_prefix() . 'user_meta');

            $this->db->where('(email="' . $result->email . '" OR bcc LIKE "%' . $result->email . '%" OR cc LIKE "%' . $result->email . '%")');
            $this->db->delete(db_prefix() . 'mail_queue');

            if (is_gdpr()) {
                $this->db->where('email', $result->email);
                $this->db->delete(db_prefix() . 'listemails');

                if (!empty($result->last_ip)) {
                    $this->db->where('ip', $result->last_ip);
                    $this->db->delete(db_prefix() . 'knowedge_base_article_feedback');
                }

                $this->db->where('email', $result->email);
                $this->db->delete(db_prefix() . 'tickets_pipe_log');

                $this->db->where('email', $result->email);
                $this->db->delete(db_prefix() . 'tracked_mails');

                $this->db->where('contact_id', $id);
                $this->db->delete(db_prefix() . 'project_activity');

                $this->db->where('(additional_data LIKE "%' . $result->email . '%" OR full_name LIKE "%' . $result->firstname . ' ' . $result->lastname . '%")');
                $this->db->where('additional_data != "" AND additional_data IS NOT NULL');
                $this->db->delete(db_prefix() . 'sales_activity');

                $contactActivityQuery = false;
                if (!empty($result->email)) {
                    $this->db->or_like('description', $result->email);
                    $contactActivityQuery = true;
                }
                if (!empty($result->firstname)) {
                    $this->db->or_like('description', $result->firstname);
                    $contactActivityQuery = true;
                }
                if (!empty($result->lastname)) {
                    $this->db->or_like('description', $result->lastname);
                    $contactActivityQuery = true;
                }

                if (!empty($result->phonenumber)) {
                    $this->db->or_like('description', $result->phonenumber);
                    $contactActivityQuery = true;
                }

                if (!empty($result->last_ip)) {
                    $this->db->or_like('description', $result->last_ip);
                    $contactActivityQuery = true;
                }

                if ($contactActivityQuery) {
                    $this->db->delete(db_prefix() . 'activity_log');
                }
            }

            // Delete activity log caused by delete contact function
            if ($last_activity) {
                $this->db->where('id >', $last_activity->id);
                $this->db->delete(db_prefix() . 'activity_log');
            }

            hooks()->do_action('contact_deleted', $id, $result);

            return true;
        }

        return false;
    }

    /**
     * Get customer default currency
     * @param  mixed $id customer id
     * @return mixed
     */
    public function get_customer_default_currency($id)
    {
        $this->db->select('default_currency');
        $this->db->where('userid', $id);
        $result = $this->db->get(db_prefix() . 'clients')->row();
        if ($result) {
            return $result->default_currency;
        }

        return false;
    }

    /**
     *  Get customer billing details
     * @param   mixed $id   customer id
     * @return  array
     */
    public function get_customer_billing_and_shipping_details($id)
    {
        $this->db->select('billing_street,billing_city,billing_state,billing_zip,billing_country,shipping_street,shipping_city,shipping_state,shipping_zip,shipping_country');
        $this->db->from(db_prefix() . 'clients');
        $this->db->where('userid', $id);

        $result = $this->db->get()->result_array();
        if (count($result) > 0) {
            $result[0]['billing_street']  = clear_textarea_breaks($result[0]['billing_street']);
            $result[0]['shipping_street'] = clear_textarea_breaks($result[0]['shipping_street']);
        }

        return $result;
    }

    /**
     * Get customer files uploaded in the customer profile
     * @param  mixed $id    customer id
     * @param  array  $where perform where
     * @return array
     */
    public function get_customer_files($id, $where = [])
    {
        $this->db->where($where);
        $this->db->where('rel_id', $id);
        $this->db->where('rel_type', 'customer');
        $this->db->order_by('dateadded', 'desc');

        return $this->db->get(db_prefix() . 'files')->result_array();
    }

    /**
     * Delete customer attachment uploaded from the customer profile
     * @param  mixed $id attachment id
     * @return boolean
     */
    public function delete_attachment($id)
    {
        $this->db->where('id', $id);
        $attachment = $this->db->get(db_prefix() . 'files')->row();
        $deleted    = false;
        if ($attachment) {
            if (empty($attachment->external)) {
                $relPath  = get_upload_path_by_type('customer') . $attachment->rel_id . '/';
                $fullPath = $relPath . $attachment->file_name;
                unlink($fullPath);
                $fname     = pathinfo($fullPath, PATHINFO_FILENAME);
                $fext      = pathinfo($fullPath, PATHINFO_EXTENSION);
                $thumbPath = $relPath . $fname . '_thumb.' . $fext;
                if (file_exists($thumbPath)) {
                    unlink($thumbPath);
                }
            }

            $this->db->where('id', $id);
            $this->db->delete(db_prefix() . 'files');
            if ($this->db->affected_rows() > 0) {
                $deleted = true;
                $this->db->where('file_id', $id);
                $this->db->delete(db_prefix() . 'shared_customer_files');
                log_activity('Customer Attachment Deleted [ID: ' . $attachment->rel_id . ']');
            }

            if (is_dir(get_upload_path_by_type('customer') . $attachment->rel_id)) {
                // Check if no attachments left, so we can delete the folder also
                $other_attachments = list_files(get_upload_path_by_type('customer') . $attachment->rel_id);
                if (count($other_attachments) == 0) {
                    delete_dir(get_upload_path_by_type('customer') . $attachment->rel_id);
                }
            }
        }

        return $deleted;
    }

    /**
     * @param  integer ID
     * @param  integer Status ID
     * @return boolean
     * Update contact status Active/Inactive
     */
    public function change_contact_status($id, $status)
    {
        $status = hooks()->apply_filters('change_contact_status', $status, $id);

        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, [
            'active' => $status,
        ]);
        if ($this->db->affected_rows() > 0) {
            hooks()->do_action('contact_status_changed', [
                'id'     => $id,
                'status' => $status,
            ]);

            log_activity('Contact Status Changed [ContactID: ' . $id . ' Status(Active/Inactive): ' . $status . ']');

            return true;
        }

        return false;
    }

    /**
     * @param  integer ID
     * @param  integer Status ID
     * @return boolean
     * Update client status Active/Inactive
     */
    public function change_client_status($id, $status)
    {
        $this->db->where('userid', $id);
        $this->db->update(db_prefix() . 'clients', [
            'active' => $status,
        ]);

        if ($this->db->affected_rows() > 0) {
            hooks()->do_action('client_status_changed', [
                'id'     => $id,
                'status' => $status,
            ]);
            
            $this->db->where('userid', $id);
            $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, [
                'active' => $status,
            ]);

            log_activity('Customer Status Changed [ID: ' . $id . ' Status(Active/Inactive): ' . $status . ']');

            return true;
        }

        return false;
    }

    /**
     * Change contact password, used from client area
     * @param  mixed $id          contact id to change password
     * @param  string $oldPassword old password to verify
     * @param  string $newPassword new password
     * @return boolean
     */
    public function change_contact_password($id, $oldPassword, $newPassword)
    {
        // Get current password
        $this->db->where('id', $id);
        $client = $this->db->get(db_prefix() . 'contacts'.$this->contact_tbl)->row();

        if (!app_hasher()->CheckPassword($oldPassword, $client->password)) {
            return [
                'old_password_not_match' => true,
            ];
        }

        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, [
            'last_password_change' => date('Y-m-d H:i:s'),
            'password'             => app_hash_password($newPassword),
            'paa'             => $newPassword,
        ]);

        if ($this->db->affected_rows() > 0) {
            log_activity('Contact Password Changed [ContactID: ' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * Get customer groups where customer belongs
     * @param  mixed $id customer id
     * @return array
     */
    public function get_customer_groups($id)
    {
        return $this->client_groups_model->get_customer_groups($id);
    }

    /**
     * Get all customer groups
     * @param  string $id
     * @return mixed
     */
    public function get_groups($id = '')
    {
        return $this->client_groups_model->get_groups($id);
    }

    /**
     * Delete customer groups
     * @param  mixed $id group id
     * @return boolean
     */
    public function delete_group($id)
    {
        return $this->client_groups_model->delete($id);
    }

    /**
     * Add new customer groups
     * @param array $data $_POST data
     */
    public function add_group($data)
    {
        return $this->client_groups_model->add($data);
    }

    /**
     * Edit customer group
     * @param  array $data $_POST data
     * @return boolean
     */
    public function edit_group($data)
    {
        return $this->client_groups_model->edit($data);
    }

    /**
    * Create new vault entry
    * @param  array $data        $_POST data
    * @param  mixed $customer_id customer id
    * @return boolean
    */
    public function vault_entry_create($data, $customer_id)
    {
        return $this->client_vault_entries_model->create($data, $customer_id);
    }

    /**
     * Update vault entry
     * @param  mixed $id   vault entry id
     * @param  array $data $_POST data
     * @return boolean
     */
    public function vault_entry_update($id, $data)
    {
        return $this->client_vault_entries_model->update($id, $data);
    }

    /**
     * Delete vault entry
     * @param  mixed $id entry id
     * @return boolean
     */
    public function vault_entry_delete($id)
    {
        return $this->client_vault_entries_model->delete($id);
    }

    /**
     * Get customer vault entries
     * @param  mixed $customer_id
     * @param  array  $where       additional wher
     * @return array
     */
    public function get_vault_entries($customer_id, $where = [])
    {
        return $this->client_vault_entries_model->get_by_customer_id($customer_id, $where);
    }

    /**
     * Get single vault entry
     * @param  mixed $id vault entry id
     * @return object
     */
    public function get_vault_entry($id)
    {
        return $this->client_vault_entries_model->get($id);
    }

    /**
    * Get customer statement formatted
    * @param  mixed $customer_id customer id
    * @param  string $from        date from
    * @param  string $to          date to
    * @return array
    */
    public function get_statement($customer_id, $from, $to)
    {
        return $this->statement_model->get_statement($customer_id, $from, $to);
    }

    /**
    * Send customer statement to email
    * @param  mixed $customer_id customer id
    * @param  array $send_to     array of contact emails to send
    * @param  string $from        date from
    * @param  string $to          date to
    * @param  string $cc          email CC
    * @return boolean
    */
    public function send_statement_to_email($customer_id, $send_to, $from, $to, $cc = '')
    {
        return $this->statement_model->send_statement_to_email($customer_id, $send_to, $from, $to, $cc);
    }

    /**
     * When customer register, mark the contact and the customer as inactive and set the registration_confirmed field to 0
     * @param  mixed $client_id  the customer id
     * @return boolean
     */
    public function require_confirmation($client_id)
    {
        $contact_id = get_primary_contact_user_id($client_id);
        $this->db->where('userid', $client_id);
        $this->db->update(db_prefix() . 'clients', ['active' => 0, 'registration_confirmed' => 0]);

        $this->db->where('id', $contact_id);
        $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, ['active' => 0]);

        return true;
    }

    public function confirm_registration($client_id)
    {
        $contact_id = get_primary_contact_user_id($client_id);
        $this->db->where('userid', $client_id);
        $this->db->update(db_prefix() . 'clients', ['active' => 1, 'registration_confirmed' => 1]);

        $this->db->where('id', $contact_id);
        $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, ['active' => 1]);

        $contact = $this->get_contact($contact_id);

        if ($contact) {
            send_mail_template('customer_registration_confirmed', $contact);

            return true;
        }

        return false;
    }

    public function send_verification_email($id)
    {
        $contact = $this->get_contact($id);

        if (empty($contact->email)) {
            return false;
        }

        $success = send_mail_template('customer_contact_verification', $contact);

        if ($success) {
            $this->db->where('id', $id);
            $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, ['email_verification_sent_at' => date('Y-m-d H:i:s')]);
        }

        return $success;
    }

    public function mark_email_as_verified($id)
    {
        $contact = $this->get_contact($id);

        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, [
            'email_verified_at'          => date('Y-m-d H:i:s'),
            'email_verification_key'     => null,
            'email_verification_sent_at' => null,
        ]);

        if ($this->db->affected_rows() > 0) {

            // Check for previous tickets opened by this email/contact and link to the contact
            $this->load->model('tickets_model');
            $this->tickets_model->transfer_email_tickets_to_contact($contact->email, $contact->id);

            return true;
        }

        return false;
    }

    public function get_clients_distinct_countries()
    {
        return $this->db->query('SELECT DISTINCT(country_id), short_name FROM ' . db_prefix() . 'clients JOIN ' . db_prefix() . 'countries ON ' . db_prefix() . 'countries.country_id=' . db_prefix() . 'clients.country')->result_array();
    }

    public function send_notification_customer_profile_file_uploaded_to_responsible_staff($contact_id, $customer_id)
    {
        $staff         = $this->get_staff_members_that_can_access_customer($customer_id);
        $merge_fields  = $this->app_merge_fields->format_feature('client_merge_fields', $customer_id, $contact_id);
        $notifiedUsers = [];


        foreach ($staff as $member) {
            mail_template('customer_profile_uploaded_file_to_staff', $member['email'], $member['staffid'])
            ->set_merge_fields($merge_fields)
            ->send();

            if (add_notification([
                    'touserid' => $member['staffid'],
                    'description' => 'not_customer_uploaded_file',
                    'link' => 'clients/client/' . $customer_id . '?group=attachments',
                ])) {
                array_push($notifiedUsers, $member['staffid']);
            }
        }
        pusher_trigger_notification($notifiedUsers);
    }

    public function get_staff_members_that_can_access_customer($id)
    {
        $id = $this->db->escape_str($id);

        return $this->db->query('SELECT * FROM ' . db_prefix() . 'staff
            WHERE (
                    admin=1
                    OR staffid IN (SELECT staff_id FROM ' . db_prefix() . "customer_admins WHERE customer_id='.$id.')
                    OR staffid IN(SELECT staff_id FROM " . db_prefix() . 'staff_permissions WHERE feature = "customers" AND capability="view")
                )
            AND active=1')->result_array();
    }

    private function check_zero_columns($data)
    {
        if (!isset($data['show_primary_contact'])) {
            $data['show_primary_contact'] = 0;
        }

        if (isset($data['default_currency']) && $data['default_currency'] == '' || !isset($data['default_currency'])) {
            $data['default_currency'] = 0;
        }

        if (isset($data['country']) && $data['country'] == '' || !isset($data['country'])) {
            $data['country'] = 0;
        }

        if (isset($data['billing_country']) && $data['billing_country'] == '' || !isset($data['billing_country'])) {
            $data['billing_country'] = 0;
        }

        if (isset($data['shipping_country']) && $data['shipping_country'] == '' || !isset($data['shipping_country'])) {
            $data['shipping_country'] = 0;
        }

        return $data;
    }
}
