<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Class_master_model extends App_Model
{
    /**
     * Add new employee role
     * @param mixed $data
     */
    public function add($data)
    {
        $this->db->insert(db_prefix() . 'master_class', $data);
        $insert_id = $this->db->insert_id();

        if ($insert_id) {
            log_activity('New Class Added [ID: ' . $insert_id . '.' . $data['name'] . ']');

            return $insert_id;
        }

        return false;
    }

    /**
     * Update employee Post
     * @param  array $data Post data
     * @param  mixed $id   Post id
     * @return boolean
     */
    public function update($data, $id)
    {
        $this->db->where('class_id', $id);
        $this->db->update(db_prefix() . 'master_class', $data);

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
        }
/*
        if ($update_staff_permissions == true) {
            $this->load->model('staff_model');

            $staff = $this->staff_model->get('', [
                'role' => $id,
            ]);

            foreach ($staff as $member) {
                if ($this->staff_model->update_permissions($permissions, $member['staffid'])) {
                    $affectedRows++;
                }
            }
        }
*/
        if ($affectedRows > 0) {
            log_activity('Class Updated [ID: ' . $id . ', Name: ' . $data['name'] . ']');

            return true;
        }

        return false;
    }

    /**
     * Get employee Post by id
     * @param  mixed $id Optional Post id
     * @return mixed     array if not id passed else object
     */
    public function get($id = '')
    {
        if (is_numeric($id)) {

            $this->db->where('class_id', $id);

            $Post              = $this->db->get(db_prefix() . 'master_class')->row();
            
            return $Post;
        }

        return $this->db->get(db_prefix() . 'master_class')->result_array();
    }

    /**
     * Delete employee role
     * @param  mixed $id role id
     * @return mixed
     */
    public function delete($id)
    {
        $current = $this->get($id);

        $affectedRows = 0;
        $this->db->where('class_id', $id);
        $this->db->delete(db_prefix() . 'master_class');

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
        }

        if ($affectedRows > 0) {
            log_activity('Class Deleted [ID: ' . $id);

            return true;
        }

        return false;
    }

    public function get_contact_permissions($id)
    {
        $this->db->where('userid', $id);

        return $this->db->get(db_prefix() . 'contact_permissions')->result_array();
    }

    public function get_role_staff($role_id)
    {
        $this->db->where('role', $role_id);

        return $this->db->get(db_prefix() . 'staff')->result_array();
    }
    
    
    /**
     * Display total tickets awaiting reply by status (chart)
     * @return array
     */
    public function campus_graph_by_student($cname)
    {
        $chart = [
            'labels'   => [],
            'datasets' => [],
        ];
        
        $colors      = get_system_favourite_colors();
        $color = '#FBB917';

        $_data                         = [];
        $_data['data']                 = [];
        $_data['backgroundColor']      = [];
        $_data['hoverBackgroundColor'] = [];
        $_data['statusLink']           = [];

        /*
        for($ii = 0; $ii < 3; $ii++)
        {
            $this->db->where('Class', $ii);
            $this->db->where('role', 1);
            $total = $this->db->count_all_results(db_prefix() . 'clients');
            if ($total > 0) {
                if($ii == 1)
                    array_push($chart['labels'], 'Active');
                else
                    array_push($chart['labels'], 'Inactive');
                array_push($_data['statusLink'], admin_url('clients'));
                array_push($_data['backgroundColor'], $colors[$ii]);
                array_push($_data['hoverBackgroundColor'], adjust_color_brightness($color, -20));
                array_push($_data['data'], $total);
            }
        }
        */
        $this->db->where('Class', $cname);
        $this->db->where('Campus', 'Elite Campus');
        $total = $this->db->count_all_results(db_prefix() . 'contacts'.$this->contact_tbl);
        array_push($chart['labels'], 'Elite Campus');
        array_push($_data['statusLink'], admin_url('clients'));
        array_push($_data['backgroundColor'], $colors[0]);
        array_push($_data['hoverBackgroundColor'], adjust_color_brightness($color, -20));
        array_push($_data['data'], $total);
        
        $this->db->where('Class', $cname);
        $this->db->where('Campus', 'Premium Campus');
        $total1 = $this->db->count_all_results(db_prefix() . 'contacts'.$this->contact_tbl);
        array_push($chart['labels'], 'Premium Campus');
        array_push($_data['statusLink'], admin_url('clients'));
        array_push($_data['backgroundColor'], $colors[3]);
        array_push($_data['hoverBackgroundColor'], adjust_color_brightness($color, -20));
        array_push($_data['data'], $total1);
       
             
        $this->db->where('Class', $cname);
        $this->db->where('Campus', 'World School');
        $total11 = $this->db->count_all_results(db_prefix() . 'contacts'.$this->contact_tbl);
        array_push($chart['labels'], 'World School');
            array_push($_data['statusLink'], admin_url('clients'));
            array_push($_data['backgroundColor'], $colors[4]);
            array_push($_data['hoverBackgroundColor'], adjust_color_brightness($color, -20));
            array_push($_data['data'], $total11);

        $chart['datasets'][] = $_data;

        return $chart;
    }
    
    
    /**
     * Display total tickets awaiting reply by status (chart)
     * @return array
     */
    public function gender_graph_by_student($cname)
    {
        $chart = [
            'labels'   => [],
            'datasets' => [],
        ];
        
        $colors      = get_system_favourite_colors();
        $color = '#FBB917';

        $_data                         = [];
        $_data['data']                 = [];
        $_data['backgroundColor']      = [];
        $_data['hoverBackgroundColor'] = [];
        $_data['statusLink']           = [];

        $this->db->where('Class', $cname);
        $this->db->where('Gender', 'Male');
        $total = $this->db->count_all_results(db_prefix() . 'contacts'.$this->contact_tbl);
        array_push($chart['labels'], 'Boys');
        array_push($_data['statusLink'], admin_url('clients'));
        array_push($_data['backgroundColor'], $colors[1]);
        array_push($_data['hoverBackgroundColor'], adjust_color_brightness($color, -20));
        array_push($_data['data'], $total);
        
        $this->db->where('Class', $cname);
        $this->db->where('Gender', 'Female');
        $total1 = $this->db->count_all_results(db_prefix() . 'contacts'.$this->contact_tbl);
        array_push($chart['labels'], 'Girls');
        array_push($_data['statusLink'], admin_url('clients'));
        array_push($_data['backgroundColor'], $colors[4]);
        array_push($_data['hoverBackgroundColor'], adjust_color_brightness($color, -20));
        array_push($_data['data'], $total1);
       
        $chart['datasets'][] = $_data;

        return $chart;
    }
}
