<?php

defined('BASEPATH') or exit('No direct script access allowed');

function app_init_admin_sidebar_menu_items()
{
    $CI = &get_instance();

    $custommenu = $CI->db->get_where('tbloptions', array('name' => 'aside_menu_active'))->row('value');
    $M = json_decode($custommenu);
    if(is_admin())
    {
        //echo '<pre>'; print_r(json_decode($custommenu)); die;
        
            $CI->app_menu->add_sidebar_menu_item('dashboard', [
                'name'     => _l($M->dashboard->label),
                'href'     => admin_url(),
                'position' => 1,
                'icon'     => 'fa fa-home',
                'label'    => _l($M->dashboard->label),
                'heading'  => _l($M->dashboard->heading),
            ]);
        /*
            if (has_permission('customers', '', 'view')
                || (have_assigned_customers()
                || (!have_assigned_customers() && has_permission('customers', '', 'create')))) {
                $CI->app_menu->add_sidebar_menu_item('customers', [
                    'name'     => _l('als_clients'),
                    'href'     => admin_url('clients'),
                    'position' => 5,
                    'icon'     => 'fa fa-user-o',
                ]);
            }
        */
            $CI->app_menu->add_sidebar_menu_item('customers', [
                    'collapse' => true,
                    'name'     => _l($M->customers->label),
                    'position' => 5,
                    'icon'     => 'fa fa-user-o',
                    'label'     => _l($M->customers->label),
                    'heading'  => _l($M->customers->heading),
                ]);
        
            $CI->app_menu->add_sidebar_children_item('customers', [
                        'slug'     => 'customer',
                        'name'     => _l($M->customers->children->customer->label),
                        'href'     => admin_url('clients'),
                        'position' => 5,
                        'label'     => _l($M->customers->children->customer->label),
                        'heading'     => _l($M->customers->children->customer->heading),
                ]);
                
            $CI->app_menu->add_sidebar_children_item('customers', [
                        'slug'     => 'class_wise_customer',
                        'name'     => _l($M->customers->children->class_wise_customer->label),
                        'href'     => admin_url('clients/classWise'),
                        'position' => 5,
                        'label'     => _l($M->customers->children->class_wise_customer->label),
                        'heading'     => _l($M->customers->children->class_wise_customer->heading),
                ]);
                
            $CI->app_menu->add_sidebar_children_item('customers', [
                    'slug'     => 'paidStudent',
                    'name'     => _l($M->customers->children->paidStudent->label),
                    'href'     => admin_url('clients/paidStudent'),
                    'position' => 6,
                    'label'     => _l($M->customers->children->paidStudent->label),
                    'heading'     => _l($M->customers->children->paidStudent->heading),
            ]);  
            
            $CI->app_menu->add_sidebar_children_item('customers', [
                    'slug'     => 'unPaidStudent',
                    'name'     => _l($M->customers->children->unPaidStudent->label),
                    'href'     => admin_url('clients/unPaidStudent'),
                    'position' => 7,
                    'label'     => _l($M->customers->children->unPaidStudent->label),
                    'heading'     => _l($M->customers->children->unPaidStudent->heading),
            ]);
                
            $CI->app_menu->add_sidebar_children_item('customers', [
                        'slug'     => 'add_customer',
                        'name'     => _l($M->customers->children->add_customer->label),
                        'href'     => admin_url('clients/client'),
                        'position' => 8,
                        'label'     => _l($M->customers->children->add_customer->label),
                        'heading'     => _l($M->customers->children->add_customer->heading),
                ]);
                
            $CI->app_menu->add_sidebar_children_item('customers', [
                        'slug'     => 'import_customer',
                        'name'     => _l($M->customers->children->import_customer->label),
                        'href'     => admin_url('clients/import'),
                        'position' => 9,
                        'label'     => _l($M->customers->children->import_customer->label),
                        'heading'     => _l($M->customers->children->import_customer->heading),
                ]);
        
            /*
            if (has_permission('staff', '', 'view')) {
                $CI->app_menu->add_sidebar_menu_item('staff', [
                            'name'     => _l($M->staff->label),
                            'href'     => admin_url('staff'),
                            'position' => 7,
                            'label'    => _l($M->staff->label),
                            'heading'    => _l($M->staff->heading),
                    ]);
            }
            */
            
            $CI->app_menu->add_sidebar_menu_item('teacher_master', [
                    'collapse' => true,
                    'name'     => _l($M->teacher_master->label),
                    'position' => 10,
                    'icon'     => 'fa fa-balance-scale',
                    'label'     => _l($M->teacher_master->label),
                    'heading'  => _l($M->teacher_master->heading),
                ]);
        
            $CI->app_menu->add_sidebar_children_item('teacher_master', [
                    'slug'     => 'staff',
                    'name'     => _l($M->teacher_master->children->staff->label),
                    'href'     => admin_url('staff'),
                    'position' => 5,
                    'label'     => _l($M->teacher_master->children->staff->label),
                    'heading'     => _l($M->teacher_master->children->staff->heading),
            ]);
            
            $CI->app_menu->add_sidebar_children_item('teacher_master', [
                    'slug'     => 'books',
                    'name'     => _l($M->teacher_master->children->books->label),
                    'href'     => admin_url('books'),
                    'position' => 5,
                    'label'     => _l($M->teacher_master->children->books->label),
                    'heading'     => _l($M->teacher_master->children->books->heading),
            ]);
            
            $CI->app_menu->add_sidebar_children_item('teacher_master', [
                    'slug'     => 'syllabus',
                    'name'     => _l($M->teacher_master->children->syllabus->label),
                    'href'     => admin_url('syllabus'),
                    'position' => 5,
                    'label'     => _l($M->teacher_master->children->syllabus->label),
                    'heading'     => _l($M->teacher_master->children->syllabus->heading),
            ]);
            
            $CI->app_menu->add_sidebar_children_item('teacher_master', [
                    'slug'     => 'meeting',
                    'name'     => _l($M->teacher_master->children->meeting->label),
                    'href'     => admin_url('meeting'),
                    'position' => 5,
                    'label'     => _l($M->teacher_master->children->meeting->label),
                    'heading'     => _l($M->teacher_master->children->meeting->heading),
            ]);
            
            $CI->app_menu->add_sidebar_children_item('teacher_master', [
                    'slug'     => 'timetable',
                    'name'     => _l($M->teacher_master->children->timetable->label),
                    'href'     => admin_url('timetable'),
                    'position' => 5,
                    'label'     => _l($M->teacher_master->children->timetable->label),
                    'heading'     => _l($M->teacher_master->children->timetable->heading),
            ]);
            
            $CI->app_menu->add_sidebar_children_item('teacher_master', [
                    'slug'     => 'videos',
                    'name'     => _l($M->teacher_master->children->videos->label),
                    'href'     => admin_url('videos'),
                    'position' => 5,
                    'label'     => _l($M->teacher_master->children->videos->label),
                    'heading'     => _l($M->teacher_master->children->videos->heading),
            ]);
            
            $CI->app_menu->add_sidebar_children_item('teacher_master', [
                    'slug'     => 'particulars',
                    'name'     => _l($M->teacher_master->children->particulars->label),
                    'href'     => admin_url('particulars'),
                    'position' => 7,
                    'label'     => _l($M->teacher_master->children->particulars->label),
                    'heading'     => _l($M->teacher_master->children->particulars->heading),
            ]);
            
            /*
            $CI->app_menu->add_sidebar_menu_item('books', [
                        'name'     => _l($M->books->label),
                        'href'     => admin_url('books'),
                        'position' => 7,
                        'label'    => _l($M->books->label),
                        'heading'    => _l($M->books->heading),
                ]);
            
            $CI->app_menu->add_sidebar_menu_item('syllabus', [
                        'name'     => _l($M->syllabus->label),
                        'href'     => admin_url('syllabus'),
                        'position' => 7,
                        'label'    => _l($M->syllabus->label),
                        'heading'    => _l($M->syllabus->heading),
                ]);
                
            $CI->app_menu->add_sidebar_menu_item('meeting', [
                        'name'     => _l($M->meeting->label),
                        'href'     => admin_url('meeting'),
                        'position' => 7,
                        'label'    => _l($M->meeting->label),
                        'heading'    => _l($M->meeting->heading),
                ]);
        */
            $CI->app_menu->add_sidebar_menu_item('sales', [
                    'collapse' => true,
                    'name'     => _l($M->sales->label),
                    'position' => 10,
                    'icon'     => 'fa fa-balance-scale',
                    'label'     => _l($M->sales->label),
                    'heading'  => _l($M->sales->heading),
                ]);
                
            $CI->app_menu->add_sidebar_menu_item('fees_', [
                    'collapse' => true,
                    'name'     => _l($M->fees_->label),
                    'position' => 55,
                    'icon'     => 'fa fa-money',
                    'label'    => _l($M->fees_->label),
                    'heading'  => _l($M->fees_->heading),
                ]);
            
            $CI->app_menu->add_sidebar_children_item('fees_', [
                        'slug'     => 'collectfees',
                        'name'     => _l($M->fees_->children->collectfees->label),
                        'href'     => admin_url('collectfees'),
                        'position' => 5,
                        'label'     => _l($M->fees_->children->collectfees->label),
                        'heading'     => _l($M->fees_->children->collectfees->heading),
                ]);
        
            $CI->app_menu->add_sidebar_children_item('fees_', [
                        'slug'     => 'feediscount',
                        'name'     => _l($M->fees_->children->feediscount->label),
                        'href'     => admin_url('collectfees/packageWise'),
                        'position' => 5,
                        'label'     => _l($M->fees_->children->feediscount->label),
                        'heading'     => _l($M->fees_->children->feediscount->heading),
                ]);
        
            if ((has_permission('proposals', '', 'view') || has_permission('proposals', '', 'view_own'))
                || (staff_has_assigned_proposals() && get_option('allow_staff_view_proposals_assigned') == 1)) {
                $CI->app_menu->add_sidebar_children_item('sales', [
                        'slug'     => 'proposals',
                        'name'     => _l($M->sales->children->proposals->label),
                        // 'href'     => admin_url('proposals'),
                        'href'     => '#',
                        'position' => 5,
                        'label'     => _l($M->sales->children->proposals->label),
                        'heading'     => _l($M->sales->children->proposals->heading),
                ]);
            }
        
            if ((has_permission('estimates', '', 'view') || has_permission('estimates', '', 'view_own'))
                || (staff_has_assigned_estimates() && get_option('allow_staff_view_estimates_assigned') == 1)) {
                $CI->app_menu->add_sidebar_children_item('sales', [
                        'slug'     => 'estimates',
                        'name'     => _l($M->sales->children->estimates->label),
                       // 'href'     => admin_url('estimates'),
                        'href'     => '#',
                        'position' => 10,
                        'label'     => _l($M->sales->children->estimates->label),
                        'heading'     => _l($M->sales->children->estimates->heading),
                ]);
            }
        
            if ((has_permission('invoices', '', 'view') || has_permission('invoices', '', 'view_own'))
                 || (staff_has_assigned_invoices() && get_option('allow_staff_view_invoices_assigned') == 1)) {
                $CI->app_menu->add_sidebar_children_item('sales', [
                        'slug'     => 'invoices',
                        'name'     => _l($M->sales->children->invoices->label),
                        //'href'     => admin_url('invoices'),
                        'href'     => '#',
                        'position' => 15,
                        'label'     => _l($M->sales->children->invoices->label),
                        'heading'     => _l($M->sales->children->invoices->heading),
                ]);
            }
        
            if (has_permission('payments', '', 'view') || has_permission('invoices', '', 'view_own')
                   || (get_option('allow_staff_view_invoices_assigned') == 1 && staff_has_assigned_invoices())) {
                $CI->app_menu->add_sidebar_children_item('sales', [
                        'slug'     => 'payments',
                        'name'     => _l($M->sales->children->payments->label),
                        //'href'     => admin_url('payments'),
                        'href'     => '#',
                        'position' => 20,
                        'label'     => _l($M->sales->children->payments->label),
                        'heading'     => _l($M->sales->children->payments->heading),
                ]);
            }
        
            if (has_permission('credit_notes', '', 'view') || has_permission('credit_notes', '', 'view_own')) {
                $CI->app_menu->add_sidebar_children_item('sales', [
                        'slug'     => 'credit_notes',
                        'name'     => _l($M->sales->children->credit_notes->label),
                       // 'href'     => admin_url('credit_notes'),
                        'href'     => '#',
                        'position' => 25,
                        'label'     => _l($M->sales->children->credit_notes->label),
                        'heading'     => _l($M->sales->children->credit_notes->heading),
                ]);
            }
        
            if (has_permission('items', '', 'view')) {
                $CI->app_menu->add_sidebar_children_item('sales', [
                        'slug'     => 'items',
                        'name'     => _l($M->sales->children->items->label),
                        //'href'     => admin_url('invoice_items'),
                        'href'     => '#',
                        'position' => 30,
                        'label'     => _l($M->sales->children->items->label),
                        'heading'     => _l($M->sales->children->items->heading),
                ]);
            }
        
            if (has_permission('subscriptions', '', 'view') || has_permission('subscriptions', '', 'view_own')) {
                $CI->app_menu->add_sidebar_menu_item('subscriptions', [
                        'name'     => _l($M->subscriptions->label),
                        //'href'     => admin_url('subscriptions'),
                        'href'     => '#',
                        'icon'     => 'fa fa-repeat',
                        'position' => 15,
                        'label'     => _l($M->subscriptions->label),
                        'heading'  => _l($M->subscriptions->heading),
                ]);
            }
        
            $CI->app_menu->add_sidebar_menu_item('transport', [
                        'name'     => _l($M->transport->label),
                        'href'     => admin_url('transport'),
                        'icon'     => 'fa fa-file-text-o',
                        'position' => 20,
                        'label'     => _l($M->transport->label),
                        'heading'  => _l($M->transport->heading),
                ]);
        
            if (has_permission('expenses', '', 'view') || has_permission('expenses', '', 'view_own')) {
                $CI->app_menu->add_sidebar_menu_item('expenses', [
                        'name'     => _l($M->expenses->label),
                       // 'href'     => admin_url('expenses'),
                        'href'     => '#',
                        'icon'     => 'fa fa-file-text-o',
                        'position' => 20,
                        'label'     => _l($M->expenses->label),
                        'heading'  => _l($M->expenses->heading),
                ]);
            }
        
            if (has_permission('contracts', '', 'view') || has_permission('contracts', '', 'view_own')) {
                $CI->app_menu->add_sidebar_menu_item('contracts', [
                        'name'     => _l($M->contracts->label),
                        //'href'     => admin_url('contracts'),
                        'href'     => '#',
                        'icon'     => 'fa fa-file',
                        'position' => 25,
                        'label'     => _l($M->contracts->label),
                        'heading'  => _l($M->contracts->heading),
                ]);
            }
        
            $CI->app_menu->add_sidebar_menu_item('projects', [
                        'name'     => _l($M->projects->label),
                        //'href'     => admin_url('projects'),
                        'href'     => '#',
                        'icon'     => 'fa fa-bars',
                        'position' => 30,
                        'label'     => _l($M->projects->label),
                        'heading'  => _l($M->projects->heading),
                ]);
            
            $CI->app_menu->add_sidebar_menu_item('classes', [
                        'name'     => _l($M->classes->label),
                        'href'     => admin_url('classes'),
                        'icon'     => 'fa fa-bars',
                        'position' => 30,
                        'label'     => _l($M->classes->label),
                        'heading'  => _l($M->classes->heading),
                ]);
                
            $CI->app_menu->add_sidebar_menu_item('results', [
                        'name'     => _l($M->results->label),
                        'href'     => admin_url('results'),
                        'icon'     => 'fa fa-bars',
                        'position' => 20,
                        'label'     => _l($M->results->label),
                        'heading'  => _l($M->results->heading),
                ]);
                
            // Certificates
            $CI->app_menu->add_sidebar_menu_item('certificates', [
                        'name'     => _l($M->certificates->label),
                        'href'     => admin_url('certificates'),
                        'icon'     => 'fa fa-bars',
                        'position' => 20,
                        'label'     => _l($M->certificates->label),
                        'heading'  => _l($M->certificates->heading),
                ]);
        
            $CI->app_menu->add_sidebar_menu_item('assignment', [
                        'name'     => _l($M->assignment->label),
                        'href'     => admin_url('assignment'),
                        //'href'     => '#',
                        'icon'     => 'fa fa-tasks',
                        'position' => 35,
                        'label'     => _l($M->assignment->label),
                        'heading'  => _l($M->assignment->heading),
                ]);
        
            $CI->app_menu->add_sidebar_menu_item('tasks', [
                        'name'     => _l($M->tasks->label),
                        //'href'     => admin_url('tasks'),
                        'href'     => '#',
                        'icon'     => 'fa fa-tasks',
                        'position' => 35,
                        'label'     => _l($M->tasks->label),
                        'heading'  => _l($M->tasks->heading),
                ]);
        
            //Communicate
            $CI->app_menu->add_sidebar_menu_item('communicate', [
                    'collapse' => true,
                    'name'     => _l($M->communicate->label),
                    'position' => 55,
                    'icon'     => 'fa fa-cogs',
                    'label'    => _l($M->communicate->label),
                    'heading'  => _l($M->communicate->heading),
                ]);
            
            $CI->app_menu->add_sidebar_children_item('communicate', [
                        'slug'     => 'sendemail',
                        'name'     => _l($M->communicate->children->sendemail->label),
                        'href'     => admin_url('communicate/sendemail'),
                        'position' => 5,
                        'label'     => _l($M->communicate->children->sendemail->label),
                        'heading'     => _l($M->communicate->children->sendemail->heading),
                ]);
            $CI->app_menu->add_sidebar_children_item('communicate', [
                        'slug'     => 'sendsms_',
                        'name'     => _l($M->communicate->children->sendsms_->label),
                        'href'     => admin_url('communicate/sendsms_'),
                        'position' => 5,
                        'label'     => _l($M->communicate->children->sendsms_->label),
                        'heading'     => _l($M->communicate->children->sendsms_->heading),
                ]);
            $CI->app_menu->add_sidebar_children_item('communicate', [
                        'slug'     => 'emailsmdlog',
                        'name'     => _l($M->communicate->children->emailsmdlog->label),
                        'href'     => admin_url('communicate/emailsmdlog'),
                        'position' => 5,
                        'label'     => _l($M->communicate->children->emailsmdlog->label),
                        'heading'     => _l($M->communicate->children->emailsmdlog->heading),
                ]);
        
            if ((!is_staff_member() && get_option('access_tickets_to_none_staff_members') == 1) || is_staff_member()) {
                $CI->app_menu->add_sidebar_menu_item('support', [
                        'name'     => _l($M->support->label),
                        'href'     => admin_url('tickets'),
                        //'href'     => '#',
                        'icon'     => 'fa fa-ticket',
                        'position' => 40,
                        'label'     => _l($M->support->label),
                        'heading'  => _l($M->support->heading),
                ]);
            }
        
            if (is_staff_member()) {
                $CI->app_menu->add_sidebar_menu_item('leads', [
                        'name'     => _l($M->leads->label),
                        'href'     => admin_url('leads'),
                        'icon'     => 'fa fa-tty',
                        'position' => 45,
                        'label'     => _l($M->leads->label),
                        'heading'  => _l($M->leads->heading),
                ]);
            }
        
            if (has_permission('knowledge_base', '', 'view')) {
                $CI->app_menu->add_sidebar_menu_item('knowledge_base', [
                        'name'     => _l($M->knowledge_base->label),
                        'href'     => admin_url('knowledge_base'),
                        'icon'     => 'fa fa-folder-open-o',
                        'position' => 50,
                        'label'    => _l($M->knowledge_base->label),
                        'heading'  => _l($M->knowledge_base->heading),
                ]);
            }
            
            $CI->app_menu->add_sidebar_menu_item('announcements', [
                    'name'     => _l($M->announcements->label),
                    'href'     => admin_url('announcements'),
                   // 'href'     => '#',
                    'icon'     => 'fa fa-folder-open-o',
                    'position' => 20,
                    'label'     => _l($M->announcements->label),
                    'heading'     => _l($M->announcements->heading),
            ]);
        
            // Utilities
            $CI->app_menu->add_sidebar_menu_item('utilities', [
                    'collapse' => true,
                    'name'     => _l($M->utilities->label),
                    'position' => 55,
                    'icon'     => 'fa fa-cogs',
                    'label'    => _l($M->utilities->label),
                    'heading'  => _l($M->utilities->heading),
                ]);
                
            $CI->app_menu->add_sidebar_children_item('utilities', [
                        'slug'     => 'important',
                        'name'     => _l($M->utilities->children->important->label),
                        'href'     => admin_url('importantReminder'),
                        'position' => 60,
                        'label'     => _l($M->utilities->children->important->label),
                        'heading'     => _l($M->utilities->children->important->heading),
                ]);
        /*
            $CI->app_menu->add_sidebar_children_item('utilities', [
                        'slug'     => 'media',
                        'name'     => _l($M->utilities->children->media->label),
                        //'href'     => admin_url('utilities/media'),
                        'href'     => '#',
                        'position' => 5,
                        'label'     => _l($M->utilities->children->media->label),
                        'heading'     => _l($M->utilities->children->media->heading),
                ]);
        */
            if (has_permission('bulk_pdf_exporter', '', 'view')) {
                $CI->app_menu->add_sidebar_children_item('utilities', [
                        'slug'     => 'bulk_pdf_exporter',
                        'name'     => _l($M->utilities->children->bulk_pdf_exporter->label),
                        //'href'     => admin_url('utilities/bulk_pdf_exporter'),
                        'href'     => '#',
                        'position' => 10,
                        'label'     => _l($M->utilities->children->bulk_pdf_exporter->label),
                        'heading'     => _l($M->utilities->children->bulk_pdf_exporter->heading),
                ]);
            }
        
            $CI->app_menu->add_sidebar_children_item('utilities', [
                        'slug'     => 'calendar',
                        'name'     => _l($M->utilities->children->calendar->label),
                        //'href'     => admin_url('utilities/calendar'),
                        'href'     => '#',
                        'position' => 15,
                        'label'     => _l($M->utilities->children->calendar->label),
                        'heading'     => _l($M->utilities->children->calendar->heading),
                ]);
        
            if (is_admin()) {
                $CI->app_menu->add_sidebar_children_item('utilities', [
                        'slug'     => 'announcements',
                        'name'     => _l($M->utilities->children->announcements->label),
                        //'href'     => admin_url('announcements'),
                        'href'     => '#',
                        'position' => 20,
                        'label'     => _l($M->utilities->children->announcements->label),
                        'heading'     => _l($M->utilities->children->announcements->heading),
                ]);
        
                $CI->app_menu->add_sidebar_children_item('utilities', [
                        'slug'     => 'activity_log',
                        'name'     => _l($M->utilities->children->activity_log->label),
                        //'href'     => admin_url('utilities/activity_log'),
                        'href'     => '#',
                        'position' => 25,
                        'label'     => _l($M->utilities->children->activity_log->label),
                        'heading'     => _l($M->utilities->children->activity_log->heading),
                ]);
        
                $CI->app_menu->add_sidebar_children_item('utilities', [
                        'slug'     => 'ticket_pipe_log',
                        'name'     => _l($M->utilities->children->ticket_pipe_log->label),
                        //'href'     => admin_url('utilities/pipe_log'),
                        'href'     => '#',
                        'position' => 30,
                        'label'     => _l($M->utilities->children->ticket_pipe_log->label),
                        'heading'     => _l($M->utilities->children->ticket_pipe_log->heading),
                ]);
            }
        
            $CI->app_menu->add_sidebar_menu_item('phonecalllog', [
                        'name'     => _l($M->phonecalllog->label),
                        'href'     => admin_url('phoneCallLog'),
                        'position' => 5,
                        'label'     => _l($M->phonecalllog->label),
                        'heading'     => _l($M->phonecalllog->heading),
                ]);
        
            $CI->app_menu->add_sidebar_menu_item('reports_', [
                        'name'     => _l($M->reports_->label),
                        'href'     => admin_url('reports'),
                        'position' => 5,
                        'label'     => _l($M->reports_->label),
                        'heading'     => _l($M->reports_->heading),
                ]);
        
            if (has_permission('reports', '', 'view')) {
                $CI->app_menu->add_sidebar_menu_item('reports', [
                        'collapse' => true,
                        'name'     => _l($M->reports->label),
                        'icon'     => 'fa fa-area-chart',
                        'position' => 60,
                        'label'     => _l($M->reports->label),
                        'heading'  => _l($M->reports->heading),
                ]);
                
                $CI->app_menu->add_sidebar_children_item('reports', [
                        'slug'     => 'sales_reports',
                        'name'     => _l($M->reports->children->sales_reports->label),
                        //'href'     => admin_url('reports/sales'),
                        'href'     => '#',
                        'position' => 5,
                        'label'     => _l($M->reports->children->sales_reports->label),
                        'heading'     => _l($M->reports->children->sales_reports->heading),
                ]);
                $CI->app_menu->add_sidebar_children_item('reports', [
                        'slug'     => 'expenses_reports',
                        'name'     => _l($M->reports->children->expenses_reports->label),
                        //'href'     => admin_url('reports/expenses'),
                        'href'     => '#',
                        'position' => 10,
                        'label'     => _l($M->reports->children->expenses_reports->label),
                        'heading'     => _l($M->reports->children->expenses_reports->heading),
                ]);
                $CI->app_menu->add_sidebar_children_item('reports', [
                        'slug'     => 'expenses_vs_income_reports',
                        'name'     => _l($M->reports->children->expenses_vs_income_reports->label),
                        //'href'     => admin_url('reports/expenses_vs_income'),
                        'href'     => '#',
                        'position' => 15,
                        'label'     => _l($M->reports->children->expenses_vs_income_reports->label),
                        'heading'     => _l($M->reports->children->expenses_vs_income_reports->heading),
                ]);
                $CI->app_menu->add_sidebar_children_item('reports', [
                        'slug'     => 'leads_reports',
                        'name'     => _l($M->reports->children->leads_reports->label),
                        //'href'     => admin_url('reports/leads'),
                        'href'     => '#',
                        'position' => 20,
                        'label'     => _l($M->reports->children->leads_reports->label),
                        'heading'     => _l($M->reports->children->leads_reports->heading),
                ]);
        
                if (is_admin()) {
                    $CI->app_menu->add_sidebar_children_item('reports', [
                            'slug'     => 'timesheets_reports',
                            'name'     => _l($M->reports->children->timesheets_reports->label),
                            //'href'     => admin_url('staff/timesheets?view=all'),
                            'href'     => '#',
                            'position' => 25,
                            'label'     => _l($M->reports->children->timesheets_reports->label),
                            'heading'     => _l($M->reports->children->timesheets_reports->heading),
                    ]);
                }
        
                $CI->app_menu->add_sidebar_children_item('reports', [
                            'slug'     => 'knowledge_base_reports',
                            'name'     => _l($M->reports->children->knowledge_base_reports->label),
                            //'href'     => admin_url('reports/knowledge_base_articles'),
                            'href'     => '#',
                            'position' => 30,
                            'label'     => _l($M->reports->children->knowledge_base_reports->label),
                            'heading'     => _l($M->reports->children->knowledge_base_reports->heading),
                    ]);
            }
        
            $customsub_menu = $CI->db->get_where('tbloptions', array('name' => 'setup_menu_active'))->row('value');
            $sM = json_decode($customsub_menu);
            //echo '<pre>'; print_r($sM); die;
            
            // Setup menu
            if (has_permission('settings', '', 'view')) {
                $CI->app_menu->add_setup_menu_item('settings', [
                            'href'     => admin_url('settings'),
                            'name'     => _l($sM->settings->label),
                            'position' => 3,
                            'label'     => _l($sM->settings->label),
                            'heading'     => _l($sM->settings->heading),
                    ]);
            }
            
            /*
            $CI->app_menu->add_setup_menu_item('student_master', [
                            'href'     => admin_url('studentMaster'),
                            'name'     => _l($sM->student_master->label),
                            'position' => 4,
                            'label'     => _l($sM->student_master->label),
                            'heading'     => _l($sM->student_master->heading),
                    ]);
            */
            /*
            $CI->app_menu->add_setup_menu_item('master', [
                            'href'     => admin_url('master'),
                            'name'     => _l($sM->master->label),
                            'position' => 4,
                            'label'     => _l($sM->master->label),
                            'heading'     => _l($sM->master->heading),
                    ]);
                */
                    
            $CI->app_menu->add_setup_menu_item('dashboard_settings', [
                            'href'     => admin_url('dashboardSetting'),
                            'name'     => _l($sM->dashboard_settings->label),
                            'position' => 4,
                            'label'     => _l($sM->dashboard_settings->label),
                            'heading'     => _l($sM->dashboard_settings->heading),
                    ]);
        
            if (has_permission('staff', '', 'view')) {
                $CI->app_menu->add_setup_menu_item('login', [
                            'name'     => _l($sM->login->label),
                            'href'     => admin_url('loginPage'),
                            'position' => 5,
                            'label'     => _l($sM->login->label),
                            'heading'     => _l($sM->login->heading),
                    ]);
            }
        
                $CI->app_menu->add_setup_menu_item('roles', [
                            'href'     => admin_url('roles'),
                            'name'     => _l($sM->roles->label),
                            'label'     => _l($sM->roles->label),
                            'heading'     => _l($sM->roles->heading),
                            'position' => 6,
                    ]);
            /*
            if (has_permission('staff', '', 'view')) {
                $CI->app_menu->add_setup_menu_item('staff', [
                            'name'     => _l($sM->staff->label),
                            'href'     => admin_url('staff'),
                            'position' => 7,
                            'label'    => _l($sM->staff->label),
                            'heading'    => _l($sM->staff->heading),
                    ]);
            }
            */
            
            $CI->app_menu->add_setup_menu_item('master', [
                            'collapse' => true,
                            'name'     => _l($sM->master->label),
                            'position' => 10,
                            'label'     => _l($sM->master->label),
                            'heading'     => _l($sM->master->heading),
                    ]);
                    
                $CI->app_menu->add_setup_children_item('master', [
                            'slug'     => 'campus',
                            'name'     => _l($sM->master->children->campus->label),
                            'href'     => admin_url('campus'),
                            'position' => 5,
                            'label'     => _l($sM->master->children->campus->label),
                            'heading'     => _l($sM->master->children->campus->heading),
                    ]);
                    
                $CI->app_menu->add_setup_children_item('master', [
                            'slug'     => 'grade',
                            'name'     => _l($sM->master->children->grade->label),
                            'href'     => admin_url('grade'),
                            'position' => 8,
                            'label'     => _l($sM->master->children->grade->label),
                            'heading'     => _l($sM->master->children->grade->heading),
                    ]);
                    
                $CI->app_menu->add_setup_children_item('master', [
                            'slug'     => 'participating',
                            'name'     => _l($sM->master->children->participating->label),
                            'href'     => admin_url('participating'),
                            'position' => 9,
                            'label'     => _l($sM->master->children->participating->label),
                            'heading'     => _l($sM->master->children->participating->heading),
                    ]);
        
                $CI->app_menu->add_setup_children_item('master', [
                            'slug'     => 'class_',
                            'name'     => _l($sM->master->children->class_->label),
                            'href'     => admin_url('classMaster'),
                            'position' => 5,
                            'label'     => _l($sM->master->children->class_->label),
                            'heading'     => _l($sM->master->children->class_->heading),
                    ]);
                    
                $CI->app_menu->add_setup_children_item('master', [
                            'slug'     => 'subject_',
                            'name'     => _l($sM->master->children->subject_->label),
                            'label'     => _l($sM->master->children->subject_->label),
                            'heading'     => _l($sM->master->children->subject_->heading),
                            'href'     => admin_url('subjectMaster'),
                            'position' => 5,
                    ]);
                    
                $CI->app_menu->add_setup_children_item('master', [
                            'slug'     => 'post_master',
                            'name'     => _l($sM->master->children->post_master->label),
                            'label'     => _l($sM->master->children->post_master->label),
                            'heading'     => _l($sM->master->children->post_master->heading),
                            'href'     => admin_url('postMaster'),
                            'position' => 5,
                    ]);
                    
                $CI->app_menu->add_setup_children_item('master', [
                            'slug'     => 'route_master',
                            'name'     => _l($sM->master->children->route_master->label),
                            'href'     => admin_url('routeMaster'),
                            'position' => 5,
                            'label'     => _l($sM->master->children->route_master->label),
                            'heading'     => _l($sM->master->children->route_master->heading),
                    ]);
                    
                $CI->app_menu->add_setup_children_item('master', [
                            'slug'     => 'vehicle_master',
                            'name'     => _l($sM->master->children->vehicle_master->label),
                            'href'     => admin_url('vehicleMaster'),
                            'position' => 5,
                            'label'     => _l($sM->master->children->vehicle_master->label),
                            'heading'     => _l($sM->master->children->vehicle_master->heading),
                    ]);
                 
                $CI->app_menu->add_setup_children_item('master', [
                            'slug'     => 'payment_type',
                            'name'     => _l($sM->master->children->payment_type->label),
                            'href'     => admin_url('paymentType'),
                            'position' => 5,
                            'label'     => _l($sM->master->children->payment_type->label),
                            'heading'     => _l($sM->master->children->payment_type->heading),
                    ]); 
                 
                $CI->app_menu->add_setup_children_item('master', [
                            'slug'     => 'package_master',
                            'name'     => _l($sM->master->children->package_master->label),
                            'href'     => admin_url('packageMaster'),
                            'position' => 5,
                            'label'     => _l($sM->master->children->package_master->label),
                            'heading'     => _l($sM->master->children->package_master->heading),
                    ]);
                    
                $CI->app_menu->add_setup_children_item('master', [
                            'slug'     => 'schoolfees',
                            'name'     => _l($sM->master->children->schoolfees->label),
                            'href'     => admin_url('schoolFees'),
                            'position' => 5,
                            'label'     => _l($sM->master->children->schoolfees->label),
                            'heading'     => _l($sM->master->children->schoolfees->heading),
                    ]);
            
            if (is_admin()) {
                $CI->app_menu->add_setup_menu_item('customers', [
                            'collapse' => true,
                            'name'     => _l($sM->customers->label),
                            'position' => 10,
                            'label'     => _l($sM->customers->label),
                            'heading'     => _l($sM->customers->heading),
                    ]);
        
                $CI->app_menu->add_setup_children_item('customers', [
                            'slug'     => 'custom_fields',
                            'name'     => _l($sM->customers->children->custom_fields->label),
                            'href'     => admin_url('clients/customFields'),
                            'position' => 5,
                            'label'     => _l($sM->customers->children->custom_fields->label),
                            'heading'     => _l($sM->customers->children->custom_fields->heading),
                    ]);
                    
                $CI->app_menu->add_setup_children_item('customers', [
                            'slug'     => 'customer_groups',
                            'name'     => _l($sM->customers->children->customer_groups->label),
                            'label'     => _l($sM->customers->children->customer_groups->label),
                            'heading'     => _l($sM->customers->children->customer_groups->heading),
                            'href'     => admin_url('clients/groups'),
                            'position' => 5,
                    ]);
        
                $CI->app_menu->add_setup_menu_item('product_services', [
                            'href'     => admin_url('#'),
                            'name'     => _l('Product / Services'),
                            'label'     => _l('Product / Services'),
                            'position' => 11,
                    ]);
                    
                $CI->app_menu->add_setup_menu_item('gdpr', [
                            'href'     => admin_url('gdpr'),
                            'name'     => _l($sM->gdpr->label),
                            'label'     => _l($sM->gdpr->label),
                            'heading'     => _l($sM->gdpr->heading),
                            'position' => 50,
                    ]);
        
                $CI->app_menu->add_setup_menu_item('finance', [
                            'collapse' => true,
                            'name'     => _l($sM->finance->label),
                            'label'     => _l($sM->finance->label),
                            'heading'     => _l($sM->finance->heading),
                            'position' => 25,
                    ]);
                $CI->app_menu->add_setup_children_item('finance', [
                            'slug'     => 'taxes',
                            'name'     => _l($sM->finance->children->taxes->label),
                            'label'     => _l($sM->finance->children->taxes->label),
                            'heading'     => _l($sM->finance->children->taxes->heading),
                            'href'     => admin_url('taxes'),
                            'position' => 5,
                    ]);
                $CI->app_menu->add_setup_children_item('finance', [
                            'slug'     => 'currencies',
                            'name'     => _l($sM->finance->children->currencies->label),
                            'label'     => _l($sM->finance->children->currencies->label),
                            'heading'     => _l($sM->finance->children->currencies->heading),
                            'href'     => admin_url('currencies'),
                            'position' => 10,
                    ]);
                $CI->app_menu->add_setup_children_item('finance', [
                            'slug'     => 'payment_modes',
                            'name'     => _l($sM->finance->children->payment_modes->label),
                            'label'     => _l($sM->finance->children->payment_modes->label),
                            'heading'     => _l($sM->finance->children->payment_modes->heading),
                            'href'     => admin_url('paymentmodes'),
                            'position' => 15,
                    ]);
                $CI->app_menu->add_setup_children_item('finance', [
                            'slug'     => 'expenses_categories',
                            'heading'     => _l($sM->finance->children->expenses_categories->heading),
                            'name'     => _l($sM->finance->children->expenses_categories->label),
                            'label'     => _l($sM->finance->children->expenses_categories->label),
                            'href'     => admin_url('expenses/categories'),
                            'position' => 20,
                    ]);
        
                $CI->app_menu->add_setup_menu_item('subscription', [
                            'href'     => admin_url('settings?group=subscriptions'),
                            'name'     => _l($sM->subscription->label),
                            'label'     => _l($sM->subscription->label),
                            'heading'     => _l($sM->subscription->heading),
                            'position' => 26,
                    ]);
        
                $CI->app_menu->add_setup_menu_item('payment_gateways', [
                            'href'     => admin_url('settings?group=payment_gateways'),
                            'name'     => _l('Payment Gateway'),
                            'label'     => _l('Payment Gateway'),
                            'position' => 27,
                    ]);
        
                $CI->app_menu->add_setup_menu_item('_sms', [
                            'href'     => admin_url('settings?group=sms'),
                            'name'     => _l('SMS'),
                            'label'     => _l('SMS'),
                            'position' => 28,
                    ]);
                    
                $CI->app_menu->add_setup_menu_item('leads', [
                            'collapse' => true,
                            'name'     => _l($sM->leads->label),
                            'label'     => _l($sM->leads->label),
                            'heading'     => _l($sM->leads->heading),
                            'position' => 20,
                    ]);
                $CI->app_menu->add_setup_children_item('leads', [
                            'slug'     => 'leads_sources',
                            'name'     => _l($sM->leads->children->leads_sources->label),
                            'label'     => _l($sM->leads->children->leads_sources->label),
                            'heading'     => _l($sM->leads->children->leads_sources->heading),
                            'href'     => admin_url('leads/sources'),
                            'position' => 5,
                    ]);
                $CI->app_menu->add_setup_children_item('leads', [
                            'slug'     => 'leads_statuses',
                            'name'     => _l($sM->leads->children->leads_statuses->label),
                            'label'     => _l($sM->leads->children->leads_statuses->label),
                            'heading'     => _l($sM->leads->children->leads_statuses->heading),
                            'href'     => admin_url('leads/statuses'),
                            'position' => 10,
                    ]);
                $CI->app_menu->add_setup_children_item('leads', [
                            'slug'     => 'leads_email_integration',
                            'name'     => _l($sM->leads->children->leads_email_integration->label),
                            'label'     => _l($sM->leads->children->leads_email_integration->label),
                            'heading'     => _l($sM->leads->children->leads_email_integration->heading),
                            'href'     => admin_url('leads/email_integration'),
                            'position' => 15,
                    ]);
                $CI->app_menu->add_setup_children_item('leads', [
                            'slug'     => 'web_to_lead',
                            'name'     => _l($sM->leads->children->web_to_lead->label),
                            'label'     => _l($sM->leads->children->web_to_lead->label),
                            'heading'     => _l($sM->leads->children->web_to_lead->heading),
                            'href'     => admin_url('leads/forms'),
                            'position' => 20,
                    ]);
                
                $CI->app_menu->add_setup_menu_item('support', [
                            'collapse' => true,
                            'name'     => _l($sM->support->label),
                            'label'     => _l($sM->support->label),
                            'heading'     => _l($sM->support->heading),
                            'position' => 15,
                    ]);
        
                $CI->app_menu->add_setup_children_item('support', [
                            'slug'     => 'departments',
                            'name'     => _l($sM->support->children->departments->label),
                            'label'     => _l($sM->support->children->departments->label),
                            'heading'     => _l($sM->support->children->departments->heading),
                            'href'     => admin_url('departments'),
                            'position' => 5,
                    ]);
                $CI->app_menu->add_setup_children_item('support', [
                            'slug'     => 'tickets_predefined_replies',
                            'name'     => _l($sM->support->children->tickets_predefined_replies->label),
                            'label'     => _l($sM->support->children->tickets_predefined_replies->label),
                            'heading'     => _l($sM->support->children->tickets_predefined_replies->heading),
                            'href'     => admin_url('tickets/predefined_replies'),
                            'position' => 10,
                    ]);
                $CI->app_menu->add_setup_children_item('support', [
                            'slug'     => 'tickets_priorities',
                            'name'     => _l($sM->support->children->tickets_priorities->label),
                            'label'     => _l($sM->support->children->tickets_priorities->label),
                            'heading'     => _l($sM->support->children->tickets_priorities->heading),
                            'href'     => admin_url('tickets/priorities'),
                            'position' => 15,
                    ]);
                $CI->app_menu->add_setup_children_item('support', [
                            'slug'     => 'tickets_statuses',
                            'name'     => _l($sM->support->children->tickets_statuses->label),
                            'label'     => _l($sM->support->children->tickets_statuses->label),
                            'heading'     => _l($sM->support->children->tickets_statuses->heading),
                            'href'     => admin_url('tickets/statuses'),
                            'position' => 20,
                    ]);
        
                $CI->app_menu->add_setup_children_item('support', [
                            'slug'     => 'tickets_services',
                            'name'     => _l($sM->support->children->tickets_services->label),
                            'label'     => _l($sM->support->children->tickets_services->label),
                            'heading'     => _l($sM->support->children->tickets_services->heading),
                            'href'     => admin_url('tickets/services'),
                            'position' => 25,
                    ]);
                $CI->app_menu->add_setup_children_item('support', [
                            'slug'     => 'tickets_spam_filters',
                            'name'     => _l($sM->support->children->tickets_spam_filters->label),
                            'label'     => _l($sM->support->children->tickets_spam_filters->label),
                            'heading'     => _l($sM->support->children->tickets_spam_filters->heading),
                            'href'     => admin_url('spam_filters/view/tickets'),
                            'position' => 30,
                    ]);
        /*
                $CI->app_menu->add_setup_menu_item('support', [
                            'collapse' => true,
                            'name'     => _l('support'),
                            'position' => 15,
                    ]);
        
                $CI->app_menu->add_setup_children_item('support', [
                            'slug'     => 'departments',
                            'name'     => _l('acs_departments'),
                            'href'     => admin_url('departments'),
                            'position' => 5,
                    ]);
                $CI->app_menu->add_setup_children_item('support', [
                            'slug'     => 'tickets-predefined-replies',
                            'name'     => _l('acs_ticket_predefined_replies_submenu'),
                            'href'     => admin_url('tickets/predefined_replies'),
                            'position' => 10,
                    ]);
                $CI->app_menu->add_setup_children_item('support', [
                            'slug'     => 'tickets-priorities',
                            'name'     => _l('acs_ticket_priority_submenu'),
                            'href'     => admin_url('tickets/priorities'),
                            'position' => 15,
                    ]);
                $CI->app_menu->add_setup_children_item('support', [
                            'slug'     => 'tickets-statuses',
                            'name'     => _l('acs_ticket_statuses_submenu'),
                            'href'     => admin_url('tickets/statuses'),
                            'position' => 20,
                    ]);
        
                $CI->app_menu->add_setup_children_item('support', [
                            'slug'     => 'tickets-services',
                            'name'     => _l('acs_ticket_services_submenu'),
                            'href'     => admin_url('tickets/services'),
                            'position' => 25,
                    ]);
                $CI->app_menu->add_setup_children_item('support', [
                            'slug'     => 'tickets-spam-filters',
                            'name'     => _l('spam_filters'),
                            'href'     => admin_url('spam_filters/view/tickets'),
                            'position' => 30,
                    ]);
        
                $CI->app_menu->add_setup_menu_item('leads', [
                            'collapse' => true,
                            'name'     => _l('acs_leads'),
                            'position' => 20,
                    ]);
                $CI->app_menu->add_setup_children_item('leads', [
                            'slug'     => 'leads-sources',
                            'name'     => _l('acs_leads_sources_submenu'),
                            'href'     => admin_url('leads/sources'),
                            'position' => 5,
                    ]);
                $CI->app_menu->add_setup_children_item('leads', [
                            'slug'     => 'leads-statuses',
                            'name'     => _l('acs_leads_statuses_submenu'),
                            'href'     => admin_url('leads/statuses'),
                            'position' => 10,
                    ]);
                $CI->app_menu->add_setup_children_item('leads', [
                            'slug'     => 'leads-email-integration',
                            'name'     => _l('leads_email_integration'),
                            'href'     => admin_url('leads/email_integration'),
                            'position' => 15,
                    ]);
                $CI->app_menu->add_setup_children_item('leads', [
                            'slug'     => 'web-to-lead',
                            'name'     => _l('web_to_lead'),
                            'href'     => admin_url('leads/forms'),
                            'position' => 20,
                    ]);
        
                $CI->app_menu->add_setup_menu_item('contracts', [
                            'collapse' => true,
                            'name'     => _l('acs_contracts'),
                            'position' => 30,
                    ]);
                $CI->app_menu->add_setup_children_item('contracts', [
                            'slug'     => 'contracts-types',
                            'name'     => _l('acs_contract_types'),
                            'href'     => admin_url('contracts/types'),
                            'position' => 5,
                    ]);
        
                $modules_name = _l('modules');
        
                if ($modulesNeedsUpgrade = $CI->app_modules->number_of_modules_that_require_database_upgrade()) {
                    $modules_name .= '<span class="badge menu-badge bg-warning">' . $modulesNeedsUpgrade . '</span>';
                }
        
                $CI->app_menu->add_setup_menu_item('modules', [
                            'href'     => admin_url('modules'),
                            'name'     => $modules_name,
                            'position' => 35,
                    ]);
        
                $CI->app_menu->add_setup_menu_item('custom-fields', [
                            'href'     => admin_url('custom_fields'),
                            'name'     => _l('asc_custom_fields'),
                            'position' => 45,
                    ]);
        
                $CI->app_menu->add_setup_menu_item('gdpr', [
                            'href'     => admin_url('gdpr'),
                            'name'     => _l('gdpr_short'),
                            'position' => 50,
                    ]);
                */
        
                
        
        /*             $CI->app_menu->add_setup_menu_item('api', [
                                  'href'     => admin_url('api'),
                                  'name'     => 'API',
                                  'position' => 65,
                          ]);*/
        
            }
        
            /*
        
            if (has_permission('email_templates', '', 'view')) {
                $CI->app_menu->add_setup_menu_item('email-templates', [
                            'href'     => admin_url('emails'),
                            'name'     => _l('acs_email_templates'),
                            'position' => 40,
                    ]);
            }
            */
    }
    else
    {
        if(get_staff_user_id() > 90)
        {
            $CI->app_menu->add_sidebar_menu_item('dashboard', [
                'name'     => _l($M->dashboard->label),
                'href'     => admin_url(),
                'position' => 1,
                'icon'     => 'fa fa-home',
                'label'    => _l($M->dashboard->label),
                'heading'  => _l($M->dashboard->heading),
            ]);
            
            $CI->app_menu->add_sidebar_menu_item('clients', [
                    'name'     => _l('Students List'),
                    'href'     => admin_url('clients'),
                    'position' => 1,
                    'icon'     => 'fa fa-home',
                    'label'    => _l($M->clients->label),
                    'heading'  => _l($M->clients->heading),
                ]);
        }
        elseif(get_staff_user_id() == 70)
        {
            /* Dashboard */
            $CI->app_menu->add_sidebar_menu_item('dashboard', [
                'name'     => _l($M->dashboard->label),
                'href'     => admin_url(),
                'position' => 1,
                'icon'     => 'fa fa-home',
                'label'    => _l($M->dashboard->label),
                'heading'  => _l($M->dashboard->heading),
            ]);

            /* Dashboard */
            
            
            /* Student list *//*
            $CI->app_menu->add_sidebar_menu_item('customers', [
                    'collapse' => true,
                    'name'     => _l($M->customers->label),
                    'position' => 5,
                    'icon'     => 'fa fa-user-o',
                    'label'     => _l($M->customers->label),
                    'heading'  => _l($M->customers->heading),
                ]);
        
            $CI->app_menu->add_sidebar_children_item('customers', [
                        'slug'     => 'customer',
                        'name'     => _l($M->customers->children->customer->label),
                        'href'     => admin_url('clients'),
                        'position' => 5,
                        'label'     => _l($M->customers->children->customer->label),
                        'heading'     => _l($M->customers->children->customer->heading),
                ]);*/
            /*
            $CI->app_menu->add_sidebar_children_item('customers', [
                        'slug'     => 'class_wise_customer',
                        'name'     => _l($M->customers->children->class_wise_customer->label),
                        'href'     => admin_url('clients/classWise'),
                        'position' => 5,
                        'label'     => _l($M->customers->children->class_wise_customer->label),
                        'heading'     => _l($M->customers->children->class_wise_customer->heading),
                ]);
            */
        }
        else
        {
            /* Dashboard */
            $CI->app_menu->add_sidebar_menu_item('dashboard', [
                'name'     => _l($M->dashboard->label),
                'href'     => admin_url(),
                'position' => 1,
                'icon'     => 'fa fa-home',
                'label'    => _l($M->dashboard->label),
                'heading'  => _l($M->dashboard->heading),
            ]);
            
            /* Teacher list *//*
            $CI->app_menu->add_sidebar_menu_item('teacher_master', [
                    'collapse' => true,
                    'name'     => _l($M->teacher_master->label),
                    'position' => 10,
                    'icon'     => 'fa fa-balance-scale',
                    'label'     => _l($M->teacher_master->label),
                    'heading'  => _l($M->teacher_master->heading),
                ]);
        
            $CI->app_menu->add_sidebar_children_item('teacher_master', [
                    'slug'     => 'staff',
                    'name'     => _l($M->teacher_master->children->staff->label),
                    'href'     => admin_url('staff'),
                    'position' => 5,
                    'label'     => _l($M->teacher_master->children->staff->label),
                    'heading'     => _l($M->teacher_master->children->staff->heading),
            ]);
            
            $CI->app_menu->add_sidebar_children_item('teacher_master', [
                    'slug'     => 'particulars',
                    'name'     => _l($M->teacher_master->children->particulars->label),
                    'href'     => admin_url('particulars'),
                    'position' => 5,
                    'label'     => _l($M->teacher_master->children->particulars->label),
                    'heading'     => _l($M->teacher_master->children->particulars->heading),
            ]);*/
            
            /* Student list *//*
            $CI->app_menu->add_sidebar_menu_item('customers', [
                    'collapse' => true,
                    'name'     => _l($M->customers->label),
                    'position' => 5,
                    'icon'     => 'fa fa-user-o',
                    'label'     => _l($M->customers->label),
                    'heading'  => _l($M->customers->heading),
                ]);
        
            $CI->app_menu->add_sidebar_children_item('customers', [
                        'slug'     => 'customer',
                        'name'     => _l($M->customers->children->customer->label),
                        'href'     => admin_url('clients'),
                        'position' => 5,
                        'label'     => _l($M->customers->children->customer->label),
                        'heading'     => _l($M->customers->children->customer->heading),
                ]);*/
              /*  
            $CI->app_menu->add_sidebar_children_item('customers', [
                        'slug'     => 'class_wise_customer',
                        'name'     => _l($M->customers->children->class_wise_customer->label),
                        'href'     => admin_url('clients/classWise'),
                        'position' => 5,
                        'label'     => _l($M->customers->children->class_wise_customer->label),
                        'heading'     => _l($M->customers->children->class_wise_customer->heading),
                ]);*/
                
            /* Report */    
            /*
            $CI->app_menu->add_sidebar_menu_item('fees_', [
                    'collapse' => true,
                    'name'     => _l($M->fees_->label),
                    'position' => 55,
                    'icon'     => 'fa fa-money',
                    'label'    => _l($M->fees_->label),
                    'heading'  => _l($M->fees_->heading),
                ]);
            
            $CI->app_menu->add_sidebar_children_item('fees_', [
                        'slug'     => 'collectfees',
                        'name'     => _l($M->fees_->children->collectfees->label),
                        'href'     => admin_url('collectfees'),
                        'position' => 5,
                        'label'     => _l($M->fees_->children->collectfees->label),
                        'heading'     => _l($M->fees_->children->collectfees->heading),
                ]);
        
            $CI->app_menu->add_sidebar_children_item('fees_', [
                        'slug'     => 'feediscount',
                        'name'     => _l($M->fees_->children->feediscount->label),
                        'href'     => admin_url('collectfees/packageWise'),
                        'position' => 5,
                        'label'     => _l($M->fees_->children->feediscount->label),
                        'heading'     => _l($M->fees_->children->feediscount->heading),
                ]);
                
            $CI->app_menu->add_sidebar_menu_item('reports_', [
                        'name'     => _l($M->reports_->label),
                        'href'     => admin_url('reports'),
                        'position' => 5,
                        'label'     => _l($M->reports_->label),
                        'heading'     => _l($M->reports_->heading),
                ]);            
                
                */
            $CI->app_menu->add_sidebar_menu_item('clients', [
                    'name'     => _l($M->clients->label),
                    'href'     => admin_url('clients'),
                    'position' => 1,
                    'icon'     => 'fa fa-home',
                    'label'    => _l($M->clients->label),
                    'heading'  => _l($M->clients->heading),
                ]);
            /* Terms */
            $CI->app_menu->add_sidebar_menu_item('terms', [
                'name'     => _l($M->terms->label),
                'href'     => admin_url('terms'),
                'position' => 1,
                'icon'     => 'fa fa-th',
                'label'    => _l($M->terms->label),
                'heading'  => _l($M->terms->heading),
            ]);
            /* Remark */
            $CI->app_menu->add_sidebar_menu_item('remark', [
                'name'     => _l($M->remark->label),
                'href'     => admin_url('remark'),
                'position' => 1,
                'icon'     => 'fa fa-th',
                'label'    => _l($M->remark->label),
                'heading'  => _l($M->remark->heading),
            ]);
        }
    }
}
