<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Videos extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('videos_model');
    }

    /* List all knowledgebase articles */
    public function index()
    {
        if (!has_permission('videos', '', 'view')) {
            access_denied('videos');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('videos');
        }
       
        $subheader_text = setupTitle_text('aside_menu_active', 'teacher_master', 'videos');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;
        
        $data['class_list'] = $this->db->get_where(db_prefix().'master_class')->result();
        $data['title']     = _l($subheader_text);
        $this->load->view('admin/videos/articles', $data);
    }

    /* Add new article or edit existing*/
    public function add($id = '')
    {
        if (!has_permission('videos', '', 'view')) {
            access_denied('videos');
        }
        if ($this->input->post()) {
            $data                = $this->input->post();
            
            if ($id == '') {
                if (!has_permission('videos', '', 'create')) {
                    access_denied('videos');
                }
                $id = $this->videos_model->add_article($data);
                if ($id) {
                    
                    $uploadedFiles = handle_task_attachments_array($id);
                    if ($uploadedFiles && is_array($uploadedFiles)) {
                        foreach ($uploadedFiles as $file) {
                            $this->misc_model->add_attachment_to_database($id, 'videoslogo', [$file]);
                        }
                    }
                    set_alert('success', _l('added_successfully', _l('Videos')));
                    redirect(admin_url('videos'));
                }
            } else {
                if (!has_permission('videos', '', 'edit')) {
                    access_denied('videos');
                }
                $success = $this->videos_model->update_article($data, $id);
                $uploadedFiles = handle_task_attachments_array($id);
                if ($uploadedFiles && is_array($uploadedFiles)) {
                    foreach ($uploadedFiles as $file) {
                        $this->misc_model->add_attachment_to_database($id, 'videoslogo', [$file]);
                    }
                }
                
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('Videos')));
                }
                redirect(admin_url('videos'));
            }
        }
        if ($id == '') {
        } else {
            $article         = $this->videos_model->get($id);
            $data['article'] = $article;
        }
        $subheader_text = setupTitle_text('aside_menu_active', 'teacher_master', 'videos');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;

        $data['title']     = _l($subheader_text);
        $this->load->view('admin/videos/article', $data);
    }

    public function save() {
        // If file uploaded
        if(is_uploaded_file($_FILES['fileURL']['tmp_name'])) {                            
            // Parse data from CSV file
            $csvData = $this->csvreader->parse_csv($_FILES['fileURL']['tmp_name']);       
            //echo '<pre>'; print_r($csvData); die;
            // create array from CSV file
           if(!empty($csvData)){
                foreach($csvData as $element){                    
                    // Prepare data for Database insertion
                    $data = array(
                        'name' => $element['Name'],
                        'mobile_one' => $element['Mobile First'],
                        'mobile_second' => $element['Mobile Second'],
                        'address' => $element['Address'],
                        'from_company' => $element['From Company'],
                        'from_vendore' => $element['From Vendor'],
                    );
                    //echo '<pre>'; print_r($data); die;
                    $this->db->insert(db_prefix() . 'master_videos_reminder', $data);
                    $data[] = '';
                }
                set_alert('success', _l('Data are stored successful!'));
            }
            else
            {
                set_alert('warning', _l('File is required'));
            }
        }
        else
        {
            set_alert('warning', _l('File is required'));
        } 
        redirect(admin_url('videos'));
    }
    
    // export Data
    public function sampledata() {
        $storData = array();
        $data[] = array('name' => 'Name', 'mobile_one' => 'Mobile First', 'mobile_second' => 'Mobile Second', 'address' => 'Address', 'from_company' => 'From Company', 'from_vendore' => 'From Vendor');       
        
        header("Content-type: application/csv");
        header("Content-Disposition: attachment; filename=\"csv-sample-customer".".csv\"");
        header("Pragma: no-cache");
        header("Expires: 0");
        $handle = fopen('php://output', 'w');
        foreach ($data as $data) {
            fputcsv($handle, $data);
        }
            fclose($handle);
        exit;
    }

    /* Delete article from database */
    public function delete_videos($id)
    {
        if (!has_permission('videos', '', 'delete')) {
            access_denied('videos');
        }
        if (!$id) {
            redirect(admin_url('videos'));
        }
        $response = $this->videos_model->delete_article($id);
        if ($response == true) {
            set_alert('success', _l('deleted', _l('Videos')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('Videos')));
        }
        redirect(admin_url('videos'));
    }
}
