<?php

defined('BASEPATH') or exit('No direct script access allowed');

class VehicleMaster extends AdminController
{
    /* List all class master */
    public function index()
    {
        $this->load->model('vehicle_master_model');
        if (!has_permission('vehicle_master', '', 'view')) {
            access_denied('vehicle_master');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('master_vehicle');
        }
        
        $subheader_text = setupTitle_text('setup_menu_active', 'master', 'vehicle_master');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;
        
        $data['title'] = _l($subheader_text);
        $this->load->view('admin/vehicleMaster/manage', $data);
    }

    /* Add new role or edit existing one */
    public function role($id = '')
    {
        $this->load->model('vehicle_master_model');
        if (!has_permission('vehicle_master', '', 'view')) {
            access_denied('vehicle_master');
        }
        if ($this->input->post()) {
            if ($id == '') {
                if (!has_permission('vehicle_master', '', 'create')) {
                    access_denied('vehicle_master');
                }
                $id = $this->vehicle_master_model->add($this->input->post());
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('Vehicle')));
                    redirect(admin_url('vehicleMaster'));
                }
            } else {
                if (!has_permission('vehicle_master', '', 'edit')) {
                    access_denied('vehicle_master');
                }
                $success = $this->vehicle_master_model->update($this->input->post(), $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('Vehicle')));
                }
                redirect(admin_url('vehicleMaster'));
            }
        }
        
        $subheader_text = setupTitle_text('setup_menu_active', 'master', 'vehicle_master');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;
        
        if ($id == '') {
            $title = _l('add_new', _l('Vehicle'));
        } else {
            $role               = $this->vehicle_master_model->get($id);
            $data['role']       = $role;
            $title              = _l('edit', _l('Vehicle')) . ' ' . $role->name;
        }
        
        $data['title'] = $subheader_text;
        $this->load->view('admin/vehicleMaster/role', $data);
    }

    /* Delete role from database */
    public function delete($id)
    {
        $this->load->model('vehicle_master_model');
        if (!has_permission('vehicle_master', '', 'delete')) {
            access_denied('vehicle_master');
        }
        if (!$id) {
            redirect(admin_url('vehicleMaster'));
        }
        $response = $this->vehicle_master_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('Vehicle master')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('Vehicle')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('Vehicle master')));
        }
        redirect(admin_url('vehicleMaster'));
    }
}
