<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Transport extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('transport_model');
    }

    /* List all knowledgebase articles */
    public function index()
    {
        if (!has_permission('transport', '', 'view')) {
            access_denied('transport');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('transport');
        }
       
        $sheader_text = title_text('aside_menu_active', 'transport');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;
        
        //$data['vehicle_result']    = $this->db->get_where(db_prefix().'master_vehicle')->result();
        //$data['route_result']    = $this->db->get_where(db_prefix().'master_route')->result();
        $data['bodyclass'] = 'top-tabs kan-ban-body';
        $data['title']     = _l('Transports');
        $this->load->view('admin/transport/articles', $data);
    }

    /* Add new article or edit existing*/
    public function article($id = '')
    {
        if (!has_permission('transport', '', 'view')) {
            access_denied('transport');
        }
        if ($this->input->post()) {
            $data                = $this->input->post();
            
            if ($id == '') {
                if (!has_permission('transport', '', 'create')) {
                    access_denied('transport');
                }
                $id = $this->transport_model->add_article($data);
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('Transport')));
                    redirect(admin_url('transport'));
                }
            } else {
                if (!has_permission('transport', '', 'edit')) {
                    access_denied('transport');
                }
                
                $success = $this->transport_model->update_article($data, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('Transport')));
                }
                redirect(admin_url('transport'));
            }
        }
        if ($id == '') {
            $title = _l('add_new', _l('transport_lowercase'));
        } else {
            $article         = $this->transport_model->get($id);
           // echo '<pre>'; print_r($article); die;
            $data['article'] = $article;
            $title           = _l('edit', _l('Transport')) . ' ' . $article->subject;
        }
        $sheader_text = title_text('aside_menu_active', 'transport');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;

        $data['title']     = _l($sheader_text);
        $data['vehicle_result']    = $this->db->get_where(db_prefix().'master_vehicle')->result();
        $data['route_result']    = $this->db->get_where(db_prefix().'master_route')->result();
        $this->load->view('admin/transport/article', $data);
    }

    public function view($slug)
    {
        if (!has_permission('transport', '', 'view')) {
            access_denied('Transport');
        }

        $data['article'] = $this->transport_model->get(false, $slug);

        if (!$data['article']) {
            show_404();
        }

        $data['related_articles'] = $this->transport_model->get_related_articles($data['article']->articleid, false);

        add_views_tracking('transport', $data['article']->articleid);
        $data['title'] = $data['article']->subject;
        $this->load->view('admin/transport/view', $data);
    }

    public function add_kb_answer()
    {
        // This is for did you find this answer useful
        if (($this->input->post() && $this->input->is_ajax_request())) {
            echo json_encode($this->transport_model->add_article_answer($this->input->post('articleid'), $this->input->post('answer')));
            die();
        }
    }

    /* Change article active or inactive */
    public function change_article_status($id, $status)
    {
        if (has_permission('transport', '', 'edit')) {
            if ($this->input->is_ajax_request()) {
                $this->transport_model->change_article_status($id, $status);
            }
        }
    }

    public function update_kan_ban()
    {
        if (has_permission('transport', '', 'edit')) {
            if ($this->input->post()) {
                $success = $this->transport_model->update_kan_ban($this->input->post());
                $message = '';
                if ($success) {
                    $message = _l('updated_successfully', _l('Transport'));
                }
                echo json_encode([
                    'success' => $success,
                    'message' => $message,
                ]);
                die();
            }
        }
    }

    public function change_group_color()
    {
        if (has_permission('transport', '', 'edit')) {
            if ($this->input->post()) {
                $this->transport_model->change_group_color($this->input->post());
            }
        }
    }

    /* Delete article from database */
    public function delete_article($id)
    {
        if (!has_permission('transport', '', 'delete')) {
            access_denied('transport');
        }
        if (!$id) {
            redirect(admin_url('transport'));
        }
        $response = $this->transport_model->delete_article($id);
        if ($response == true) {
            set_alert('success', _l('deleted', _l('Transport')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('transport_lowercase')));
        }
        redirect(admin_url('transport'));
    }

    /* View all article groups */
    public function manage_groups()
    {
        if (!has_permission('transport', '', 'view')) {
            access_denied('transport');
        }
        $data['groups'] = $this->transport_model->get_kbg();
        $data['title']  = _l('als_kb_groups');
        $this->load->view('admin/transport/manage_groups', $data);
    }

    /* Add or edit existing article group */
    public function group($id = '')
    {
        if (!has_permission('transport', '', 'view')) {
            access_denied('transport');
        }
        if ($this->input->post()) {
            $post_data        = $this->input->post();
            $article_add_edit = isset($post_data['article_add_edit']);
            if (isset($post_data['article_add_edit'])) {
                unset($post_data['article_add_edit']);
            }
            if (!$this->input->post('id')) {
                if (!has_permission('transport', '', 'create')) {
                    access_denied('transport');
                }
                $id = $this->transport_model->add_group($post_data);
                if (!$article_add_edit && $id) {
                    set_alert('success', _l('added_successfully', _l('kb_dt_group_name')));
                } else {
                    echo json_encode([
                        'id'      => $id,
                        'success' => $id ? true : false,
                        'name'    => $post_data['name'],
                    ]);
                }
            } else {
                if (!has_permission('transport', '', 'edit')) {
                    access_denied('transport');
                }

                $id = $post_data['id'];
                unset($post_data['id']);
                $success = $this->transport_model->update_group($post_data, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('kb_dt_group_name')));
                }
            }
            die;
        }
    }

    /* Change group active or inactive */
    public function change_group_status($id, $status)
    {
        if (has_permission('transport', '', 'edit')) {
            if ($this->input->is_ajax_request()) {
                $this->transport_model->change_group_status($id, $status);
            }
        }
    }

    public function update_groups_order()
    {
        if (has_permission('transport', '', 'edit')) {
            if ($this->input->post()) {
                $this->transport_model->update_groups_order();
            }
        }
    }

    /* Delete article group */
    public function delete_group($id)
    {
        if (!has_permission('transport', '', 'delete')) {
            access_denied('transport');
        }
        if (!$id) {
            redirect(admin_url('transport/manage_groups'));
        }
        $response = $this->transport_model->delete_group($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('danger', _l('is_referenced', _l('kb_dt_group_name')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('kb_dt_group_name')));
        } else {
            set_alert('warning', _l('problem_deleting', mb_strtolower(_l('kb_dt_group_name'))));
        }
        redirect(admin_url('transport/manage_groups'));
    }

    public function get_article_by_id_ajax($id)
    {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->transport_model->get($id));
        }
    }
}
