<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Timetable extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('timetable_model');
    }

    /* Open also all taks if user access this /timetable url */
    public function index($id = '')
    {
        $this->list_timetable($id);
    }

    /* List all timetable */
    public function list_timetable($id = '')
    {
        close_setup_menu();
        // If passed from url
        $data['custom_view'] = $this->input->get('custom_view') ? $this->input->get('custom_view') : '';
        $data['taskid']      = $id;

        if ($this->input->get('kanban')) {
            $this->switch_kanban(0, true);
        }

        $data['switch_kanban'] = false;
        $data['bodyclass']     = 'timetable-page';

        if ($this->session->userdata('tasks_kanban_view') == 'true') {
            $data['switch_kanban'] = true;
            $data['bodyclass']     = 'tasks-page kan-ban-body';
        }
       
        $subheader_text = setupTitle_text('aside_menu_active', 'teacher_master', 'timetable');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;
         $data['heading_text'] = $subheader_text;
        $data['_text'] = $subheader_text;

        $data['title'] = _l($subheader_text);
        $this->load->view('admin/timetable/manage', $data);
    }

    public function table()
    {
        $this->app->get_table_data('timetable');
    }

  

    public function ajax_search_assign_task_to_timer()
    {
        if ($this->input->is_ajax_request()) {
            $q = $this->input->post('q');
            $q = trim($q);
            $this->db->select('name, id,' . tasks_rel_name_select_query() . ' as subtext');
            $this->db->from(db_prefix() . 'tasks');
            $this->db->where('' . db_prefix() . 'tasks.id IN (SELECT taskid FROM ' . db_prefix() . 'task_assigned WHERE staffid = ' . get_staff_user_id() . ')');
            //   $this->db->where('id NOT IN (SELECT task_id FROM '.db_prefix().'taskstimers WHERE staff_id = ' . get_staff_user_id() . ' AND end_time IS NULL)');
            $this->db->where('status != ', 5);
            $this->db->where('billed', 0);
            $this->db->group_start();
            $this->db->like('name', $q);
            $this->db->or_like(tasks_rel_name_select_query(), $q);
            $this->db->group_end();
            echo json_encode($this->db->get()->result_array());
        }
    }
 
    public function update_order()
    {
        $this->timetable_model->update_order($this->input->post());
    }

    
    public function init_relation_tasks($rel_id, $rel_type)
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('tasks_relations', [
                'rel_id'   => $rel_id,
                'rel_type' => $rel_type,
            ]);
        }
    }

    /* Add new task or update existing */
    public function task($id = '')
    {
        if (!has_permission('timetable', '', 'edit') && !has_permission('timetable', '', 'create')) {
            ajax_access_denied();
        }

        $data = [];
        /*
        if ($this->input->get('start_date')) {
            $data['start_date'] = $this->input->get('start_date');
        }
        */
        if ($this->input->post()) {
            $data                = $this->input->post();
            //$data['description'] = $this->input->post('description', false);
            //$data['file_url'] = @$this->input->post('file_url');
            if ($id == '') {
                /*if (!has_permission('timetable', '', 'create')) {
                    header('HTTP/1.0 400 Bad error');
                    echo json_encode([
                        'success' => false,
                        'message' => _l('access_denied'),
                    ]);
                    die;
                }*/
                $id      = $this->timetable_model->add($data);
                $_id     = false;
                $success = false;
                $message = '';
                if ($id) {
                    $success       = true;
                    $_id           = $id;
                    $message       = _l('added_successfully', _l('task'));
                    $uploadedFiles = handle_task_attachments_array($id);
                    if ($uploadedFiles && is_array($uploadedFiles)) {
                        foreach ($uploadedFiles as $file) {
                            $this->misc_model->add_attachment_to_database($id, 'timetable', [$file]);
                        }
                    }
                }
                echo json_encode([
                    'success' => $success,
                    'id'      => $_id,
                    'message' => $message,
                ]);
            } else {
                if (!has_permission('timetable', '', 'edit')) {
                    header('HTTP/1.0 400 Bad error');
                    echo json_encode([
                        'success' => false,
                        'message' => _l('access_denied'),
                    ]);
                    die;
                }
                $success = $this->timetable_model->update($data, $id);
                $message = '';
                if ($success) {
                    $message = _l('updated_successfully', _l('task'));
                }
                echo json_encode([
                    'success' => $success,
                    'message' => $message,
                    'id'      => $id,
                ]);
            }
            die;
        }

        $data['milestones']         = [];
        $header_text = title_text('aside_menu_active', 'timetable');
        $data['heading_text'] = $header_text;
        $data['checklistTemplates'] = $this->timetable_model->get_checklist_templates();
        if ($id == '') {
            $title = _l('add_new', _l($header_text));
        } else {
            $data['task'] = $this->timetable_model->get($id);
            
            if ($data['task']->rel_type == 'project') {
                $data['milestones'] = $this->projects_model->get_milestones($data['task']->rel_id);
            }
            $title = _l('edit', _l($header_text)) . ' ' . $data['task']->name;
        }
 
        $data['id']    = $id;
        $data['title'] = $title;
        $this->load->view('admin/timetable/task', $data);
    }
 

    
    /**
     * Task ajax request modal
     * @param  mixed $taskid
     * @return mixed
     */
    public function get_task_data($taskid, $return = false)
    {
        $timetable_where = [];

        if (!has_permission('timetable', '', 'view')) {
            $timetable_where = get_tasks_where_string(false);
        }

        $task = $this->timetable_model->get($taskid, $timetable_where);

        if (!$task) {
            header('HTTP/1.0 404 Not Found');
            echo 'Task not found';
            die();
        }

         $data['task']               = $task;
         
        if ($return == false) {
            $this->load->view('admin/timetable/view_task_template', $data);
        } else {
            return $this->load->view('admin/timetable/view_task_template', $data, true);
        }
    }

    

   

    public function download_files($task_id, $comment_id = null)
    {
        $taskWhere = 'external IS NULL';

        if ($comment_id) {
            $taskWhere .= ' AND task_comment_id=' . $this->db->escape_str($comment_id);
        }

        if (!has_permission('timetable', '', 'view')) {
            $taskWhere .= ' AND ' . get_tasks_where_string(false);
        }

        $files = $this->timetable_model->get_task_attachments($task_id, $taskWhere);

        if (count($files) == 0) {
            redirect($_SERVER['HTTP_REFERER']);
        }

        $path = get_upload_path_by_type('timetable') . $task_id;

        $this->load->library('zip');

        foreach ($files as $file) {
            $this->zip->read_file($path . '/' . $file['file_name']);
        }

        $this->zip->download('files.zip');
        $this->zip->clear_data();
    }

    

   
    /* Delete task from database */
    public function delete_timetable($id)
    {
        if (!has_permission('timetable', '', 'delete')) {
            access_denied('timetable');
        }
        $success = $this->timetable_model->delete_timetable($id);
        $message = _l('problem_deleting', _l('task_lowercase'));
        if ($success) {
            $message = _l('deleted', _l('task'));
            set_alert('success', $message);
        } else {
            set_alert('warning', $message);
        }

        if (strpos($_SERVER['HTTP_REFERER'], 'timetable/index') !== false || strpos($_SERVER['HTTP_REFERER'], 'timetable/view') !== false) {
            redirect(admin_url('timetable'));
        } elseif (preg_match("/projects\/view\/[1-9]+/", $_SERVER['HTTP_REFERER'])) {
            $project_url = explode('?', $_SERVER['HTTP_REFERER']);
            redirect($project_url[0] . '?group=project_tasks');
        } else {
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    /**
     * Remove task attachment
     * @since  Version 1.0.1
     * @param  mixed $id attachment it
     * @return json
     */
    public function remove_task_attachment($id)
    {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->timetable_model->remove_task_attachment($id));
        }
    }

    /**
     * Upload task attachment
     * @since  Version 1.0.1
     */
    public function upload_file()
    {
        if ($this->input->post()) {
            $taskid  = $this->input->post('taskid');
            $files   = handle_task_attachments_array($taskid, 'file');
            $success = false;

            if ($files) {
                $i   = 0;
                $len = count($files);
                foreach ($files as $file) {
                    $success = $this->timetable_model->add_attachment_to_database($taskid, [$file], false, ($i == $len - 1 ? true : false));
                    $i++;
                }
            }

            echo json_encode([
                'success'  => $success,
                'taskHtml' => $this->get_task_data($taskid, true),
            ]);
        }
    }

    
}
