<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Terms extends AdminController
{
    public function __construct()
    {
        parent::__construct();
    }

    /* Index function of Terms controller */
    public function index()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('terms');
        }
       
        $sheader_text = title_text('aside_menu_active', 'terms');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;        
        $data['title']   = _l($sheader_text);
        $data['trems_result'] = $this->db->get_where('tblterms')->result(); 
        $this->load->view('admin/terms/terms', $data);
    }

    public function table()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('terms');
        }
    }

    /* Add new article or edit existing*/
    public function add($id = '')
    {
        if ($this->input->post()) {
            $data                = $this->input->post();
            if ($id == '') {
                $collegeName = $this->db->get_where('tblterms', array('term_title' => $data['term_title']))->row('term_title');
                if($collegeName)
                {
                    set_alert('warning', _l($collegeName.' is already exists'));
                }
                else
                {
                    $postdata['term_year'] = $data['term_year'];
                    $postdata['term_title'] = $data['term_title'];
                    $postdata['created_date'] = date('Y-m-d H:i:s');
                    $postdata['updated_date'] = date('Y-m-d H:i:s');
                    $this->db->insert('tblterms', $postdata);
                    $id = $this->db->insert_id();
                    if ($id) {   
                        set_alert('success', _l('added_successfully', _l('Terms')));
                    }
                }                       
                redirect(admin_url('terms'));
            } else {
                $postdata['term_year'] = $data['term_year'];
                $postdata['term_title'] = $data['term_title'];
                $postdata['updated_date'] = date('Y-m-d H:i:s');
                $this->db->where('id', $id);
                $success = $this->db->update('tblterms',$postdata);   
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('Terms')));
                }
                redirect(admin_url('terms'));
            }
        }
        if ($id == '') {
            $title = _l('add_new', _l('Terms'));
            $data['title']     = _l('Terms');
        } else {
            $article         = $this->db->get_where('tblterms', array('id' => $id))->row();
            //echo '<pre>'; print_r($article); die;
            $data['article'] = $article;
            $data['title']     = _l('Terms');
        }
        $data['trems_result'] = $this->db->get_where('tblterms')->result(); 
        $sheader_text = setupTitle_text('aside_menu_active', 'terms');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;
        $data['title']     = _l($sheader_text);
        $this->load->view('admin/terms/terms', $data);
    }

    /**
    * @funciton: Status change
    */
    public function change_status($id, $status)
    {
        if ($this->input->is_ajax_request()) {
        
            $postdata['status'] = $status;
            $this->db->where('id', $id);
            $this->db->update(db_prefix().'terms', $postdata);
        }
    }

    /**
    *   @Function: Update colleges, image remove
    */
    public function delete_terms($id)
    {
        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'terms');
        if ($this->db->affected_rows() > 0) {
            set_alert('success', _l('deleted', _l('Terms')));
        } 
        redirect(admin_url('terms'));
    }
}
