<?php

defined('BASEPATH') or exit('No direct script access allowed');

class SubjectMaster extends AdminController
{
    /* List all subject master */
    public function index()
    {
        $this->load->model('subject_master_model');
        if (!has_permission('subject_', '', 'view')) {
            access_denied('subject_');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('master_subject');
        }
        
        $subheader_text = setupTitle_text('setup_menu_active', 'master', 'subject_');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;
        
        $data['title'] = _l($subheader_text);
        $this->load->view('admin/subjectMaster/manage', $data);
    }

    /* Add new role or edit existing one */
    public function role($id = '')
    {
        $this->load->model('subject_master_model');
        if (!has_permission('subject_', '', 'view')) {
            access_denied('subject_');
        }
        if ($this->input->post()) {
            if ($id == '') {
                if (!has_permission('subject_', '', 'create')) {
                    access_denied('subject_');
                }
                $id = $this->subject_master_model->add($this->input->post());
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('subject')));
                    redirect(admin_url('subjectMaster/role/' . $id));
                }
            } else {
                if (!has_permission('subject_', '', 'edit')) {
                    access_denied('subject_');
                }
                $success = $this->subject_master_model->update($this->input->post(), $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('subject')));
                }
                redirect(admin_url('subjectMaster/role/' . $id));
            }
        }
        
        $subheader_text = setupTitle_text('setup_menu_active', 'master', 'subject_');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;
        
        if ($id == '') {
            $title = _l('add_new', _l('subject'));
        } else {
            $role               = $this->subject_master_model->get($id);
            $data['role']       = $role;
            $title              = _l('edit', _l('subject')) . ' ' . $role->name;
        }
        
        $data['title'] = $subheader_text;
        $this->load->view('admin/subjectMaster/role', $data);
    }

    /* Delete role from database */
    public function delete($id)
    {
        $this->load->model('subject_master_model');
        if (!has_permission('subject_', '', 'delete')) {
            access_denied('subject_');
        }
        if (!$id) {
            redirect(admin_url('subjectMaster'));
        }
        $response = $this->subject_master_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('subject master')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('subject')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('subject master')));
        }
        redirect(admin_url('subjectMaster'));
    }
}
