<?php

defined('BASEPATH') or exit('No direct script access allowed');

class StudentMaster extends AdminController
{
    /* List all staff roles */
    public function index()
    {
        if (!has_permission('student_master', '', 'view')) {
            access_denied('student_master');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('students');
        }
        
        $sheader_text = title_text('setup_menu_active', 'student_master');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;

        $data['heading_text'] = $sheader_text;
        $this->load->view('admin/studentMaster/manage', $data);
    }
    
    /**
    *   @ Function: CSVformate
    *
    */
    public function exportformat()
    {
        $this->load->helper('download');
        $filepath = "./admin/studentMaster/import_student_sample_file.csv";
        $data     = file_get_contents($filepath);
        $name     = 'import_student_sample_file.csv';

        force_download($name, $data);
    }
    
    /**
    *   @function: Import
    */
    public function import()
    {
        $dbFields = $this->db->list_fields(db_prefix() . 'students');
        
        $this->load->library('import/import_customers', [], 'import');

        $this->import->setDatabaseFields($dbFields)->setCustomFields(get_custom_fields('students'));

        if ($this->input->post('download_sample') === 'true') {
            $this->import->downloadSample();
        }
        $fields = array('school_campus','admission_date','roll_no','academic_year','shift_timing', 'placeOfBirth', 'firstname', 'lastname', 'dob','gender','nationality', 'adhar_no','motherTongue','passportNo','father_email','languageSpokenHome','housenoBuildingName','category_id','mother_email','father_qualification','mother_qualification', 'guardian_qualification','father_organisation','mother_organisation','guardian_organisation','father_office_address','mother_office_address','guardian_residential_address','guardian_office_address','father_office_telephone','mother_office_telephone','guardian_office_telephone','father_office_email','mother_office_email','guardian_office_email','emergency_contact_address','emergency_contact_name','emergency_contact_number','emergency_contact_relationship','samagra_id','religion', 'cast', 'mobileno', 'email','blood_group', 'height', 'weight', 'measurement_date', 'father_name', 'father_phone', 'father_occupation', 'mother_name', 'mother_phone', 'mother_occupation', 'guardian_is', 'guardian_name', 'guardian_relation', 'guardian_email', 'guardian_phone', 'guardian_occupation', 'guardian_address', 'current_address', 'permanent_address', 'bank_account_no', 'bank_name', 'ifsc_code', 'rte', 'previous_school', 'image','father_pic','mother_pic','guardian_pic','note');

        if ($this->input->post())
        {
            $this->load->library('encoding_lib');
            $class_id   = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $school_campus = $this->input->post('school_campus');
            
            if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {
                $ext = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
                if ($ext == 'csv') {
                    $file = $_FILES['file']['tmp_name'];
                    $this->load->library('CSVReader');
                    $result = $this->csvreader->parse_file($file);
				//echo '<pre>'; print_r($result); die;
                    if (!empty($result)) {
                        $rowcount = 0;
                        for ($i = 1; $i <= count($result); $i++) {

                            $student_data[$i] = array();
                            $n                = 0;
                            foreach ($result[$i] as $key => $value) {
								if($n == 0)
								{
									/*$student_data[$i][$fields[$n]] = $school_campus;	*/
									$student_data[$i][$fields[$n]] = $this->encoding_lib->toUTF8($result[$i][$key]);
						 		}
								else{
									$student_data[$i][$fields[$n]] = $this->encoding_lib->toUTF8($result[$i][$key]);
									if($fields[$n]== 'dob'){
										 
										$student_data[$i][$fields[$n]] = date('Y-m-d',strtotime($this->encoding_lib->toUTF8($result[$i][$key])));
									}
									if($fields[$n]== 'measurement_date'){
										 
										$student_data[$i][$fields[$n]] = date('Y-m-d',strtotime($this->encoding_lib->toUTF8($result[$i][$key])));
									}
									if($fields[$n]== 'admission_date')
									{
										$student_data[$i][$fields[$n]] = date('Y-m-d',strtotime($this->encoding_lib->toUTF8($result[$i][$key])));										
									}
									
								}
								$admission_no = 'TheISB';
								$last_student         = 1;
								$last_admission_digit = $admission_no.'1';
                                $last_admission_digit_ = $last_admission_digit + 1;
                                if($fields[$n]== 'image')
								{
									$url_array = explode('/',$this->encoding_lib->toUTF8($result[$i][$key]));
									$image_name = end($url_array);
									$image_array = explode(".",$image_name);
									$ext = end($image_array);
									$image_data = file_get_contents($this->encoding_lib->toUTF8($result[$i][$key]));
									$new_image_path = "uploads/clients/".$last_admission_digit_.".".$ext;
									file_put_contents($new_image_path, $image_data);
									$student_data[$i][$fields[$n]] = $new_image_path;
								}
                                if($fields[$n]== 'father_pic')
								{
								    $url_array_father = explode('/',$this->encoding_lib->toUTF8($result[$i][$key]));
                                    $image_name_father = end($url_array_father);
                                    $image_array_father = explode(".",$image_name_father);
                                    $ext_father = end($image_array_father);
                                    $image_data_father = file_get_contents($this->encoding_lib->toUTF8($result[$i][$key]));
                                    $new_image_path_father = "uploads/clients/".$last_admission_digit_."father.".$ext_father;
                                    file_put_contents($new_image_path_father, $image_data_father);
                                    $student_data[$i][$fields[$n]] = $new_image_path_father;
								}
								if($fields[$n]== 'mother_pic')
								{
								    $url_array_mother = explode('/',$this->encoding_lib->toUTF8($result[$i][$key]));
                                    $image_name_mother = end($url_array_mother);
                                    $image_array_mother = explode(".",$image_name_mother);
                                    $ext_mother = end($image_array_mother);
                                    $image_data_mother = file_get_contents($this->encoding_lib->toUTF8($result[$i][$key]));
                                    $new_image_path_mother = "uploads/clients/".$last_admission_digit_."mother.".$ext_mother;
                                    file_put_contents($new_image_path_mother, $image_data_mother);
                                    $student_data[$i][$fields[$n]] = $new_image_path_mother;
								}
								if($fields[$n]== 'guardian_pic')
								{
								    $url_array_guardian = explode('/',$this->encoding_lib->toUTF8($result[$i][$key]));
                                $image_name_guardian = end($url_array_guardian);
                                $image_array_guardian = explode(".",$image_name_guardian);
                                $ext_guardian = end($image_array_guardian);
                                $image_data_guardian = file_get_contents($this->encoding_lib->toUTF8($result[$i][$key]));
                                $new_image_path_guardian = "uploads/clients/".$last_admission_digit_."guardian.".$ext_guardian;
                                file_put_contents($new_image_path_guardian, $image_data_guardian);
                                $student_data[$i][$fields[$n]] = $new_image_path_guardian;
								}
								//$admission_no         = $this->sch_setting_detail->adm_prefix . sprintf("%0" . $this->sch_setting_detail->adm_no_digit . "d", $last_admission_digit + 1);
								
								$student_data[$i]['admission_no'] = rand();
								$student_data[$i]['application_number'] = rand();

                                $student_data[$i]['is_active'] = 'yes';
                                $n++;
                                //echo '<pre>'; print_r($student_data[$i]); die;
                                $this->db->insert(db_prefix() . 'students', $student_data[$i]);
                            }
                        }
                    } else {
                        set_alert('error', _l('no_record_found'));
                    }
                } else {
                    set_alert('error', _l('please_upload_CSV_file_onlyl'));
                }
                set_alert('success', _l('import total imported successful'));
            }
        }

        $sheader_text = title_text('setup_menu_active', 'student_master');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;
        $data['title']     = _l($sheader_text);
        $this->load->view('admin/studentMaster/import', $data);
    }
    
    public function table()
    {
        $this->app->get_table_data('students');
    }
}
