<?php

defined('BASEPATH') or exit('No direct script access allowed');

class SchoolFees extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('schoolfees_model');
    }

    /* List all knowledgebase articles */
    public function index()
    {
        if (!has_permission('schoolfees', '', 'view')) {
            access_denied('schoolfees');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('school_fees');
        }
       
        $subheader_text = setupTitle_text('setup_menu_active', 'master', 'schoolfees');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;
        
        $data['bodyclass'] = 'top-tabs kan-ban-body';
        $data['title']     = _l($subheader_text);
        $this->load->view('admin/schoolfees/articles', $data);
    }

    /* Add new article or edit existing*/
    public function add($id = '')
    {
        if (!has_permission('schoolfees', '', 'view')) {
            access_denied('schoolfees');
        }
        if ($this->input->post()) {
            $data                = $this->input->post();
            
            if ($id == '') {
                if (!has_permission('schoolfees', '', 'create')) {
                    access_denied('schoolfees');
                }
                $id = $this->schoolfees_model->add_article($data);
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('schoolfees')));
                    redirect(admin_url('schoolFees'));
                }
            } else {
                if (!has_permission('schoolfees', '', 'edit')) {
                    access_denied('schoolfees');
                }
                
                $success = $this->schoolfees_model->update_article($data, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('schoolfees')));
                }
                redirect(admin_url('schoolFees'));
            }
        }
        if ($id == '') {
            $title = _l('add_new', _l('schoolfees'));
        } else {
            $article         = $this->schoolfees_model->get($id);
           // echo '<pre>'; print_r($article); die;
            $data['article'] = $article;
            $title           = _l('edit', _l('schoolfees')) . ' ' . $article->subject;
        }
        $subheader_text = setupTitle_text('setup_menu_active', 'master', 'schoolfees');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;

        $data['title']     = _l($subheader_text);
        $this->load->view('admin/schoolfees/article', $data);
    }

    public function save() {
        // If file uploaded
        if(is_uploaded_file($_FILES['fileURL']['tmp_name'])) {                            
            // Parse data from CSV file
            $csvData = $this->csvreader->parse_csv($_FILES['fileURL']['tmp_name']);       
            //echo '<pre>'; print_r($csvData); die;
            // create array from CSV file
           if(!empty($csvData)){
                foreach($csvData as $element){                    
                    // Prepare data for Database insertion
                    $data = array(
                        'name' => $element['Name'],
                        'mobile_one' => $element['Mobile First'],
                        'mobile_second' => $element['Mobile Second'],
                        'address' => $element['Address'],
                        'from_company' => $element['From Company'],
                        'from_vendore' => $element['From Vendor'],
                    );
                    //echo '<pre>'; print_r($data); die;
                    $this->db->insert(db_prefix() . 'master_schoolfees_reminder', $data);
                    $data[] = '';
                }
                set_alert('success', _l('Data are stored successful!'));
            }
            else
            {
                set_alert('warning', _l('File is required'));
            }
        }
        else
        {
            set_alert('warning', _l('File is required'));
        } 
        redirect(admin_url('schoolFees'));
    }
    
    // export Data
    public function sampledata() {
        $storData = array();
        $data[] = array('name' => 'Name', 'mobile_one' => 'Mobile First', 'mobile_second' => 'Mobile Second', 'address' => 'Address', 'from_company' => 'From Company', 'from_vendore' => 'From Vendor');       
        
        header("Content-type: application/csv");
        header("Content-Disposition: attachment; filename=\"csv-sample-customer".".csv\"");
        header("Pragma: no-cache");
        header("Expires: 0");
        $handle = fopen('php://output', 'w');
        foreach ($data as $data) {
            fputcsv($handle, $data);
        }
            fclose($handle);
        exit;
    }

    /* Delete article from database */
    public function delete_schoolFees($id)
    {
        if (!has_permission('schoolfees', '', 'delete')) {
            access_denied('schoolfees');
        }
        if (!$id) {
            redirect(admin_url('schoolFees'));
        }
        $response = $this->schoolfees_model->delete_article($id);
        if ($response == true) {
            set_alert('success', _l('deleted', _l('schoolfees')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('schoolfees')));
        }
        redirect(admin_url('schoolFees'));
    }
}
