<?php

defined('BASEPATH') or exit('No direct script access allowed');

class RouteMaster extends AdminController
{
    /* List all Route master */
    public function index()
    {
        $this->load->model('route_master_model');
        if (!has_permission('route_master', '', 'view')) {
            access_denied('route_master');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('master_route');
        }
        
        $subheader_text = setupTitle_text('setup_menu_active', 'master', 'route_master');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;
        
        $data['title'] = _l($subheader_text);
        $this->load->view('admin/routeMaster/manage', $data);
    }

    /* Add new role or edit existing one */
    public function role($id = '')
    {
        $this->load->model('route_master_model');
        if (!has_permission('route_master', '', 'view')) {
            access_denied('route_master');
        }
        if ($this->input->post()) {
            if ($id == '') {
                if (!has_permission('route_master', '', 'create')) {
                    access_denied('route_master');
                }
                $id = $this->route_master_model->add($this->input->post());
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('Route')));
                    redirect(admin_url('routeMaster'));
                }
            } else {
                if (!has_permission('route_master', '', 'edit')) {
                    access_denied('route_master');
                }
                $success = $this->route_master_model->update($this->input->post(), $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('Route')));
                }
                redirect(admin_url('routeMaster'));
            }
        }
        
        $subheader_text = setupTitle_text('setup_menu_active', 'master', 'route_master');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;
        
        if ($id == '') {
            $title = _l('add_new', _l('Route'));
        } else {
            $role               = $this->route_master_model->get($id);
            $data['role']       = $role;
            $title              = _l('edit', _l('Route')) . ' ' . $role->name;
        }
        
        $data['title'] = $subheader_text;
        $this->load->view('admin/routeMaster/role', $data);
    }

    /* Delete role from database */
    public function delete($id)
    {
        $this->load->model('route_master_model');
        if (!has_permission('route_master', '', 'delete')) {
            access_denied('route_master');
        }
        if (!$id) {
            redirect(admin_url('routeMaster'));
        }
        $response = $this->route_master_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('Route master')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('Route')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('Route master')));
        }
        redirect(admin_url('routeMaster'));
    }
}
