<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Results extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        //$this->load->model('results_model');
    }

    /* List all knowledgebase articles */
    public function index()
    {
        /*
        if (!has_permission('results', '', 'view')) {
            access_denied('results');
        }
        */
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('results');
        }
       
        $sheader_text = title_text('aside_menu_active', 'results');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;
        
        $data['title']     = _l($sheader_text);
        $data['class_list'] = $this->db->get_where(db_prefix().'master_class')->result();
        $this->load->view('admin/results/results', $data);
    }
    
    /**
    *   Function: classList
    */
    public function studentList($classname)
    {
        if($classname)
        {
            $classname_ = str_replace('_',' ',$classname);
            $data['classname'] = $classname_;
            $_SESSION['_classname'] = $classname_;
            
            if ($this->input->is_ajax_request()) {
                $this->app->get_table_data('result_studentlist');
            }
            
            if($classname_ == 'Playgroup')
            {
                $total_student = $this->db->get_where(db_prefix().'contacts', array('Class' => $classname_))->num_rows();
                $total_student_ = $this->db->get_where(db_prefix().'contacts', array('Class' => 'PG'))->num_rows();
                $data['total_student'] = $total_student + $total_student_;
                
                $total_activestudent = $this->db->select('userid')->get_where(db_prefix().'contacts', array('Class' => $classname_))->result();
                $studentid = [];
                if($total_activestudent)
                {
                    foreach($total_activestudent as $r)
                    {
                        array_push($studentid, $r->userid);
                    }
                }
                
    			$this->db->select('id');
    			$this->db->from(db_prefix().'student_result');
    			$this->db->group_by('student_id');
    			$this->db->where_in('student_id',$studentid);
    			$completeres = $this->db->get()->num_rows();
    			$data['pending_result'] = $data['total_student'] - $completeres;
                $data['completed_result'] = $completeres;
            }
            else
            {
                $total_activestudent = $this->db->select('userid')->get_where(db_prefix().'contacts', array('Class' => $classname_))->result();
                $studentid = [];
                if($total_activestudent)
                {
                    foreach($total_activestudent as $r)
                    {
                        array_push($studentid, $r->userid);
                    }
                }
                
    			$this->db->select('id');
    			$this->db->from(db_prefix().'student_result');
    			$this->db->group_by('student_id');
    			$this->db->where_in('student_id',$studentid);
    			$completeres = $this->db->get()->num_rows();
    			
                $data['total_student'] = $this->db->get_where(db_prefix().'contacts', array('Class' => $classname_))->num_rows();
                $data['pending_result'] = $data['total_student'] - $completeres;
                $data['completed_result'] = $completeres;
            }
            
            $data['class_list'] = $this->db->get_where(db_prefix().'master_class')->result();
            $header_text = title_text('aside_menu_active', 'results');
            $data['heading_text'] = $header_text;
            $data['title']          = _l($header_text);
            $this->load->view('admin/results/result_studentlist', $data);
        }
        else
        {
            set_alert('error', _l('Class not found'));
            redirect(admin_url('results'));
        }
    }
    
    /**
    *   Function: getSubjectList
    **/
    public function getSubjectList()
    {
        $classid = $_POST['cid'];
        $uid = $_POST['uid'];
        $rid = $_POST['rid'];
        $html = '';
        if($rid > 0)
        {
            //$data['exresult'] = $this->db->get_where(db_prefix().'suject_result', array('result_id' => $rid))->result();
            $data['editTerm_result'] = $this->db->get_where(db_prefix().'student_result', array('id' => $rid))->row();
            $exam_id = $data['editTerm_result']->exam_id;
        }
        else
        {
            //$data['exresult'] = ''; 
            $data['editTerm_result'] = '';
            $exam_id = '';
        }
    
        if($classid)
        {
            $data['uid'] = $uid;
            $data['rid'] = $rid;
            $data['exam_id'] = $exam_id;
            $data['classid'] = $classid;
            $data['grad_list'] = $this->db->order_by('name','asc')->get_where(db_prefix().'result_grade')->result();
            $data['subjectlist'] = $this->db->order_by('subject_id', 'desc')->get_where(db_prefix().'master_subject', array('class_id' => $classid))->result(); 
            $html = $this->load->view('admin/results/subjectlist', $data, true);
        }
        echo $html;
    }
    
    /**
    *   @Function: Get Assessment Result
    **/
    public function getAssessmentResult_()
    {
        $classid = $_POST['cid'];
        $uid = $_POST['uid'];
        $rid = $_POST['rid'];
        $aid = $_POST['aid'];
        $exam_id = '';
        $html = '';
        if($aid)
        {
            //$data['exresult'] = $this->db->get_where(db_prefix().'suject_result', array('result_id' => $rid))->result();
            $data['editTerm_result'] = $this->db->get_where(db_prefix().'student_result', array('class_id' => $classid, 'student_id' => $uid, 'exam_id' => $aid))->row();
            $rid = $data['editTerm_result']->id;
        }
        else
        {
            //$data['exresult'] = ''; 
            $data['editTerm_result'] = '';
            $rid = '';
        }
    
        if($classid)
        {
            $data['uid'] = $uid;
            $data['rid'] = $rid;
            $data['exam_id'] = $aid;
            $data['classid'] = $classid;
            $data['grad_list'] = $this->db->order_by('name','asc')->get_where(db_prefix().'result_grade')->result();
            $data['subjectlist'] = $this->db->order_by('subject_id', 'desc')->get_where(db_prefix().'master_subject', array('class_id' => $classid))->result(); 
            $html = $this->load->view('admin/results/subjectlist', $data, true);
        }
        echo $html;
    }
    
    /**
    *   @Function: studentres
    */
    public function studentres()
    {
        $data = $this->input->post();
        $rid_  = $data['rid'];
        $resultdata['class_id'] = $data['class_id'];
        $resultdata['student_id'] = $data['student_id'];
        $resultdata['exam_id'] = $data['exam_id'];
        
        $rid = $this->db->get_where(db_prefix().'student_result', array('class_id' => $data['class_id'], 'student_id' => $data['student_id'], 'exam_id' => $data['exam_id']))->row('id');
        
        if($rid > 0)
        {
            $this->db->delete(db_prefix().'suject_result', array('result_id' => $rid));
            $subjectarr = $data['subject_id'];
            $gradarr   = $data['grad_id'];
            $subcount = count($data['subject_id']);
            for($i = 0; $i < $subcount; $i++)
            {
                $postdata['student_id']  = $data['student_id']; 
                $postdata['result_id']   = $rid; 
                $postdata['subject_id']  = $subjectarr[$i]; 
                $postdata['grad_id']     = $gradarr[$i]; 
                
                $this->db->insert(db_prefix().'suject_result', $postdata);
            }
            set_alert('success', _l('Result are updated successfully'));
        }
        else
        {
            $this->db->insert(db_prefix().'student_result', $resultdata);
            $resultid = $this->db->insert_id();
            if($resultid)
            {
                $subjectarr = $data['subject_id'];
                $gradarr   = $data['grad_id'];
                $subcount = count($data['subject_id']);
                for($i = 0; $i < $subcount; $i++)
                {
                    $postdata['student_id']  = $data['student_id']; 
                    $postdata['result_id']   = $resultid; 
                    $postdata['subject_id']  = $subjectarr[$i]; 
                    $postdata['grad_id']     = $gradarr[$i]; 
                    
                    $this->db->insert(db_prefix().'suject_result', $postdata);
                }
                set_alert('success', _l('Result are created successfully'));
            }
        }
            
        $_classname = str_replace(' ','_',$_SESSION['_classname']);
        redirect(admin_url('results/studentList/'.$_classname));
    }
}
