<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Remark extends AdminController
{
    public function __construct()
    {
        parent::__construct();
    }

    /* Index function of remark controller */
    public function index()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('remark');
        }
       
        $sheader_text = title_text('aside_menu_active', 'remark');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;        
        $data['title']   = _l($sheader_text);
        $data['trems_result'] = $this->db->get_where('tblmaster_remark')->result(); 
        $this->load->view('admin/remark/remark', $data);
    }

    public function table()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('remark');
        }
    }

    /* Add new article or edit existing */
    public function add($id = '')
    {
        if ($this->input->post()) {
            $data                = $this->input->post();
            if ($id == '') {
                $collegeName = $this->db->get_where('tblmaster_remark', array('description' => $data['description'], 'type' => 2, 'gender' => 'Female'))->row('description');
                if($collegeName)
                {
                    set_alert('danger', _l($collegeName.' is already exists'));
                }
                else
                {
                    $postdata['description'] = $data['description'];
                    $postdata['gender'] = 'Female';
                    $postdata['type'] = 2;
                    $postdata['created_date'] = date('Y-m-d H:i:s');
                    $postdata['updated_date'] = date('Y-m-d H:i:s');
                    $this->db->insert('tblmaster_remark', $postdata);
                    $id = $this->db->insert_id();
                    if ($id) {   
                        set_alert('success', _l('added_successfully', _l('Remark')));
                    }
                }                       
                redirect(admin_url('remark'));
            } else {
                $postdata['description'] = $data['description'];
                $this->db->where('id', $id);
                $success = $this->db->update('tblmaster_remark',$postdata);   
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('Remark')));
                }
                redirect(admin_url('remark'));
            }
        }
        if ($id == '') {
            $title = _l('add_new', _l('Remark'));
            $data['title']     = _l('Remark');
        } else {
            $article         = $this->db->get_where('tblmaster_remark', array('id' => $id))->row();
            //echo '<pre>'; print_r($article); die;
            $data['article'] = $article;
            $data['title']     = _l('Remark');
        }
        $data['trems_result'] = $this->db->get_where('tblmaster_remark')->result(); 
        $sheader_text = setupTitle_text('aside_menu_active', 'remark');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;
        $data['title']     = _l($sheader_text);
        $this->load->view('admin/remark/remark', $data);
    }

    /**
    * @funciton: Status change
    */
    public function change_status($id, $status)
    {
        if ($this->input->is_ajax_request()) {
        
            $postdata['status'] = $status;
            $this->db->where('id', $id);
            $this->db->update(db_prefix().'master_remark', $postdata);
        }
    }

    /**
    *   @Function: Update colleges, image remove
    */
    public function delete_remark($id)
    {
        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'master_remark');
        if ($this->db->affected_rows() > 0) {
            set_alert('success', _l('deleted', _l('Remark')));
        } 
        redirect(admin_url('remark'));
    }
}
