<?php

defined('BASEPATH') or exit('No direct script access allowed');

class PostMaster extends AdminController
{
    /* List all staff post_master */
    public function index()
    {
        $this->load->model('post_master_model');
        if (!has_permission('post_master', '', 'view')) {
            access_denied('post_master');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('master_post');
        }
        
        $sheader_text = title_text('setup_menu_active', 'post_master');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;
        
        $data['title'] = _l($sheader_text);
        $this->load->view('admin/postMaster/manage', $data);
    }

    /* Add new role or edit existing one */
    public function role($id = '')
    {
        $this->load->model('post_master_model');
        if (!has_permission('post_master', '', 'view')) {
            access_denied('post_master');
        }
        if ($this->input->post()) {
            if ($id == '') {
                if (!has_permission('post_master', '', 'create')) {
                    access_denied('post_master');
                }
                $id = $this->post_master_model->add($this->input->post());
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('post')));
                    redirect(admin_url('postMaster/role/' . $id));
                }
            } else {
                if (!has_permission('post_master', '', 'edit')) {
                    access_denied('post_master');
                }
                $success = $this->post_master_model->update($this->input->post(), $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('post')));
                }
                redirect(admin_url('postMaster/role/' . $id));
            }
        }
        
        $sheader_text = title_text('setup_menu_active', 'post_master');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;
        
        if ($id == '') {
            $title = _l('add_new', _l('post'));
        } else {
            //$data['role_staff'] = $this->post_master_model->get_role_staff($id);
            $role               = $this->post_master_model->get($id);
            $data['role']       = $role;
            $title              = _l('edit', _l('post')) . ' ' . $role->name;
        }
        
        $data['title'] = $sheader_text;
        $this->load->view('admin/postMaster/role', $data);
    }

    /* Delete role from database */
    public function delete($id)
    {
        $this->load->model('post_master_model');
        if (!has_permission('post_master', '', 'delete')) {
            access_denied('post_master');
        }
        if (!$id) {
            redirect(admin_url('postMaster'));
        }
        $response = $this->post_master_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('post master')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('post')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('post master')));
        }
        redirect(admin_url('postMaster'));
    }
}
