<?php

defined('BASEPATH') or exit('No direct script access allowed');

class PhoneCallLog extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('phonecalllog_model');
         $this->load->library('form_validation');
        // load CSV library
        $this->load->library('CSVReader');
        // Load file helper
        $this->load->helper('file');
    }

    /* List all knowledgebase articles */
    public function index()
    {
        if (!has_permission('phonecalllog', '', 'view')) {
            access_denied('phonecalllog');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('phonecalllog');
        }
       
        $sheader_text = title_text('aside_menu_active', 'phonecalllog');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;
        
        $data['bodyclass'] = 'top-tabs kan-ban-body';
        $data['title']     = _l($sheader_text);
        $this->load->view('admin/phonecalllog/articles', $data);
    }

    /* Add new article or edit existing*/
    public function add($id = '')
    {
        if (!has_permission('phonecalllog', '', 'view')) {
            access_denied('phonecalllog');
        }
        if ($this->input->post()) {
            $data                = $this->input->post();
            
            if ($id == '') {
                if (!has_permission('phonecalllog', '', 'create')) {
                    access_denied('phonecalllog');
                }
                $id = $this->phonecalllog_model->add_article($data);
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('phonecalllog')));
                    redirect(admin_url('phoneCallLog'));
                }
            } else {
                if (!has_permission('phonecalllog', '', 'edit')) {
                    access_denied('phonecalllog');
                }
                
                $success = $this->phonecalllog_model->update_article($data, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('phonecalllog')));
                }
                redirect(admin_url('phoneCallLog'));
            }
        }
        if ($id == '') {
            $title = _l('add_new', _l('Phone Call Logs'));
        } else {
            $article         = $this->phonecalllog_model->get($id);
           // echo '<pre>'; print_r($article); die;
            $data['article'] = $article;
            $title           = _l('edit', _l('Phone Call Logs')) . ' ' . $article->subject;
        }
        $sheader_text = title_text('aside_menu_active', 'Phone Call Logs');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;

        $data['title']     = _l($sheader_text);
        $this->load->view('admin/phonecalllog/article', $data);
    }

    public function save() {
        // If file uploaded
        if(is_uploaded_file($_FILES['fileURL']['tmp_name'])) {                            
            // Parse data from CSV file
            $csvData = $this->csvreader->parse_csv($_FILES['fileURL']['tmp_name']);       
            //echo '<pre>'; print_r($csvData); die;
            // create array from CSV file
           if(!empty($csvData)){
                foreach($csvData as $element){                    
                    // Prepare data for Database insertion
                    $data = array(
                        'name' => $element['Name'],
                        'mobile_one' => $element['Mobile First'],
                        'mobile_second' => $element['Mobile Second'],
                        'address' => $element['Address'],
                        'from_company' => $element['From Company'],
                        'from_vendore' => $element['From Vendor'],
                    );
                    //echo '<pre>'; print_r($data); die;
                    $this->db->insert(db_prefix() . 'master_phonecalllog', $data);
                    $data[] = '';
                }
                set_alert('success', _l('Data are stored successful!'));
            }
            else
            {
                set_alert('warning', _l('File is required'));
            }
        }
        else
        {
            set_alert('warning', _l('File is required'));
        } 
        redirect(admin_url('phoneCallLog'));
    }
    
    // export Data
    public function sampledata() {
        $storData = array();
        $data[] = array('name' => 'Name', 'mobile_one' => 'Mobile First', 'mobile_second' => 'Mobile Second', 'address' => 'Address', 'from_company' => 'From Company', 'from_vendore' => 'From Vendor');       
        
        header("Content-type: application/csv");
        header("Content-Disposition: attachment; filename=\"csv-sample-customer".".csv\"");
        header("Pragma: no-cache");
        header("Expires: 0");
        $handle = fopen('php://output', 'w');
        foreach ($data as $data) {
            fputcsv($handle, $data);
        }
            fclose($handle);
        exit;
    }

    public function view($slug)
    {
        if (!has_permission('phonecalllog', '', 'view')) {
            access_denied('phonecalllog');
        }

        $data['article'] = $this->phonecalllog_model->get(false, $slug);

        if (!$data['article']) {
            show_404();
        }

        $data['related_articles'] = $this->phonecalllog_model->get_related_articles($data['article']->articleid, false);

        add_views_tracking('phonecalllog', $data['article']->articleid);
        $data['title'] = $data['article']->subject;
        $this->load->view('admin/phonecalllog/view', $data);
    }

    public function add_kb_answer()
    {
        // This is for did you find this answer useful
        if (($this->input->post() && $this->input->is_ajax_request())) {
            echo json_encode($this->phonecalllog_model->add_article_answer($this->input->post('articleid'), $this->input->post('answer')));
            die();
        }
    }

    /* Change article active or inactive */
    public function change_article_status($id, $status)
    {
        if (has_permission('phonecalllog', '', 'edit')) {
            if ($this->input->is_ajax_request()) {
                $this->phonecalllog_model->change_article_status($id, $status);
            }
        }
    }

    public function update_kan_ban()
    {
        if (has_permission('phonecalllog', '', 'edit')) {
            if ($this->input->post()) {
                $success = $this->phonecalllog_model->update_kan_ban($this->input->post());
                $message = '';
                if ($success) {
                    $message = _l('updated_successfully', _l('Phone Call Logs'));
                }
                echo json_encode([
                    'success' => $success,
                    'message' => $message,
                ]);
                die();
            }
        }
    }

    public function change_group_color()
    {
        if (has_permission('phonecalllog', '', 'edit')) {
            if ($this->input->post()) {
                $this->phonecalllog_model->change_group_color($this->input->post());
            }
        }
    }

    /* Delete article from database */
    public function delete_calllog($id)
    {
        if (!has_permission('phonecalllog', '', 'delete')) {
            access_denied('phonecalllog');
        }
        if (!$id) {
            redirect(admin_url('phoneCallLog'));
        }
        $response = $this->phonecalllog_model->delete_article($id);
        if ($response == true) {
            set_alert('success', _l('deleted', _l('phonecalllog')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('phonecalllog_lowercase')));
        }
        redirect(admin_url('phoneCallLog'));
    }

    /* View all article groups */
    public function manage_groups()
    {
        if (!has_permission('phonecalllog', '', 'view')) {
            access_denied('phonecalllog');
        }
        $data['groups'] = $this->phonecalllog_model->get_kbg();
        $data['title']  = _l('als_kb_groups');
        $this->load->view('admin/phonecalllog/manage_groups', $data);
    }

    /* Add or edit existing article group */
    public function group($id = '')
    {
        if (!has_permission('phonecalllog', '', 'view')) {
            access_denied('phonecalllog');
        }
        if ($this->input->post()) {
            $post_data        = $this->input->post();
            $article_add_edit = isset($post_data['article_add_edit']);
            if (isset($post_data['article_add_edit'])) {
                unset($post_data['article_add_edit']);
            }
            if (!$this->input->post('id')) {
                if (!has_permission('phonecalllog', '', 'create')) {
                    access_denied('phonecalllog');
                }
                $id = $this->phonecalllog_model->add_group($post_data);
                if (!$article_add_edit && $id) {
                    set_alert('success', _l('added_successfully', _l('kb_dt_group_name')));
                } else {
                    echo json_encode([
                        'id'      => $id,
                        'success' => $id ? true : false,
                        'name'    => $post_data['name'],
                    ]);
                }
            } else {
                if (!has_permission('phonecalllog', '', 'edit')) {
                    access_denied('phonecalllog');
                }

                $id = $post_data['id'];
                unset($post_data['id']);
                $success = $this->phonecalllog_model->update_group($post_data, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('kb_dt_group_name')));
                }
            }
            die;
        }
    }

    /* Change group active or inactive */
    public function change_group_status($id, $status)
    {
        if (has_permission('phonecalllog', '', 'edit')) {
            if ($this->input->is_ajax_request()) {
                $this->phonecalllog_model->change_group_status($id, $status);
            }
        }
    }

    public function update_groups_order()
    {
        if (has_permission('phonecalllog', '', 'edit')) {
            if ($this->input->post()) {
                $this->phonecalllog_model->update_groups_order();
            }
        }
    }

    /* Delete article group */
    public function delete_group($id)
    {
        if (!has_permission('phonecalllog', '', 'delete')) {
            access_denied('phonecalllog');
        }
        if (!$id) {
            redirect(admin_url('phonecalllog/manage_groups'));
        }
        $response = $this->phonecalllog_model->delete_group($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('danger', _l('is_referenced', _l('kb_dt_group_name')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('kb_dt_group_name')));
        } else {
            set_alert('warning', _l('problem_deleting', mb_strtolower(_l('kb_dt_group_name'))));
        }
        redirect(admin_url('phonecalllog/manage_groups'));
    }

    public function get_article_by_id_ajax($id)
    {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->phonecalllog_model->get($id));
        }
    }
}
