<?php

defined('BASEPATH') or exit('No direct script access allowed');

class PaymentType extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('paymenttype_model');
    }

    /* List all paymenttype articles */
    public function index()
    {
        if (!has_permission('payment_type', '', 'view')) {
            access_denied('payment_type');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('payment_type');
        }
       /*
        $sheader_text = title_text('setup_menu_active', 'payment_type');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;
        */
        
        $subheader_text = setupTitle_text('setup_menu_active', 'master', 'payment_type');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;
        
        //$data['vehicle_result']    = $this->db->get_where(db_prefix().'master_vehicle')->result();
        //$data['route_result']    = $this->db->get_where(db_prefix().'master_route')->result();
        $data['bodyclass'] = 'top-tabs kan-ban-body';
        $data['title']     = _l($subheader_text);
        $this->load->view('admin/paymentType/articles', $data);
    }

    /* Add new article or edit existing*/
    public function add($id = '')
    {
        if (!has_permission('payment_type', '', 'view')) {
            access_denied('payment_type');
        }
        if ($this->input->post()) {
            $data                = $this->input->post();
            
            if ($id == '') {
                if (!has_permission('payment_type', '', 'create')) {
                    access_denied('payment_type');
                }
                $id = $this->paymenttype_model->add_article($data);
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('Package')));
                    redirect(admin_url('paymentType'));
                }
            } else {
                if (!has_permission('payment_type', '', 'edit')) {
                    access_denied('payment_type');
                }
                
                $success = $this->paymenttype_model->update_article($data, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('Package')));
                }
                redirect(admin_url('paymentType'));
            }
        }
        if ($id == '') {
            $title = _l('add_new', _l('Package'));
        } else {
            $article         = $this->paymenttype_model->get($id);
           // echo '<pre>'; print_r($article); die;
            $data['article'] = $article;
            $title           = _l('edit', _l('Package')) . ' ' . $article->subject;
        }
        /*
        $sheader_text = title_text('setup_menu_active', 'payment_type');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;
        */
        
        $subheader_text = setupTitle_text('setup_menu_active', 'master', 'payment_type');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;

        $data['title']     = _l($subheader_text);
        $data['paymenttype_result']    = $this->db->get_where(db_prefix().'payment_type')->result();
        $data['class_result']    = $this->db->order_by('class_id', 'desc')->get_where(db_prefix().'master_class')->result();
        $this->load->view('admin/paymentType/article', $data);
    }

    public function view($slug)
    {
        if (!has_permission('payment_type', '', 'view')) {
            access_denied('payment_type');
        }

        $data['article'] = $this->paymenttype_model->get(false, $slug);

        if (!$data['article']) {
            show_404();
        }

        $data['related_articles'] = $this->paymenttype_model->get_related_articles($data['article']->articleid, false);

        add_views_tracking('payment_type', $data['article']->articleid);
        $data['title'] = $data['article']->subject;
        $this->load->view('admin/paymentType/view', $data);
    }

    public function add_kb_answer()
    {
        // This is for did you find this answer useful
        if (($this->input->post() && $this->input->is_ajax_request())) {
            echo json_encode($this->paymenttype_model->add_article_answer($this->input->post('articleid'), $this->input->post('answer')));
            die();
        }
    }

    /* Change article active or inactive */
    public function change_article_status($id, $status)
    {
        if (has_permission('payment_type', '', 'edit')) {
            if ($this->input->is_ajax_request()) {
                $this->paymenttype_model->change_article_status($id, $status);
            }
        }
    }

    public function update_kan_ban()
    {
        if (has_permission('payment_type', '', 'edit')) {
            if ($this->input->post()) {
                $success = $this->paymenttype_model->update_kan_ban($this->input->post());
                $message = '';
                if ($success) {
                    $message = _l('updated_successfully', _l('Package'));
                }
                echo json_encode([
                    'success' => $success,
                    'message' => $message,
                ]);
                die();
            }
        }
    }

    public function change_group_color()
    {
        if (has_permission('payment_type', '', 'edit')) {
            if ($this->input->post()) {
                $this->paymenttype_model->change_group_color($this->input->post());
            }
        }
    }

    /* Delete article from database */
    public function delete_article($id)
    {
        if (!has_permission('payment_type', '', 'delete')) {
            access_denied('payment_type');
        }
        if (!$id) {
            redirect(admin_url('paymentType'));
        }
        $response = $this->paymenttype_model->delete_article($id);
        if ($response == true) {
            set_alert('success', _l('deleted', _l('Package')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('Package')));
        }
        redirect(admin_url('paymentType'));
    }

    /* View all article groups */
    public function manage_groups()
    {
        if (!has_permission('payment_type', '', 'view')) {
            access_denied('payment_type');
        }
        $data['groups'] = $this->paymenttype_model->get_kbg();
        $data['title']  = _l('als_kb_groups');
        $this->load->view('admin/paymentType/manage_groups', $data);
    }

    /* Add or edit existing article group */
    public function group($id = '')
    {
        if (!has_permission('payment_type', '', 'view')) {
            access_denied('payment_type');
        }
        if ($this->input->post()) {
            $post_data        = $this->input->post();
            $article_add_edit = isset($post_data['article_add_edit']);
            if (isset($post_data['article_add_edit'])) {
                unset($post_data['article_add_edit']);
            }
            if (!$this->input->post('id')) {
                if (!has_permission('payment_type', '', 'create')) {
                    access_denied('payment_type');
                }
                $id = $this->paymenttype_model->add_group($post_data);
                if (!$article_add_edit && $id) {
                    set_alert('success', _l('added_successfully', _l('kb_dt_group_name')));
                } else {
                    echo json_encode([
                        'id'      => $id,
                        'success' => $id ? true : false,
                        'name'    => $post_data['name'],
                    ]);
                }
            } else {
                if (!has_permission('payment_type', '', 'edit')) {
                    access_denied('payment_type');
                }

                $id = $post_data['id'];
                unset($post_data['id']);
                $success = $this->paymenttype_model->update_group($post_data, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('kb_dt_group_name')));
                }
            }
            die;
        }
    }

    /* Change group active or inactive */
    public function change_group_status($id, $status)
    {
        if (has_permission('payment_type', '', 'edit')) {
            if ($this->input->is_ajax_request()) {
                $this->paymenttype_model->change_group_status($id, $status);
            }
        }
    }

    public function update_groups_order()
    {
        if (has_permission('payment_type', '', 'edit')) {
            if ($this->input->post()) {
                $this->paymenttype_model->update_groups_order();
            }
        }
    }

    /* Delete article group */
    public function delete_group($id)
    {
        if (!has_permission('payment_type', '', 'delete')) {
            access_denied('payment_type');
        }
        if (!$id) {
            redirect(admin_url('paymentType/manage_groups'));
        }
        $response = $this->paymenttype_model->delete_group($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('danger', _l('is_referenced', _l('kb_dt_group_name')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('kb_dt_group_name')));
        } else {
            set_alert('warning', _l('problem_deleting', mb_strtolower(_l('kb_dt_group_name'))));
        }
        redirect(admin_url('paymentType/manage_groups'));
    }

    public function get_article_by_id_ajax($id)
    {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->paymenttype_model->get($id));
        }
    }
}
