<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Particulars extends AdminController
{
    public function __construct()
    {
        parent::__construct();
    }

    /* List all knowledgebase articles */
    public function index()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('particulars');
        }
        
        $subheader_text = setupTitle_text('setup_menu_active', 'teacher_master', 'particulars');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;
        $data['title']     = _l('Particular');
        $this->load->view('admin/particulars/particular', $data);
    }

    /* Add new article or edit existing*/
    public function add($id = '')
    {
        if ($this->input->post()) {
            $data                = $this->input->post();
            
            if ($id == '') {
                $this->db->insert('tblparticulars', $data);
                $id = $this->db->insert_id();
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('Particular')));
                    redirect(admin_url('particulars'));
                }
            } else {
                $this->db->where('id', $id);
                $this->db->update('tblparticulars', $data);
                $success = 1;
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('Particular')));
                }
                redirect(admin_url('particulars'));
            }
        }
        if ($id == '') {
            $title = _l('add_new', _l('Particular'));
        } else {
            $article         = $this->db->get_where('tblparticulars', array('id' => $id))->row();
           // echo '<pre>'; print_r($article); die;
            $data['article'] = $article;
            $title           = _l('edit', _l('Particular')) . ' ' . $article->subject;
        }
        $subheader_text = setupTitle_text('setup_menu_active', 'teacher_master', 'particulars');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;

        $data['title']     = _l('Particular');
        $this->load->view('admin/particulars/particular', $data);
    }

    /**
    * @ Change status
    */
    public function change_status($id, $status)
    {
        if ($this->input->is_ajax_request()) {
            $postdata['status'] = $status;
            $this->db->where('id', $id);
            $this->db->update(db_prefix().'particulars', $postdata);
        }
    }

    /* Delete article from database */
    public function delete_particulars($id)
    {
        if (!$id) {
            redirect(admin_url('particulars'));
        }
        $response = $this->db->delete('tblparticulars', array('id' => $id));
        if ($response == true) {
            set_alert('success', _l('deleted', _l('Particular')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('Particular')));
        }
        redirect(admin_url('particulars'));
    }
}
