<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Participating extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('participating_model');
    }

    /* List all knowledgebase articles */
    public function index()
    {
        if (!has_permission('participating', '', 'view')) {
            access_denied('participating');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('participating');
        }
       
        $subheader_text = setupTitle_text('setup_menu_active', 'master', 'participating');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;
        
        $data['title']     = _l($subheader_text);
        $this->load->view('admin/participating/participatings', $data);
    }

    /* Add new article or edit existing*/
    public function add($id = '')
    {
        if (!has_permission('participating', '', 'view')) {
            access_denied('participating');
        }
        if ($this->input->post()) {
            $data                = $this->input->post();
            
            if ($id == '') {
                if (!has_permission('participating', '', 'create')) {
                    access_denied('participating');
                }
                
                $existname = $this->db->get_where(db_prefix().'certificates_participating', array('name' => $data['name']))->row('name');
                if($existname)
                {
                    set_alert('warning', _l($data['name'].' name is existing'));
                    redirect(admin_url('participating'));
                }
                else
                {
                    $data['created_at'] = date('Y-m-d h:i:s');
                    $id = $this->participating_model->add_article($data);
                    if ($id) {
                        set_alert('success', _l('added_successfully', _l('Participating')));
                        redirect(admin_url('participating'));
                    }
                }
            } else {
                if (!has_permission('participating', '', 'edit')) {
                    access_denied('participating');
                }
                $success = $this->participating_model->update_article($data, $id);
                
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('Participating')));
                }
                redirect(admin_url('participating'));
            }
        }
        if ($id == '') {
            $title = _l('add_new', _l('Participating'));
        } else {
            $article         = $this->participating_model->get($id);
           // echo '<pre>'; print_r($article); die;
            $data['article'] = $article;
            $title           = _l('edit', _l('Participating')) . ' ' . $article->name;
        }
        $subheader_text = setupTitle_text('setup_menu_active', 'master', 'participating');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;

        $data['title']     = _l($subheader_text);
        $this->load->view('admin/participating/participating', $data);
    }

    public function save() {
        // If file uploaded
        if(is_uploaded_file($_FILES['fileURL']['tmp_name'])) {                            
            // Parse data from CSV file
            $csvData = $this->csvreader->parse_csv($_FILES['fileURL']['tmp_name']);       
            //echo '<pre>'; print_r($csvData); die;
            // create array from CSV file
           if(!empty($csvData)){
                foreach($csvData as $element){                    
                    // Prepare data for Database insertion
                    $data = array(
                        'name' => $element['Name'],
                        'mobile_one' => $element['Mobile First'],
                        'mobile_second' => $element['Mobile Second'],
                        'address' => $element['Address'],
                        'from_company' => $element['From Company'],
                        'from_vendore' => $element['From Vendor'],
                    );
                    //echo '<pre>'; print_r($data); die;
                    $this->db->insert(db_prefix() . 'master_participating_reminder', $data);
                    $data[] = '';
                }
                set_alert('success', _l('Data are stored successful!'));
            }
            else
            {
                set_alert('warning', _l('File is required'));
            }
        }
        else
        {
            set_alert('warning', _l('File is required'));
        } 
        redirect(admin_url('participating'));
    }
    
    // export Data
    public function sampledata() {
        $storData = array();
        $data[] = array('name' => 'Name', 'mobile_one' => 'Mobile First', 'mobile_second' => 'Mobile Second', 'address' => 'Address', 'from_company' => 'From Company', 'from_vendore' => 'From Vendor');       
        
        header("Content-type: application/csv");
        header("Content-Disposition: attachment; filename=\"csv-sample-customer".".csv\"");
        header("Pragma: no-cache");
        header("Expires: 0");
        $handle = fopen('php://output', 'w');
        foreach ($data as $data) {
            fputcsv($handle, $data);
        }
            fclose($handle);
        exit;
    }

    /* Delete article from database */
    public function delete_participating($id)
    {
        if (!has_permission('participating', '', 'delete')) {
            access_denied('participating');
        }
        if (!$id) {
            redirect(admin_url('participating'));
        }
        $response = $this->participating_model->delete_article($id);
        if ($response == true) {
            set_alert('success', _l('deleted', _l('Participating')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('Participating')));
        }
        redirect(admin_url('participating'));
    }
}
