<?php

defined('BASEPATH') or exit('No direct script access allowed');

class ImportantReminder extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('importantreminder_model');
    }

    /* List all knowledgebase articles */
    public function index()
    {
        if (!has_permission('important', '', 'view')) {
            access_denied('important');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('important_reminder');
        }
       
        $sheader_text = title_text('aside_menu_active', 'utilities','important');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;
        
        $data['bodyclass'] = 'top-tabs kan-ban-body';
        $data['title']     = _l('Important Reminder');
        $this->load->view('admin/importantReminder/articles', $data);
    }

    /* Add new article or edit existing*/
    public function add($id = '')
    {
        if (!has_permission('important', '', 'view')) {
            access_denied('important');
        }
        if ($this->input->post()) {
            $data                = $this->input->post();
            
            if ($id == '') {
                if (!has_permission('important', '', 'create')) {
                    access_denied('important');
                }
                $id = $this->importantreminder_model->add_article($data);
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('importantReminder')));
                    redirect(admin_url('importantReminder'));
                }
            } else {
                if (!has_permission('important', '', 'edit')) {
                    access_denied('important');
                }
                
                $success = $this->importantreminder_model->update_article($data, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('importantReminder')));
                }
                redirect(admin_url('importantReminder'));
            }
        }
        if ($id == '') {
            $title = _l('add_new', _l('Important Reminder'));
        } else {
            $article         = $this->importantreminder_model->get($id);
           // echo '<pre>'; print_r($article); die;
            $data['article'] = $article;
            $title           = _l('edit', _l('Important Reminder')) . ' ' . $article->subject;
        }
        $sheader_text = title_text('aside_menu_active', 'Important Reminder');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;

        $data['title']     = _l($sheader_text);
        $this->load->view('admin/importantReminder/article', $data);
    }

    public function save() {
        // If file uploaded
        if(is_uploaded_file($_FILES['fileURL']['tmp_name'])) {                            
            // Parse data from CSV file
            $csvData = $this->csvreader->parse_csv($_FILES['fileURL']['tmp_name']);       
            //echo '<pre>'; print_r($csvData); die;
            // create array from CSV file
           if(!empty($csvData)){
                foreach($csvData as $element){                    
                    // Prepare data for Database insertion
                    $data = array(
                        'name' => $element['Name'],
                        'mobile_one' => $element['Mobile First'],
                        'mobile_second' => $element['Mobile Second'],
                        'address' => $element['Address'],
                        'from_company' => $element['From Company'],
                        'from_vendore' => $element['From Vendor'],
                    );
                    //echo '<pre>'; print_r($data); die;
                    $this->db->insert(db_prefix() . 'master_important_reminder', $data);
                    $data[] = '';
                }
                set_alert('success', _l('Data are stored successful!'));
            }
            else
            {
                set_alert('warning', _l('File is required'));
            }
        }
        else
        {
            set_alert('warning', _l('File is required'));
        } 
        redirect(admin_url('importantReminder'));
    }
    
    // export Data
    public function sampledata() {
        $storData = array();
        $data[] = array('name' => 'Name', 'mobile_one' => 'Mobile First', 'mobile_second' => 'Mobile Second', 'address' => 'Address', 'from_company' => 'From Company', 'from_vendore' => 'From Vendor');       
        
        header("Content-type: application/csv");
        header("Content-Disposition: attachment; filename=\"csv-sample-customer".".csv\"");
        header("Pragma: no-cache");
        header("Expires: 0");
        $handle = fopen('php://output', 'w');
        foreach ($data as $data) {
            fputcsv($handle, $data);
        }
            fclose($handle);
        exit;
    }

    /* Delete article from database */
    public function delete_importantreminder($id)
    {
        if (!has_permission('important', '', 'delete')) {
            access_denied('important');
        }
        if (!$id) {
            redirect(admin_url('importantReminder'));
        }
        $response = $this->importantreminder_model->delete_article($id);
        if ($response == true) {
            set_alert('success', _l('deleted', _l('Important Reminder')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('Important Reminder')));
        }
        redirect(admin_url('importantReminder'));
    }
}
