<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Feediscount extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('feediscount_model');
    }

    /* List all knowledgebase articles */
    public function index()
    {
        if (!has_permission('fees_', '', 'view')) {
            access_denied('fees_');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('fees_discount');
        }
       
        $sheader_text = title_text('aside_menu_active', 'fees_', 'feediscount');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = 'Fees Discount';
        
        //$data['vehicle_result']    = $this->db->get_where(db_prefix().'master_vehicle')->result();
        //$data['route_result']    = $this->db->get_where(db_prefix().'master_route')->result();
        $data['bodyclass'] = 'top-tabs kan-ban-body';
        $data['title']     = _l('Fees Discount');
        $this->load->view('admin/feediscount/articles', $data);
    }

    /* Add new article or edit existing*/
    public function add($id = '')
    {
        if (!has_permission('fees_', '', 'view')) {
            access_denied('fees_');
        }
        if ($this->input->post()) {
            $data                = $this->input->post();
            
            if ($id == '') {
                if (!has_permission('fees_', '', 'create')) {
                    access_denied('fees_');
                }
                $id = $this->feediscount_model->add_article($data);
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('Fees Discount')));
                    redirect(admin_url('feediscount'));
                }
            } else {
                if (!has_permission('fees_', '', 'edit')) {
                    access_denied('fees_');
                }
                
                $success = $this->feediscount_model->update_article($data, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('Fees Discount')));
                }
                redirect(admin_url('feediscount'));
            }
        }
        if ($id == '') {
            $title = _l('add_new', _l('Fees Discount'));
        } else {
            $article         = $this->feediscount_model->get($id);
           // echo '<pre>'; print_r($article); die;
            $data['article'] = $article;
            $title           = _l('edit', _l('Fees Discount')) . ' ' . $article->subject;
        }
        $sheader_text = title_text('aside_menu_active', 'fees_', 'feediscount');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;

        $data['title']     = _l('Fees Discount');
        $data['vehicle_result']    = $this->db->get_where(db_prefix().'master_vehicle')->result();
        $data['route_result']    = $this->db->get_where(db_prefix().'master_route')->result();
        $this->load->view('admin/feediscount/article', $data);
    }

    public function view($slug)
    {
        if (!has_permission('fees_', '', 'view')) {
            access_denied('fees_');
        }

        $data['article'] = $this->feediscount_model->get(false, $slug);

        if (!$data['article']) {
            show_404();
        }

        $data['related_articles'] = $this->feediscount_model->get_related_articles($data['article']->articleid, false);

        add_views_tracking('fees_', $data['article']->articleid);
        $data['title'] = $data['article']->subject;
        $this->load->view('admin/feediscount/view', $data);
    }

    public function add_kb_answer()
    {
        // This is for did you find this answer useful
        if (($this->input->post() && $this->input->is_ajax_request())) {
            echo json_encode($this->feediscount_model->add_article_answer($this->input->post('articleid'), $this->input->post('answer')));
            die();
        }
    }

    /* Change article active or inactive */
    public function change_article_status($id, $status)
    {
        if (has_permission('fees_', '', 'edit')) {
            if ($this->input->is_ajax_request()) {
                $this->feediscount_model->change_article_status($id, $status);
            }
        }
    }

    public function update_kan_ban()
    {
        if (has_permission('fees_', '', 'edit')) {
            if ($this->input->post()) {
                $success = $this->feediscount_model->update_kan_ban($this->input->post());
                $message = '';
                if ($success) {
                    $message = _l('updated_successfully', _l('Fees Discount'));
                }
                echo json_encode([
                    'success' => $success,
                    'message' => $message,
                ]);
                die();
            }
        }
    }

    public function change_group_color()
    {
        if (has_permission('fees_', '', 'edit')) {
            if ($this->input->post()) {
                $this->feediscount_model->change_group_color($this->input->post());
            }
        }
    }

    /* Delete article from database */
    public function delete_article($id)
    {
        if (!has_permission('fees_', '', 'delete')) {
            access_denied('fees_');
        }
        if (!$id) {
            redirect(admin_url('Feediscount'));
        }
        $response = $this->feediscount_model->delete_article($id);
        if ($response == true) {
            set_alert('success', _l('deleted', _l('Fees Discount')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('Fees Discount')));
        }
        redirect(admin_url('feediscount'));
    }

    /* View all article groups */
    public function manage_groups()
    {
        if (!has_permission('fees_', '', 'view')) {
            access_denied('fees_');
        }
        $data['groups'] = $this->feediscount_model->get_kbg();
        $data['title']  = _l('als_kb_groups');
        $this->load->view('admin/feediscount/manage_groups', $data);
    }

    /* Add or edit existing article group */
    public function group($id = '')
    {
        if (!has_permission('fees_', '', 'view')) {
            access_denied('fees_');
        }
        if ($this->input->post()) {
            $post_data        = $this->input->post();
            $article_add_edit = isset($post_data['article_add_edit']);
            if (isset($post_data['article_add_edit'])) {
                unset($post_data['article_add_edit']);
            }
            if (!$this->input->post('id')) {
                if (!has_permission('fees_', '', 'create')) {
                    access_denied('fees_');
                }
                $id = $this->feediscount_model->add_group($post_data);
                if (!$article_add_edit && $id) {
                    set_alert('success', _l('added_successfully', _l('kb_dt_group_name')));
                } else {
                    echo json_encode([
                        'id'      => $id,
                        'success' => $id ? true : false,
                        'name'    => $post_data['name'],
                    ]);
                }
            } else {
                if (!has_permission('fees_', '', 'edit')) {
                    access_denied('fees_');
                }

                $id = $post_data['id'];
                unset($post_data['id']);
                $success = $this->feediscount_model->update_group($post_data, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('kb_dt_group_name')));
                }
            }
            die;
        }
    }

    /* Change group active or inactive */
    public function change_group_status($id, $status)
    {
        if (has_permission('fees_', '', 'edit')) {
            if ($this->input->is_ajax_request()) {
                $this->feediscount_model->change_group_status($id, $status);
            }
        }
    }

    public function update_groups_order()
    {
        if (has_permission('fees_', '', 'edit')) {
            if ($this->input->post()) {
                $this->feediscount_model->update_groups_order();
            }
        }
    }

    /* Delete article group */
    public function delete_group($id)
    {
        if (!has_permission('fees_', '', 'delete')) {
            access_denied('fees_');
        }
        if (!$id) {
            redirect(admin_url('feediscount/manage_groups'));
        }
        $response = $this->feediscount_model->delete_group($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('danger', _l('is_referenced', _l('kb_dt_group_name')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('kb_dt_group_name')));
        } else {
            set_alert('warning', _l('problem_deleting', mb_strtolower(_l('kb_dt_group_name'))));
        }
        redirect(admin_url('feediscount/manage_groups'));
    }

    public function get_article_by_id_ajax($id)
    {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->feediscount_model->get($id));
        }
    }
}
