<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Export extends CI_Controller {

    // construct
    public function __construct() {
        parent::__construct();
        
        $GLOBALS['EXT']->call_hook('pre_controller_constructor');
        $this->academic_session = $this->session->userdata('academic_session');
        $this->current_session  = CURRENT_SESSION;
        if($this->academic_session==$this->current_session){
            $this->contact_tbl ='';
            $this->session->set_userdata('contact_tbl', '');
        }else if($this->academic_session=='2021-22'){
            $this->contact_tbl = '_2021_22';
            $this->session->set_userdata('contact_tbl', '_2021_22');
        }else if($this->academic_session=='2022-23'){
            $this->contact_tbl = '_2022_23';
            $this->session->set_userdata('contact_tbl', '_2022_23');
        }
        else if($this->academic_session=='2023-24'){
            $this->contact_tbl = '_2023_24';
            $this->session->set_userdata('contact_tbl', '_2023_24');
        }
        else if($this->academic_session=='2024-25'){
            $this->contact_tbl = '_2024_25';
            $this->session->set_userdata('contact_tbl', '_2024_25');
        }
		$this->load->model('dashboard_model');
    }
	
	/* New Student Academic Year */
	public function dateWiseStudentFees($s_date) {
		if($s_date == '')
		{
			$s_date = date('Y-m-d');
		}
		
        // create file name
        $fileName = $s_date.'-'. time() . '.xlsx';
        // load excel library
        $this->load->library('excel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
		
		//$studentInfo = $this->db->select(array('firstname','middlename','lastname','Father_Name','Father_Mobile','Mother_Name','Mother_Mobile','Campus','Admission_Year','Class','Shift','Gender'))->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Admission_Year !=' => $this->academic_session, 'payment_status >' => 0))->result_array();
		$ignore = array('07582970904','9039524321');
		$this->db->select('a.*,b.academic_year,b.deposit_amount,b.payment_mode');
		$this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');
        $this->db->join(db_prefix().'student_fees_deposit b','b.userid = a.userid', 'LEFT');
		//$this->db->where('a.Admission_Year !=', '2022-23');
		//$this->db->where('b.academic_year', '2022-23');
		$this->db->where('b.deposit_date', $s_date);
		$this->db->where_not_in('a.Father_Mobile', $ignore);
        $studentInfo = $this->db->get()->result_array();
        // set Header
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Student Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Father Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Father Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Mother Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Mother Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Class');
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Campus');
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Gender');
        $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Admission Year');
        $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Shift');
        $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Academic Year');
        $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Payment Mode');
        $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Deposit Amount');
        // set Row
        $rowCount = 2;
        foreach ($studentInfo as $element) {
			$sname = $element['firstname'].' '.$element['middlename'].' '.$element['lastname'];
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $sname);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['Father_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['Father_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['Mother_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $element['Mother_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $element['Class']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $element['Campus']);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $element['Gender']);
			$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $element['Admission_Year']);
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $element['Shift']);
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $element['academic_year']);
            $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $element['payment_mode']);
            $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $element['deposit_amount']);
            $rowCount++;
        }
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('assets/uploads/import/' . $fileName);
        // download file
        header("Content-Type: application/vnd.ms-excel");
        redirect(base_url().'assets/uploads/import/'. $fileName);
    }

	/* New Student Academic Year */
	public function allPaidStudentData() {
		
        // create file name
        $fileName = '2022-03-31-'. time() . '.xlsx';
        // load excel library
        $this->load->library('excel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
		
		//$studentInfo = $this->db->select(array('firstname','middlename','lastname','Father_Name','Father_Mobile','Mother_Name','Mother_Mobile','Campus','Admission_Year','Class','Shift','Gender'))->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Admission_Year !=' => $this->academic_session, 'payment_status >' => 0))->result_array();
		$ignore = array('07582970904','9039524321');
		$this->db->select('a.*,b.academic_year,b.deposit_amount,b.payment_mode');
		$this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');
        $this->db->join(db_prefix().'student_fees_deposit b','b.userid = a.userid', 'LEFT');
		//$this->db->where('a.Admission_Year !=', '2022-23');
		//$this->db->where('b.academic_year', '2022-23');
		$this->db->where('b.deposit_date', '2022-03-31');
		//$this->db->where('b.deposit_date', '2022-04-01');
		$this->db->where_not_in('a.Father_Mobile', $ignore);
        $studentInfo = $this->db->get()->result_array();
        // set Header
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Student Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Father Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Father Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Mother Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Mother Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Class');
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Campus');
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Gender');
        $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Shift');
        $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Academic Year');
        $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Payment Mode');
        $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Deposit Amount');
        // set Row
        $rowCount = 2;
        foreach ($studentInfo as $element) {
			$sname = $element['firstname'].' '.$element['middlename'].' '.$element['lastname'];
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $sname);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['Father_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['Father_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['Mother_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $element['Mother_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $element['Class']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $element['Campus']);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $element['Gender']);
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $element['Shift']);
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $element['academic_year']);
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $element['payment_mode']);
            $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $element['deposit_amount']);
            $rowCount++;
        }
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('assets/uploads/import/' . $fileName);
        // download file
        header("Content-Type: application/vnd.ms-excel");
        redirect(base_url().'assets/uploads/import/'. $fileName);
    }

    // create xlsx
    public function tcReport() {
        // create file name
        $fileName = 'TC-' . time() . '.xlsx';
        // load excel library
        $this->load->library('excel');
        //$empInfo = $this->export->employeeList();
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        // set Header
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'First Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Last Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Email');
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'DOB');
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Contact_No');
        // set Row
        /*$rowCount = 2;
        foreach ($empInfo as $element) {
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $element['first_name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['last_name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['email']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['dob']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $element['contact_no']);
            $rowCount++;
        }*/
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('assets/uploads/import/' . $fileName);
        // download file
        header("Content-Type: application/vnd.ms-excel");
        redirect(base_url().'assets/uploads/import/'. $fileName);
    }
	
	
    // create xlsx
    public function createXLSClass($class = null) {		
        // create file name
        $fileName = 'Class-'.$class.'-'. time() . '.xlsx';
        // load excel library
        $this->load->library('excel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
		$class_name = '';
		if($class == 'Playgroup' || $class == 'Nursery' || $class == 'LKG' || $class == 'UKG')
		{
			$class_name = $class;
		}
		else
		{
			$class_name = 'Class '.$class;
		}
		//$studentInfo = $this->db->select(array('firstname','middlename','lastname','Father_Name','Father_Mobile','Mother_Name','Mother_Mobile','Class'))->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => $class_name))->result_array();
		$studentInfo = $this->db->select(array('a.firstname','a.middlename','a.lastname','a.Father_Name','a.Father_Occupation','a.Father_Designation','a.Mother_Occupation','a.Mother_Designation','a.Father_Mobile','a.Mother_Name','a.Mother_Mobile','a.Class','a.Campus','a.Shift','a.payment_status','a.email','a.paa','a.Gender','a.Date_of_Birth','a.Place_Of_Birth','a.Religion','a.Nationality','a.Caste','a.Mother_Tongue','a.Birth_Certificate','a.Aadhar_Card','a.Samagra_ID','a.TC','a.student_address','b.active'))->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->order_by('a.id', 'asc')->where('b.active',1)->where('a.Class', $class_name)->get()->result_array();
        // set Header
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Student Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Father Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Father Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Mother Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Mother Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Class');
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Campus');
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Shift');
        $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Section');
        $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Login ID');
        $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Password');
        $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Gender');
        $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Date of Birth');
        $objPHPExcel->getActiveSheet()->SetCellValue('N1', 'Place of Birth');
        $objPHPExcel->getActiveSheet()->SetCellValue('O1', 'Religion');
        $objPHPExcel->getActiveSheet()->SetCellValue('P1', 'Nationality');
        $objPHPExcel->getActiveSheet()->SetCellValue('Q1', 'Caste');
        $objPHPExcel->getActiveSheet()->SetCellValue('R1', 'Mother Tongue');
        $objPHPExcel->getActiveSheet()->SetCellValue('S1', 'Birth Certificate');
        $objPHPExcel->getActiveSheet()->SetCellValue('T1', 'Aadhar Card');
        $objPHPExcel->getActiveSheet()->SetCellValue('U1', 'Samagra Id');
        $objPHPExcel->getActiveSheet()->SetCellValue('V1', 'TC');
        $objPHPExcel->getActiveSheet()->SetCellValue('W1', 'Father Occupation');
        $objPHPExcel->getActiveSheet()->SetCellValue('X1', 'Father Designation');
        $objPHPExcel->getActiveSheet()->SetCellValue('Y1', 'Mother Occupation');
        $objPHPExcel->getActiveSheet()->SetCellValue('Z1', 'Mother Designation');
        $objPHPExcel->getActiveSheet()->SetCellValue('AA1', 'Address');
        // set Row
        $rowCount = 2;
        foreach ($studentInfo as $element) {
			$sname = $element['firstname'].' '.$element['middlename'].' '.$element['lastname'];
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $sname);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['Father_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['Father_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['Mother_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $element['Mother_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $element['Class']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $element['Campus']);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $element['Shift']);
            if($element['payment_status'] == 1){
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, 'A1');
            }
            elseif($element['payment_status'] == 2){
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, 'A2');
            }
            elseif($element['payment_status'] == 3){
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, 'A3');
            }
            elseif($element['payment_status'] == 4){
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, 'A4');
            }
            elseif($element['payment_status'] == 5){
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, 'A5');
            }
            elseif($element['payment_status'] == 6){
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, 'A6');
            }
            else{
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, 'NA');
            }
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $element['email']);
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $element['paa']);
            $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $element['Gender']);
            $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $element['Date_of_Birth']);
            $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $element['Place_Of_Birth']);
            $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, $element['Religion']);
            $objPHPExcel->getActiveSheet()->SetCellValue('P' . $rowCount, $element['Nationality']);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $rowCount, $element['Caste']);
            $objPHPExcel->getActiveSheet()->SetCellValue('R' . $rowCount, $element['Mother_Tongue']);
            $objPHPExcel->getActiveSheet()->SetCellValue('S' . $rowCount, $element['Birth_Certificate']);
            $objPHPExcel->getActiveSheet()->SetCellValue('T' . $rowCount, $element['Aadhar_Card']);
            $objPHPExcel->getActiveSheet()->SetCellValue('U' . $rowCount, $element['Samagra_ID']);
            $objPHPExcel->getActiveSheet()->SetCellValue('V' . $rowCount, $element['TC']);
            $objPHPExcel->getActiveSheet()->SetCellValue('W' . $rowCount, $element['Father_Occupation']);
            $objPHPExcel->getActiveSheet()->SetCellValue('X' . $rowCount, $element['Father_Designation']);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y' . $rowCount, $element['Mother_Occupation']);
            $objPHPExcel->getActiveSheet()->SetCellValue('Z' . $rowCount, $element['Mother_Designation']);
            $objPHPExcel->getActiveSheet()->SetCellValue('AA' . $rowCount, $element['student_address']);
            $rowCount++;
        }
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('assets/uploads/import/' . $fileName);
        // download file
        header("Content-Type: application/vnd.ms-excel");
        redirect(base_url().'assets/uploads/import/'. $fileName);
    }

    // create xlsx
    public function exportXLSClass($class = null) {
        // create file name
        $fileName = 'Class-'.$class.'-'. time() . '.xlsx';
        // load excel library
        $this->load->library('excel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
		$class_name = '';
		if($class == 'Playgroup' || $class == 'Nursery' || $class == 'LKG' || $class == 'UKG')
		{
			$class_name = $class;
		}
		else
		{
			$class_name = 'Class '.$class;
		}
		$studentInfo = $this->db->select(array('firstname','middlename','lastname','Father_Name','Father_Mobile','Mother_Name','Mother_Mobile','Class', 'Campus', 'Date_of_Admission'))->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => $class_name, 'Admission_Year' => $this->academic_session))->result_array();
        // set Header
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Student Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Father Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Father Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Mother Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Mother Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Class');
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Campus');
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Date of Admission');
        // set Row
        $rowCount = 2;
        foreach ($studentInfo as $element) {
			$sname = $element['firstname'].' '.$element['middlename'].' '.$element['lastname'];
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $sname);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['Father_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['Father_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['Mother_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $element['Mother_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $element['Class']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $element['Campus']);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $element['Date_of_Admission']);
            $rowCount++;
        }
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('assets/uploads/import/' . $fileName);
        // download file
        header("Content-Type: application/vnd.ms-excel");
        redirect(base_url().'assets/uploads/import/'. $fileName);
    }
	
    // create xlsx
    public function todayAdmissionList() {
        // create file name
        $fileName = 'Today-'. time() . '.xlsx';
        // load excel library
        $this->load->library('excel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        
        $studentInfo = $this->db->select(array('firstname','middlename','lastname','Father_Name','Father_Mobile','Mother_Name','Mother_Mobile','Class', 'Campus', 'Date_of_Admission', 'Shift'))->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Date_of_Admission' => date('d-m-Y'), 'Admission_Year' => $this->academic_session))->result_array();
        // set Header
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Firstname');
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Middlename');
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Lastname');
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Father Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Father Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Mother Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Mother Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Class');
        $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Campus');
        $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Shift');
        $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Date of Admission');
        // set Row
        $rowCount = 2;
        foreach ($studentInfo as $element) {
            /*$sname = $element['firstname'].' '.$element['middlename'].' '.$element['lastname'];
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $sname);*/
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $element['firstname']);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['middlename']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['lastname']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['Father_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $element['Father_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $element['Mother_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $element['Mother_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $element['Class']);
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $element['Campus']);
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $element['Shift']);
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $element['Date_of_Admission']);
            $rowCount++;
        }
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('assets/uploads/import/' . $fileName);
        // download file
        header("Content-Type: application/vnd.ms-excel");
        redirect(base_url().'assets/uploads/import/'. $fileName);
    }
    
	/* Create XLS TC Report */
	public function createXLSTCReport()
	{
		$data = $this->input->post();
		$this->db->select('a.userid,a.firstname,a.middlename,a.lastname,a.Father_Mobile,a.Father_Name,a.Campus,a.Class,a.Mother_Name,b.date_of_application_for_tc,b.status');
        $this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');
        $this->db->join(db_prefix().'tc_requests b','b.student_id = a.userid', 'RIGHT');		
		if($data['tc_report_date'] != '')
		{
			$this->db->where('b.date_of_application_for_tc',$data['tc_report_date']);			
		}
		if($data['tc_report_type'] != 'All')
		{
			$this->db->where('b.status',$data['tc_report_type']);			
		}
		$studentInfo = $this->db->get()->result_array();
		//echo $this->db->last_query();
		//echo '<pre>'; print_r($studentInfo); die;
		$fileName = 'TC-Report-'.time().'.xlsx';
		
        $this->load->library('excel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
		$class_name = '';
		
        // set Header
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Student Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Class');
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Campus');
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Father Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Mother Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Father Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Applied Date');
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Status');
        // set Row
        $rowCount = 2;
        foreach ($studentInfo as $element) {
			$sname = $element['firstname'].' '.$element['middlename'].' '.$element['lastname'];
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $sname);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['Class']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['Campus']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['Father_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $element['Mother_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $element['Father_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $element['date_of_application_for_tc']);
            if($element['status'] == 1)
            {
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, 'Approved');
            }
            else
            {
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, 'Pending');
            }
            $rowCount++;
        }
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('assets/uploads/import/' . $fileName);
        // download file
        header("Content-Type: application/vnd.ms-excel");
        redirect(base_url().'assets/uploads/import/'. $fileName);
	}
	
	// create xlsx
    public function exportDayBookJs($n_start_date = '', $n_end_date = '')
	{
		if(!empty($n_start_date) && !empty($n_end_date))
		{
			$start_date = date('Y-m-d', strtotime($n_start_date));
            $end_date = date('Y-m-d', strtotime($n_end_date));
		}
		elseif(!empty($n_start_date) && empty($n_end_date))
		{
			$start_date = date('Y-m-d', strtotime($n_start_date));
            $end_date = date('Y-m-d', strtotime($n_start_date));
		}
		elseif(empty($n_start_date) && !empty($n_end_date))
		{
			$start_date = date('Y-m-d', strtotime($n_end_date));
            $end_date = date('Y-m-d', strtotime($n_end_date));
		}
		else{
			$start_date = date('Y-m-d');
			$end_date = date('Y-m-d');
		}
		
        // create file name
        $fileName = 'Day-Book-'.$start_date.'-'. time() . '.xlsx';
        // load excel library
        $this->load->library('excel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
				
		$type = 'All';
		$studentInfo = $this->dashboard_model->totalDayBookNStudentFeesRecord_export($type, $start_date, $end_date);
        // set Header
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Student Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Class');
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Shift');
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Campus');
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Father Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Mother Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Father Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Mother Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Date');
        $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Amount');
        $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Mode');
        $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Transaction ID/Cheque NO');
        // set Row
        $rowCount = 2;
        foreach ($studentInfo as $element) {
			//$sname = $element['firstname'].' '.$element['middlename'].' '.$element['lastname'];
			$paymentTr = $element['payment_mode'] =='cheque' ? 'Cheque N0:'.$element['check_no']  : strtoupper($element['dd_upi_online']);
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $element['student_name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['Class']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['Shift']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['Campus']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $element['Father_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $element['Mother_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $element['Father_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $element['Mother_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, date('d-m-Y', strtotime($element['deposit_date'])));
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $element['deposit_amount']);
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, strtoupper($element['payment_mode']));
			$objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $paymentTr);
            $rowCount++;
        }
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('assets/uploads/import/' . $fileName);
        // download file
        header("Content-Type: application/vnd.ms-excel");
        redirect(base_url().'assets/uploads/import/'. $fileName);
    }
	
	// create xlsx
    public function exportPackageStudent()
	{		
        // create file name
        $fileName = 'Package-Student-'. time() . '.xlsx';
        // load excel library
        $this->load->library('excel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
				
		$type = 'All';
		$studentInfo = $this->dashboard_model->exportPackageStudent_export();
        // set Header
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Student Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Class');
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Shift');
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Campus');
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Father Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Mother Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Father Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Package Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Package Amount');
        // set Row
        $rowCount = 2;
        foreach ($studentInfo as $element) {
			//$sname = $element['firstname'].' '.$element['middlename'].' '.$element['lastname'];
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $element['student_name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['Class']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['Shift']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['Campus']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $element['Father_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $element['Mother_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $element['Father_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $element['pname']);
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $element['pamount']);
            $rowCount++;
        }
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('assets/uploads/import/' . $fileName);
        // download file
        header("Content-Type: application/vnd.ms-excel");
        redirect(base_url().'assets/uploads/import/'. $fileName);
    }
	
	// Transport Report Export xlsx
    public function transportReportExport($route_number = '')
	{		
		if($route_number == '')
		{
			$routenumber = 'All-route-';
		}
		else
		{
			$routenumber = $route_number;
		}
		
		
		$this->db->select('a.userid,a.firstname,a.middlename,a.lastname,a.Father_Mobile,a.Mother_Mobile,a.Father_Name,a.Campus,,a.Shift,a.Class,a.Mother_Name,a.student_address,b.transport_by,b.transport_bus_no,b.transport_route_name,b.transport_pickup_stop,b.transport_drop_stop');
        $this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');
        $this->db->join(db_prefix().'student_transport b','b.student_id = a.userid', 'RIGHT');		
		if($route_number != '')
		{
			$this->db->where('b.transport_route_name',$route_number);			
		}
		$this->db->where('b.academic_session',$this->academic_session);
		$ignore = array('07582970904','9039524321');
        $this->db->where_not_in('a.Father_Mobile', $ignore);
		
		$studentInfo = $this->db->get()->result_array();
				
        // create file name
        $fileName = $routenumber.'-'. time() . '.xlsx';
        // load excel library
        $this->load->library('excel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
		
        // set Header
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Student Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Father Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Father Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Mother Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Mother Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Class');
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Shift');
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Address');
        $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Transport By');
        $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Registration Number');
        $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Route Number');
        $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Pickup Stop');
        $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Drop Stop');
        // set Row
        $rowCount = 2;
        foreach ($studentInfo as $element) {
			$sname = $element['firstname'].' '.$element['middlename'].' '.$element['lastname'];
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $sname);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['Father_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['Father_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['Mother_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $element['Mother_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $element['Class']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $element['Shift']);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $element['student_address']);
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $element['transport_by']);
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $element['transport_bus_no']);
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $element['transport_route_name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $element['transport_pickup_stop']);
            $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $element['transport_drop_stop']);
            $rowCount++;
        }
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('assets/uploads/import/' . $fileName);
        // download file
        header("Content-Type: application/vnd.ms-excel");
        redirect(base_url().'assets/uploads/import/'. $fileName);
    }

    public function importCsvToDb()
    {
        $data = array(); 
        if(!empty($_FILES['file']['name'])){ 
            // Set preference 
            $config['upload_path'] = 'assets/uploads/import/'; 
            $config['allowed_types'] = 'csv'; 
            $config['max_size'] = '1000'; // max_size in kb 
            $config['file_name'] = $_FILES['file']['name'];

            // Load upload library 
            $this->load->library('upload',$config); 

            // File upload
            if($this->upload->do_upload('file')){ 
            // Get data about the file
            $uploadData = $this->upload->data(); 
            $filename = $uploadData['file_name'];

            // Reading file
            $file = fopen("assets/uploads/import/".$filename,"r");
            $i = 0;
            $numberOfFields = 20; // Total number of fields
            $csvArr = array();
            $importData_arr = array();

            while (($filedata = fgetcsv($file, 1000, ",")) !== FALSE) {
                $num = count($filedata);
                if($i > 0 && $num == $numberOfFields){ 
                    $csvArr[$i]['id'] = $filedata[0];
                    $csvArr[$i]['email'] = $filedata[1];
                    $csvArr[$i]['phone'] = $filedata[2];
                    $csvArr[$i]['created_at'] = $filedata[3];
                }
                $i++;
            }
            fclose($file);

            $skip = 0;
if($csvArr)
{
    /*
    $sdata = [];
    foreach($importData_arr as $rrr){
        $class_id = '';
        $student_id = '';
        $exam_id = '';
        $academic_year = '';
        $result_remark = '';
        if()
        {

        }
        else{
            $exam_id = '';
            $class_id = '';
            $student_id = '';
            $academic_year = '';
            $result_remark = '';
        }
    }*/
    $group = array();

    foreach ( $csvArr as $value ) {
        $group[$value['id']][] = $value;
    }
}
//echo "<pre>"; print_r($group); die();
$response = [];
if($group)
{
    foreach($group as $key => $g){
        $sarray[] = $group[$key];
        //echo "<pre>"; print_r($sarray); die();
        foreach($sarray as $s){
            $data['id'] = $s[$key]['id'];
            $data['email'] = $s[$key]['email'];
            $data['phone'] = $s[$key]['phone'];
            $response[] = $data;
        }
    }
}
echo "<pre>"; print_r($response); die();
            // insert import data
            
                $data['response'] = 'successfully uploaded '.$filename; 
            }else{ 
                $data['response'] = 'failed'; 
            } 
        }    
    }

    public function importCsvToDbView()
    {
        $this->load->view('import');
    }


    // create xlsx
    public function studentPaymentReport()
    {       
        // create file name
        $fileName = 'Student-payment-'. time() . '.xlsx';
        // load excel library
        $this->load->library('excel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
                
        $type = 'All';
        $studentInfo = $this->dashboard_model->studentPaymentReport_export();
        // set Header
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Student Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Class');
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Shift');
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Father Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Father Mobile');
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Admission Year');
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Academic Year');
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Package Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Package Amount');
        $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Deposit Amount');
        $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Balance Amount');
        // set Row
        $rowCount = 2;
        foreach ($studentInfo as $element) {
            //$sname = $element['firstname'].' '.$element['middlename'].' '.$element['lastname'];
            $ramount = $element['pamount'] - $element['damount'];
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $element['student_name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['Class']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['Shift']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['Father_Name']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $element['Father_Mobile']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $element['Admission_Year']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $element['Academic_Year']);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $element['pname']);
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $element['pamount']);
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $element['damount']);
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $ramount);
            $rowCount++;
        }
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('assets/uploads/import/' . $fileName);
        // download file
        header("Content-Type: application/vnd.ms-excel");
        redirect(base_url().'assets/uploads/import/'. $fileName);
    }
}
