<?php

defined('BASEPATH') or exit('No direct script access allowed');
class Dashboard extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('dashboard_model');
    }

    /* This is admin dashboard view */
    public function index()
    {
        close_setup_menu();
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('approvedStudentFee');
        }
        $this->load->model('departments_model');
        $this->load->model('todo_model');
        $data['departments'] = $this->departments_model->get();

        $data['todos'] = $this->todo_model->get_todo_items(0);
        // Only show last 5 finished todo items
        $this->todo_model->setTodosLimit(5);
        $data['todos_finished']            = $this->todo_model->get_todo_items(1);
        $data['upcoming_events_next_week'] = $this->dashboard_model->get_upcoming_events_next_week();
        $data['upcoming_events']           = $this->dashboard_model->get_upcoming_events();
        $data['title']                     = _l('dashboard_string');
        $this->load->model('currencies_model');
        $data['currencies']    = $this->currencies_model->get();
        $data['base_currency'] = $this->currencies_model->get_base_currency();
        $data['activity_log']  = $this->misc_model->get_activity_log();
        // Tickets charts
        $tickets_awaiting_reply_by_status     = $this->dashboard_model->tickets_awaiting_reply_by_status();
        $tickets_awaiting_reply_by_department = $this->dashboard_model->tickets_awaiting_reply_by_department();

        $data['tickets_reply_by_status']              = json_encode($tickets_awaiting_reply_by_status);
        $data['tickets_awaiting_reply_by_department'] = json_encode($tickets_awaiting_reply_by_department);

        $data['tickets_reply_by_status_no_json']              = $tickets_awaiting_reply_by_status;
        $data['tickets_awaiting_reply_by_department_no_json'] = $tickets_awaiting_reply_by_department;

        $data['projects_status_stats'] = json_encode($this->dashboard_model->projects_status_stats());
        $data['leads_status_stats']    = json_encode($this->dashboard_model->leads_status_stats());
        $data['google_ids_calendars']  = $this->misc_model->get_google_calendar_ids();
        $data['bodyclass']             = 'dashboard invoices-total-manual';
        $this->load->model('announcements_model');
        $data['staff_announcements']             = $this->announcements_model->get();
        $data['total_undismissed_announcements'] = $this->announcements_model->get_total_undismissed_announcements();

        $this->load->model('projects_model');
        $data['projects_activity'] = $this->projects_model->get_activity('', hooks()->apply_filters('projects_activity_dashboard_limit', 20));
        add_calendar_assets();
        $this->load->model('utilities_model');
        $this->load->model('estimates_model');
        $data['estimate_statuses'] = $this->estimates_model->get_statuses();

        $this->load->model('proposals_model');
        $data['proposal_statuses'] = $this->proposals_model->get_statuses();

        $wps_currency = 'undefined';
        if (is_using_multiple_currencies()) {
            $wps_currency = $data['base_currency']->id;
        }
        $data['weekly_payment_stats'] = json_encode($this->dashboard_model->get_weekly_payments_statistics($wps_currency));

        $data['dashboard'] = true;
        
        $total_playgrop_ = $this->db->get_where(db_prefix().'contacts', array('Class' => 'Playgroup'))->num_rows();
        $total_playgrop = $this->db->get_where(db_prefix().'contacts', array('Class' => 'PG'))->num_rows();
        $data['total_playgrop'] = $total_playgrop + $total_playgrop_;
        
        $total_nursery = $this->db->get_where(db_prefix().'contacts', array('Class' => 'Nursery'))->num_rows();
        $data['total_nursery'] = $total_nursery;
        
        $total_lkg = $this->db->get_where(db_prefix().'contacts', array('Class' => 'LKG'))->num_rows();
        $data['total_lkg'] = $total_lkg;
        
        $total_ukg = $this->db->get_where(db_prefix().'contacts', array('Class' => 'UKG'))->num_rows();
        $data['total_ukg'] = $total_ukg;
        
        $total_I = $this->db->get_where(db_prefix().'contacts', array('Class' => 'Class I'))->num_rows();
        $data['total_I'] = $total_I;
        
        $total_II = $this->db->get_where(db_prefix().'contacts', array('Class' => 'Class II'))->num_rows();
        $data['total_II'] = $total_II;
        
        $total_III = $this->db->get_where(db_prefix().'contacts', array('Class' => 'Class III'))->num_rows();
        $data['total_III'] = $total_III;
        
        $total_IV = $this->db->get_where(db_prefix().'contacts', array('Class' => 'Class IV'))->num_rows();
        $data['total_IV'] = $total_IV;
        
        $total_V = $this->db->get_where(db_prefix().'contacts', array('Class' => 'Class V'))->num_rows();
        $data['total_V'] = $total_V;
        
        $total_VI = $this->db->get_where(db_prefix().'contacts', array('Class' => 'Class VI'))->num_rows();
        $data['total_VI'] = $total_VI;
        
        $total_VII = $this->db->get_where(db_prefix().'contacts', array('Class' => 'Class VII'))->num_rows();
        $data['total_VII'] = $total_VII;
        
        $total_VIII = $this->db->get_where(db_prefix().'contacts', array('Class' => 'Class VIII'))->num_rows();
        $data['total_VIII'] = $total_VIII;

        $data['user_dashboard_visibility'] = get_staff_meta(get_staff_user_id(), 'dashboard_widgets_visibility');

        if (!$data['user_dashboard_visibility']) {
            $data['user_dashboard_visibility'] = [];
        } else {
            $data['user_dashboard_visibility'] = unserialize($data['user_dashboard_visibility']);
        }
        $data['user_dashboard_visibility'] = json_encode($data['user_dashboard_visibility']);
        
        //$data['box_result'] = $this->db->get_where('tbldashboard_boxsetting')->result();
        $box_result = $this->db->get_where('tbldashboard_boxsetting')->result();
        if($box_result)
        {
            $ik = 0;
            foreach($box_result as $rr)
            {
                if($ik > 3)
                {
                    if($rr->value == '')
                    {
                        if($rr->link == 'clients')
                        {
                            $totalclient = $this->db->get_where(db_prefix().'clients')->num_rows();
                            $box_result[$ik]->value = $totalclient;
                        }
                        elseif($rr->link == 'proposals')
                        {
                            $totalclient = $this->db->get_where(db_prefix().'proposals')->num_rows();
                            $box_result[$ik]->value = $totalclient;
                        }
                    }
                }
                $ik++;
            }
        }
        
       // echo '<pre>'; print_r($box_result); die;
        
        $data['box_result'] = $box_result;

        $data = hooks()->apply_filters('before_dashboard_render', $data);
        //$this->load->view('admin/dashboard/dashboard', $data);
        $data['package_list'] = $this->db->get_where(db_prefix().'master_package')->result();
        $this->load->view('admin/dashboard/newDashboard', $data);
    }
    
    /* This is admin dashboard view */
    public function newDashboard()
    {
        $data['user_dashboard_visibility'] = [];
        $data['package_list'] = $this->db->get_where(db_prefix().'master_package')->result();
        $this->load->view('admin/dashboard/newDashboard', $data);
    }
    
    /* Agreements */
    public function agreements()
    {
        if ($this->input->post()) {
            $data                = $this->input->post();
            if ($id == '') {
                $data['created_date'] = date('Y-m-d h:i:s');
                $id      = $this->dashboard_model->addAgreement($data);
                $_id     = false;
                $success = false;
                $message = '';
                if ($id) {
                    $success       = true;
                    $_id           = $id;
                    $message       = _l('added_successfully', _l('Agreement'));
                    $uploadedFiles = handle_file_upload($id,'agreements', 'agreements');
                    if ($uploadedFiles && is_array($uploadedFiles)) {
                        foreach ($uploadedFiles as $file) {
                            $this->misc_model->add_attachment_to_database($id, 'agreements', [$file]);
                        }
                    }
                }
                echo json_encode([
                    'success' => $success,
                    'id'      => $_id,
                    'message' => $message,
                ]);
            } else {
                $success = $this->dashboard_model->updateAgreement($data, $id);
                
                if($_FILES['agreements']['name'] != '')
                {
                    $this->dashboard_model->delete_image($id);
                    $uploadedFiles = handle_file_upload($id,'agreements', 'agreements');
                    if ($uploadedFiles && is_array($uploadedFiles)) {
                        foreach ($uploadedFiles as $file) {
                            $this->misc_model->add_attachment_to_database($id, 'agreements', [$file]);
                        }
                    }
                }
                
                $message = '';
                if ($success) {
                    $message = _l('updated_successfully', _l('Agreement'));
                }
                echo json_encode([
                    'success' => $success,
                    'message' => $message,
                    'id'      => $id,
                ]);
            }
            die;
        }
        else
        {
            echo json_encode([
                    'success' => false,
                    'message' => 'Documents are not submitted, try again!',
                    'id'      => false,
                ]);
        }
    }
    
    /* Ladger */
    public function ledger($id)
    {
        $data['student_details'] = $this->db->get_where(db_prefix().'contacts', array('userid' => $id))->row();
        $data['packageamount'] =  $this->db->select('package_id,package_amount,deposit_amount,admission_year')->get_where(db_prefix().'student_package',array('userid' => $id))->row();
        $data['package_details'] = $this->db->get_where(db_prefix().'master_package', array('id' => $data['packageamount']->package_id))->row('name');
        $data['deposit_result'] = $this->db->get_where(db_prefix().'student_fees_deposit', array('userid' => $id))->result();
        $this->load->view('admin/dashboard/ledger', $data);
    }

    /* This is admin dashboard view */
    public function newDashboard2()
    {
        $data['user_dashboard_visibility'] = [];
        $data['package_list'] = $this->db->get_where(db_prefix().'master_package')->result();
        $this->load->view('admin/dashboard/newDashboard2', $data);
    }
    
    /* Staff list */
    public function staffDashboard()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('staff_dashboard');
        }
    }
    
    /* Staff list */
    public function dayPayListData()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('dayPayList');
        }
    }

    public function table()
    {
        if (has_permission('customers', '', 'view')) {
            if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
                ajax_access_denied();
            }
        }

        $this->app->get_table_data('clients');
    }
    
    public function table__()
    {
        if (has_permission('customers', '', 'view')) {
            if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
                ajax_access_denied();
            }
        }

        $this->app->get_table_data('clients_dashboard');
    }

    public function packagewiseList($package_id)
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('packagewise_student', [
                'package_id'   => $package_id
            ]);
        }
        
        //$this->app->get_table_data('clients_dashboard');
    }

    /*
    *   @function:  feedLedger
    */
    public  function feesLedger($id){
        /*
        //$data['student_details'] = $this->db->get_where(db_prefix().'contacts', array('userid' => $id))->row();
        $data['packageamount'] =  $this->db->select('package_amount,deposit_amount')->get_where(db_prefix().'student_package',array('userid' => $id))->row();
        $data['deposit_result'] = $this->db->get_where(db_prefix().'student_fees_deposit', array('userid' => $id))->result();
        echo $this->load->view('admin/dashboard/ladgerModel',$data,true);
        */
        
        $data['student_details'] = $this->db->get_where(db_prefix().'contacts', array('userid' => $id))->row();
        $data['packageamount'] =  $this->db->select('package_amount,deposit_amount,userid,package_id,admission_year,admission_date')->get_where(db_prefix().'student_package',array('userid' => $id))->row();
        $data['deposit_result'] = $this->db->get_where(db_prefix().'student_fees_deposit', array('userid' => $id, 'management_status' => 1))->result();
        echo $this->load->view('admin/collectfees/ladgerModel',$data,true);
    }
    
    /*
    *   @function:  feedLedger
    */
    public function studentdatalist($id){
        $data['transport_result'] = $this->db->get_where(db_prefix().'transport')->result();
        
        //echo $this->input->get('group');
        //die;

        $group         = !$this->input->get('group') ? 'profile' : $this->input->get('group');
        $data['group'] = $group;

        if ($group != 'contacts' && $contact_id = $this->input->get('contactid')) {
            //redirect(admin_url('clients/client/' . $id . '?group=contacts&contactid=' . $contact_id));
        }
                // Customer groups
        $data['groups'] = $this->clients_model->get_groups();

        if ($id == '') {
            $title = _l('add_new', _l('client_lowercase'));
        } else {
            $client                = $this->clients_model->get($id);
            $data['customer_tabs'] = get_customer_profile_tabs();

            if (!$client) {
                show_404();
            }
            
            $feesmodule = [];
            $studentshift = $this->db->get_where(db_prefix().'contacts', array('userid' => $client->userid))->row('Shift');
            if($studentshift)
            {
                $feesmodule = $this->db->get_where(db_prefix().'school_fees', array('shift' => $studentshift))->row();
            }
            
            $data['school_fees'] = $feesmodule;

            $data['contacts'] = $this->clients_model->get_contacts($id);
            $data['tab']      = isset($data['customer_tabs'][$group]) ? $data['customer_tabs'][$group] : null;

            /*
            if (!$data['tab']) {
                show_404();
            }
            */

            // Fetch data based on groups
            if ($group == 'profile') {
                $data['customer_groups'] = $this->clients_model->get_customer_groups($id);
                $data['customer_admins'] = $this->clients_model->get_admins($id);
            } elseif ($group == 'attachments') {
                $data['attachments'] = get_all_customer_attachments($id);
            } elseif ($group == 'vault') {
                $data['vault_entries'] = hooks()->apply_filters('check_vault_entries_visibility', $this->clients_model->get_vault_entries($id));

                if ($data['vault_entries'] === -1) {
                    $data['vault_entries'] = [];
                }
            } elseif ($group == 'estimates') {
                $this->load->model('estimates_model');
                $data['estimate_statuses'] = $this->estimates_model->get_statuses();
            } elseif ($group == 'invoices') {
                $this->load->model('invoices_model');
                $data['invoice_statuses'] = $this->invoices_model->get_statuses();
            } elseif ($group == 'credit_notes') {
                $this->load->model('credit_notes_model');
                $data['credit_notes_statuses'] = $this->credit_notes_model->get_statuses();
                $data['credits_available']     = $this->credit_notes_model->total_remaining_credits_by_customer($id);
            } elseif ($group == 'payments') {
                $this->load->model('payment_modes_model');
                $data['payment_modes'] = $this->payment_modes_model->get();
            } elseif ($group == 'notes') {
                $data['user_notes'] = $this->misc_model->get_notes($id, 'customer');
            } elseif ($group == 'projects') {
                $this->load->model('projects_model');
                $data['project_statuses'] = $this->projects_model->get_project_statuses();
            } elseif ($group == 'statement') {
                if (!has_permission('invoices', '', 'view') && !has_permission('payments', '', 'view')) {
                    set_alert('danger', _l('access_denied'));
                    //redirect(admin_url('clients/client/' . $id));
                }

                $data = array_merge($data, prepare_mail_preview_data('customer_statement', $id));
            } elseif ($group == 'map') {
                if (get_option('google_api_key') != '' && !empty($client->latitude) && !empty($client->longitude)) {
                    $this->app_scripts->add('map-js', base_url($this->app_scripts->core_file('assets/js', 'map.js')) . '?v=' . $this->app_css->core_version());

                    $this->app_scripts->add('google-maps-api-js', [
                        'path'       => 'https://maps.googleapis.com/maps/api/js?key=' . get_option('google_api_key') . '&callback=initMap',
                        'attributes' => [
                            'async',
                            'defer',
                            'latitude'       => "$client->latitude",
                            'longitude'      => "$client->longitude",
                            'mapMarkerTitle' => "$client->company",
                        ],
                        ]);
                }
            }

            $data['staff'] = $this->staff_model->get('', ['active' => 1]);
            //$data['user_result'] = $this->db->get_where(db_prefix.'contacts', array('userid' => $client->userid))->row();

            $data['client'] = $client;
            $title          = $client->company;

            // Get all active staff members (used to add reminder)
            $data['members'] = $data['staff'];

            if (!empty($data['client']->company)) {
                // Check if is realy empty client company so we can set this field to empty
                // The query where fetch the client auto populate firstname and lastname if company is empty
                if (is_empty_customer_company($data['client']->userid)) {
                    $data['client']->company = '';
                }
            }
        }

        $this->load->model('currencies_model');
        $data['currencies'] = $this->currencies_model->get();

        if ($id != '') {
            $customer_currency = $data['client']->default_currency;

            foreach ($data['currencies'] as $currency) {
                if ($customer_currency != 0) {
                    if ($currency['id'] == $customer_currency) {
                        $customer_currency = $currency;

                        break;
                    }
                } else {
                    if ($currency['isdefault'] == 1) {
                        $customer_currency = $currency;

                        break;
                    }
                }
            }

            if (is_array($customer_currency)) {
                $customer_currency = (object) $customer_currency;
            }

            $data['customer_currency'] = $customer_currency;

            $slug_zip_folder = (
                $client->company != ''
                ? $client->company
                : get_contact_full_name(get_primary_contact_user_id($client->userid))
            );

            $data['zip_in_folder'] = slug_it($slug_zip_folder);
        }

        $data['bodyclass'] = 'customer-profile dynamic-create-groups';
        $data['title']     = $title;
        //echo $this->load->view('admin/dashboard/studentdatalist',$data,true);
        
        $data['student_details'] = $this->db->get_where(db_prefix().'contacts', array('userid' => $id))->row();
        $data['packageamount'] =  $this->db->select('package_amount,deposit_amount,userid,package_id,admission_year,admission_date')->get_where(db_prefix().'student_package',array('userid' => $id))->row();
        $data['deposit_result'] = $this->db->get_where(db_prefix().'student_fees_deposit', array('userid' => $id))->result();
        echo $this->load->view('admin/clients/dashboard_profile',$data,true);
    }
    
    /*
    *   @function:  feedLedger
    */
    public  function feesLedger_($id){
        /*
        $data['student_details'] = $this->db->get_where(db_prefix().'contacts', array('userid' => $id))->row();
        $data['packageamount'] =  $this->db->select('package_amount,deposit_amount')->get_where(db_prefix().'student_package',array('userid' => $id))->row();
        $data['deposit_result'] = $this->db->get_where(db_prefix().'student_fees_deposit', array('userid' => $id))->result();
        echo $this->load->view('admin/collectfees/ladgerModel_',$data,true);
        */
        
        $data['student_details'] = $this->db->get_where(db_prefix().'contacts', array('userid' => $id))->row();
        $data['packageamount'] =  $this->db->select('package_amount,deposit_amount,userid,package_id,admission_year,admission_date')->get_where(db_prefix().'student_package',array('userid' => $id))->row();
        $data['deposit_result'] = $this->db->get_where(db_prefix().'student_fees_deposit', array('userid' => $id, 'management_status' => 1))->result();
        echo $this->load->view('admin/collectfees/ladgerModel',$data,true);
    
    }

    /**
    *   Function: getSubCategory
    */
    public function studentList()
    {
        $classname = $_POST['classname'];
        $html = '';
        if($classname)
        {
            $class = str_replace('_', ' ', $classname);
            $html = $this->db->select('userid,firstname,middlename,lastname,Father_Mobile,Father_Name,registration_id,Class,Admission_Year')->get_where(db_prefix().'contacts', array('Class' => $class))->result();
        }
        echo json_encode($html);
    }
   
    /**
    *   Function: getSubCategory Class wise
    */
    public function studentClassWiseList($classname)
    {
        $html = '';
        if($classname)
        {
            $class = str_replace('_', ' ', $classname);
            $html = $this->db->select('userid,firstname,middlename,lastname,Father_Mobile,Father_Name,registration_id,Class,Admission_Year')->get_where(db_prefix().'contacts', array('Class' => $class))->result();
        }
        echo json_encode($html);
    }
    
    /**
    *   Function: getSubCategory
    */
    public function selectStudent()
    {
        $classname = $_POST['classname'];
        $sid = $_POST['sid'];
        $html = '';
        if($classname)
        {
            $class = str_replace('_', ' ', $classname);
            //$html = $this->db->select('userid,firstname,middlename,lastname,Father_Mobile,Father_Name,registration_id,Class')->get_where(db_prefix().'contacts', array('Class' => $class, 'userid' => $sid))->result();
            $this->db->select('a.userid,a.firstname,a.middlename,a.lastname,a.Father_Mobile,a.Father_Name,a.registration_id,a.Class, b.package_amount as amount,b.deposit_amount as deposit_amount,b.last_payment_date,c.name,c.id as package_id,a.Admission_Year');
            $this->db->from('contacts a');
            $this->db->join('student_package b','b.userid = a.userid', 'LEFT');
            $this->db->join('master_package c','c.id = b.package_id', 'LEFT');
            //$this->db->order_by('b.id', 'DESC');
            //$this->db->group_by('b.userid');
            $this->db->where('a.userid',$sid);
            $html = $this->db->get()->result();
        }
        echo json_encode($html);
    }
    
    /**
    *   Function: selectStudentInvoice
    */
    public function selectStudentInvoice()
    {
        $classname = $_POST['classname'];
        $sid = $_POST['sid'];
        $html = '';
        if($sid)
        {
            $html =  $this->db->select('deposit_date,note,payment_mode,deposit_amount,userid,id,management_status')->order_by('id', 'desc')->get_where(db_prefix().'student_fees_deposit',array('userid'=>$sid))->result();
        }
        echo json_encode($html);
    }
    
    /**
    *   Function: getSubCategory
    */
    public function getStudentPackage()
    {
       $sid = $_POST['sid'];
        $html = '';
        if($sid)
        {
            $studentpackage_id = $this->db->get_where(db_prefix().'student_package',array('userid' => $sid))->row('package_id');
            $html = $studentpackage_id;
        }
        echo json_encode($html);
    }

    /* Get item by id / ajax */
    public function searchStudent($classid, $studentname)
    {
        if ($this->input->is_ajax_request()) {
            $item                     = $this->invoice_items_model->get($id);
            $item->long_description   = nl2br($item->long_description);
            $item->custom_fields_html = render_custom_fields('items', $id, [], ['items_pr' => true]);
            $item->custom_fields      = [];

            $cf = get_custom_fields('items');

            foreach ($cf as $custom_field) {
                $val = get_custom_field_value($id, $custom_field['id'], 'items_pr');
                if ($custom_field['type'] == 'textarea') {
                    $val = clear_textarea_breaks($val);
                }
                $custom_field['value'] = $val;
                $item->custom_fields[] = $custom_field;
            }

            echo json_encode($item);
        }
    }
    
     /* feesdeposit */
    public function feesdeposit($userids)
    {
        if ($this->input->is_ajax_request()) {
                
            $userid = $this->input->post('student_id');
            $plandetails = $this->db->get_where(db_prefix().'student_package', array('userid' => $userid))->result();
            
            if(count($plandetails) > 0)
            {
                
            }
            else
            {
                $packageamount = $this->db->get_where(db_prefix().'master_package', array('id' => $this->input->post('package_id')))->row('amount');
                $postpackage['package_amount'] = $packageamount;
                $postpackage['package_id'] = $this->input->post('package_id');
                $postpackage['last_payment_date'] = date('Y-m-d h:i:s');
                $postpackage['userid'] = $userid;
                $this->db->insert(db_prefix().'student_package', $postpackage);
                $plandetails = $this->db->get_where(db_prefix().'student_package', array('userid' => $userid))->result();
            }
            
          //  echo  $this->db->last_query();
            if(count($plandetails) > 0)
            {
                $postData['package_id'] = $plandetails[0]->package_id;
                $postData['userid']     = $userid;
                $postData['deposit_date']     =date('Y-m-d', strtotime($this->input->post('deposit_date')));
                $postData['payment_mode'] = $this->input->post('payment_mode');
                $postData['check_no'] = $this->input->post('check_no');
                $postData['cheque_date'] = $this->input->post('cheque_date');
                $postData['bank_name'] = $this->input->post('bank_name');
                $postData['branch_name'] = $this->input->post('branch_name');
                $postData['fees_type'] = $this->input->post('fees_type');
                $postData['deposit_amount'] = $this->input->post('deposit_amount');
                $postData['installment'] = $this->input->post('installment');
                $postData['accounted_id'] = get_staff_user_id();
                $postData['accounted_update_date'] = date('Y-m-d h:i:s');
                $postData['note'] = $this->input->post('note');
                $postData['dd_upi_online'] = @$this->input->post('dd_upi_online');
                if($postData['deposit_amount'] > 0)
                {
                    $this->db->insert(db_prefix().'student_fees_deposit', $postData);
                    $stfee =  $this->db->insert_id();
                    if($plandetails[0]->deposit_amount != '')
                    {
                        //$packageData['deposit_amount'] = $plandetails[0]->deposit_amount + $postData['deposit_amount'];
                    }
                    else
                    {
                        //$packageData['deposit_amount'] = $postData['deposit_amount'];
                    }
                    $packageData['last_payment_date'] = date('Y-m-d h:i:s');
                    $this->db->where('id', $plandetails[0]->id);
                    $this->db->update(db_prefix().'student_package', $packageData);
                       
                    $message = _l('Fees deposit successful!', _l('student'));
                    echo json_encode([
                        'success' => $plandetails[0]->package_id ? true : false,
                        'message' => $message,
                        'url' => base_url().'admin/dashboard/studentPrint/'.$userid.'/'.$stfee
                    ]); 
                }
                else
                {
                    
                  $message = _l('Fees already deposited!', _l('student'));
                    echo json_encode([
                    'success' => $plandetails[0]->package_id ? true : false,
                    'message' => $message,
                 ]);
                    
                }
            }
            else
            {
                  $message = _l('User Id Not found', _l('student'));
                    echo json_encode([
                    'success' => $plandetails[0]->package_id ? true : false,
                    'message' => $message,
                 ]);
            }
        }
    }
    
    public function studentPrint($id,$invoice){
        $data['student_details'] = $this->db->get_where(db_prefix().'contacts', array('userid' => $id))->row();
        $invoice_details =    $this->db->get_where(db_prefix().'student_fees_deposit', array('id' => $invoice))->row();
        $data['invoice_details'] = $invoice_details;
        $packagenameArr = $this->db->select('name,deduction_mode')->get_where(db_prefix().'master_package', array('id' => $invoice_details->package_id))->row();
        $packagename = $packagenameArr->name;
        $data['packagename'] = ($packagename != '')?$packagename:'NA';
        $deduction_mode = ($packagenameArr->deduction_mode == 2)?"NIL":"0.00";
        $data['deduction_mode'] = $deduction_mode;
        $accountantnameArr = $this->db->select('firstname,lastname')->get_where(db_prefix().'staff', array('staffid' => $invoice_details->accounted_id))->row();
        $accountantname = $accountantnameArr->firstname.' '.$accountantnameArr->lastname;
        $data['accountantname'] = ($accountantname != '')?$accountantname:'NA';
        $this->load->view('theisb-invoice/index',$data);
    }

    /* ---------------------------------------------------
    *   @Function: feesCollectRecord
    *---------------------------------------------------*/
    public function feesCollectRecord()
    {
        $pendingStudent = $this->db->get_where(db_prefix().'student_fees_deposit', array('management_status' => 0))->num_rows();
        $approvedStudent = $this->db->get_where(db_prefix().'student_fees_deposit', array('management_status' => 1))->num_rows();
        $resubmitStudent = $this->db->get_where(db_prefix().'student_fees_deposit', array('management_status' => 2))->num_rows();
       
       $data = array(
                'pendingStudent' => $pendingStudent,
                'approvedStudent' => $approvedStudent,
                'resubmitStudent' => $resubmitStudent
            );
        echo json_encode($data);
    }

    public function approvedStudentFee($para1='')
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('approvedStudentFee', [
                'payment_status'   => $para1
            ]);
        }
    }
    
    public function getAgreementsList()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('agreementsList');
        }
    }
    
    public function dayBookList()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('daybook_students');
        }
    }
    
    public function totalRTEStudents()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('total_rte_students');
        }
    }
    
    public function totalPaidStudents($para1 = '')
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('total_paid_students', [
                'payment_status'   => $para1
            ]);
        }
    }
    
     public function totalunPaidStudents($para1 = '')
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('total_unpaid_students', [
                'payment_status'   => $para1
            ]);
        }
    }
    
    
    
    public function resubmitStatusFees()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('resubmitStatusFees', [
                'payment_status'   => 2
            ]);
        }
    }

    /* Chart weekly payments statistics on home page / ajax */
    public function weekly_payments_statistics($currency)
    {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->dashboard_model->get_weekly_payments_statistics($currency));
            die();
        }
    }
    
    /* Reports FUnstion */
    public function reportData($para1=''){
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('approvedStudentFee', [
                'payment_status'   => $para1
            ]);
        }
    }
    
  public function shiftwiseStudent($para1 = '')
    {
        if ($this->input->is_ajax_request()) {
            $_SESSION['shift'] = $para1;
            $this->app->get_table_data('student_list_shiftwise', [
                'shift'   => $para1
            ]);
        }
    }
    
}
