<?php

defined('BASEPATH') or exit('No direct script access allowed');
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
class Dashboard extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('dashboard_model');
        if($this->academic_session=='2024-25'){            
		  $this->contact_tbl_last_year = '_2023_24';
        }
        else{
          $this->contact_tbl_last_year = '_2022_23';            
        }
        
    }

    /* This is admin dashboard view */
    public function index()
    {
        $data['academic_session'] = $this->academic_session;
        close_setup_menu();
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('approvedStudentFee',[
                'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
        $this->load->model('departments_model');
        $this->load->model('todo_model');
        $data['departments'] = $this->departments_model->get();

        $data['todos'] = $this->todo_model->get_todo_items(0);
        // Only show last 5 finished todo items
        $this->todo_model->setTodosLimit(5);
        $data['todos_finished']            = $this->todo_model->get_todo_items(1);
        $data['upcoming_events_next_week'] = $this->dashboard_model->get_upcoming_events_next_week();
        $data['upcoming_events']           = $this->dashboard_model->get_upcoming_events();
        $data['title']                     = _l('dashboard_string');
        $this->load->model('currencies_model');
        $data['currencies']    = $this->currencies_model->get();
        $data['base_currency'] = $this->currencies_model->get_base_currency();
        $data['activity_log']  = $this->misc_model->get_activity_log();
        // Tickets charts
        $tickets_awaiting_reply_by_status     = $this->dashboard_model->tickets_awaiting_reply_by_status();
        $tickets_awaiting_reply_by_department = $this->dashboard_model->tickets_awaiting_reply_by_department();

        $data['tickets_reply_by_status']              = json_encode($tickets_awaiting_reply_by_status);
        $data['tickets_awaiting_reply_by_department'] = json_encode($tickets_awaiting_reply_by_department);

        $data['tickets_reply_by_status_no_json']              = $tickets_awaiting_reply_by_status;
        $data['tickets_awaiting_reply_by_department_no_json'] = $tickets_awaiting_reply_by_department;

        $data['projects_status_stats'] = json_encode($this->dashboard_model->projects_status_stats());
        $data['leads_status_stats']    = json_encode($this->dashboard_model->leads_status_stats());
        $data['google_ids_calendars']  = $this->misc_model->get_google_calendar_ids();
        $data['bodyclass']             = 'dashboard invoices-total-manual';
        $this->load->model('announcements_model');
        $data['staff_announcements']             = $this->announcements_model->get();
        $data['total_undismissed_announcements'] = $this->announcements_model->get_total_undismissed_announcements();

        $this->load->model('projects_model');
        $data['projects_activity'] = $this->projects_model->get_activity('', hooks()->apply_filters('projects_activity_dashboard_limit', 20));
        add_calendar_assets();
        $this->load->model('utilities_model');
        $this->load->model('estimates_model');
        $data['estimate_statuses'] = $this->estimates_model->get_statuses();

        $this->load->model('proposals_model');
        $data['proposal_statuses'] = $this->proposals_model->get_statuses();

        $wps_currency = 'undefined';
        if (is_using_multiple_currencies()) {
            $wps_currency = $data['base_currency']->id;
        }
        $data['weekly_payment_stats'] = json_encode($this->dashboard_model->get_weekly_payments_statistics($wps_currency));

        $data['dashboard'] = true;
        
        $total_playgrop_ = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Playgroup'))->num_rows();
        $total_playgrop = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'PG'))->num_rows();
        $data['total_playgrop'] = $total_playgrop + $total_playgrop_;
        
        //$total_nursery = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Nursery'))->num_rows();
		$total_nursery = $this->db->select('a.userid')->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->where('b.active',1)->where('a.Class','Nursery')->get()->num_rows();
        $data['total_nursery'] = $total_nursery;
        
        //$total_lkg = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'LKG'))->num_rows();
		$total_lkg = $this->db->select('a.userid')->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->where('b.active',1)->where('a.Class','LKG')->get()->num_rows();
        $data['total_lkg'] = $total_lkg;
        
        //$total_ukg = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'UKG'))->num_rows();
		$total_ukg = $this->db->select('a.userid')->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->where('b.active',1)->where('a.Class','UKG')->get()->num_rows();
        $data['total_ukg'] = $total_ukg;
        
        //$total_I = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class I'))->num_rows();
		$total_I = $this->db->select('a.userid')->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->where('b.active',1)->where('a.Class','Class I')->get()->num_rows();
        $data['total_I'] = $total_I;
        
        //$total_II = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class II'))->num_rows();
		$total_II = $this->db->select('a.userid')->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->where('b.active',1)->where('a.Class','Class II')->get()->num_rows();
        $data['total_II'] = $total_II;
        
        //$total_III = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class III'))->num_rows();
		$total_III = $this->db->select('a.userid')->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->where('b.active',1)->where('a.Class','Class III')->get()->num_rows();
        $data['total_III'] = $total_III;
        
        //$total_IV = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class IV'))->num_rows();
		$total_IV = $this->db->select('a.userid')->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->where('b.active',1)->where('a.Class','Class IV')->get()->num_rows();
        $data['total_IV'] = $total_IV;
        
        //$total_V = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class V'))->num_rows();
		$total_V = $this->db->select('a.userid')->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->where('b.active',1)->where('a.Class','Class V')->get()->num_rows();
        $data['total_V'] = $total_V;
        
        //$total_VI = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class VI'))->num_rows();
		$total_VI = $this->db->select('a.userid')->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->where('b.active',1)->where('a.Class','Class VI')->get()->num_rows();
        $data['total_VI'] = $total_VI;
        
        //$total_VII = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class VII'))->num_rows();
		$total_VII = $this->db->select('a.userid')->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->where('b.active',1)->where('a.Class','Class VII')->get()->num_rows();
        $data['total_VII'] = $total_VII;
        
        //$total_VIII = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class VIII'))->num_rows();
		$total_VIII = $this->db->select('a.userid')->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->where('b.active',1)->where('a.Class','Class VIII')->get()->num_rows();
        $data['total_VIII'] = $total_VIII;
        
        //$total_IX = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class IX'))->num_rows();
		$total_IX = $this->db->select('a.userid')->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->where('b.active',1)->where('a.Class','Class IX')->get()->num_rows();
        $data['total_IX'] = $total_IX;
 
        //$total_X = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class X'))->num_rows();
		$total_X = $this->db->select('a.userid')->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->where('b.active',1)->where('a.Class','Class X')->get()->num_rows();
        $data['total_X'] = $total_X;

        $total_XI = $this->db->select('a.userid')->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->where('b.active',1)->where('a.Class','Class XI')->get()->num_rows();
        $data['total_XI'] = $total_XI;
        
        $total_XII = $this->db->select('a.userid')->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->where('b.active',1)->where('a.Class','Class XII')->get()->num_rows();
        $data['total_XII'] = $total_XII;
 
        $total_PlaygroupN = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Playgroup', 'Admission_Year' => $this->academic_session))->num_rows();
        $data['total_PlaygroupN'] = $total_PlaygroupN;
        $total_nurseryN = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Nursery', 'Admission_Year' => $this->academic_session))->num_rows();
        $data['total_nurseryN'] = $total_nurseryN;
        
        $total_lkgN = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'LKG', 'Admission_Year' => $this->academic_session))->num_rows();
        $data['total_lkgN'] = $total_lkgN;
        
        $total_ukgN = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'UKG', 'Admission_Year' => $this->academic_session))->num_rows();
        $data['total_ukgN'] = $total_ukgN;
        
        $total_IN = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class I', 'Admission_Year' => $this->academic_session))->num_rows();
        $data['total_IN'] = $total_IN;
        
        $total_IIN = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class II', 'Admission_Year' => $this->academic_session))->num_rows();
        $data['total_IIN'] = $total_IIN;
        
        $total_IIIN = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class III', 'Admission_Year' => $this->academic_session))->num_rows();
        $data['total_IIIN'] = $total_IIIN;
        
        $total_IVN = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class IV', 'Admission_Year' => $this->academic_session))->num_rows();
        $data['total_IVN'] = $total_IVN;
        
        $total_VN = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class V', 'Admission_Year' => $this->academic_session))->num_rows();
        $data['total_VN'] = $total_VN;
        
        $total_VIN = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class VI', 'Admission_Year' => $this->academic_session))->num_rows();
        $data['total_VIN'] = $total_VIN;
        
        $total_VIIN = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class VII', 'Admission_Year' => $this->academic_session))->num_rows();
        $data['total_VIIN'] = $total_VIIN;
        
        $total_VIIIN = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class VIII', 'Admission_Year' => $this->academic_session))->num_rows();
        $data['total_VIIIN'] = $total_VIIIN;
        
        $total_IXN = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class IX', 'Admission_Year' => $this->academic_session))->num_rows();
        $data['total_IXN'] = $total_IXN;
 
        $total_XN = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class X', 'Admission_Year' => $this->academic_session))->num_rows();
        $data['total_XN'] = $total_XN;

        $total_XIN = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class XI', 'Admission_Year' => $this->academic_session))->num_rows();
        $data['total_XIN'] = $total_XIN;

        $total_XIIN = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class XII', 'Admission_Year' => $this->academic_session))->num_rows();
        $data['total_XIIN'] = $total_XIIN;
 
        $data['user_dashboard_visibility'] = get_staff_meta(get_staff_user_id(), 'dashboard_widgets_visibility');

        if (!$data['user_dashboard_visibility']) {
            $data['user_dashboard_visibility'] = [];
        } else {
            $data['user_dashboard_visibility'] = unserialize($data['user_dashboard_visibility']);
        }
        $data['user_dashboard_visibility'] = json_encode($data['user_dashboard_visibility']);
        
        //$data['box_result'] = $this->db->get_where('tbldashboard_boxsetting')->result();
        $box_result = $this->db->get_where('tbldashboard_boxsetting')->result();
        if($box_result)
        {
            $ik = 0;
            foreach($box_result as $rr)
            {
                if($ik > 3)
                {
                    if($rr->value == '')
                    {
                        if($rr->link == 'clients')
                        {
                            $totalclient = $this->db->get_where(db_prefix().'clients')->num_rows();
                            $box_result[$ik]->value = $totalclient;
                        }
                        elseif($rr->link == 'proposals')
                        {
                            $totalclient = $this->db->get_where(db_prefix().'proposals')->num_rows();
                            $box_result[$ik]->value = $totalclient;
                        }
                    }
                }
                $ik++;
            }
        }        
        // echo '<pre>'; print_r($box_result); die;        
        $data['box_result'] = $box_result;
        $data = hooks()->apply_filters('before_dashboard_render', $data);
        //$this->load->view('admin/dashboard/dashboard', $data);
        //$data['package_list'] = $this->db->get_where(db_prefix().'master_package',array('acedmic_year'=>$this->academic_session))->result();
        $data['package_list'] = $this->db->order_by('id', 'desc')->get_where(db_prefix().'master_package')->result();
		$data['class_list'] = $this->db->order_by('name','asc')->get_where(db_prefix().'master_class')->result();
        $this->load->view('admin/dashboard/newDashboard', $data);
    }
    
    /**
     *Function @ Update Email
     **/
    public function emailIDUpdate(){
        /*
        $studentList = $this->db->get_where(db_prefix().'contacts_2023_24')->result();
        if($studentList){
            foreach($studentList as $res){
                $sid = $res->userid;
                
                $invID = str_pad($sid, 4, '0', STR_PAD_LEFT);
                $nemail = 'isb'.$invID;
                //$postData['email'] = $nemail;
                
                if($res->paa == ''){
                    $pass_ = rand(10000, 99999);
                    $postData['paa'] = $pass_;
                    $postData['password'] = app_hash_password($pass_);
                    $this->db->where('userid', $res->userid);
                    $this->db->update(db_prefix().'contacts_2023_24', $postData);
                }
            }
        }*/
    }

    function send_mail()
    {
        //$email = 'tanmay@immersiveinfotech.com';
        $email = 'theisb.ac.in@gmail.com';
        $subject = 'Day Book Report - '.date('d M, Y');
        $message = '';
        
        $type = 'All';
        $start_date = date('3-m-Y');
        $end_date = date('d-m-Y');

        $student_all = $this->dashboard_model->totalDayBookNStudentCount($type, $start_date, $end_date);
        $t_all = $this->dashboard_model->totalDayBookN($type, $start_date, $end_date);
        $cash = $this->dashboard_model->totalDayBookN('cash', $start_date, $end_date);
        $cheque = $this->dashboard_model->totalDayBookN('cheque', $start_date, $end_date);
        $dd = $this->dashboard_model->totalDayBookN('dd', $start_date, $end_date);
        $upi = $this->dashboard_model->totalDayBookN('upi', $start_date, $end_date);
        $online = $this->dashboard_model->totalDayBookN('online', $start_date, $end_date);
        $IMPS = $this->dashboard_model->totalDayBookN('IMPS', $start_date, $end_date);
        $card = $this->dashboard_model->totalDayBookN('card', $start_date, $end_date);
        $data = array(
                'student_count' => $student_all,
                't_all' => (!empty($t_all->total_amount)) ? $t_all->total_amount : '0',
                'cash' => (!empty($cash->total_amount)) ? $cash->total_amount : '0',
                'cheque' => (!empty($cheque->total_amount)) ? $cheque->total_amount : '0',
                'dd' => (!empty($dd->total_amount)) ? $dd->total_amount : '0',
                'upi' => (!empty($upi->total_amount)) ? $upi->total_amount : '0',
                'online' => (!empty($online->total_amount)) ? $online->total_amount : '0',
                'IMPS' => (!empty($IMPS->total_amount)) ? $IMPS->total_amount : '0',
                'card' => (!empty($card->total_amount)) ? $card->total_amount : '0',
                'n_start_date'=>$start_date,
                'n_end_date'=>$end_date,
            );

        $data['title'] = date('d M, Y');
        $post['payment_mode_filter'] = 'All';
        $post['date_timepicker_start'] = date('3-m-Y');
        $post['date_timepicker_end'] = date('d-m-Y');
        $day_book_list = $this->dashboard_model->dayBookReport($post);

        /*echo '<pre>'; print_r($day_book_list); die();*/

        $data['daybook_result'] = $day_book_list;

        $message .= $this->load->view('admin/dashboard/email/email-temp-daybook', $data, true);

/*
        $message .= '<table class="table dataTable no-footer" id="day_book_table_dataa" role="grid" aria-describedby="day_book_table_dataa_info">
                <thead>
                    <tr role="row">
                        <th>Student Name</th>
                        <th>Father Name</th>
                        <th">Mother Name</th>
                        <th>Class</th>
                        <th>Father Mobile</th>
                        <th>Mother Mobile</th>
                        <th>Login Details</th>
                        <th>Academic Year</th>
                        <th>Date</th>
                        <th>Amount</th>
                        <th>Mode</th>
                        <th>Transaction ID/Cheque NO</th>
                        <th>Note</th>
                        <th>Accountant Name</th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="odd">
                        <td>Aaradhya Chouhan</td>
                        <td>Vijay Singh Chouhan</td>
                        <td>Vinita Chouhan</td>
                        <td>Class IV</td>
                        <td>9926688787</td>
                        <td>8964081981</td>
                        <td>
                            <b>ID: </b>aar787<br />
                            <b>Password: </b>aaradhya123
                        </td>
                        <td>2020-21(Due)</td>
                        <td>30-07-2021</td>
                        <td>10000</td>
                        <td>CHEQUE</td>
                        <td>Cheque N0:438064</td>
                        <td></td>
                        <td>JYOTI SINGH</td>
                    </tr>
                </tbody>
            </table>
';
*/
        $params = array(
            'to'        => $email,
            'subject'   => $subject,
            'html'      => $message,
            'from'      => 'info@theisb.in',
        );

        $request = 'https://api.sendgrid.com/api/mail.send.json';
        $headr = array();
        $pass = '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';
        // set authorization header
        $headr[] = 'Authorization: Bearer '.$pass;

        $session = curl_init($request);
        curl_setopt ($session, CURLOPT_POST, true);
        curl_setopt ($session, CURLOPT_POSTFIELDS, $params);
        curl_setopt($session, CURLOPT_HEADER, false);
        curl_setopt($session, CURLOPT_RETURNTRANSFER, true);

        // add authorization header
        curl_setopt($session, CURLOPT_HTTPHEADER,$headr);

        $response = curl_exec($session);
        //echo '<pre>'; print_r($response); die();
        curl_close($session);
        return $response;
    }     

    /* This is admin dashboard view */
    public function newDashboard()
    {
        $data['user_dashboard_visibility'] = [];
        $data['package_list'] = $this->db->get_where(db_prefix().'master_package')->result();
        $this->load->view('admin/dashboard/newDashboard', $data);
    }
    
    /* Agreements */
    public function agreements()
    {
        if ($this->input->post()) {
            $data                = $this->input->post();
            if ($id == '') {
                $data['created_date'] = date('Y-m-d h:i:s');
                $id      = $this->dashboard_model->addAgreement($data);
                $_id     = false;
                $success = false;
                $message = '';
                if ($id) {
                    $success       = true;
                    $_id           = $id;
                    $message       = _l('added_successfully', _l('Agreement'));
                    $uploadedFiles = handle_file_upload($id,'agreements', 'agreements');
                    if ($uploadedFiles && is_array($uploadedFiles)) {
                        foreach ($uploadedFiles as $file) {
                            $this->misc_model->add_attachment_to_database($id, 'agreements', [$file]);
                        }
                    }
                }
                echo json_encode([
                    'success' => $success,
                    'id'      => $_id,
                    'message' => $message,
                ]);
            } else {
                $success = $this->dashboard_model->updateAgreement($data, $id);
                
                if($_FILES['agreements']['name'] != '')
                {
                    $this->dashboard_model->delete_image($id);
                    $uploadedFiles = handle_file_upload($id,'agreements', 'agreements');
                    if ($uploadedFiles && is_array($uploadedFiles)) {
                        foreach ($uploadedFiles as $file) {
                            $this->misc_model->add_attachment_to_database($id, 'agreements', [$file]);
                        }
                    }
                }
                
                $message = '';
                if ($success) {
                    $message = _l('updated_successfully', _l('Agreement'));
                }
                echo json_encode([
                    'success' => $success,
                    'message' => $message,
                    'id'      => $id,
                ]);
            }
            die;
        }
        else
        {
            echo json_encode([
                    'success' => false,
                    'message' => 'Documents are not submitted, try again!',
                    'id'      => false,
                ]);
        }
    }

    /* Change Student Package */
    public function changeStudentPackage()
    {
        $status = '';
        $message = '';
        $data           =   $this->input->post();
        $id     =   $data['student_id'];
        if($id)
        {
            $class_name     =   $data['class_id'];
            $student_id     =   $data['student_id'];
            $packageid      =   $data['packagename'];
            $resone_note    =   $data['resone_note'];
            $packageArr = $this->db->get_where(db_prefix().'student_package', array('userid' => $id,'package_year'=>$this->academic_session))->result_array();
            if(count($packageArr) > 0)
            {                
                $newdata                =   $packageArr[0];
                $newdata['current_package_id'] =   $packageid;
                $newdata['transfer_by'] =   get_staff_user_id();
                $this->db->insert(db_prefix().'student_package_befor', $newdata);
                $this->db->delete(db_prefix().'student_package', array('userid' => $id,'package_year'=>$this->academic_session));

                $packageamount = $this->db->get_where(db_prefix().'master_package', array('id' => $packageid))->row('amount');
                $postpackage['package_amount']  = $packageamount;
                $postpackage['package_id']      = $packageid;
                $postpackage['userid']          = $id;
                $postpackage['deposit_amount']  = 0;
                $postpackage['admission_year']  = $newdata['admission_year'];
                $postpackage['package_year']    = $newdata['package_year'];
                $postpackage['accounted_id']    = get_staff_user_id();
                $postpackage['added_datetime']  = date('Y-m-d h:i:s');
                $postpackage['createddate']     = date('Y-m-d h:i:s');
                $postpackage['resone_note']     = $resone_note;
                $this->db->insert(db_prefix().'student_package', $postpackage);

                $studentFeesDeposit = $this->db->get_where(db_prefix().'student_fees_deposit', array('userid' => $id,'academic_year'=>$this->academic_session))->result();
                if($studentFeesDeposit)
                {
                    $this->db->delete(db_prefix().'student_fees_deposit', array('userid' => $id,'academic_year'=>$this->academic_session));
                    foreach($studentFeesDeposit as $res)
                    {
                        $depositdata['package_id']              = $res->package_id;
                        $depositdata['userid']                  = $res->userid;
                        $depositdata['invoice_id']              = $res->invoice_id;
                        $depositdata['deposit_date']            = $res->deposit_date;
                        $depositdata['payment_mode']            = $res->payment_mode;
                        $depositdata['check_no']                = $res->check_no;
                        $depositdata['cheque_date']             = $res->cheque_date;
                        $depositdata['bank_name']               = $res->bank_name;
                        $depositdata['branch_name']             = $res->branch_name;
                        $depositdata['fees_type']               = $res->fees_type;
                        $depositdata['installment']          	= $res->installment;
                        $depositdata['deposit_amount']          = $res->deposit_amount;
                        $depositdata['accounted_id']            = $res->accounted_id;
                        $depositdata['accounted_status']        = $res->accounted_status;
                        $depositdata['management_id']           = $res->management_id;
                        $depositdata['management_status']       = $res->management_status;
                        $depositdata['accounted_update_date']   = $res->accounted_update_date;
                        $depositdata['management_update_date']  = $res->management_update_date;
                        $depositdata['accounted_message']       = $res->accounted_message;
                        $depositdata['management_message']      = $res->management_message;
                        $depositdata['note']                    = $res->note;
                        $depositdata['dd_upi_online']           = $res->dd_upi_online;
                        $depositdata['academic_year']           = $res->academic_year;
                        $depositdata['status']                  = $res->status;
                        $depositdata['createddate']             = $res->createddate;
                        $depositdata['transaction_id']          = $res->transaction_id;
                        $depositdata['cheque_status']           = $res->cheque_status;
                        $depositdata['check_bounced_status']    = $res->check_bounced_status;
                        $depositdata['check_bounced_amount']    = $res->check_bounced_amount;
                        $depositdata['check_bounced_datetime']  = $res->check_bounced_datetime;
                        $depositdata['is_delete']    			= $res->is_delete;
                        $depositdata['deleted_by']    			= $res->deleted_by;
                        $depositdata['delete_reason']    		= $res->delete_reason;
						//echo '<pre>'; print_r($depositdata); die;exit();
                        $this->db->insert(db_prefix().'student_fees_deposit_befor', $depositdata);
                    }
                }

                $status = true;
                $message = 'Package update successful';
                set_alert('success', _l('Package update successful'));
                redirect($_SERVER['HTTP_REFERER']);
            }
            else
            {
                $currentYear = date('Y');
                $packageamount = $this->db->get_where(db_prefix().'master_package', array('id' => $packageid))->row('amount');
                $postpackage['package_amount']  = $packageamount;
                $postpackage['package_id']      = $packageid;
                $postpackage['userid']          = $id;
                $postpackage['deposit_amount']  = 0;
                $postpackage['admission_year']  = '';//$this->academic_session;
                $postpackage['package_year']    = $this->academic_session;
                $postpackage['accounted_id']    = get_staff_user_id();
                $postpackage['added_datetime']  = date('Y-m-d h:i:s');
                $postpackage['createddate']     = date('Y-m-d h:i:s');
                $postpackage['resone_note']     = $resone_note;
                $this->db->insert(db_prefix().'student_package', $postpackage);
                $plid = $this->db->insert_id();
                if($plid)
                {
                    $studentFeesDeposit = $this->db->get_where(db_prefix().'student_fees_deposit', array('userid' => $id,'academic_year'=>$this->academic_session))->result();
                    if($studentFeesDeposit)
                    {
                        $this->db->delete(db_prefix().'student_fees_deposit', array('userid' => $id,'academic_year'=>$this->academic_session));
                        foreach($studentFeesDeposit as $res)
                        {
                            $depositdata['package_id']              = $res->package_id;
							$depositdata['userid']                  = $res->userid;
							$depositdata['invoice_id']              = $res->invoice_id;
							$depositdata['deposit_date']            = $res->deposit_date;
							$depositdata['payment_mode']            = $res->payment_mode;
							$depositdata['check_no']                = $res->check_no;
							$depositdata['cheque_date']             = $res->cheque_date;
							$depositdata['bank_name']               = $res->bank_name;
							$depositdata['branch_name']             = $res->branch_name;
							$depositdata['fees_type']               = $res->fees_type;
							$depositdata['installment']          	= $res->installment;
							$depositdata['deposit_amount']          = $res->deposit_amount;
							$depositdata['accounted_id']            = $res->accounted_id;
							$depositdata['accounted_status']        = $res->accounted_status;
							$depositdata['management_id']           = $res->management_id;
							$depositdata['management_status']       = $res->management_status;
							$depositdata['accounted_update_date']   = $res->accounted_update_date;
							$depositdata['management_update_date']  = $res->management_update_date;
							$depositdata['accounted_message']       = $res->accounted_message;
							$depositdata['management_message']      = $res->management_message;
							$depositdata['note']                    = $res->note;
							$depositdata['dd_upi_online']           = $res->dd_upi_online;
							$depositdata['academic_year']           = $res->academic_year;
							$depositdata['status']                  = $res->status;
							$depositdata['createddate']             = $res->createddate;
							$depositdata['transaction_id']          = $res->transaction_id;
							$depositdata['cheque_status']           = $res->cheque_status;
							$depositdata['check_bounced_status']    = $res->check_bounced_status;
							$depositdata['check_bounced_amount']    = $res->check_bounced_amount;
							$depositdata['check_bounced_datetime']  = $res->check_bounced_datetime;
							$depositdata['is_delete']    			= $res->is_delete;
							$depositdata['deleted_by']    			= $res->deleted_by;
							$depositdata['delete_reason']    		= $res->delete_reason;
                            $this->db->insert(db_prefix().'student_fees_deposit_befor', $depositdata);
                        }
                    }

                    $status = true;
                    $message = 'Package add successful';
					set_alert('success', _l('Package add successful'));
					redirect($_SERVER['HTTP_REFERER']);
                    echo json_encode([
                        'success' => $status,
                        'message' => $message,
                    ]);
                }
                else
                {
                    $status = false;
                    $message = 'Record not match';
                    echo json_encode([
                        'success' => $status,
                        'message' => $message,
                    ]);
                    exit();
                }                    
            }
        }
        else
        {
            $status = false;
            $message = 'Record not match';
            echo json_encode([
                'success' => $status,
                'message' => $message,
            ]);

            exit();
        }
        //set_alert('warning', _l('Record not match'));
        //redirect($_SERVER['HTTP_REFERER']);
    }
    
    /* Created Student Result */
    public function createdStudentResult($sid = null)
    {
        $status = '';
        $message = '';
        $data           =   $this->input->post();
        $sid = $data['result-student_id'];
        $classid = $data['result-class_id'];
        $result_trems = $data['result-result_trems'];
        $result_trems_id = $data['result-exam_id'];
        $academic_year = $this->academic_session;
        $resultid = $this->db->order_by('id','desc')->get_where('tblstudent_result', array('student_id' => $sid, 'class_id' => $classid, 'exam_id' =>$result_trems, 'academic_year' => $academic_year))->row('id');
        
        $resultdata['class_id'] = $classid;
        $resultdata['student_id'] = $sid;
        $resultdata['exam_id'] = $result_trems;
        $resultdata['academic_year'] = $academic_year;
        $resultdata['result_remark'] = $data['result_remark'];
        $resultdata['result_date'] = $data['result_date'];
        $resultdata['attendance'] = $data['attendance'];
        $resultdata['total_attendance'] = $data['total_attendance'];
        $resultdata['created_date'] = date('Y-m-d H:i:s');
        
        if(!empty($resultid))
        {
            $updateresultdata['result_date'] = $data['result_date'];
            $updateresultdata['result_remark'] = $data['result_remark'];
            $updateresultdata['attendance'] = $data['attendance'];
            $updateresultdata['total_attendance'] = $data['total_attendance'];
            $this->db->where('id', $resultid);
            $this->db->update('tblstudent_result', $updateresultdata);
            
            $this->db->delete(db_prefix().'suject_result', array('result_id' => $resultid));
            $subjectarr = $data['subject_id'];
            
            $periodic_assessment = @$data['periodic_assessment_id'];
            $subject_enrichment_activity = @$data['subject_enrichment_activity_id'];
            $multiple_assessment = @$data['multiple_assessment_id'];
            $portfolio = @$data['portfolio_id'];
            $note_book = @$data['note_book_id'];
            $half_yearly_assessment = @$data['half_yearly_assessment_id'];
            $marks_obtained = @$data['marks_obtained_id'];
            
            $gradarr   = $data['grad_id'];
            $subcount = count($data['subject_id']);
            for($i = 0; $i < $subcount; $i++)
            {
                $postdata['student_id']  = $sid; 
                $postdata['result_id']   = $resultid;
                $postdata['subject_id']  = $subjectarr[$i]; 
                if($periodic_assessment)
                {
                    $postdata['periodic_assessment']  = $periodic_assessment[$i]; 
                }
                if($multiple_assessment)
                {
                    $postdata['multiple_assessment']  = $multiple_assessment[$i]; 
                }
                if($portfolio)
                {
                    $postdata['portfolio']  = $portfolio[$i]; 
                }
                if($subject_enrichment_activity)
                {
                    $postdata['subject_enrichment_activity']  = $subject_enrichment_activity[$i]; 
                }
                if($note_book)
                {
                    $postdata['note_book']  = $note_book[$i]; 
                }
                if($half_yearly_assessment)
                {
                    $postdata['half_yearly_assessment']  = $half_yearly_assessment[$i]; 
                }
                if($marks_obtained)
                {
                    $postdata['marks_obtained']  = $marks_obtained[$i]; 
                }                
                $postdata['grad_id']     = $gradarr[$i]; 
                $postdata['subject_type']     = 'Scholastic'; 
                
                $this->db->insert(db_prefix().'suject_result', $postdata);
            }
            /* Other Subject */
            $other_subjectarr = $data['other_subject_id'];
            $other_gradarr   = $data['other_grad_id'];
            $other_subcount = count($data['other_subject_id']);
            for($i = 0; $i < $other_subcount; $i++)
            {
                $postdata_['student_id']  = $sid; 
                $postdata_['result_id']   = $resultid; 
                $postdata_['subject_id']  = $other_subjectarr[$i]; 
                $postdata_['grad_id']     = $other_gradarr[$i]; 
                $postdata_['subject_type']     = 'Co-Scholastic'; 
                
                $this->db->insert(db_prefix().'suject_result', $postdata_);
            }
            set_alert('success', _l('Result are updated successfully'));
        }
        else
        {
            $this->db->insert(db_prefix().'student_result', $resultdata);
            $resultid = $this->db->insert_id();
            if($resultid)
            {
                $subjectarr = $data['subject_id'];
                
                $periodic_assessment = @$data['periodic_assessment_id'];
                $subject_enrichment_activity = @$data['subject_enrichment_activity_id'];
                $multiple_assessment = @$data['multiple_assessment_id'];
                $portfolio = @$data['portfolio_id'];
                $note_book = @$data['note_book_id'];
                $half_yearly_assessment = @$data['half_yearly_assessment_id'];
                $marks_obtained = @$data['marks_obtained_id'];
                
                $gradarr   = $data['grad_id'];
                $subcount = count($data['subject_id']);
                for($i = 0; $i < $subcount; $i++)
                {
                    $postdata['student_id']  = $sid; 
                    $postdata['result_id']   = $resultid; 
                    
                    if($periodic_assessment)
                    {
                        $postdata['periodic_assessment']  = $periodic_assessment[$i]; 
                    }
                    if($multiple_assessment)
                    {
                        $postdata['multiple_assessment']  = $multiple_assessment[$i]; 
                    }
                    if($subject_enrichment_activity)
                    {
                        $postdata['subject_enrichment_activity']  = $subject_enrichment_activity[$i]; 
                    }
                    if($portfolio)
                    {
                        $postdata['portfolio']  = $portfolio[$i]; 
                    }
                    if($subject_enrichment_activity)
                    {
                        $postdata['subject_enrichment_activity']  = $subject_enrichment_activity[$i]; 
                    }
                    if($note_book)
                    {
                        $postdata['note_book']  = $note_book[$i]; 
                    }
                    if($half_yearly_assessment)
                    {
                        $postdata['half_yearly_assessment']  = $half_yearly_assessment[$i]; 
                    }
                    if($marks_obtained)
                    {
                        $postdata['marks_obtained']  = $marks_obtained[$i]; 
                    }
                    
                    $postdata['subject_id']  = $subjectarr[$i]; 
                    $postdata['grad_id']     = $gradarr[$i]; 
                    $postdata['subject_type']     = 'Scholastic'; 
                    
                    $this->db->insert(db_prefix().'suject_result', $postdata);
                }
                /* Other Subject */
                $other_subjectarr = $data['other_subject_id'];
                $other_gradarr   = $data['other_grad_id'];
                $other_subcount = count($data['other_subject_id']);
                for($i = 0; $i < $other_subcount; $i++)
                {
                    $postdata_['student_id']  = $sid; 
                    $postdata_['result_id']   = $resultid; 
                    $postdata_['subject_id']  = $other_subjectarr[$i]; 
                    $postdata_['grad_id']     = $other_gradarr[$i]; 
                    $postdata_['subject_type']= 'Co-Scholastic'; 
                    
                    $this->db->insert(db_prefix().'suject_result', $postdata_);
                }
                set_alert('success', _l('Result are created successfully'));
            }
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    
    /* Get Student Subject */
    public function getStudentSubject()
    {
        $data           =   $this->input->post();
        $html = '';
        $sid = $data['sid'];
        $classname = $data['classname'];
        $result_trems = $data['result_trems'];
        $result_trems_id = $data['result_trems_id'];
        $academic_year = $this->academic_session;
        $classid = $this->db->get_where('tblmaster_class', array('name' => $classname))->row('class_id');
        $subjectRest = $this->db->order_by('subject_id','asc')->get_where('tblmaster_subject_account_db', array('class_id' => $classid))->result();
        //print_r($subjectRest); die;
        $student_gender = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $sid))->row('Gender');
        $preprimaryClasses = [9,10,11,12];
        if(in_array($classid, $preprimaryClasses)){
            $remarkList = $this->db->get_where('tblmaster_remark', array('type' => 1, 'gender' => $student_gender))->result();
        }
        else{
            $remarkList = $this->db->get_where('tblmaster_remark', array('type' => 2, 'gender' => $student_gender))->result();            
        }
        
        $resultid = $this->db->get_where('tblstudent_result', array('student_id' => $sid, 'class_id' => $classid, 'exam_id' => $result_trems, 'academic_year' => $academic_year))->row('id');
        $responsedata['grad_list'] = $this->db->order_by('name','asc')->get_where(db_prefix().'result_grade')->result();
        $responsedata['subjectlist'] = $this->db->order_by('subject_id', 'asc')->get_where(db_prefix().'master_subject_account_db', array('class_id' => $classid))->result(); 
        
        $responsedata['rid'] = $resultid;
        $responsedata['sid'] = $sid;
        $responsedata['classid'] = $classid;
        $responsedata['result_trems'] = $result_trems;
        $responsedata['result_trems_id'] = $result_trems_id;
        $responsedata['subjectRest'] = $subjectRest;
        $responsedata['remarkList'] = $remarkList;
        if($subjectRest)
        {
            if($classid == 9 || $classid == 10 || $classid == 11 || $classid == 12)
            {
                $responsedata['subjectlist'] = $this->db->order_by('subject_id', 'desc')->get_where(db_prefix().'master_subject_account_db', array('class_id' => $classid))->result(); 
                echo $this->load->view('admin/dashboard/modal/class-primary-subject-list', $responsedata, true); // For class primary
            }
            elseif($classid == 7 || $classid == 8)
            {
                echo $this->load->view('admin/dashboard/modal/class-one-to-two-subject-list', $responsedata, true); // For class 1 to 5
            }
            elseif($classid == 4 || $classid == 5 || $classid == 6)
            {
                echo $this->load->view('admin/dashboard/modal/class-three-to-five-subject-list', $responsedata, true); // For class 1 to 5
            }
            elseif($classid == 1 || $classid == 2 || $classid == 3)
            {
                echo $this->load->view('admin/dashboard/modal/class-six-to-eight-subject-list', $responsedata, true); // For class 6 to 8
            }
            elseif($classid == 13 || $classid == 14)
            {
                echo $this->load->view('admin/dashboard/modal/class-nine-subject-list', $responsedata, true); // For class 9
            }
        }
        elseif($classid == 15 || $classid == 16)
        {
            $student_subject = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $sid))->row('subject_id');
            $student_optional_subject = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $sid))->row('optional_subject');
            if($student_subject == 1){
                $subjectRest = $this->db->get_where('tblmaster_subject_commerce', array('class_id' => $classid))->result();
            }
            elseif($student_subject == 2){
                $subjectRest = $this->db->get_where('tblmaster_subject_mathematics', array('class_id' => $classid))->result();
            }
            elseif($student_subject == 3){
                $subjectRest = $this->db->get_where('tblmaster_subject_biology', array('class_id' => $classid))->result();
            }
            $optionalSubject = $this->db->get_where('tblmaster_other_subject', array('subject_id' => $student_optional_subject))->row('name');
            $responsedata['subjectRest'] = $subjectRest;
            $responsedata['subjectlist'] = $subjectRest;
            $responsedata['optionalSubject'] = $optionalSubject;
            echo $this->load->view('admin/dashboard/modal/class-eleven-subject-list', $responsedata, true); // For class 11 and 12
        }
        else
        {
            echo '';
        }
    }
    
    /* Student result print */
    public function resultPrint($sid = null)
    {
        $academic_year = $this->academic_session;
        
        $studentdata = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $sid))->row();
        if($academic_year == '2021-22'){
            $studentResult = $this->db->get_where(db_prefix().'student_result_2021_22', array('student_id' => $sid,'academic_year'=>$this->academic_session))->row();
            $subjectResult = $this->db->order_by('id','asc')->get_where(db_prefix().'suject_result_2021_22', array('student_id' => $sid,'result_id'=>$studentResult->id))->result();
        }
        else{
            $studentResult = $this->db->get_where(db_prefix().'student_result', array('student_id' => $sid, 'exam_id'=> 'Term-I', 'academic_year'=>$this->academic_session))->row();
            $subjectResult = $this->db->order_by('id','asc')->get_where(db_prefix().'suject_result', array('student_id' => $sid,'result_id'=>$studentResult->id))->result();
        }
        //print_r($studentdata); die;
        $data['firstname'] = ucfirst($studentdata->firstname);
        $data['middlename'] = ucfirst($studentdata->middlename);
        $data['lastname'] = ucfirst($studentdata->lastname);
        $data['Father_Name'] = $studentdata->Father_Name;
        $Date_of_Birth = str_replace('.','/',$studentdata->Date_of_Birth);
        $data['Date_of_Birth'] = str_replace('-','/',$Date_of_Birth);
        $data['Mother_Name'] = ucfirst($studentdata->Mother_Name);
        $data['Class'] = str_replace('Class','',$studentdata->Class);
        $data['resultData'] = $studentResult;
        $data['subjectResult'] = $subjectResult;
        $data['academic_year'] = $academic_year;
		$student_section_id = $studentdata->payment_status;
		$student_section = student_section($studentdata->payment_status);
        /*
		if($student_section_id == 2)
		{
			$student_section = 'A';
		}
		if($student_section_id == 1)
		{
			$student_section = 'B';
		}
		if($student_section_id == 3)
		{
			$student_section = 'C';
		}
		*/
		$data['student_section'] = $student_section;
        if($studentdata->Class == 'Playgroup' || $studentdata->Class == 'Nursery' || $studentdata->Class == 'LKG' || $studentdata->Class == 'UKG')
        {
            $this->load->view('theisb-result/index-primary',$data);
        }
        elseif($studentdata->Class == 'Class I' || $studentdata->Class == 'Class II')
        {
            if($studentdata->Campus == 'World School'){
                $this->load->view('theisb-result/index-one-to-five-CBSE',$data);
            }
            else
            {
                $this->load->view('theisb-result/index',$data);   
            }
        }
        elseif($studentdata->Class == 'Class III' || $studentdata->Class == 'Class IV' || $studentdata->Class == 'Class V')
        {
            if($studentdata->Campus == 'World School'){
                $this->load->view('theisb-result/index-three-to-five-CBSE',$data);
            }
            else
            {
                $this->load->view('theisb-result/index-three-to-five',$data);   
            }
        }
        elseif($studentdata->Class == 'Class VI' || $studentdata->Class == 'Class VII' || $studentdata->Class == 'Class VIII')
        {
            if($studentdata->Campus == 'World School'){
                $this->load->view('theisb-result/index-six-to-eight-CBSE',$data);
            }
            else
            {
                $this->load->view('theisb-result/index-six-to-eight',$data);
            }
        }
        elseif($studentdata->Class == 'Class IX' || $studentdata->Class == 'Class X')
        {
            $this->load->view('theisb-result/index-nine',$data);
        }
        elseif($studentdata->Class == 'Class XI' || $studentdata->Class == 'Class XII')
        {
            $this->load->view('theisb-result/index-eleven-twelve',$data);
        }
        else
        {
            $this->load->view('theisb-result/index',$data);
        }
    }
    
    /* Student Orientation print */
    public function showOrientationPrint($sid = null)
    {
        $academic_year = $this->academic_session;
        
        $studentdata = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $sid))->row();
        $data['firstname'] = ucfirst($studentdata->firstname);
        $data['middlename'] = ucfirst($studentdata->middlename);
        $data['lastname'] = ucfirst($studentdata->lastname);
        $data['Father_Name'] = $studentdata->Father_Name;
        $data['Father_Mobile'] = $studentdata->Father_Mobile;
        $data['Mother_Mobile'] = $studentdata->Mother_Mobile;
        $Date_of_Birth = str_replace('.','/',$studentdata->Date_of_Birth);
        $data['Date_of_Birth'] = str_replace('-','/',$Date_of_Birth);
        $data['Mother_Name'] = ucfirst($studentdata->Mother_Name);
        $data['Campus'] = ucfirst($studentdata->Campus);
        $data['Shift'] = ucfirst($studentdata->Shift);
        $data['Class'] = str_replace('Class','',$studentdata->Class);
		$this->load->view('orientation/orientation',$data);
    }
	
    /* Student Declaration print */
    public function showDeclarationPrint($sid = null)
    {
        $academic_year = $this->academic_session;
        
        $studentdata = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $sid))->row();
        $data['firstname'] = ucfirst($studentdata->firstname);
        $data['middlename'] = ucfirst($studentdata->middlename);
        $data['lastname'] = ucfirst($studentdata->lastname);
        $data['Father_Name'] = $studentdata->Father_Name;
        $data['Father_Mobile'] = $studentdata->Father_Mobile;
        $data['Mother_Mobile'] = $studentdata->Mother_Mobile;
        $Date_of_Birth = str_replace('.','/',$studentdata->Date_of_Birth);
        $data['Date_of_Birth'] = str_replace('-','/',$Date_of_Birth);
        $data['Mother_Name'] = ucfirst($studentdata->Mother_Name);
        $data['Campus'] = ucfirst($studentdata->Campus);
        $data['Shift'] = ucfirst($studentdata->Shift);
        $data['Gaurdian_Name'] = ucfirst($studentdata->Gaurdian_Name);
		
		$Class_ = str_replace('Class','',$studentdata->Class);
        $data['Class'] = $Class_;
        $data['promotedClass'] = $Class_;
		/*
		$promotedClass = '';
		if($Class_ == 'Playgroup')
		{
			$promotedClass = 'Nursery';
		}
		elseif($Class_ == 'Nursery')
		{
			$promotedClass = 'LKG';
		}
		elseif($Class_ == 'LKG')
		{
			$promotedClass = 'UKG';
		}
		elseif($Class_ == 'UKG')
		{
			$promotedClass = 'I';
		}
		elseif($Class_ == ' I')
		{
			$promotedClass = 'II';
		}
		elseif($Class_ == ' II')
		{
			$promotedClass = 'III';
		}
		elseif($Class_ == ' III')
		{
			$promotedClass = 'IV';
		}
		elseif($Class_ == ' IV')
		{
			$promotedClass = 'V';
		}
		elseif($Class_ == ' V')
		{
			$promotedClass = 'VI';
		}
		elseif($Class_ == ' VI')
		{
			$promotedClass = 'VII';
		}
		elseif($Class_ == ' VII')
		{
			$promotedClass = 'VIII';
		}
		elseif($Class_ == ' VIII')
		{
			$promotedClass = 'IX';
		}
		elseif($Class_ == ' IX')
		{
			$promotedClass = 'X';
		}		
        $data['promotedClass'] = $promotedClass;
		*/
		$this->load->view('declaration/declaration',$data);
    }
    
    /* Student result print */
    public function resultPrintSecondTerms($sid = null)
    {
        $academic_year = $this->academic_session;
        
        $studentdata = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $sid))->row();
        //$studentResult = $this->db->order_by('id','desc')->get_where(db_prefix().'student_result', array('student_id' => $sid,'academic_year'=>$this->academic_session))->row();
        //$subjectResult = $this->db->order_by('id','asc')->get_where(db_prefix().'suject_result', array('student_id' => $sid,'result_id'=>$studentResult->id))->result();
        if($academic_year == '2021-22'){
            $studentResult = $this->db->order_by('id','desc')->get_where(db_prefix().'student_result_2021_22', array('student_id' => $sid,'academic_year'=>$this->academic_session))->row();
            $subjectResult = $this->db->order_by('id','asc')->get_where(db_prefix().'suject_result_2021_22', array('student_id' => $sid,'result_id'=>$studentResult->id))->result();
        }
        else{
            $studentResult = $this->db->order_by('id','desc')->get_where(db_prefix().'student_result', array('student_id' => $sid, 'exam_id'=> 'Term-II', 'academic_year'=>$this->academic_session))->row();
            $subjectResult = $this->db->order_by('id','asc')->get_where(db_prefix().'suject_result', array('student_id' => $sid,'result_id'=>$studentResult->id))->result();
        }
        //print_r($studentdata); die;
        $data['firstname'] = ucfirst($studentdata->firstname);
        $data['middlename'] = ucfirst($studentdata->middlename);
        $data['lastname'] = ucfirst($studentdata->lastname);
        $data['Father_Name'] = $studentdata->Father_Name;
        $Date_of_Birth = str_replace('.','/',$studentdata->Date_of_Birth);
        $data['Date_of_Birth'] = str_replace('-','/',$Date_of_Birth);
        $data['Mother_Name'] = ucfirst($studentdata->Mother_Name);
        $data['Class'] = str_replace('Class','',$studentdata->Class);
        $data['resultData'] = $studentResult;
        $data['subjectResult'] = $subjectResult;
        $data['academic_year'] = $academic_year;
        $student_section_id = $studentdata->payment_status;
        $student_section = student_section($studentdata->payment_status);
        /*
        if($student_section_id == 2)
        {
            $student_section = 'A';
        }
        if($student_section_id == 1)
        {
            $student_section = 'B';
        }
        if($student_section_id == 3)
        {
            $student_section = 'C';
        }
        */
        $data['student_section'] = $student_section;
        if($studentdata->Class == 'Playgroup' || $studentdata->Class == 'Nursery' || $studentdata->Class == 'LKG' || $studentdata->Class == 'UKG')
        {
            $this->load->view('theisb-result/index-primary',$data);
        }
        elseif($studentdata->Class == 'Class I' || $studentdata->Class == 'Class II' || $studentdata->Class == 'Class III' || $studentdata->Class == 'Class IV' || $studentdata->Class == 'Class V' )
        {
            if($studentdata->Campus == 'World School'){
                $this->load->view('theisb-result/index-one-to-five-CBSE',$data);
            }
            else
            {
                $this->load->view('theisb-result/index',$data); 
            }
        }
        elseif($studentdata->Class == 'Class VI' || $studentdata->Class == 'Class VII' || $studentdata->Class == 'Class VIII')
        {
            if($studentdata->Campus == 'World School'){
                $this->load->view('theisb-result/index-six-to-eight-CBSE',$data);
            }
            else
            {
                $this->load->view('theisb-result/index-six-to-eight',$data);
            }
        }
        elseif($studentdata->Class == 'Class IX' || $studentdata->Class == 'Class X' )
        {
            $this->load->view('theisb-result/index-nine',$data);
        }
        else
        {
            $this->load->view('theisb-result/index',$data);
        }
    }
    
	public function resultPrintFinal($sid)
	{
		$academic_year = $this->academic_session;
		$studentdata = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $sid))->row();
		if($academic_year == '2021-22'){
    		/* Term-I */
    		$studentResult1 = $this->db->get_where(db_prefix().'student_result_2021_22', array('student_id' => $sid, 'exam_id'=> 'Term-I', 'academic_year'=>$this->academic_session))->row();
            $subjectResult1 = $this->db->order_by('id','asc')->get_where(db_prefix().'suject_result_2021_22', array('student_id' => $sid,'result_id'=>$studentResult1->id))->result();
    		/*******END********/
    		
    		/* Term-II */
    		$studentResult2 = $this->db->order_by('id','desc')->get_where(db_prefix().'student_result_2021_22', array('student_id' => $sid, 'exam_id'=> 'Term-II', 'academic_year'=>$this->academic_session))->row();
            $subjectResult2 = $this->db->order_by('id','asc')->get_where(db_prefix().'suject_result_2021_22', array('student_id' => $sid,'result_id'=>$studentResult2->id))->result();
		}
		else{
		    /* Term-I */
    		$studentResult1 = $this->db->get_where(db_prefix().'student_result', array('student_id' => $sid, 'exam_id'=> 'Term-I', 'academic_year'=>$this->academic_session))->row();
            $subjectResult1 = $this->db->order_by('id','asc')->get_where(db_prefix().'suject_result', array('student_id' => $sid,'result_id'=>$studentResult1->id))->result();
    		/*******END********/
    		
    		/* Term-II */
    		$studentResult2 = $this->db->order_by('id','desc')->get_where(db_prefix().'student_result', array('student_id' => $sid, 'exam_id'=> 'Term-II', 'academic_year'=>$this->academic_session))->row();
            $subjectResult2 = $this->db->order_by('id','asc')->get_where(db_prefix().'suject_result', array('student_id' => $sid,'result_id'=>$studentResult2->id))->result();
		}
				
		$data['firstname'] = ucfirst($studentdata->firstname);
        $data['middlename'] = ucfirst($studentdata->middlename);
        $data['lastname'] = ucfirst($studentdata->lastname);
        $data['Father_Name'] = $studentdata->Father_Name;
        $Date_of_Birth = str_replace('.','/',$studentdata->Date_of_Birth);
        $data['Date_of_Birth'] = str_replace('-','/',$Date_of_Birth);
        $data['Mother_Name'] = ucfirst($studentdata->Mother_Name);
        $Class_ = str_replace('Class','',$studentdata->Class);
        $student_section = student_section($studentdata->payment_status);        
        $data['student_section'] = $student_section;
        $data['Class'] = $Class_;
		$promotedClass = '';
		if($Class_ == 'Playgroup')
		{
			$promotedClass = 'Nursery';
		}
		elseif($Class_ == 'Nursery')
		{
			$promotedClass = 'LKG';
		}
		elseif($Class_ == 'LKG')
		{
			$promotedClass = 'UKG';
		}
		elseif($Class_ == 'UKG')
		{
			$promotedClass = 'I';
		}
		elseif($Class_ == ' I')
		{
			$promotedClass = 'II';
		}
		elseif($Class_ == ' II')
		{
			$promotedClass = 'III';
		}
		elseif($Class_ == ' III')
		{
			$promotedClass = 'IV';
		}
		elseif($Class_ == ' IV')
		{
			$promotedClass = 'V';
		}
		elseif($Class_ == ' V')
		{
			$promotedClass = 'VI';
		}
		elseif($Class_ == ' VI')
		{
			$promotedClass = 'VII';
		}
		elseif($Class_ == ' VII')
		{
			$promotedClass = 'VIII';
		}
		elseif($Class_ == ' VIII')
		{
			$promotedClass = 'IX';
		}
		elseif($Class_ == ' IX')
		{
			$promotedClass = 'X';
		}
        elseif($Class_ == ' X')
        {
            $promotedClass = 'XI';
        }
        elseif($Class_ == ' XI')
        {
            $promotedClass = 'XII';
        }
		
        $data['promotedClass'] = $promotedClass;
        $data['resultData1'] = $studentResult1;
        $data['subjectResult1'] = $subjectResult1;
        $data['resultData2'] = $studentResult2;
        $data['subjectResult2'] = $subjectResult2;
        $data['academic_year'] = $academic_year;
		if($studentdata->Class == 'Playgroup' || $studentdata->Class == 'Nursery' || $studentdata->Class == 'LKG' || $studentdata->Class == 'UKG')
        {
           $this->load->view('theisb-result/final/class-per-primary',$data);
        }
        elseif($studentdata->Class == 'Class I' || $studentdata->Class == 'Class II' || $studentdata->Class == 'Class III' || $studentdata->Class == 'Class IV' || $studentdata->Class == 'Class V' )
        {
            $this->load->view('theisb-result/final/class-primary',$data);
        }
        elseif($studentdata->Class == 'Class VI' || $studentdata->Class == 'Class VII' || $studentdata->Class == 'Class VIII')
        {
            if($studentdata->Campus == 'World School'){
                $this->load->view('theisb-result/final/class-six-to-eight-CBSE',$data);
            }
            else
            {
                $this->load->view('theisb-result/final/class-six-to-eight',$data);
            }
        }
        elseif($studentdata->Class == 'Class IX' || $studentdata->Class == 'Class X' )
        {
			$this->load->view('theisb-result/final/class-nine',$data);
        }
        elseif($studentdata->Class == 'Class XI' || $studentdata->Class == 'Class XII' )
        {
            $this->load->view('theisb-result/final/class-eleven-twelve',$data);
        }
        else
        {
            $this->load->view('theisb-result/final/class-nine',$data);
        }
	}
		
	public function tcPrintPreview($tid,$sid)
	{
		$data['academic_year'] = $this->academic_session;
		$data['student_data'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $sid))->row();
		$data['tc_data'] = $this->db->get_where(db_prefix().'tc_requests', array('id' => $tid))->row();
		$this->load->view('tc/tc-print',$data);
	}
	
     /* Excel data Student result print */
    /*public function resultPrintInExcel()
    {
        $fileName = 'ReportCardData.xlsx';  
		$academic_year = $this->academic_session;
        $class9_students = $this->db->select('userid')->get_where('tblcontacts_2021_22', array('Class' => 'Class IX'))->result();
        //$studentdata = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $sid))->row();
        //print_r($studentdata); die;
		$spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A1', 'Hello World !');
		$sheet->setCellValue('A1', 'SN');
        $sheet->setCellValue('B1', 'Student Name');
        $sheet->setCellValue('C1', 'Father Name');
        $sheet->setCellValue('D1', 'Mother Name');
		$sheet->setCellValue('E1', 'Class');
        $sheet->setCellValue('F1', 'Date of Birth');       
        $sheet->setCellValue('G1', 'English Periodic Assesment (10 M)');       
        $sheet->setCellValue('H1', 'English Subject Enrichment Activity (5M)');       
        $sheet->setCellValue('I1', 'English Notebook (5M)');       
        $sheet->setCellValue('J1', 'English Half Yearly Assesment (80M)');       
        $sheet->setCellValue('K1', 'English Mark obtained (100M)');       
        $sheet->setCellValue('L1', 'English Term -I Grade');       
        $sheet->setCellValue('M1', 'Hindi Periodic Assesment (10 M)');       
        $sheet->setCellValue('N1', 'Hindi Subject Enrichment Activity (5M)');       
        $sheet->setCellValue('O1', 'Hindi Notebook (5M)');       
        $sheet->setCellValue('P1', 'Hindi Half Yearly Assesment (80M)');       
        $sheet->setCellValue('Q1', 'Hindi Mark obtained (100M)');       
        $sheet->setCellValue('R1', 'Hindi Term -I Grade	Mathematic Periodic Assesment (10 M)');       
        $sheet->setCellValue('S1', 'Mathematic Subject Enrichment Activity (5M)');       
        $sheet->setCellValue('T1', 'Mathematic Notebook (5M)');       
        $sheet->setCellValue('U1', 'Mathematic Half Yearly Assesment (80M)');       
        $sheet->setCellValue('V1', 'Mathematic Mark obtained (100M)');       
        $sheet->setCellValue('W1', 'Mathematic Term -I Grade');       
        $sheet->setCellValue('X1', 'Science Periodic Assesment (10 M)');       
        $sheet->setCellValue('Y1', 'Science Subject Enrichment Activity (5M)');       
        $sheet->setCellValue('Z1', 'Science Notebook (5M)');       
        $sheet->setCellValue('AA1', 'Science  Half Yearly Assesment (80M)');       
        $sheet->setCellValue('AB1', 'Science  Mark obtained (100M)');       
        $sheet->setCellValue('AC1', 'Science  Term -I Grade');       
        $sheet->setCellValue('AD1', 'Social Science Periodic Assesment (10 M)');       
        $sheet->setCellValue('AE1', 'Social Science Subject Enrichment Activity (5M)');       
        $sheet->setCellValue('AF1', 'Social Science Notebook (5M)');       
        $sheet->setCellValue('AG1', 'Social Science Half Yearly Assesment (80M)');       
        $sheet->setCellValue('AH1', 'Social Science Mark obtained (100M)');       
        $sheet->setCellValue('AI1', 'Social Science Term -I Grade');       
        $sheet->setCellValue('AJ1', 'Computer Periodic Assesment (10 M)');       
        $sheet->setCellValue('AK1', 'Computer Subject Enrichment Activity (5M)');       
        $sheet->setCellValue('AL1', 'Computer Notebook (5M)');       
        $sheet->setCellValue('AM1', 'Computer Half Yearly Assesment (80M)');       
        $sheet->setCellValue('AN1', 'Computer Mark obtained (100M)');       
        $sheet->setCellValue('AO1', 'Computer Term -I Grade');       
        $sheet->setCellValue('AP1', 'Work Education (Term-I)');       
        $sheet->setCellValue('AQ1', 'Art Education (Term-I)');       
        $sheet->setCellValue('AR1', 'Health & Physical Education (Term-I)');       
        $sheet->setCellValue('AS1', 'Discipline (Term-I)');       
        $sheet->setCellValue('AT1', 'Class Teacher`s Remark');
        $rows = 2;
        if($class9_students)
        {
            foreach($class9_students as $rrr){
                $studentdata = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $rrr->userid))->row();
                foreach ($studentdata as $val){
                    $sname = $val->firstname.' '.$val->middlename.' '.$val->lastname;
                    $sheet->setCellValue('A' . $rows, $val->userid);
                    $sheet->setCellValue('B' . $rows, $sname);
                    $sheet->setCellValue('C' . $rows, $val->Father_Name);
                    $sheet->setCellValue('D' . $rows, $val->Mother_Name);
        			$sheet->setCellValue('E' . $rows, $val->Class);
                    $sheet->setCellValue('F' . $rows, $val->userid);
                    $rows++;
                } 
            }
        }
        $writer = new Xlsx($spreadsheet);
		$writer->save("uploads/".$fileName);
		header("Content-Type: application/vnd.ms-excel");
        redirect(base_url()."/uploads/".$fileName); 
		
        $academic_year = $this->academic_session;
        $sid = 2798;
        $studentdata = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $sid))->row();
        $studentResult = $this->db->get_where(db_prefix().'student_result', array('student_id' => $sid,'academic_year'=>$this->academic_session))->row();
        $subjectResult = $this->db->order_by('id','asc')->get_where(db_prefix().'suject_result', array('student_id' => $sid,'result_id'=>$studentResult->id))->result();
        //print_r($studentdata); die;
        $data['firstname'] = ucfirst($studentdata->firstname);
        $data['middlename'] = ucfirst($studentdata->middlename);
        $data['lastname'] = ucfirst($studentdata->lastname);
        $data['Father_Name'] = $studentdata->Father_Name;
        $data['Date_of_Birth'] = str_replace('-','/',$studentdata->Date_of_Birth);
        $data['Mother_Name'] = ucfirst($studentdata->Mother_Name);
        $data['Class'] = str_replace('Class','',$studentdata->Class);
        $data['resultData'] = $studentResult;
        $data['subjectResult'] = $subjectResult;
        $data['academic_year'] = $academic_year;
        if($studentdata->Class == 'Playgroup' || $studentdata->Class == 'Nursery' || $studentdata->Class == 'LKG' || $studentdata->Class == 'UKG')
        {
            $this->load->view('theisb-result/index-primary',$data);
        }
        elseif($studentdata->Class == 'Class I' || $studentdata->Class == 'Class II' || $studentdata->Class == 'Class III' || $studentdata->Class == 'Class IV' || $studentdata->Class == 'Class V' )
        {
            if($studentdata->Campus == 'World School'){
                $this->load->view('theisb-result/index-one-to-five-CBSE',$data);
            }
            else
            {
                $this->load->view('theisb-result/index',$data);   
            }
        }
        elseif($studentdata->Class == 'Class VI' || $studentdata->Class == 'Class VII' || $studentdata->Class == 'Class VIII')
        {
            if($studentdata->Campus == 'World School'){
                $this->load->view('theisb-result/index-six-to-eight-CBSE',$data);
            }
            else
            {
                $this->load->view('theisb-result/index-six-to-eight',$data);
            }
        }
        elseif($studentdata->Class == 'Class IX' || $studentdata->Class == 'Class X' )
        {
            $this->load->view('theisb-result/index-nine',$data);
        }
        else
        {
            $this->load->view('theisb-result/index',$data);
        }
    }
    */
    
    /* Ladger */
    public function ledger($id)
    {
        $data['student_details'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $id))->row();
        $Years =  $this->getTotalYearList($data['student_details']->Admission_Year);
        $data['packageamount'] =  $this->getPackageamount($id,$Years);
        //$data['packageamount'] =  $this->db->select('package_id,package_amount,deposit_amount,admission_year,package_year,accounted_id,resone_note')->get_where(db_prefix().'student_package',array('userid' => $id,'package_year'=>$this->academic_session))->row();
        $data['package_details'] = $this->db->get_where(db_prefix().'master_package', array('id' => $data['packageamount']->package_id))->row('name');
        $data['deposit_result'] = $this->db->get_where(db_prefix().'student_fees_deposit', array('userid' => $id,'academic_year'=>$this->academic_session))->result();
        $this->load->view('admin/dashboard/ledger', $data);
    }

    /* This is admin dashboard view */
    public function newDashboard2()
    {
        $data['user_dashboard_visibility'] = [];
        $data['package_list'] = $this->db->get_where(db_prefix().'master_package')->result();
        $this->load->view('admin/dashboard/newDashboard2', $data);
    }
    
    /* Staff list */
    public function staffDashboard()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('staff_dashboard');
        }
    }

    /* Referral list */
    public function referralList()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('referral_list');
        }
    }
    
    /* Staff list */
    public function dayPayListData()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('dayPayList');
        }
    }

    public function table()
    {
        if (has_permission('customers', '', 'view')) {
            if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
                ajax_access_denied();
            }
        }

        $this->app->get_table_data('clients');
    }
    
    public function table__()
    {
        if (has_permission('customers', '', 'view')) {
            if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
                ajax_access_denied();
            }
        }

        $this->app->get_table_data('clients_dashboard',[
                 'contact_tbl'=>$this->contact_tbl
            ]);
    }

    public function studentLoginCredentials()
    {
        $this->app->get_table_data('student-login-credentials',[
                 'contact_tbl'=>$this->contact_tbl
            ]);
    }

    public function packagewiseList($package_id)
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('packagewise_student', [
                'package_id'   => $package_id,'contact_tbl'=>$this->contact_tbl
            ]);
        }
        //$this->app->get_table_data('clients_dashboard');
    }

    /*
    *   @function:  feedLedger
    */
    public  function feesLedger($id){
        /*
        //$data['student_details'] = $this->db->get_where(db_prefix().'contacts', array('userid' => $id))->row();
        $data['packageamount'] =  $this->db->select('package_amount,deposit_amount')->get_where(db_prefix().'student_package',array('userid' => $id))->row();
        $data['deposit_result'] = $this->db->get_where(db_prefix().'student_fees_deposit', array('userid' => $id))->result();
        echo $this->load->view('admin/dashboard/ladgerModel',$data,true);
        */
        
        $data['student_details'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $id))->row();
        $data['packageamount'] =  $this->db->select('package_amount,deposit_amount,userid,package_id,admission_year,admission_date')->get_where(db_prefix().'student_package',array('userid' => $id,'package_year'=>$this->academic_session))->row();
        $data['deposit_result'] = $this->db->get_where(db_prefix().'student_fees_deposit', array('userid' => $id, 'management_status' => 1,'academic_year'=>$this->academic_session))->result();
        echo $this->load->view('admin/collectfees/ladgerModel',$data,true);
    }
    
    /*
    *   @function:  feedLedger
    */
    public function studentdatalist($id){
        $data['transport_result'] = $this->db->get_where(db_prefix().'transport')->result();
        
        //echo $this->input->get('group');
        //die;

        $group         = !$this->input->get('group') ? 'profile' : $this->input->get('group');
        $data['group'] = $group;

        if ($group != 'contacts' && $contact_id = $this->input->get('contactid')) {
            //redirect(admin_url('clients/client/' . $id . '?group=contacts&contactid=' . $contact_id));
        }
                // Customer groups
        $data['groups'] = $this->clients_model->get_groups();

        if ($id == '') {
            $title = _l('add_new', _l('client_lowercase'));
        } else {
            $client                = $this->clients_model->get($id);
            $data['customer_tabs'] = get_customer_profile_tabs();

            if (!$client) {
                show_404();
            }
            
            $feesmodule = [];
            $studentshift = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $client->userid))->row('Shift');
            if($studentshift)
            {
                $feesmodule = $this->db->get_where(db_prefix().'school_fees', array('shift' => $studentshift))->row();
            }
            
            $data['school_fees'] = $feesmodule;

            $data['contacts'] = $this->clients_model->get_all_contacts($id);
            $data['tab']      = isset($data['customer_tabs'][$group]) ? $data['customer_tabs'][$group] : null;

            /*
            if (!$data['tab']) {
                show_404();
            }
            */

            // Fetch data based on groups
            if ($group == 'profile') {
                $data['customer_groups'] = $this->clients_model->get_customer_groups($id);
                $data['customer_admins'] = $this->clients_model->get_admins($id);
            } elseif ($group == 'attachments') {
                $data['attachments'] = get_all_customer_attachments($id);
            } elseif ($group == 'vault') {
                $data['vault_entries'] = hooks()->apply_filters('check_vault_entries_visibility', $this->clients_model->get_vault_entries($id));

                if ($data['vault_entries'] === -1) {
                    $data['vault_entries'] = [];
                }
            } elseif ($group == 'estimates') {
                $this->load->model('estimates_model');
                $data['estimate_statuses'] = $this->estimates_model->get_statuses();
            } elseif ($group == 'invoices') {
                $this->load->model('invoices_model');
                $data['invoice_statuses'] = $this->invoices_model->get_statuses();
            } elseif ($group == 'credit_notes') {
                $this->load->model('credit_notes_model');
                $data['credit_notes_statuses'] = $this->credit_notes_model->get_statuses();
                $data['credits_available']     = $this->credit_notes_model->total_remaining_credits_by_customer($id);
            } elseif ($group == 'payments') {
                $this->load->model('payment_modes_model');
                $data['payment_modes'] = $this->payment_modes_model->get();
            } elseif ($group == 'notes') {
                $data['user_notes'] = $this->misc_model->get_notes($id, 'customer');
            } elseif ($group == 'projects') {
                $this->load->model('projects_model');
                $data['project_statuses'] = $this->projects_model->get_project_statuses();
            } elseif ($group == 'statement') {
                if (!has_permission('invoices', '', 'view') && !has_permission('payments', '', 'view')) {
                    set_alert('danger', _l('access_denied'));
                    //redirect(admin_url('clients/client/' . $id));
                }

                $data = array_merge($data, prepare_mail_preview_data('customer_statement', $id));
            } elseif ($group == 'map') {
                if (get_option('google_api_key') != '' && !empty($client->latitude) && !empty($client->longitude)) {
                    $this->app_scripts->add('map-js', base_url($this->app_scripts->core_file('assets/js', 'map.js')) . '?v=' . $this->app_css->core_version());

                    $this->app_scripts->add('google-maps-api-js', [
                        'path'       => 'https://maps.googleapis.com/maps/api/js?key=' . get_option('google_api_key') . '&callback=initMap',
                        'attributes' => [
                            'async',
                            'defer',
                            'latitude'       => "$client->latitude",
                            'longitude'      => "$client->longitude",
                            'mapMarkerTitle' => "$client->company",
                        ],
                    ]);
                }
            }

            $data['staff'] = $this->staff_model->get('', ['active' => 1]);
            //$data['user_result'] = $this->db->get_where(db_prefix.'contacts', array('userid' => $client->userid))->row();

            $data['client'] = $client;
            $title          = $client->company;

            // Get all active staff members (used to add reminder)
            $data['members'] = $data['staff'];

            if (!empty($data['client']->company)) {
                // Check if is realy empty client company so we can set this field to empty
                // The query where fetch the client auto populate firstname and lastname if company is empty
                if (is_empty_customer_company($data['client']->userid)) {
                    $data['client']->company = '';
                }
            }
        }

        $this->load->model('currencies_model');
        $data['currencies'] = $this->currencies_model->get();

        if ($id != '') {
            $customer_currency = $data['client']->default_currency;

            foreach ($data['currencies'] as $currency) {
                if ($customer_currency != 0) {
                    if ($currency['id'] == $customer_currency) {
                        $customer_currency = $currency;

                        break;
                    }
                } else {
                    if ($currency['isdefault'] == 1) {
                        $customer_currency = $currency;

                        break;
                    }
                }
            }

            if (is_array($customer_currency)) {
                $customer_currency = (object) $customer_currency;
            }

            $data['customer_currency'] = $customer_currency;

            $slug_zip_folder = (
                $client->company != ''
                ? $client->company
                : get_contact_full_name(get_primary_contact_user_id($client->userid))
            );

            $data['zip_in_folder'] = slug_it($slug_zip_folder);
        }

        $data['bodyclass'] = 'customer-profile dynamic-create-groups';
        $data['title']     = $title;
        //echo $this->load->view('admin/dashboard/studentdatalist',$data,true);
        
        $data['student_details'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $id))->row();
        $Years =  $this->getTotalYearList($data['student_details']->Admission_Year);
       
        $data['packageamount'] =  $this->getPackageamount($id,$Years);
        
        $data['deposit_result'] = $this->db->get_where(db_prefix().'student_fees_deposit', array('userid' => $id,'academic_year'=>$this->academic_session))->result();
        $data['academic_session'] = $this->academic_session;
        echo $this->load->view('admin/clients/dashboard_profile',$data,true);
    }
    
	
    /*
    *   @function:  student Details for TC
    */
    public function studentDetailsTC($id){
        $data['transport_result'] = $this->db->get_where(db_prefix().'transport')->result();
        
        //echo $this->input->get('group');
        //die;

        $group         = !$this->input->get('group') ? 'profile' : $this->input->get('group');
        $data['group'] = $group;

        if ($group != 'contacts' && $contact_id = $this->input->get('contactid')) {
            //redirect(admin_url('clients/client/' . $id . '?group=contacts&contactid=' . $contact_id));
        }
                // Customer groups
        $data['groups'] = $this->clients_model->get_groups();

        if ($id == '') {
            $title = _l('add_new', _l('client_lowercase'));
        } else {
            $client                = $this->clients_model->get($id);
            $data['customer_tabs'] = get_customer_profile_tabs();

            if (!$client) {
                show_404();
            }
            
            $feesmodule = [];
            $studentshift = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $client->userid))->row('Shift');
            if($studentshift)
            {
                $feesmodule = $this->db->get_where(db_prefix().'school_fees', array('shift' => $studentshift))->row();
            }
            
            $data['school_fees'] = $feesmodule;

            $data['contacts'] = $this->clients_model->get_all_contacts($id);
            $data['tab']      = isset($data['customer_tabs'][$group]) ? $data['customer_tabs'][$group] : null;

            /*
            if (!$data['tab']) {
                show_404();
            }
            */

            // Fetch data based on groups
            if ($group == 'profile') {
                $data['customer_groups'] = $this->clients_model->get_customer_groups($id);
                $data['customer_admins'] = $this->clients_model->get_admins($id);
            } elseif ($group == 'attachments') {
                $data['attachments'] = get_all_customer_attachments($id);
            } elseif ($group == 'vault') {
                $data['vault_entries'] = hooks()->apply_filters('check_vault_entries_visibility', $this->clients_model->get_vault_entries($id));

                if ($data['vault_entries'] === -1) {
                    $data['vault_entries'] = [];
                }
            } elseif ($group == 'estimates') {
                $this->load->model('estimates_model');
                $data['estimate_statuses'] = $this->estimates_model->get_statuses();
            } elseif ($group == 'invoices') {
                $this->load->model('invoices_model');
                $data['invoice_statuses'] = $this->invoices_model->get_statuses();
            } elseif ($group == 'credit_notes') {
                $this->load->model('credit_notes_model');
                $data['credit_notes_statuses'] = $this->credit_notes_model->get_statuses();
                $data['credits_available']     = $this->credit_notes_model->total_remaining_credits_by_customer($id);
            } elseif ($group == 'payments') {
                $this->load->model('payment_modes_model');
                $data['payment_modes'] = $this->payment_modes_model->get();
            } elseif ($group == 'notes') {
                $data['user_notes'] = $this->misc_model->get_notes($id, 'customer');
            } elseif ($group == 'projects') {
                $this->load->model('projects_model');
                $data['project_statuses'] = $this->projects_model->get_project_statuses();
            } elseif ($group == 'statement') {
                if (!has_permission('invoices', '', 'view') && !has_permission('payments', '', 'view')) {
                    set_alert('danger', _l('access_denied'));
                    //redirect(admin_url('clients/client/' . $id));
                }

                $data = array_merge($data, prepare_mail_preview_data('customer_statement', $id));
            } elseif ($group == 'map') {
                if (get_option('google_api_key') != '' && !empty($client->latitude) && !empty($client->longitude)) {
                    $this->app_scripts->add('map-js', base_url($this->app_scripts->core_file('assets/js', 'map.js')) . '?v=' . $this->app_css->core_version());

                    $this->app_scripts->add('google-maps-api-js', [
                        'path'       => 'https://maps.googleapis.com/maps/api/js?key=' . get_option('google_api_key') . '&callback=initMap',
                        'attributes' => [
                            'async',
                            'defer',
                            'latitude'       => "$client->latitude",
                            'longitude'      => "$client->longitude",
                            'mapMarkerTitle' => "$client->company",
                        ],
                    ]);
                }
            }

            $data['staff'] = $this->staff_model->get('', ['active' => 1]);
            //$data['user_result'] = $this->db->get_where(db_prefix.'contacts', array('userid' => $client->userid))->row();

            $data['client'] = $client;
            $title          = $client->company;

            // Get all active staff members (used to add reminder)
            $data['members'] = $data['staff'];

            if (!empty($data['client']->company)) {
                // Check if is realy empty client company so we can set this field to empty
                // The query where fetch the client auto populate firstname and lastname if company is empty
                if (is_empty_customer_company($data['client']->userid)) {
                    $data['client']->company = '';
                }
            }
        }

        $this->load->model('currencies_model');
        $data['currencies'] = $this->currencies_model->get();

        if ($id != '') {
            $customer_currency = $data['client']->default_currency;

            foreach ($data['currencies'] as $currency) {
                if ($customer_currency != 0) {
                    if ($currency['id'] == $customer_currency) {
                        $customer_currency = $currency;

                        break;
                    }
                } else {
                    if ($currency['isdefault'] == 1) {
                        $customer_currency = $currency;

                        break;
                    }
                }
            }

            if (is_array($customer_currency)) {
                $customer_currency = (object) $customer_currency;
            }

            $data['customer_currency'] = $customer_currency;

            $slug_zip_folder = (
                $client->company != ''
                ? $client->company
                : get_contact_full_name(get_primary_contact_user_id($client->userid))
            );

            $data['zip_in_folder'] = slug_it($slug_zip_folder);
        }

        $data['bodyclass'] = 'customer-profile dynamic-create-groups';
        $data['title']     = $title;
        //echo $this->load->view('admin/dashboard/studentdatalist',$data,true);
        
        $data['student_details'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $id))->row();
        $Years =  $this->getTotalYearList($data['student_details']->Admission_Year);       
        $data['packageamount'] =  $this->getPackageamount($id,$Years);
        //$data['packageamount'] =  $this->db->select('package_amount,deposit_amount,userid,package_id,admission_year,admission_date')->get_where(db_prefix().'student_package',array('userid' => $id,'package_year'=>$this->academic_session))->row();
        $data['deposit_result'] = $this->db->get_where(db_prefix().'student_fees_deposit', array('userid' => $id,'academic_year'=>$this->academic_session))->result();
        $data['academic_session'] = $this->academic_session;
        $data['checklist_array'] = $this->db->get_where('tblmaster_checklist')->result();
        $data['sid'] = $id;
		$data['class_list'] = $this->db->get_where(db_prefix().'master_class')->result();
		//$data['subject_list'] = $this->db->group_by('name')->get_where(db_prefix().'master_subject')->result();
		$student_last_class = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl_last_year, array('userid' => $id))->row('classId');
		
		if($student_last_class == 9 || $student_last_class == 10 || $student_last_class == 11 || $student_last_class == 12)
		{
			$data['subject_list'] = $this->db->order_by('subject_id', 'desc')->get_where(db_prefix().'master_subject_account_db', array('class_id' => $student_last_class))->result(); 
		}
		else
		{
			if($student_last_class == '')
			{
				$student_last_class_name = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $id))->row('Class');
				$master_class_id = $this->db->get_where(db_prefix().'master_class', array('name' => $student_last_class_name))->row('class_id');
				$data['subject_list'] = $this->db->group_by('name')->order_by('subject_id', 'asc')->get_where(db_prefix().'master_subject_account_db', array('class_id' => $master_class_id))->result();
			}
			else
			{
				$data['subject_list'] = $this->db->group_by('name')->order_by('subject_id', 'asc')->get_where(db_prefix().'master_subject_account_db', array('class_id' => $student_last_class))->result();
			}
		}
		
        $data['tc_details'] =  $this->db->get_where(db_prefix().'tc_requests', array('student_id' => $id))->row();
        echo $this->load->view('admin/dashboard/modal/tc/student-profile',$data,true);
    }
		    
	/* Class Subject List */
	public function classSubjectList($classid)
	{
		$subjectlist = $this->db->select('name')->order_by('name', 'asc')->get_where(db_prefix().'master_subject', array('class_id' => $classid))->result(); 	
			
		echo json_encode($subjectlist);
		exit;
	}
	
    /* Update TC request */
	public function updateTCDetails($sid = ''){
	    $recordCount = $this->db->get_where(db_prefix().'tc_requests', array('student_id' => $sid))->num_rows();
	    if($recordCount > 0)
	    {
	        $postData = $this->input->post();
			if($postData['gender'] == 'on')
			{
				$postData['gender'] = 'Female';
			}
			else
			{
				$postData['gender'] = 'Male';				
			}
			//echo '<pre>'; print_r($postData); die;
	        $postData['subjects_studied'] 	= implode(',',$postData['subjects_studied']);
	        $this->db->where('student_id', $sid);
	        $this->db->update('tbltc_requests', $postData);
			
			$tcID = $this->db->get_where(db_prefix().'tc_requests', array('student_id' => $sid))->row('id');
			if($_FILES['tc_application']['name'] != '')
			{
				$uploadedFiles = handle_file_upload($tcID,'tc_application', 'tc_application');
				if ($uploadedFiles && is_array($uploadedFiles)) {
					foreach ($uploadedFiles as $file) {
						$this->misc_model->add_attachment_to_database($tcID, 'tc_application', [$file]);
					}
				}
			}
	        
	        $status = true;
    		$message = 'TC request updated successfully!';
    		echo json_encode([
    			'success' => $status,
    			'message' => $message,
    		]);
    		exit();
	    }
	    else
	    {
			$postData = $this->input->post();	
	        $postData['student_id'] 		= $sid;
	        $postData['subjects_studied'] 	= implode(',',$postData['subjects_studied']);
			$postData['academic_year'] 		= $this->academic_session;
			$postData['created_at'] 		= date('Y-m-d H:i:s');
			$this->db->insert('tbltc_requests', $postData);
			$lid = $this->db->insert_id();
			//echo $this->db->last_query();
			//die;
			if ($lid) {			
				$uploadedFiles = handle_file_upload($lid,'tc_application', 'tc_application');
				if ($uploadedFiles && is_array($uploadedFiles)) {
					foreach ($uploadedFiles as $file) {
						$this->misc_model->add_attachment_to_database($lid, 'tc_application', [$file]);
					}
				}
				
				$status = true;
				$message = 'TC request submitted successfully!';
				echo json_encode([
					'success' => $status,
					'message' => $message,
				]);
				exit();
			}
			else{
				$status = false;
				$message = 'Documents are not submitted, try again!';
				echo json_encode([
					'success' => $status,
					'message' => $message,
				]);
				exit();
			}
	    }	            	
	}
	
    function getTotalYearList($Admission_Year){
       $year = explode("-",$Admission_Year);
       for($i = $year[0];$i <= date('Y');$i++){
           $ni = $i;
          $nYA[] = $i."-".substr(($ni+1), -2);
       }
        return $nYA;
    }
    
    function getPackageamount($id,$year){
        $this->db->select('package_amount,deposit_amount,userid,package_id,admission_year,admission_date,package_year');
        $this->db->from(db_prefix().'student_package');
        $this->db->where('userid',$id);
        $this->db->where_in('package_year',$year);
        $query = $this->db->get();
        return $query->result();
    }
    
    /*
    *   @function:  feedLedger
    */
    public  function feesLedger_($id){
        /*
        $data['student_details'] = $this->db->get_where(db_prefix().'contacts', array('userid' => $id))->row();
        $data['packageamount'] =  $this->db->select('package_amount,deposit_amount')->get_where(db_prefix().'student_package',array('userid' => $id))->row();
        $data['deposit_result'] = $this->db->get_where(db_prefix().'student_fees_deposit', array('userid' => $id))->result();
        echo $this->load->view('admin/collectfees/ladgerModel_',$data,true);
        */
        
        $data['student_details'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $id))->row();
        $Years =  $this->getTotalYearList($data['student_details']->Admission_Year);
        $data['packageamount'] =  $this->getPackageamount($id,$Years);
        //$data['packageamount'] =  $this->db->select('package_amount,deposit_amount,userid,package_id,admission_year,admission_date')->get_where(db_prefix().'student_package',array('userid' => $id,'package_year'=>$this->academic_session))->row();
        $data['deposit_result'] = $this->db->get_where(db_prefix().'student_fees_deposit', array('userid' => $id, 'management_status' => 1,'academic_year'=>$this->academic_session))->result();
        echo $this->load->view('admin/collectfees/ladgerModel',$data,true);
    
    }

    /**
    *  Function: getSubCategory
    */
    public function studentList()
    {
        $classname = $_POST['classname'];
        $html = '';
        if($classname)
        {
            $class = str_replace('_', ' ', $classname);
            $html = $this->db->select('userid,firstname,middlename,lastname,Father_Mobile,Father_Name,registration_id,Class,Admission_Year,payment_status')->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => $class, 'payment_status >' => 0))->result();
        }
        echo json_encode($html);
    }
   
    /**
    *   Function: getSubCategory Class wise
    */
    public function studentClassWiseList($classname)
    {
        $html = '';
        if($classname)
        {
            $class = str_replace('_', ' ', $classname);
            $html = $this->db->select('userid,firstname,middlename,lastname,Father_Mobile,Father_Name,registration_id,Class,Admission_Year')->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => $class))->result();
        }
        echo json_encode($html);
    }
    
    /**
    *   Function: getSubCategory
    */
    public function selectStudent()
    {
        $classname = $_POST['classname'];
        $sid = $_POST['sid'];
        $html = '';
        if($classname)
        {
            $class = str_replace('_', ' ', $classname);
            //$html = $this->db->select('userid,firstname,middlename,lastname,Father_Mobile,Father_Name,registration_id,Class')->get_where(db_prefix().'contacts', array('Class' => $class, 'userid' => $sid))->result();
            $this->db->select('a.Admission_Year,a.userid,a.Campus,a.Shift,a.firstname,a.middlename,a.lastname,a.Father_Mobile,a.Father_Name,a.registration_id,a.Class, b.package_amount as amount,b.createddate as createddate,b.deposit_amount as deposit_amount,b.last_payment_date,c.name,c.id as package_id,a.Admission_Year');
            $this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');
            $this->db->join(db_prefix().'student_package b','b.userid = a.userid', 'LEFT');
            $this->db->join(db_prefix().'master_package c','c.id = b.package_id', 'LEFT');
            //$this->db->order_by('b.id', 'DESC');
            //$this->db->group_by('b.userid');
            $this->db->where('b.package_year',$this->academic_session);
            $this->db->where('a.userid',$sid);
            $html = $this->db->get()->result();
            
            if(count($html) <= 0){
                $this->db->select('a.Admission_Year,a.userid,a.Campus,a.Shift,a.firstname,a.middlename,a.lastname,a.Father_Mobile,a.Father_Name,a.registration_id,a.Class,a.Admission_Year');
                $this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');
                $this->db->where('a.userid',$sid);
                $html = $this->db->get()->result();
                foreach($html as $vl){
                    $vl->amount             = '0';
                    $vl->createddate        = 'NA';
                    $vl->deposit_amount     = '0';
                    $vl->last_payment_date  = 'NA';
                    $vl->name               =   'No Package Selected';
                    $vl->id               =   '';
                }
            }
        }
      
        echo json_encode($html);
    }
    
    /**
    *   Function: selectStudentResult
    */
    public function selectStudentResult()
    {
        $classname = $_POST['classname'];
        $sid = $_POST['sid'];
        $html = '';
        if($classname)
        {
            $class = str_replace('_', ' ', $classname);
            //$html = $this->db->select('userid,firstname,middlename,lastname,Father_Mobile,Father_Name,registration_id,Class')->get_where(db_prefix().'contacts', array('Class' => $class, 'userid' => $sid))->result();
            $this->db->select('a.Academic_Year,a.userid,a.Campus,a.Shift,a.firstname,a.middlename,a.lastname,a.Father_Mobile,a.Father_Name,a.registration_id,a.Class,a.Date_of_Birth,a.Mother_Name');
            $this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');
            //$this->db->join(db_prefix().'student_package b','b.userid = a.userid', 'LEFT');
            //$this->db->join(db_prefix().'master_package c','c.id = b.package_id', 'LEFT');
            //$this->db->order_by('b.id', 'DESC');
            //$this->db->group_by('b.userid');
            //$this->db->where('b.package_year',$this->academic_session);
            $this->db->where('a.userid',$sid);
            $html = $this->db->get()->result();
            
            if(count($html) <= 0){
                $this->db->select('a.Admission_Year,a.userid,a.Campus,a.Shift,a.firstname,a.middlename,a.lastname,a.Father_Mobile,a.Father_Name,a.registration_id,a.Class,a.Academic_Year');
                $this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');
                $this->db->where('a.userid',$sid);
                $html = $this->db->get()->result();
                foreach($html as $vl){
                    $vl->amount             = '0';
                    $vl->createddate        = 'NA';
                    $vl->deposit_amount     = '0';
                    $vl->last_payment_date  = 'NA';
                    $vl->name               =   'No Package Selected';
                    $vl->id               =   '';
                }
            }
        }
      
        echo json_encode($html);
    }
    
    /**
    *   @Student result list
    */
    public function studentResultList($classname)
    {
        $class = str_replace('_', ' ', $classname);
        $tablename = db_prefix().'contacts'.$this->contact_tbl;
        $academic_year = $this->academic_session;
        $classid = $this->db->get_where('tblmaster_class', array('name' => $class))->row('class_id');
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('studentresult_list', [
                'classname'   => $class,'classid' => $classid,'tablename'=>$tablename, 'academic_year' => $academic_year
            ]);
        }
        //$this->app->get_table_data('clients_dashboard');
    }
    
    /**
    *   Function: studentResultPrivew
    */
    public function studentResultPrivew()
    {
        $classname = $_POST['classname'];
        $academic_year = $this->academic_session;
        //$sid = $_POST['sid'];
        $html = '';
        if($classname)
        {
            $class = str_replace('_', ' ', $classname);
            $classid = $this->db->get_where('tblmaster_class', array('name' => $class))->row('class_id');
            $this->db->select('a.Academic_Year,a.userid,a.Campus,a.Shift,a.firstname,a.middlename,a.lastname,a.Father_Mobile,a.Father_Name,a.registration_id,a.Class,a.Date_of_Birth,a.Mother_Name');
            $this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');
            $this->db->order_by('a.firstname','asc');
            $this->db->where('a.Class',$class);
            //$this->db->where('a.userid',$sid);
            $result = $this->db->get()->result();
            if($result)
            {
                foreach($result as $r)
                {
                    $resultData = $this->db->get_where('tblstudent_result', array('student_id' => $r->userid, 'class_id' => $classid, 'academic_year' => $academic_year))->num_rows();
                    $html .= '<tr>';
                    if($r->middlename != '' || $r->middlename != 'null')
                    {
                        $html .= '<td>'.$r->firstname.' '.$r->middlename.''.$r->lastname.'</td>';
                    }
                    else
                    {
                        $html .= '<td>'.$r->firstname.''.$r->lastname.'</td>';
                    }
                    $html .= '<td>'.$r->Father_Name.'</td>';
                    $html .= '<td>'.$r->Mother_Name.'</td>';
                    if($r->Academic_Year!==''){
                        $html .= '<td>'.$r->Academic_Year.'</td>';
                     }else{
                        $html .= '<td>NA</td>'; 
                     }
                    $html .= '<td>'.$r->Date_of_Birth.'</td>';
                    $html .= '<td>'.$r->Class.'</td>';
                    $html .= '<td>'.$r->Campus.'</td>';
                    if($resultData > 0)
                    {
                        $html .= '<td><a class="btn btn-info" onclick="printInvoice_priview('.$r->userid.')" href="javascript:void(0)">Print</a></td>';
                    }
                    else
                    {
                        $html .= '<td>NA</td>';   
                    }
                    $html .= '<tr>';
                }
            }
            else
            {
                $html .= '<tr>';
                    $html .= '<td>No record found</td>';
                $html .= '</tr>';
            }
        }
        echo $html;
    }
    
    /**
    *   Function: selectStudentInvoice
    */
    public function selectStudentInvoice()
    {
        $classname = $_POST['classname'];
        $sid = $_POST['sid'];
        $html = '';
        if($sid)
        {
            $html =  $this->db->select('deposit_date,note,payment_mode,deposit_amount,userid,id,management_status')->order_by('id', 'desc')->get_where(db_prefix().'student_fees_deposit',array('userid'=>$sid,'academic_year'=>$this->academic_session))->result();
        }
        echo json_encode($html);
    }
    
    /**
    *   Function: getSubCategory
    */
    public function getStudentPackage()
    {
       $sid = $_POST['sid'];
        $html = '';
        if($sid)
        {
            $studentpackage_id = $this->db->get_where(db_prefix().'student_package',array('userid' => $sid,'package_year'=>$this->academic_session))->row('package_id');
            $html = $studentpackage_id;
        }
        echo json_encode($html);
    }

    /* Get item by id / ajax */
    public function searchStudent($classid, $studentname)
    {
        if ($this->input->is_ajax_request()) {
            $item                     = $this->invoice_items_model->get($id);
            $item->long_description   = nl2br($item->long_description);
            $item->custom_fields_html = render_custom_fields('items', $id, [], ['items_pr' => true]);
            $item->custom_fields      = [];

            $cf = get_custom_fields('items');

            foreach ($cf as $custom_field) {
                $val = get_custom_field_value($id, $custom_field['id'], 'items_pr');
                if ($custom_field['type'] == 'textarea') {
                    $val = clear_textarea_breaks($val);
                }
                $custom_field['value'] = $val;
                $item->custom_fields[] = $custom_field;
            }
            echo json_encode($item);
        }
    }
    
    /* feesdeposit */
    public function feesdeposit($userids)
    {        
        if ($this->input->is_ajax_request()) {
			$packageYearlyDedection = $this->db->get_where('tblpackage_yearly_deduct', array('package_id' => $this->input->post('package_id')))->result();
			
			if(count($packageYearlyDedection) > 0)
			{
				$this->feeSchemeRs1();
			}
			else
			{
				$userid = $this->input->post('student_id');
				if($this->input->post('Campus')!=''){
					  $post_st['Campus'] = $this->input->post('Campus');
				}
				if($this->input->post('Shift')!=''){
					  $post_st['Shift'] = $this->input->post('Shift');
				}
				if($post_st['Shift']!="" || $post_st['Campus'] !=''){
					$this->db->where('userid',$userid);
					$this->db->update(db_prefix().'contacts'.$this->contact_tbl,$post_st);
				}
				$plandetails = $this->db->get_where(db_prefix().'student_package', array('userid' => $userid,'package_year'=>$this->academic_session))->result();
				if(count($plandetails) <= 0)
				{
					$packageamount = $this->db->get_where(db_prefix().'master_package', array('id' => $this->input->post('package_id')))->row('amount');
					
					$contactsInfo = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $userid))->row();
					$postpackage['package_amount']      =   $packageamount;
					$postpackage['package_id']          =   $this->input->post('package_id');
					$postpackage['package_year']        =   $this->academic_session;
					$postpackage['last_payment_date']   =   date('Y-m-d H:i:s');
					$postpackage['userid']              =   $userid;
					$postpackage['admission_year']      =   $contactsInfo->Admission_Year;
					$postpackage['admission_date']      =   date('Y-m-d',$contactsInfo->Date_of_Admission);
					$this->db->insert(db_prefix().'student_package', $postpackage);
					$plandetails = $this->db->get_where(db_prefix().'student_package', array('userid' => $userid,'package_year'=>$this->academic_session))->result();					
				}
				 
				if(count($plandetails) > 0)
				{
					$postData['payment_mode'] = $this->input->post('payment_mode');
					$particulars_id = $this->input->post('particulars_id');
					if($this->input->post('invoiceId')!=''){
						$invoice_ID = $this->input->post('invoiceId');
					}else{					 
						$studentType = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl_last_year, array('userid' => $userid))->num_rows();
						$studentTypeOldInvoice = $this->db->get_where('tblstudent_fees_invoice', array('old_new_status' => 1))->num_rows();
						$studentTypeNewInvoice = $this->db->get_where('tblstudent_fees_invoice', array('old_new_status' => 2))->num_rows();
						if($studentType > 0)
						{
							$studentTypeOldInvoice++;
							$number_ = sprintf('%03d',$studentTypeOldInvoice);
							$old_new_status = 1;
							/*$invoice_number = '22-23/01/'.$number_;	*/
                            $invoice_number = $this->f_year.'-'.$this->l_year.'/01/'.$number_;  
						}
						else
						{
							$studentTypeNewInvoice++;
							$number_ = sprintf('%03d',$studentTypeNewInvoice);
							$old_new_status = 2;
							/*$invoice_number = '22-23/02/'.$number_;	*/
                            $invoice_number = $this->f_year.'-'.$this->l_year.'/02/'.$number_;  		
						}
						$this->db->insert('tblstudent_fees_invoice',array('userid'=>$userid,'created_date'=>date('Y-m-d H:i:s'),'academic_year'=>$this->academic_session,'package_id'=>$plandetails[0]->package_id,'particulars_id'=>$particulars_id, 'invoice_number' => $invoice_number, 'old_new_status' => $old_new_status));
						$invoice_ID =  $this->db->insert_id();
					}
					 $deposit_amount = 0;
					 foreach($postData['payment_mode'] as $val){
						$check_no            =   $this->input->post('deposit_amount_'.$val);
						foreach($check_no as $key=>$vanew){ 
							$postData['userid']                 =   $userid;
							$postData['invoice_id']             =   $invoice_ID;
							$postData['package_id']             =   $plandetails[0]->package_id;
							$postData['deposit_date']           =   date('Y-m-d', strtotime($this->input->post('deposit_date_'.$val)[$key]));
							$postData['payment_mode']           =   $val;
							$postData['check_no']               =   $this->input->post('check_no_'.$val)[$key];
						   // if($val=='cheque'){
								$postData['cheque_date']            =   date('Y-m-d',strtotime($this->input->post('cheque_date_'.$val)[$key]));
							//}
							$postData['bank_name']              =   $this->input->post('bank_name_'.$val)[$key];
							$postData['branch_name']            =   $this->input->post('branch_name_'.$val)[$key];
							$postData['fees_type']              =   $this->input->post('fees_type_'.$val)[$key];
							$postData['deposit_amount']         =   $this->input->post('deposit_amount_'.$val)[$key];
							$postData['installment']            =   1;
							$postData['accounted_id']           =   get_staff_user_id();
							$postData['accounted_update_date']  =   date('Y-m-d h:i:s');
							$postData['note']                   =   $this->input->post('note');
							$postData['dd_upi_online']          =   @$this->input->post('dd_upi_online_'.$val)[$key];
							$postData['academic_year']          =   $this->academic_session;
							$deposit_amount  .= $postData['deposit_amount'];
						  
							if($postData['deposit_amount'] > 0){
								
								if($this->input->post('invoiceId')!=''){
									$invoice_ID = $this->input->post('invoiceId');
                                    if($this->input->post('fees_deposit_id_'.$val)[$key] !=''){
    									$this->db->where('id',$this->input->post('fees_deposit_id_'.$val)[$key]);
    									$this->db->update(db_prefix().'student_fees_deposit',$postData);
                                    }
                                    else{
                                        $this->db->insert(db_prefix().'student_fees_deposit', $postData);
                                        $stfee =  $this->db->insert_id();
                                    }
									//echo $this->db->last_query();
								 }else{
										$this->db->insert(db_prefix().'student_fees_deposit', $postData);
										$stfee =  $this->db->insert_id();
								  }
							}
						}   
					}
					$deposit_amount = $this->db->select('sum(deposit_amount) AS deposit_amount')->get_where('tblstudent_fees_deposit',array('userid'=>$userid,'invoice_id'=>$invoice_ID))->row('deposit_amount');
					 
					$this->db->where('id',$invoice_ID);
					$this->db->update('tblstudent_fees_invoice',array('deposit_amount'=>$deposit_amount,'note'=>$postData['note'],'deposit_date'=>$postData['deposit_date'],'particulars_id'=>$particulars_id));
					 if($deposit_amount > 0)
					{
						$TotaldDepositAmount =    $this->db->select('sum(deposit_amount) AS deposit_amount')->get_where(db_prefix().'student_fees_deposit', array('userid'=>$userid,'academic_year'=>$this->academic_session))->row('deposit_amount');
						$packageData['last_payment_date'] = date('Y-m-d h:i:s');
						$packageData['deposit_amount'] = $TotaldDepositAmount;
						$this->db->where('id', $plandetails[0]->id);
						$this->db->update(db_prefix().'student_package', $packageData);
						$message = _l('Fees deposit successful!', _l('student'));
						echo json_encode([
							'success' => $plandetails[0]->package_id ? true : false,
							'message' => $message,
							'url' => base_url().'admin/dashboard/studentPrint/'.$userid.'/'.$invoice_ID
						]); 
					}
					else
					{
						
					  $message = _l('Fees already deposited!', _l('student'));
						echo json_encode([
						'success' => $plandetails[0]->package_id ? true : false,
						'message' => $message,
					 ]);
						
					}
				}
				else
				{
					  $message = _l('User Id Not found', _l('student'));
						echo json_encode([
						'success' => $plandetails[0]->package_id ? true : false,
						'message' => $message,
					 ]);
				}				
			}			
        }
    }
	
	/* Fee Scheme Rs1 */
	public function feeSchemeRs1()
	{
		$userid = $this->input->post('student_id');
		$packageYearlyDedection = $this->db->get_where('tblpackage_yearly_deduct', array('package_id' => $this->input->post('package_id')))->result();
		if(count($packageYearlyDedection) > 0)
		{
			if($this->input->post('Campus')!=''){
				$post_st['Campus'] = $this->input->post('Campus');
			}
			if($this->input->post('Shift')!=''){
				$post_st['Shift'] = $this->input->post('Shift');
			}
			if($post_st['Shift']!="" || $post_st['Campus'] !=''){
				$this->db->where('userid',$userid);
				$this->db->update(db_prefix().'contacts'.$this->contact_tbl,$post_st);
			}
			$plandetails = $this->db->get_where(db_prefix().'student_package', array('userid' => $userid,'package_year'=>$this->academic_session))->result();	

			if(count($plandetails) <= 0)
			{
				$packageamount = $this->db->get_where(db_prefix().'master_package', array('id' => $this->input->post('package_id')))->row('amount');
				$lsp = 0;
				$contactsInfo = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $userid))->row();
				foreach($packageYearlyDedection as $p)
				{
					$last_payment_date 					= 	date("Y-m-d H:i:s", strtotime("+$lsp year"));
					$postpackage['package_amount']      =   $packageamount;
					$postpackage['yearly_amount']       =   $p->deduct_amount;
					$postpackage['package_id']          =   $this->input->post('package_id');
					$postpackage['package_year']        =   $p->deduct_year;
					$postpackage['last_payment_date']   =   $last_payment_date;
					$postpackage['userid']              =   $userid;
					$postpackage['admission_year']      =   $contactsInfo->Admission_Year;
					$postpackage['admission_date']      =   date('Y-m-d', strtotime($contactsInfo->Date_of_Admission));
					$this->db->insert(db_prefix().'student_package', $postpackage);	
					$lsp++;
				}
				$plandetails = $this->db->get_where(db_prefix().'student_package', array('userid' => $userid,'package_year'=>$this->academic_session))->result();					
			}
			if(count($plandetails) > 0)
			{
				$postData['payment_mode'] = $this->input->post('payment_mode');
                $particulars_id = $this->input->post('particulars_id');
                if($this->input->post('invoiceId')!=''){
                    $invoice_ID = $this->input->post('invoiceId');
                }else{
					$studentType = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl_last_year, array('userid' => $userid))->num_rows();
					$studentTypeOldInvoice = $this->db->get_where('tblstudent_fees_invoice', array('old_new_status' => 1))->num_rows();
					$studentTypeNewInvoice = $this->db->get_where('tblstudent_fees_invoice', array('old_new_status' => 2))->num_rows();
										
					if(count($packageYearlyDedection) > 0){
						/*$f_year = 22;
						$l_year = 23;*/
						
						if($studentType > 0)
						{
							$studentTypeOldInvoice++;
							$number_ = sprintf('%03d',$studentTypeOldInvoice);
							$old_new_status = 1;
							$invoice_number = $this->f_year.'-'.$this->l_year.'/01/'.$number_;	
						}
						else
						{
							$studentTypeNewInvoice++;
							$number_ = sprintf('%03d',$studentTypeNewInvoice);
							$old_new_status = 2;
							$invoice_number = $this->f_year.'-'.$this->l_year.'/02/'.$number_;			
						}
						$rs_invoice_academic_year = '20'.$this->f_year.'-'.$this->l_year;
						$this->db->insert('tblstudent_fees_invoice',array('userid'=>$userid,'created_date'=>date('Y-m-d H:i:s'),'academic_year'=>$rs_invoice_academic_year,'package_id'=>$plandetails[0]->package_id,'particulars_id'=>$particulars_id, 'invoice_number' => $invoice_number, 'old_new_status' => $old_new_status));
						$invoice_ID =  $this->db->insert_id();								
					}
				}
				$deposit_amount = 0;
				//echo '<pre>'; print_r($invoiceIDData); die;
				foreach($postData['payment_mode'] as $val){
					$check_no            =   $this->input->post('deposit_amount_'.$val);
					foreach($check_no as $key=>$vanew){
						$postData['userid']                 =   $userid;
						$postData['invoice_id']             =   $invoice_ID;
						$postData['package_id']             =   $plandetails[0]->package_id;
						$postData['deposit_date']           =   date('Y-m-d', strtotime($this->input->post('deposit_date_'.$val)[$key]));
						$postData['payment_mode']           =   $val;
						$postData['check_no']               =   $this->input->post('check_no_'.$val)[$key];
					   // if($val=='cheque'){
							$postData['cheque_date']            =   date('Y-m-d',strtotime($this->input->post('cheque_date_'.$val)[$key]));
						//}
						$postData['bank_name']              =   $this->input->post('bank_name_'.$val)[$key];
						$postData['branch_name']            =   $this->input->post('branch_name_'.$val)[$key];
						$postData['fees_type']              =   $this->input->post('fees_type_'.$val)[$key];
						$postData['deposit_amount']         =   $this->input->post('deposit_amount_'.$val)[$key];
						$postData['installment']            =   1;
						$postData['accounted_id']           =   get_staff_user_id();
						$postData['accounted_update_date']  =   date("Y-m-d H:i:s", strtotime("+$lsps year"));
						$postData['note']                   =   $this->input->post('note');
						$postData['dd_upi_online']          =   @$this->input->post('dd_upi_online_'.$val)[$key];
						$postData['academic_year']          =   $this->academic_session;
						$deposit_amount  .= $postData['deposit_amount'];
						//echo '<pre>'; print_r($deposit_amount); die;
						if($postData['deposit_amount'] > 0){									
							if($this->input->post('invoiceId')!=''){
								$invoice_ID = $this->input->post('invoiceId');
								$this->db->where('id',$this->input->post('fees_deposit_id_'.$val)[$key]);
								$this->db->update(db_prefix().'student_fees_deposit',$postData);
								//echo $this->db->last_query();
							}else{
								$this->db->insert(db_prefix().'student_fees_deposit', $postData);
								$stfee =  $this->db->insert_id();
							}
						}
					}
				}
				$deposit_amount = $this->db->select('sum(deposit_amount) AS deposit_amount')->get_where('tblstudent_fees_deposit',array('userid'=>$userid,'invoice_id'=>$invoice_ID))->row('deposit_amount');
				
				$this->db->where('id',$invoice_ID);
				$this->db->update('tblstudent_fees_invoice',array('deposit_amount'=>$deposit_amount,'note'=>$postData['note'],'deposit_date'=>$postData['deposit_date'],'particulars_id'=>$particulars_id));
				if($deposit_amount > 0)
				{
					$TotaldDepositAmount = $this->db->select('sum(deposit_amount) AS deposit_amount')->get_where(db_prefix().'student_fees_deposit', array('userid'=>$userid,'academic_year'=>$this->academic_session))->row('deposit_amount');
					$packageData['last_payment_date'] = date('Y-m-d H:i:s');
					$packageData['deposit_amount'] = $TotaldDepositAmount;
					$this->db->where('id', $plandetails[0]->id);
					$this->db->update(db_prefix().'student_package', $packageData);			
				}
							
				if($deposit_amount > 0)
                {
                    $message = _l('Fees deposit successful!', _l('student'));
                    echo json_encode([
                        'success' => $plandetails[0]->package_id ? true : false,
                        'message' => $message,
                        'url' => base_url().'admin/dashboard/studentPrintFessSchemeRs1/'.$userid.'/'.$invoice_ID
                    ]); 
                }
                else
                {             
					$message = _l('Fees already deposited!', _l('student'));
						echo json_encode([
						'success' => $plandetails[0]->package_id ? true : false,
						'message' => $message,
					]);                    
                }
			}
		}
	}
    
    public function studentPrint($id,$invoice){
        $data['student_details'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $id))->row();
        $data['invoice'] = $this->db->get_where(db_prefix().'student_fees_invoice', array('userid' => $id,'academic_year'=>$this->academic_session,'id'=>$invoice))->row();
      
		$data['invoice_number'] = $data['invoice']->invoice_number;
	  
        $invoice_details = $this->db->get_where(db_prefix().'student_fees_deposit', array('invoice_id' => $data['invoice']->id,'academic_year'=>$this->academic_session));
        $data['invoice_details'] = $invoice_details->result();
        $packagenameArr = $this->db->select('name,deduction_mode,payment_type')->get_where(db_prefix().'master_package', array('id' => $invoice_details->row()->package_id))->row();
        $packagename = $packagenameArr->name;
        
        $packageType = $packagenameArr->payment_type;
        if($packageType == 3)
            $notetext = 1;
        elseif($packageType == 2)
            $notetext = 2;
        else
            $notetext = 3;
        
        $data['academic_session'] = $this->academic_session;
        $data['packagename'] = ($packagename != '')?$packagename:'NA';
        $deduction_mode = ($packagenameArr->deduction_mode == 2)?"Nil":"0.00";
        $data['deduction_mode'] = $deduction_mode;
        $accountantnameArr = $this->db->select('firstname,lastname')->get_where(db_prefix().'staff', array('staffid' => $invoice_details->row()->accounted_id))->row();
        $accountantname = $accountantnameArr->firstname.' '.$accountantnameArr->lastname;
        $data['accountantname'] = ($accountantname != '')?$accountantname:'NA';
        //$this->load->view('theisb-invoice/index',$data);
		$payment_mode = strtoupper($invoice_details->row()->payment_mode);
		$cheque_status = $invoice_details->row()->cheque_status;
		if($payment_mode == 'CHEQUE')
		{
			if($cheque_status == 'pass')
			{
				$this->load->view('theisb-invoice/index',$data);							
			}
			else{
				$this->load->view('theisb-invoice/voucher',$data);				
			}			
		}
		else
		{
			$this->load->view('theisb-invoice/index',$data);			
		}
    }
	
	/* Befor Receipts */
    public function studentBeforReceiptPrint($id,$invoice){
        $data['student_details'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $id))->row();
        $data['invoice'] = $this->db->get_where(db_prefix().'student_fees_invoice', array('userid' => $id,'academic_year'=>$this->academic_session,'id'=>$invoice))->row();
      
		$data['invoice_number'] = $data['invoice']->invoice_number;
	  
        $invoice_details = $this->db->get_where(db_prefix().'student_fees_deposit_befor', array('invoice_id' => $data['invoice']->id,'academic_year'=>$this->academic_session));
        $data['invoice_details'] = $invoice_details->result();
        $packagenameArr = $this->db->select('name,deduction_mode,payment_type')->get_where(db_prefix().'master_package', array('id' => $invoice_details->row()->package_id))->row();
        $packagename = $packagenameArr->name;
        
        $packageType = $packagenameArr->payment_type;
        if($packageType == 3)
            $notetext = 1;
        elseif($packageType == 2)
            $notetext = 2;
        else
            $notetext = 3;
        
        $data['academic_session'] = $this->academic_session;
        $data['packagename'] = ($packagename != '')?$packagename:'NA';
        $deduction_mode = ($packagenameArr->deduction_mode == 2)?"Nil":"0.00";
        $data['deduction_mode'] = $deduction_mode;
        $accountantnameArr = $this->db->select('firstname,lastname')->get_where(db_prefix().'staff', array('staffid' => $invoice_details->row()->accounted_id))->row();
        $accountantname = $accountantnameArr->firstname.' '.$accountantnameArr->lastname;
        $data['accountantname'] = ($accountantname != '')?$accountantname:'NA';
        //$this->load->view('theisb-invoice/index',$data);
		$payment_mode = strtoupper($invoice_details->row()->payment_mode);
		$cheque_status = $invoice_details->row()->cheque_status;
		if($payment_mode == 'CHEQUE')
		{
			if($cheque_status == 'pass')
			{
				$this->load->view('theisb-invoice/index',$data);							
			}
			else{
				$this->load->view('theisb-invoice/voucher',$data);				
			}			
		}
		else
		{
			$this->load->view('theisb-invoice/index',$data);			
		}
    }

	public function studentPrintFessSchemeRs1($id,$invoice){
        $data['student_details'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $id))->row();
        $data['invoice'] = $this->db->get_where(db_prefix().'student_fees_invoice', array('userid' => $id,'academic_year'=>$this->academic_session,'id'=>$invoice))->row();
		
		$data['invoice_number'] = $data['invoice']->invoice_number;
      
        $invoice_details =    $this->db->get_where(db_prefix().'student_fees_deposit', array('invoice_id' => $data['invoice']->id,'academic_year'=>$this->academic_session));
        $data['invoice_details'] = $invoice_details->result();
        $packagenameArr = $this->db->select('name,deduction_mode,payment_type')->get_where(db_prefix().'master_package', array('id' => $invoice_details->row()->package_id))->row();
        $packagename = $packagenameArr->name;
        
        $packageType = $packagenameArr->payment_type;
        if($packageType == 3)
            $notetext = 1;
        elseif($packageType == 2)
            $notetext = 2;
        else
            $notetext = 3;
        
        $data['academic_session'] = $this->academic_session;
        $data['packagename'] = ($packagename != '')?$packagename:'NA';
        $deduction_mode = ($packagenameArr->deduction_mode == 2)?"Nil":"0.00";
        $data['deduction_mode'] = $deduction_mode;
        $accountantnameArr = $this->db->select('firstname,lastname')->get_where(db_prefix().'staff', array('staffid' => $invoice_details->row()->accounted_id))->row();
        $accountantname = $accountantnameArr->firstname.' '.$accountantnameArr->lastname;
        $data['accountantname'] = ($accountantname != '')?$accountantname:'NA';
		$payment_mode = strtoupper($invoice_details->row()->payment_mode);
		$cheque_status = $invoice_details->row()->cheque_status;
		if($payment_mode == 'CHEQUE')
		{
			if($cheque_status == 'pass')
			{
				$this->load->view('theisb-invoice/feeSchemeRs1',$data);							
			}
			else{
				$this->load->view('theisb-invoice/voucher',$data);				
			}
		}
		else
		{
			$this->load->view('theisb-invoice/feeSchemeRs1',$data);			
		}
    }

    /* ---------------------------------------------------
    *   @Function: feesCollectRecord
    *---------------------------------------------------*/
    public function feesCollectRecord()
    {
        $pendingStudent = $this->db->get_where(db_prefix().'student_fees_invoice', array('management_status' => 0,'academic_year'=>$this->academic_session))->num_rows();
        $approvedStudent = $this->db->get_where(db_prefix().'student_fees_invoice', array('management_status' => 1,'academic_year'=>$this->academic_session))->num_rows();
        $resubmitStudent = $this->db->get_where(db_prefix().'student_fees_invoice', array('management_status' => 2,'academic_year'=>$this->academic_session))->num_rows();
       
       $data = array(
                'pendingStudent' => $pendingStudent,
                'approvedStudent' => $approvedStudent,
                'resubmitStudent' => $resubmitStudent
            );
        echo json_encode($data);
    }

    public function approvedStudentFee($para1='')
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('approvedStudentFee', [
                'payment_status'   => $para1, 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }

    public function studentFeesDepositList($para1='')
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('studentFeesDepositList', [
                'payment_status'   => $para1, 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }

    /**
    *   Function: getSubCategory
    */
    public function checkBouncedPenalty()
    {
        $invoiceid = $_POST['invoiceid'];
        $html = '';
        if($invoiceid)
        {
            $postData['check_bounced_status'] = 1;
            $postData['check_bounced_datetime'] = date('Y-m-d H:i:s');
            $postData['check_bounced_amount'] = 500;

            $this->db->where('invoice_id', $invoiceid);
            $this->db->update('tblstudent_fees_deposit', $postData);
            if ($this->db->affected_rows() >= 0) {
                $html = 1;
            }
        }
        echo json_encode($html);
    }

    public function getAgreementsList()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('agreementsList');
        }
    }
    
    public function dayBookList()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('daybook_students');
        }
    }
    
    public function getBounceTable()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('getBounceTable');
        }
    }
    
    public function totalRTEStudents()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('total_rte_students', [ 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
    
    public function packageRecordList()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('packageRecord_list');
        }
    }
    
    public function totalPaidStudents($para1 = '')
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('total_paid_students', [
                'payment_status'   => $para1, 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
    
     public function totalunPaidStudents($para1 = '')
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('total_unpaid_students', [
                'payment_status'   => $para1, 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
            
    public function resubmitStatusFees()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('resubmitStatusFees', [
                'payment_status'   => 2
            ]);
        }
    }

    /* Chart weekly payments statistics on home page / ajax */
    public function weekly_payments_statistics($currency)
    {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->dashboard_model->get_weekly_payments_statistics($currency));
            die();
        }
    }
    
    /* Reports FUnstion */
    public function reportData($para1=''){
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('approvedStudentFee', [
                'payment_status'   => $para1, 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
    
    public function shiftwiseStudent($para1 = '')
    {
        if ($this->input->is_ajax_request()) {
            $_SESSION['shift'] = $para1;
            $this->app->get_table_data('student_list_shiftwise', [
                'shift'   => $para1,
            ]);
        }
    }    
    
    /* New Student Add */
    public function newStudentAdd()
    {
        if($this->input->post())
        {
            $data = $this->input->post();
            //$this->clients_model->add_($data, false);
            $message = _l('Student add successfully');
            echo json_encode([
                'success' => true,
                'message' => $message,
            ]);
        }
        else
        {
            $message = _l('Data not found');
            echo json_encode([
                'success' => false,
                'message' => $message,
            ]);
        }
    }
    
    public function setSession($session = '')
    {
        if ($this->input->is_ajax_request()) {
            $this->session->set_userdata('academic_session', $session);
        }
    } 
    
    function getInvoiceData($invoiceID,$studentFeeDepositeId){
        
        $invoice_details =    $this->db->get_where(db_prefix().'student_fees_deposit', array('id'=>$studentFeeDepositeId,'invoice_id'=> $invoiceID,'academic_year'=>$this->academic_session))->result();
        
        echo json_encode($invoice_details);
    }
    
    public function dayBookReport(){
        $post['payment_mode_filter'] = $this->uri->segment(4);
        $post['date_timepicker_start'] = $this->uri->segment(5);
        $post['date_timepicker_end'] = $this->uri->segment(6);
        $day_book_list = $this->dashboard_model->dayBookReport($post);
        $data = array();
        $no = $_POST['start'];
        foreach($day_book_list as $value){
            $no++;
            $row = array();
            $ct= '';
            $year =   explode("-",$value->academic_year);
            $ct ='(Due)';
            if($year[0]==date('Y')){
                    $ct=  '(Current Year)';
                }
            
            $row[] = $value->student_name;
            $row[] = $value->Father_Name;
            $row[] = $value->Mother_Name;
            $row[] = $value->Class;
            $row[] = $value->Campus;
            $row[] = $value->Shift;
            $row[] = $value->Father_Mobile;
            $row[] = $value->Mother_Mobile;
            $row[] = '<b>ID: </b>'.$value->email.'<br><b>Password: </b>'.$value->paa;
            $row[] = $value->academic_year.$ct;
            $row[] = date('d-m-Y', strtotime($value->deposit_date));
            $row[] = $value->deposit_amount;
            $row[] = strtoupper($value->payment_mode);
            $row[] = $value->payment_mode=='cheque' ? 'Cheque N0:'.$value->check_no  : strtoupper($value->dd_upi_online);
            $row[] = strtoupper($value->note);
            $row[] = get_staff_full_name($value->accounted_id);
            
            $data[] = $row; 
        }
        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => count($day_book_list),
            "recordsFiltered" => $this->dashboard_model->count_dayBookReport($post),
            "data" => $data,
        );
        //output to json format
        echo json_encode($output);
    }
	
	/* New student list management */
	public function newStudentToday($date_timepicker_start = '', $date_timepicker_end = ''){
		
		if($date_timepicker_start != '')
		{
			$start_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_start.' -1 day'));
		}
		else
		{
			$start_date = date('Y-m-d 23:59:59', strtotime('-1 day'));		
		}
		if($date_timepicker_end != '')
		{
			$end_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_end.' +1 day'));
		}
		else
		{
			$end_date = date('Y-m-d 23:59:59', strtotime('+1 day'));				
		}
		
		if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('newStudentToday_management', [
                'start_date' => $start_date, 'end_date' => $end_date, 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }		
    }
	
	/* Search Total Student */
	public function searchTotalStudent()
	{
		$date_timepicker_start 	= $_POST['n_start_date'];
		$date_timepicker_end 	= $_POST['n_end_date'];
		
		if($date_timepicker_start != '')
		{
			$start_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_start.' -1 day'));
		}
		else
		{
			$start_date = date('Y-m-d 23:59:59', strtotime('-1 day'));		
		}
		if($date_timepicker_end != '')
		{
			$end_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_end.' +1 day'));
		}
		else
		{
			$end_date = date('Y-m-d 23:59:59', strtotime('+1 day'));				
		}
		
		$newStudentCount = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('datecreated > ' => $start_date, 'datecreated < ' => $end_date, 'Academic_Year' => $this->academic_session))->num_rows();
		
		echo json_encode($newStudentCount);
	}
	
	/* Search New Student Print */
	public function searchNewStudentPrint()
	{
		$date_timepicker_start 	= $_POST['date_timepicker_start_new'];
		$date_timepicker_end 	= $_POST['date_timepicker_end_new'];
		
		if($date_timepicker_start != '')
		{
			$start_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_start.' -1 day'));
		}
		else
		{
			$start_date = date('Y-m-d 23:59:59', strtotime('-1 day'));		
		}
		if($date_timepicker_end != '')
		{
			$end_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_end.' +1 day'));
		}
		else
		{
			$end_date = date('Y-m-d 23:59:59', strtotime('+1 day'));				
		}
		
		$this->db->select('a.userid,a.firstname,a.middlename,a.lastname,a.Father_Mobile,a.Father_Name,a.Campus,a.Class,a.Mother_Name,a.Mother_Mobile,a.Admission_Year,a.Shift,a.Date_of_Admission,a.Academic_Year,a.datecreated');
        $this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');        
        $this->db->where('a.datecreated > ', $start_date);		
        $this->db->where('a.datecreated < ', $end_date);		
		$student_list = $this->db->get()->result_array();
		
        $data['title'] = date('d M, Y');
        $data['student_list'] = $student_list;
        $this->load->view('admin/dashboard/modal/management/print-new-student', $data);
	}
	
	/* TC Report list management */
	public function tcReport_list_management($date_timepicker_start = '', $date_timepicker_end = '')
    {
		if($date_timepicker_start != '')
		{
			$start_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_start.' -1 day'));
		}
		else
		{
			$start_date = date('Y-m-d 23:59:59', strtotime('-1 day'));		
		}
		if($date_timepicker_end != '')
		{
			$end_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_end.' +1 day'));
		}
		else
		{
			$end_date = date('Y-m-d 23:59:59', strtotime('+1 day'));				
		}
		
        if ($this->input->is_ajax_request()) {
			$this->app->get_table_data('tcReport_list_management',[
                'start_date' => $start_date, 'end_date' => $end_date, 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
	
	/* Search Total TC Student */
	public function searchTotalTCReport()
	{
		$date_timepicker_start 	= $_POST['n_start_date'];
		$date_timepicker_end 	= $_POST['n_end_date'];
		
		if($date_timepicker_start != '')
		{
			$start_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_start.' -1 day'));
		}
		else
		{
			$start_date = date('Y-m-d 23:59:59', strtotime('-1 day'));		
		}
		if($date_timepicker_end != '')
		{
			$end_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_end.' +1 day'));
		}
		else
		{
			$end_date = date('Y-m-d 23:59:59', strtotime('+1 day'));				
		}
		
		$newStudentCount = $this->db->get_where(db_prefix().'tc_requests', array('created_at > ' => $start_date, 'created_at < ' => $end_date))->num_rows();
		$pendingTCCount = $this->db->get_where(db_prefix().'tc_requests', array('created_at > ' => $start_date, 'created_at < ' => $end_date, 'status' => 0))->num_rows();
		$approvedTCCount = $this->db->get_where(db_prefix().'tc_requests', array('created_at > ' => $start_date, 'created_at < ' => $end_date, 'status' => 1))->num_rows();
		
		$data['totalTc'] = $newStudentCount;
		$data['pendingTCCount'] = $pendingTCCount;
		$data['approvedTCCount'] = $approvedTCCount;
		
		echo json_encode($data);
	}
	
	/* Search Tc Report Print */
	public function searchTcReportPrint()
	{
		$date_timepicker_start 	= $_POST['date_timepicker_start_tc'];
		$date_timepicker_end 	= $_POST['date_timepicker_end_tc'];
		
		if($date_timepicker_start != '')
		{
			$start_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_start.' -1 day'));
		}
		else
		{
			$start_date = date('Y-m-d 23:59:59', strtotime('-1 day'));		
		}
		if($date_timepicker_end != '')
		{
			$end_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_end.' +1 day'));
		}
		else
		{
			$end_date = date('Y-m-d 23:59:59', strtotime('+1 day'));				
		}
		
		$this->db->select('a.userid,a.firstname,a.middlename,a.lastname,a.Father_Mobile,a.Father_Name,a.Campus,a.Class,a.Mother_Name,a.Mother_Mobile,a.Admission_Year,a.Shift,a.Date_of_Admission,a.Academic_Year,a.datecreated,b.created_at');
        $this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');    
		$this->db->join(db_prefix().'tc_requests b','b.student_id = a.userid', 'RIGHT');
        $this->db->where('b.created_at > ', $start_date);		
        $this->db->where('b.created_at < ', $end_date);		
		$tcReport_list = $this->db->get()->result_array();
		
		$data['search_date'] = date('d-m-Y', strtotime($start_date)).' to '.date('d-m-Y', strtotime($end_date));
        $data['title'] = date('d M, Y');
        $data['tcReport_list'] = $tcReport_list;
        $this->load->view('admin/dashboard/modal/management/print-tc-record', $data);
	}
	
	/* Id Card Report List Management */
	public function idCard_list_management($date_timepicker_start = '', $date_timepicker_end = '')
    {
		if($date_timepicker_start != '')
		{
			$start_date = date('Y-m-d', strtotime($date_timepicker_start.' -1 day'));
		}
		else
		{
			$start_date = date('Y-m-d', strtotime('-1 day'));		
		}
		if($date_timepicker_end != '')
		{
			$end_date = date('Y-m-d', strtotime($date_timepicker_end.' +1 day'));
		}
		else
		{
			$end_date = date('Y-m-d', strtotime('+1 day'));				
		}
		
        if ($this->input->is_ajax_request()) {
			$this->app->get_table_data('idCard_list_management',[
                'start_date' => $start_date, 'end_date' => $end_date, 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
		
	/* Id Card Report List Management */
	public function searchTotalIDCardReport()
    {
		$date_timepicker_start 	= $_POST['n_start_date'];
		$date_timepicker_end 	= $_POST['n_end_date'];
		
		if($date_timepicker_start != '')
		{
			$start_date = date('Y-m-d', strtotime($date_timepicker_start.' -1 day'));
		}
		else
		{
			$start_date = date('Y-m-d', strtotime('-1 day'));		
		}
		if($date_timepicker_end != '')
		{
			$end_date = date('Y-m-d', strtotime($date_timepicker_end.' +1 day'));
		}
		else
		{
			$end_date = date('Y-m-d', strtotime('+1 day'));				
		}
				
		$this->db->select('*');
        $this->db->from(db_prefix().'contacts'.$this->contact_tbl);        
        $this->db->where('idcard_created_date >', $start_date);		
        $this->db->where('idcard_created_date <', $end_date);	
		//$this->db->where("idcard_created_date BETWEEN '$start_date' AND '$end_date'");		
		$html = $this->db->get()->num_rows();
		
		echo json_encode($html); 
    }
	
    public function getTotalDayBookCount()
    {
        $type = $this->input->post('payment_mode_filter');
        $start_date = $this->input->post('date_timepicker_start');
        $end_date = $this->input->post('date_timepicker_end');
        // echo 'S-'.$start_date.'----e--'.$end_date;die;
        if(!empty($start_date) && !empty($end_date))
		{
			$n_start_date = date('d-m-Y', strtotime($start_date));
            $n_end_date = date('d-m-Y', strtotime($end_date));
		}
		elseif(!empty($start_date) && empty($end_date))
		{
			$n_start_date = date('d-m-Y', strtotime($start_date));
            $n_end_date = date('d-m-Y', strtotime($start_date));
		}
		elseif(empty($start_date) && !empty($end_date))
		{
			$n_start_date = date('d-m-Y', strtotime($end_date));
            $n_end_date = date('d-m-Y', strtotime($end_date));
		}
		else{
		    $n_start_date = date('d-m-Y');
            $n_end_date = date('d-m-Y');
		}
		
        $student_all = $this->dashboard_model->totalDayBookNStudentCount($type, $start_date, $end_date);
        $t_all = $this->dashboard_model->totalDayBookN($type, $start_date, $end_date);
        $cash = $this->dashboard_model->totalDayBookN('cash', $start_date, $end_date);
        $cheque = $this->dashboard_model->totalDayBookN('cheque', $start_date, $end_date);
        $dd = $this->dashboard_model->totalDayBookN('dd', $start_date, $end_date);
        $upi = $this->dashboard_model->totalDayBookN('upi', $start_date, $end_date);
        $online = $this->dashboard_model->totalDayBookN('online', $start_date, $end_date);
        $IMPS = $this->dashboard_model->totalDayBookN('IMPS', $start_date, $end_date);
        $card = $this->dashboard_model->totalDayBookN('card', $start_date, $end_date);
        $data = array(
                'student_count' => $student_all,
                't_all' => (!empty($t_all->total_amount)) ? $t_all->total_amount : '0',
                'cash' => (!empty($cash->total_amount)) ? $cash->total_amount : '0',
                'cheque' => (!empty($cheque->total_amount)) ? $cheque->total_amount : '0',
                'dd' => (!empty($dd->total_amount)) ? $dd->total_amount : '0',
                'upi' => (!empty($upi->total_amount)) ? $upi->total_amount : '0',
                'online' => (!empty($online->total_amount)) ? $online->total_amount : '0',
                'IMPS' => (!empty($IMPS->total_amount)) ? $IMPS->total_amount : '0',
                'card' => (!empty($card->total_amount)) ? $card->total_amount : '0',
                'n_start_date'=>$n_start_date,
                'n_end_date'=>$n_end_date,
            );
        echo json_encode($data);
    }
    
    public function printDayBook()
    {
        $start_date = date('Y-m-d');
        $end_date = date('Y-m-d');
		$search_date = date('d-m-Y', strtotime($start_date)).' to '.date('d-m-Y', strtotime($end_date));
        $type = 'All';
        $fees_records = $this->dashboard_model->totalDayBookNStudentFeesRecord($type, $start_date, $end_date);
        $student_all = $this->dashboard_model->totalDayBookNStudentCount($type, $start_date, $end_date);
        $t_all = $this->dashboard_model->totalDayBookN($type, $start_date, $end_date);
        $cash = $this->dashboard_model->totalDayBookN('cash', $start_date, $end_date);
        $cheque = $this->dashboard_model->totalDayBookN('cheque', $start_date, $end_date);
        $dd = $this->dashboard_model->totalDayBookN('dd', $start_date, $end_date);
        $upi = $this->dashboard_model->totalDayBookN('upi', $start_date, $end_date);
        $online = $this->dashboard_model->totalDayBookN('online', $start_date, $end_date);
        $IMPS = $this->dashboard_model->totalDayBookN('IMPS', $start_date, $end_date);
        $card = $this->dashboard_model->totalDayBookN('card', $start_date, $end_date);
        $data = array(
                'fees_records' => $fees_records,
                'student_count' => $student_all,
                'search_date' => $search_date,
                't_all' => (!empty($t_all->total_amount)) ? $t_all->total_amount : '0',
                'cash' => (!empty($cash->total_amount)) ? $cash->total_amount : '0',
                'cheque' => (!empty($cheque->total_amount)) ? $cheque->total_amount : '0',
                'dd' => (!empty($dd->total_amount)) ? $dd->total_amount : '0',
                'upi' => (!empty($upi->total_amount)) ? $upi->total_amount : '0',
                'online' => (!empty($online->total_amount)) ? $online->total_amount : '0',
                'IMPS' => (!empty($IMPS->total_amount)) ? $IMPS->total_amount : '0',
                'card' => (!empty($card->total_amount)) ? $card->total_amount : '0',
            );
        $this->load->view('admin/dashboard/day_book_report_print', $data);
    }
    
    public function printDayBookJs($n_start_date = '', $n_end_date = '')
    {
        if(!empty($n_start_date) && !empty($n_end_date))
		{
			$start_date = date('Y-m-d', strtotime($n_start_date));
            $end_date = date('Y-m-d', strtotime($n_end_date));
		}
		elseif(!empty($n_start_date) && empty($n_end_date))
		{
			$start_date = date('Y-m-d', strtotime($n_start_date));
            $end_date = date('Y-m-d', strtotime($n_start_date));
		}
		elseif(empty($n_start_date) && !empty($n_end_date))
		{
			$start_date = date('Y-m-d', strtotime($n_end_date));
            $end_date = date('Y-m-d', strtotime($n_end_date));
		}
		else{
			$start_date = date('Y-m-d');
			$end_date = date('Y-m-d');
		}
		
		$search_date = date('d-m-Y', strtotime($start_date)).' to '.date('d-m-Y', strtotime($end_date));
		
        $type = 'All';
        $fees_records = $this->dashboard_model->totalDayBookNStudentFeesRecord($type, $start_date, $end_date);
        $student_all = $this->dashboard_model->totalDayBookNStudentCount($type, $start_date, $end_date);
        $t_all = $this->dashboard_model->totalDayBookN($type, $start_date, $end_date);
        $cash = $this->dashboard_model->totalDayBookN('cash', $start_date, $end_date);
        $cheque = $this->dashboard_model->totalDayBookN('cheque', $start_date, $end_date);
        $dd = $this->dashboard_model->totalDayBookN('dd', $start_date, $end_date);
        $upi = $this->dashboard_model->totalDayBookN('upi', $start_date, $end_date);
        $online = $this->dashboard_model->totalDayBookN('online', $start_date, $end_date);
        $IMPS = $this->dashboard_model->totalDayBookN('IMPS', $start_date, $end_date);
        $card = $this->dashboard_model->totalDayBookN('card', $start_date, $end_date);
        $data = array(
                'fees_records' => $fees_records,
                'student_count' => $student_all,
                'search_date' => $search_date,
                't_all' => (!empty($t_all->total_amount)) ? $t_all->total_amount : '0',
                'cash' => (!empty($cash->total_amount)) ? $cash->total_amount : '0',
                'cheque' => (!empty($cheque->total_amount)) ? $cheque->total_amount : '0',
                'dd' => (!empty($dd->total_amount)) ? $dd->total_amount : '0',
                'upi' => (!empty($upi->total_amount)) ? $upi->total_amount : '0',
                'online' => (!empty($online->total_amount)) ? $online->total_amount : '0',
                'IMPS' => (!empty($IMPS->total_amount)) ? $IMPS->total_amount : '0',
                'card' => (!empty($card->total_amount)) ? $card->total_amount : '0',
            );
        $this->load->view('admin/dashboard/day_book_report_print', $data);
    }
    
	/* Rs1 Package Report List Management */
	public function rs1Package_list_management($date_timepicker_start = '', $date_timepicker_end = '')
    {
		if($date_timepicker_start != '')
		{
			$start_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_start.' -1 day'));
		}
		else
		{
			$start_date = date('Y-m-d 23:59:59', strtotime('-1 day'));		
		}
		if($date_timepicker_end != '')
		{
			$end_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_end.' +1 day'));
		}
		else
		{
			$end_date = date('Y-m-d 23:59:59', strtotime('+1 day'));				
		}
		
        if ($this->input->is_ajax_request()) {
			$this->app->get_table_data('rs1Package_list_management',[
                'start_date' => $start_date, 'end_date' => $end_date, 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
	
	/* Search Total TC Student */
	public function searchTotalRs1PackageReport()
	{
		$date_timepicker_start 	= $_POST['n_start_date'];
		$date_timepicker_end 	= $_POST['n_end_date'];
		
		if($date_timepicker_start != '')
		{
			$start_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_start.' -1 day'));
		}
		else
		{
			$start_date = date('Y-m-d 23:59:59', strtotime('-1 day'));		
		}
		if($date_timepicker_end != '')
		{
			$end_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_end.' +1 day'));
		}
		else
		{
			$end_date = date('Y-m-d 23:59:59', strtotime('+1 day'));				
		}
		
		$this->db->select('a.Admission_Year,a.userid,a.Campus,a.Shift,a.firstname,a.middlename,a.lastname,a.Father_Mobile,a.Father_Name,a.registration_id,a.Class, b.package_amount as amount,b.createddate as createddate,b.deposit_amount as deposit_amount,b.last_payment_date,c.name,c.id as package_id,a.Admission_Year');
		$this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');
		$this->db->join(db_prefix().'student_package b','b.userid = a.userid', 'LEFT');
		$this->db->join(db_prefix().'master_package c','c.id = b.package_id', 'LEFT');
		
		$this->db->where('b.package_year',$this->academic_session);
		$this->db->where('b.last_payment_date>',$start_date);
		$this->db->where('b.last_payment_date<',$end_date);
		$this->db->where('b.package_id>','49');
		$html = $this->db->get()->num_rows();
				
		echo json_encode($html);
	}
	
	/* Rs1 Package Report List Management */
	public function paidStudents_list_management($date_timepicker_start = '', $date_timepicker_end = '')
    {
		if($date_timepicker_start != '')
		{
			$start_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_start.' -1 day'));
		}
		else
		{
			$start_date = date('Y-m-d 23:59:59', strtotime('-1 day'));		
		}
		if($date_timepicker_end != '')
		{
			$end_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_end.' +1 day'));
		}
		else
		{
			$end_date = date('Y-m-d 23:59:59', strtotime('+1 day'));				
		}
		
        if ($this->input->is_ajax_request()) {
			$this->app->get_table_data('paidStudents_list_management',[
                'start_date' => $start_date, 'end_date' => $end_date, 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
	
	/* RTE Package Report List Management */
	public function rteStudents_list_management($date_timepicker_start = '', $date_timepicker_end = '')
    {
		if($date_timepicker_start != '')
		{
			$start_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_start.' -1 day'));
		}
		else
		{
			$start_date = date('Y-m-d 23:59:59', strtotime('-1 day'));		
		}
		if($date_timepicker_end != '')
		{
			$end_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_end.' +1 day'));
		}
		else
		{
			$end_date = date('Y-m-d 23:59:59', strtotime('+1 day'));				
		}
		
        if ($this->input->is_ajax_request()) {
			$this->app->get_table_data('rteStudents_list_management',[
                'cname' => '', 'end_date' => $end_date, 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
	
	/* Package Report List Management */
	public function package_list_management()
    {		
        if ($this->input->is_ajax_request()) {
			$this->app->get_table_data('package_list_management',[
                'cname' => '', 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
	
	/* Package Filter Report List Management */
	public function filterPackageStudent($cname = '')
    {		
        if ($this->input->is_ajax_request()) {
			$this->app->get_table_data('package_list_management',[
                'cname' => $cname, 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
	
	/* RTE Filter Report List Management */
	public function filterRTEStudent($cname = '')
    {		
        if ($this->input->is_ajax_request()) {
			$this->app->get_table_data('rteStudents_list_management',[
                'cname' => $cname, 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }

	/* Search Total Paid Student Report */
	public function searchTotalRTEStudentReport()
	{
		$date_timepicker_start 	= $_POST['n_start_date'];
		$date_timepicker_end 	= $_POST['n_end_date'];
		$cname 					= $_POST['cname'];
		
		if($date_timepicker_start != '')
		{
			$start_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_start.' -1 day'));
		}
		else
		{
			$start_date = date('Y-m-d 23:59:59', strtotime('-1 day'));		
		}
		if($date_timepicker_end != '')
		{
			$end_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_end.' +1 day'));
		}
		else
		{
			$end_date = date('Y-m-d 23:59:59', strtotime('+1 day'));				
		}

		$where_in = array('1','2','9','10','26','27','50','51');
		$this->db->select('a.Admission_Year,a.userid,a.Campus,a.Shift,a.firstname,a.middlename,a.lastname,a.Father_Mobile,a.Father_Name,a.registration_id,a.Class, b.package_amount as amount,b.createddate as createddate,b.deposit_amount as deposit_amount,b.last_payment_date,c.name,c.id as package_id,a.Admission_Year');
		$this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');
		$this->db->join(db_prefix().'student_package b','b.userid = a.userid', 'LEFT');
		$this->db->join(db_prefix().'master_package c','c.id = b.package_id', 'LEFT');
		if($cname != '')
		{
			$class_name = str_replace('_',' ',$cname);
			$this->db->where('a.Class', $class_name);
		}
		//$this->db->where('b.package_year',$this->academic_session);
		//$this->db->where('b.last_payment_date>',$start_date);
		//$this->db->where('b.last_payment_date<',$end_date);
		$this->db->where('b.package_id','15');
		$html = $this->db->get()->num_rows();

		echo json_encode($html);
	}
	
	/* Set RTE Student Package */
	public function setRTEStudentPackage()
	{
		$data = $this->input->post();
		$postData['student_id'] 	= $data['sid'];
		$postData['package_id'] 	= $data['pid'];
		$postData['package_year'] 	= $data['pval'];
		$postData['created_date'] 	= date('Y-m-d H:i:s');
		
		$this->db->insert('tblstudent_package_pass', $postData);
		echo $this->db->insert_id();
	}
	
	/* Search Total Paid Student Report */
	public function searchTotalPackageStudentReport()
	{
		$cname 					= $_POST['cname'];
		
		$ignore = array('6264080852','07582970904','7582970904','9039524321');
		$where_in = array('1','2','9','10','26','27','50','51');
		$this->db->select('a.Admission_Year,a.userid,a.Campus,a.Shift,a.firstname,a.middlename,a.lastname,a.Father_Mobile,a.Father_Name,a.registration_id,a.Class, b.package_amount as amount,b.createddate as createddate,b.deposit_amount as deposit_amount,b.last_payment_date,c.name,c.id as package_id,a.Admission_Year');
		$this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');
		$this->db->join(db_prefix().'student_package b','b.userid = a.userid', 'RIGHT');
		$this->db->join(db_prefix().'master_package c','c.id = b.package_id', 'RIGHT');
		if($cname != '')
		{
			$class_name = str_replace('_',' ',$cname);
			$this->db->where('a.Class', $class_name);
		}
		//$this->db->where('b.package_year',$this->academic_session);
		//$this->db->where('b.last_payment_date>',$start_date);
		//$this->db->where('b.last_payment_date<',$end_date);
		$this->db->group_by('a.userid');
		$this->db->where_in('b.package_id',$where_in);
        $this->db->where_not_in('a.Father_Mobile', $ignore);
		$html = $this->db->get()->num_rows();

		echo json_encode($html);
	}
	
	/* Search Total Paid Student Report */
	public function searchTotalPaidStudentReport()
	{
		$date_timepicker_start 	= $_POST['n_start_date'];
		$date_timepicker_end 	= $_POST['n_end_date'];
		
		if($date_timepicker_start != '')
		{
			$start_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_start.' -1 day'));
		}
		else
		{
			$start_date = date('Y-m-d 23:59:59', strtotime('-1 day'));		
		}
		if($date_timepicker_end != '')
		{
			$end_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_end.' +1 day'));
		}
		else
		{
			$end_date = date('Y-m-d 23:59:59', strtotime('+1 day'));				
		}

		$where_in = array('1','2','9','10','26','27','50','51');
		$this->db->select('a.Admission_Year,a.userid,a.Campus,a.Shift,a.firstname,a.middlename,a.lastname,a.Father_Mobile,a.Father_Name,a.registration_id,a.Class, b.package_amount as amount,b.createddate as createddate,b.deposit_amount as deposit_amount,b.last_payment_date,c.name,c.id as package_id,a.Admission_Year');
		$this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');
		$this->db->join(db_prefix().'student_package b','b.userid = a.userid', 'LEFT');
		$this->db->join(db_prefix().'master_package c','c.id = b.package_id', 'LEFT');

		$this->db->where('b.package_year',$this->academic_session);
		//$this->db->where('b.last_payment_date>',$start_date);
		//$this->db->where('b.last_payment_date<',$end_date);
		//$this->db->where('b.package_id>','49');
		$html = $this->db->get()->num_rows();

		echo json_encode($html);
	}
	
	/* Un paid Student List Management */
	public function unPaidStudents_list_management($date_timepicker_start = '', $date_timepicker_end = '')
    {
		if($date_timepicker_start != '')
		{
			$start_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_start.' -1 day'));
		}
		else
		{
			$start_date = date('Y-m-d 23:59:59', strtotime('-1 day'));		
		}
		if($date_timepicker_end != '')
		{
			$end_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_end.' +1 day'));
		}
		else
		{
			$end_date = date('Y-m-d 23:59:59', strtotime('+1 day'));				
		}
		
        if($this->input->is_ajax_request()) {
			$this->app->get_table_data('unPaidStudents_list_management',[
                'start_date' => $start_date, 'end_date' => $end_date, 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }

	public function testSQL()
	{
		$query = "SELECT `tblcontacts_2022_23`.`userid`,`firstname`, `middlename`, `lastname`, `Gender`, `Date_of_Admission`, `tblcontacts_2022_23`.`Admission_Year`, `Campus`, `Shift`, `Class`, `Academic_Year`,`Date_of_Birth`,`Father_Name` , `Father_Mobile`,`Mother_Name`,`Mother_Mobile`,`payment_status`,`active_status` FROM `tblcontacts_2022_23`  where `tblcontacts_2022_23`.`userid` NOT IN ( SELECT `tblpa`.`userid` FROM `tblstudent_package` as `tblpa`  where `package_id` IN (1,2,9,10,26,27) or `package_id` IN (15) or `tblpa`.`package_year`  IN ('2022-23') GROUP BY `tblpa`.`userid`) GROUP BY `tblcontacts_2022_23`.`userid` ORDER BY `tblcontacts_2022_23`.`userid` ASC";
		
		$result = $this->db->query($query)->result();
		echo '<pre>'; print_r($result); die;
	}

	/* Search Total Un Paid Student Report */
	public function searchTotalunPaidStudentReport()
	{
		$date_timepicker_start 	= $_POST['n_start_date'];
		$date_timepicker_end 	= $_POST['n_end_date'];
		
		if($date_timepicker_start != '')
		{
			$start_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_start.' -1 day'));
		}
		else
		{
			$start_date = date('Y-m-d 23:59:59', strtotime('-1 day'));		
		}
		if($date_timepicker_end != '')
		{
			$end_date = date('Y-m-d 23:59:59', strtotime($date_timepicker_end.' +1 day'));
		}
		else
		{
			$end_date = date('Y-m-d 23:59:59', strtotime('+1 day'));				
		}

		$this->db->select('a.userid,a.payment_status,a.active');
		$this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');

		$this->db->where('a.payment_status',0);
		//$this->db->or_where('a.active',0);
		$html = $this->db->get()->num_rows();
		
		/*		$this->db->select('a.Admission_Year,a.userid,a.Campus,a.Shift,a.firstname,a.middlename,a.lastname,a.Father_Mobile,a.Father_Name,a.registration_id,a.Class, b.package_amount as amount,b.createddate as createddate,b.deposit_amount as deposit_amount,b.last_payment_date,c.name,c.id as package_id,a.Admission_Year');
		$this->db->from(db_prefix().'contacts'.$this->contact_tbl.' a');
		$this->db->join(db_prefix().'student_package b','b.userid = a.userid', 'LEFT');
		$this->db->join(db_prefix().'master_package c','c.id = b.package_id', 'LEFT');

		$this->db->where('b.package_year',$this->academic_session);
		$this->db->where('b.last_payment_date>',$start_date);
		$this->db->where('b.last_payment_date<',$end_date);
		//$this->db->where('b.package_id>','49');
		$html = $this->db->get()->num_rows();
*/
		echo json_encode($html);
	}
	
    /*
    *   @FUNCTION: DELETE STUDENT FEES 
    */   
    function deleteFees(){
        $sfidDel = $this->input->post('sfidDel');
        $sidDel = $this->input->post('sidDel');
        $reason = $this->input->post('reason');
        $this->db->where('id',$sfidDel);
        $this->db->where('userid',$sidDel);
        $this->db->delete('tblstudent_fees_deposit');
       // $this->db->update('tblstudent_fees_deposit',array('is_delete'=>1,'delete_reason'=>$reason));
         $message = _l('Student Fees Delete successfully');
            echo json_encode([
                'success' => true,
                'message' => $message,
            ]);
    }
	
	/* Apply TC List */
	public function applyTCList($para1 = '')
    {
        if ($this->input->is_ajax_request()) {
			$this->app->get_table_data('applyTCList',[
                'tc_status'=> $para1,'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
	
	/* Apply TC List */
	public function reportTCList($para1 = '')
    {
        if ($this->input->is_ajax_request()) {
			$this->app->get_table_data('reportTCList',[
                'tc_status'=> $para1,'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
		
	/* Save TC Request */
	public function createTCRequest()
	{
		$data = $this->input->post();	
		$sid = $data['tcstudentid'];
		$getStudentRecord = $this->db->get_where('tbltc_requests', array('student_id' => $sid))->num_rows();
		if($getStudentRecord > 0)
		{
			$status = true;
			$message = 'TC request updated successfully!';
			echo json_encode([
				'success' => $status,
				'message' => $message,
			]);
			exit();
		}
		else{
			$postData['student_id'] 		= $data['tcstudentid'];
			$postData['apply_date'] 		= $data['apply_date'];
			$postData['academic_year'] 		= $this->academic_session;
			$postData['reason'] 			= $data['reason'];
			$postData['created_at'] 		= date('Y-m-d H:i:s');
            if($postData['gender'] == 'on')
            {
                $postData['gender'] = 'Female';
            }
            else
            {
                $postData['gender'] = 'Male';               
            }
			$this->db->insert('tbltc_requests', $postData);
			$lid = $this->db->insert_id();
			if ($lid) {				
				$uploadedFiles = handle_file_upload($lid,'tc_application', 'tc_application');
				if ($uploadedFiles && is_array($uploadedFiles)) {
					foreach ($uploadedFiles as $file) {
						$this->misc_model->add_attachment_to_database($lid, 'tc_application', [$file]);
					}
				}
				
				$status = true;
				$message = 'TC request submitted successfully!';
				echo json_encode([
					'success' => $status,
					'message' => $message,
				]);
				exit();
			}
			else{
				$status = false;
				$message = 'Documents are not submitted, try again!';
				echo json_encode([
					'success' => $status,
					'message' => $message,
				]);
				exit();
			}
		}		
	}
	
	/* applyTCCount */
	public function applyTCCount()
	{
		$pendingTC = $this->db->get_where('tbltc_requests', array('status' => 0))->num_rows();
		$approvedTC = $this->db->get_where('tbltc_requests', array('status' => 1))->num_rows();
		$reportTC = $this->db->get_where('tbltc_requests')->num_rows();
		echo json_encode([
				'pendingTC' => $pendingTC,
				'approvedTC' => $approvedTC,
				'reportTC' => $reportTC,
			]);
			exit();
	}
		
	/* Cheque Payment List */
	public function unapprovedChequeList()
    {
        if ($this->input->is_ajax_request()) {
			$this->app->get_table_data('chequePaymentList',[
                 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
	
	/* Student Transport list */
	public function studentTransportList($para1 = '')
    {
        if ($this->input->is_ajax_request()) {
			$this->app->get_table_data('transport_list',[
                'class_name' => $para1, 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
	
	/* Student Transport list */
	public function studentTransport_report($para1 = '')
    {
        if ($this->input->is_ajax_request()) {
			$this->app->get_table_data('transport_report',[
                'route_number' => $para1, 'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
	
	/* Update Student transport*/
	public function transportUpdate()
	{
		$userid = $_POST['userid'];
		$postData['transport_by'] 			= $_POST['transport_by'];
		$postData['transport_bus_no'] 		= $_POST['bus_no'];
		$postData['transport_route_name'] 	= $_POST['route_name'];
		$postData['transport_pickup_stop'] 	= $_POST['pickup_stop'];
		$postData['transport_drop_stop'] 	= $_POST['drop_stop'];
		$existingData = $this->db->get_where('tblstudent_transport', array('student_id' => $userid, 'academic_session' => $this->academic_session))->num_rows();
		if($existingData > 0)
		{
			$this->db->where('student_id', $userid);
			$this->db->update(db_prefix().'student_transport', $postData);			
		}
		else
		{
			$postData['student_id']  		= $userid;
			$postData['academic_session']  	= $this->academic_session;
			$postData['created_date'] 		= date('Y-m-d H:i:s');
			$this->db->insert(db_prefix().'student_transport', $postData);
		}
		echo 1;
	}
	
	
	/* Cheque Status Update */
	public function chequeApproved($id, $invoice, $type){
        $data['student_details'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $id))->row();
        $data['invoice'] = $this->db->get_where(db_prefix().'student_fees_invoice', array('userid' => $id,'academic_year'=>$this->academic_session,'id'=>$invoice))->row();
      
		$data['invoice_number'] = $data['invoice']->invoice_number;
	  
        $invoice_details =    $this->db->get_where(db_prefix().'student_fees_deposit', array('invoice_id' => $data['invoice']->id,'academic_year'=>$this->academic_session));
        $data['invoice_details'] = $invoice_details->result();
        $packagenameArr = $this->db->select('name,deduction_mode,payment_type')->get_where(db_prefix().'master_package', array('id' => $invoice_details->row()->package_id))->row();
        $packagename = $packagenameArr->name;
        
         $packageType = $packagenameArr->payment_type;
        if($packageType == 3)
            $notetext = 1;
        elseif($packageType == 2)
            $notetext = 2;
        else
            $notetext = 3;
        
        $data['academic_session'] = $this->academic_session;
        $data['packagename'] = ($packagename != '')?$packagename:'NA';
        $deduction_mode = ($packagenameArr->deduction_mode == 2)?"Nil":"0.00";
        $data['deduction_mode'] = $deduction_mode;
        $accountantnameArr = $this->db->select('firstname,lastname')->get_where(db_prefix().'staff', array('staffid' => $invoice_details->row()->accounted_id))->row();
        $accountantname = $accountantnameArr->firstname.' '.$accountantnameArr->lastname;
        $data['accountantname'] = ($accountantname != '')?$accountantname:'NA';
		$payment_mode = strtoupper($invoice_details->row()->payment_mode);
		//$cheque_status = $invoice_details->row()->cheque_status;
		$chequeStatus['cheque_status'] = $type;
		$this->db->where('invoice_id', $invoice);
		$this->db->update('tblstudent_fees_deposit', $chequeStatus);
		if($payment_mode == 'CHEQUE')
		{
			if($type == 'pass')
			{
				$this->load->view('theisb-invoice/index',$data);							
			}
			else{
				$this->load->view('theisb-invoice/voucher',$data);				
			}
		}
		else
		{
			$this->load->view('theisb-invoice/index',$data);			
		}
    }
	
	/* ID card module */
	public function studentDetailsIDCard($sid)
	{
		$data['student_details'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $sid))->row();
		$data['campus_list'] = $this->db->get_where('tblcampus')->result();
        echo $this->load->view('admin/dashboard/modal/IDCard/student-details',$data,true);
	}
	
	/* ID Card List */
	public function idCardList()
    {
        if ($this->input->is_ajax_request()) {
			$this->app->get_table_data('idCardList',[
                'contact_tbl'=>$this->contact_tbl,'academic_session'=>$this->academic_session
            ]);
        }
    }
	
	public function studentIDCardPrint($sid)
	{
		$data['student_details'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $sid))->row();
		$data['campus_list'] = $this->db->get_where('tblcampus')->result();
        $this->load->view('idcard/idcard-print',$data);
	}
	
	public function studentPickupCardPrint($sid)
	{
		$data['student_details'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $sid))->row();
		$data['campus_list'] = $this->db->get_where('tblcampus')->result();
        $this->load->view('idcard/pickupcard-print',$data);
	}
	
	/* Update id care value */
	public function updateidcardcreateddate()
	{
		$idcardvalue = $this->db->select('userid,idcard_created_date')->get_where(db_prefix().'contacts'.$this->contact_tbl, array('idcard_created_date !=' => ''))->result();
		foreach($idcardvalue as $rr)
		{
			$updatedata['idcard_created_date'] = date('Y-m-d', strtotime($rr->idcard_created_date));
			$this->db->where('userid',$rr->userid);
			$this->db->update(db_prefix().'contacts'.$this->contact_tbl, $updatedata);
		}
	}
	
	/* Create ID Card Request */
	public function updateStudenIDCard($sid = null)
	{
		if($sid)
		{
			$data = $this->input->post();
			$data['idcard_created_date'] = date('Y-m-d');
			$this->db->where('userid', $sid);
			$this->db->update(db_prefix().'contacts'.$this->contact_tbl, $data);
			if($_FILES['profile_image']['name'] != '')
			{
				$student_tbl = db_prefix().'contacts'.$this->contact_tbl;
				handle_id_card_profile_image_upload($sid, $this->academic_session, $student_tbl);
			}
			$status = true;
			$message = 'Student details update successfully!';
			echo json_encode([
				'sid' => $sid,
				'success' => $status,
				'message' => $message,
			]);
			exit();
		}
		else
		{
			$status = false;
			$message = 'Record not found, try again!';
			echo json_encode([
				'success' => $status,
				'message' => $message,
			]);
			exit();
		}	
	}	
	
	/* Change Photo */
	public function change_photo()
	{
		$post = isset($_POST) ? $_POST: array();
		$maxWidth = "500"; 
		$userId = isset($post['hdn-profile-id']) ? intval($post['hdn-profile-id']) : 0;
		$path = 'assets/id-card/images/tmp';
		$validFormats = array("jpg", "png", "gif", "jpeg");
		$picName = $_FILES['profileImage']['name'];
		$size = $_FILES['profileImage']['size'];
		if(strlen($picName)) {
			list($txt, $ext) = explode(".", $picName);
			if(in_array($ext,$validFormats)) {
				if($size<(1024*1024)) {
					$actualImageName = 'avatar'.'_'.time().'.'.$ext;
					$filePath = $path .'/'.$actualImageName;
					$tmp = $_FILES['profileImage']['tmp_name'];
					if(move_uploaded_file($tmp, $filePath)) {
						$width = $this->getWidth($filePath);
						$height = $this->getHeight($filePath);						
						if ($width > $maxWidth){
							$scale = $maxWidth/$width;
							$uploaded = $this->resizeImage($filePath,$width,$height,$scale, $ext);
						} else {
							$scale = 1;
							$uploaded = $this->resizeImage($filePath,$width,$height,$scale, $ext);
						}						
						echo "<img id='photo' file-name='".$actualImageName."' class='' src='".$filePath.'?'.time()."' class='preview'/>";
					}
					else
					echo "failed";
				}
				else
				echo "Image file size max 1 MB"; 
			}
			else
			echo "Invalid file format.."; 
		}
		else
		echo "Please select image..!";
		exit;
	}
	
	public function saveProfilePhoto() {		
		$post = isset($_POST) ? $_POST: array();
		$userId = isset($post['id']) ? intval($post['id']) : 0;		
		$path = 'assets/id-card/images/tmp/'.$_POST['imageName'];
		$tmpWidth = 300; 
		$tmpHeight = 300; 
		if(isset($_POST['t']) and $_POST['t'] == "ajax") {
			extract($_POST);		
			$imagePath = 'assets/id-card/images/'.$_POST['imageName'];
			$ratio = ($tmpWidth/$w1); 
			$nw = ceil($w1 * $ratio);
			$nh = ceil($h1 * $ratio);
			$nimg = imagecreatetruecolor($nw,$nh);			
			$imgSrc = imagecreatefromjpeg($path);
			imagecopyresampled($nimg,$imgSrc,0,0,$x1,$y1,$nw,$nh,$w1,$h1);
			imagejpeg($nimg,$imagePath,90);		
		}
		/*
		$updateQuery = "
			UPDATE ".$this->userTable." 
			SET photo = '".$_POST['imageName']."'
			WHERE id = '$userId'";
		mysqli_query($this->dbConnect, $updateQuery);
		*/
		$saveImagePath = $imagePath.'?'.time();
		echo $saveImagePath;
		exit(0);    
	}    	
	public function resizeImage($image,$width,$height,$scale, $ext) {
		$newImageWidth = ceil($width * $scale);
		$newImageHeight = ceil($height * $scale);
		$newImage = imagecreatetruecolor($newImageWidth,$newImageHeight);
		switch ($ext) {
			case 'jpg':
			case 'jpeg':
				$source = imagecreatefromjpeg($image);
				break;
			case 'gif':
				$source = imagecreatefromgif($image);
				break;
			case 'png':
				$source = imagecreatefrompng($image);
				break;
			default:
				$source = false;
				break;
		}	
		imagecopyresampled($newImage,$source,0,0,0,0,$newImageWidth,$newImageHeight,$width,$height);
		imagejpeg($newImage,$image,90);
		chmod($image, 0777);
		return $image;
	}	
	public function getHeight($image) {
		$sizes = getimagesize($image);
		$height = $sizes[1];
		return $height;
	}	
	public function getWidth($image) {
		$sizes = getimagesize($image);
		$width = $sizes[0];
		return $width;
	}	
	
	/* Data Entry */
	/* Get Missing Student Data */
	public function getMissingStudentData()
    {
        if ($this->input->is_ajax_request()) {
			$this->app->get_table_data('data_entry_student',[
                'contact_tbl'=>$this->contact_tbl
            ]);
        }
    }
	
	/* Update Student Admission Year */
	public function updateStudentAdmissionYear($year, $userid)
	{
		$postData['Admission_Year'] = $year;
		$postData['updated_by'] = get_staff_user_id();
		
		/* 2020-21 */
		$this->db->where('userid', $userid);
		$this->db->update(db_prefix().'contacts', $postData);
		
		/* 2021-22 */
		$this->db->where('userid', $userid);
		$this->db->update('tblcontacts_2021_22', $postData);
		
		/* 2022-23 */
		$this->db->where('userid', $userid);
		$this->db->update('tblcontacts_2022_23', $postData);
        
        /* 2023-24 */
        $this->db->where('userid', $userid);
        $this->db->update('tblcontacts_2023_24', $postData);
		
		//$this->db->where('userid', $userid);
		//$this->db->update(db_prefix().'contacts'.$this->contact_tbl, $postData);
		echo $this->db->affected_rows();
	}
		
	/* Get Class wise data */
	public function getStudentListForStatus($class_name)
    {
		if($class_name == 'Playgroup' || $class_name == 'Nursery' || $class_name == 'LKG' || $class_name == 'UKG')
		{			
		}
		else
		{
			$class_name = 'Class '.$class_name;
		}
        if ($this->input->is_ajax_request()) {
			$this->app->get_table_data('student_list_for_status',[
                'contact_tbl'=>$this->contact_tbl, 'class_name' => $class_name
            ]);
        }
    }
	/* Update Student Academin Status */
	public function updateStudent_academicStatus($status, $userid)
	{
		$postData['student_status'] = $status;	
		$postData['updated_by'] = get_staff_user_id();		
		$this->db->where('userid', $userid);
		$this->db->update(db_prefix().'contacts'.$this->contact_tbl, $postData);
		echo $this->db->affected_rows();
	}
	
	public function dbBackup()
	{
		$username = $_POST['backup_username'];
		$password = $_POST['backup_password'];
		if($username != '' && $password != '')
		{
			if($username == 'master' && $password == '789321')
			{
				//$this->dashboard_model->db_backup();
				$message = _l('ID and password are match!');
				echo json_encode([
					'success' => true,
					'message' => $message
				]);			
			}
			else
			{
				$message = _l('Username and password are not match');
				echo json_encode([
					'success' => false,
					'message' => $message,
				]);
			}
		}
		else
		{
			$message = _l('Username and password are required');
			echo json_encode([
				'success' => false,
				'message' => $message,
			]);			
		}		
	}
	
	public function sscount()
	{
		echo $this->db->select('a.userid')->from(db_prefix().'contacts'.$this->contact_tbl.' a')->join(db_prefix().'clients b','b.userid = a.userid', 'RIGHT')->where('b.active',1)->where('a.Class','Nursery')->get()->num_rows();
	}
	
	function promoteClass__20221227(){
      $res =   $this->db->select('classId')->group_by('classId')->get_where('tblcontacts')->result();
     // echo  '<pre>';
     // print_r( $res);
       foreach($res  as $val){
           
           if($val->classId=='8'){
               $Class = 'UKG';
               $classId = '9';
               $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts',array('Class'=>$Class,'classId'=>$classId));
           }
           
           if($val->classId=='7'){
                 $Class = 'Class I';
                  $classId = '8';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts',array('Class'=>$Class,'classId'=>$classId));
           }
           
           
           if($val->classId=='6'){
                 $Class = 'Class II';
                  $classId = '7';
                   $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts',array('Class'=>$Class,'classId'=>$classId));
           }
           
           if($val->classId=='5'){
                 $Class = 'Class III';
                  $classId = '6';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts',array('Class'=>$Class,'classId'=>$classId));
           }
           
           
           
           if($val->classId=='4'){
                 $Class = 'Class IV';
                  $classId = '5';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts',array('Class'=>$Class,'classId'=>$classId));
           }
           
           
           if($val->classId=='3'){
                 $Class = 'Class V';
                  $classId = '4';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts',array('Class'=>$Class,'classId'=>$classId));
           }
           
           
           if($val->classId=='2'){
                 $Class = 'Class VI';
                  $classId = '3';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts',array('Class'=>$Class,'classId'=>$classId));
           }
           
           
           if($val->classId=='1'){
                 $Class = 'Class VII';
                  $classId = '2';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts',array('Class'=>$Class,'classId'=>$classId));
           }
           
           
            if($val->classId=='10'){
                 $Class = 'Nursery';
                  $classId = '11';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts',array('Class'=>$Class,'classId'=>$classId));
           }
           
           
            if($val->classId=='11'){
                 $Class = 'Playgroup';
                  $classId = '12';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts',array('Class'=>$Class,'classId'=>$classId));
           }
           
           
            if($val->classId=='12'){
                 $Class = 'Playgroup';
                  $classId = '12';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts',array('Class'=>$Class,'classId'=>$classId));
           }
           
            if($val->classId=='9'){
                 $Class = 'LKG';
                  $classId = '10';
                   $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts',array('Class'=>$Class,'classId'=>$classId));
                    echo  $this->db->last_query();
           }            
       }
    }

    public function getReferralDetails($snumber){
        $studentDetails = $this->db->order_by('id', 'asc')->get_where('tblrefer_a_friend', array('refer_student_mobile_number_1' => $snumber))->row();
        if(!empty($studentDetails)){
            echo json_encode([
                'success' => true,
                'refer_student_name' => $studentDetails->student_name,
                'refer_student_class' => $studentDetails->student_class,
                'refer_student_number' => $studentDetails->student_mobile_number,
                'refer_id' => $studentDetails->id,
            ]);  
        }
        else{
            echo json_encode([
                'success' => false,
                'refer_student_name' => '',
                'refer_student_class' => '',
                'refer_student_number' => '',
                'refer_id' => '',
            ]);                 
        }
    }

    public function approvedByAccount($refer_id){
        if($refer_id){
            $referralDetails = $this->db->get_where('tblrefer_a_friend', array('id' => $refer_id))->row();
            if($referralDetails){
                $comment_by_account = '';
                $comment_by_account .= 'Student name: '.$referralDetails->student_name; 
                $comment_by_account .= ', approved by Account: '.date('Y-m-d H:i');

                $postData['approved_by_account'] = 1;
                $postData['comment_by_account'] = $comment_by_account;
                $postData['comment_by_account'] = $comment_by_account;
                $postData['approved_by_account_datetime'] = date('Y-m-d H:i');
                $this->db->where('id', $refer_id);
                $this->db->update('tblrefer_a_friend', $postData);
                echo json_encode([
                    'success' => true,
                    'message' => 'Referral request approved by Account',
                ]); 
            }
            else{
                echo json_encode([
                    'success' => false
                ]); 
            }
        }
        else{
            echo json_encode([
                'success' => false
            ]);  
        }
    }
}
