<?php

defined('BASEPATH') or exit('No direct script access allowed');
class CronDayBook extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('dashboard_model');  
        $this->contact_tbl = '';   
        $this->academic_session = '2021-22';   
    }

    /* This is admin dashboard view */
    public function index()
    {
        $email = 'tanmay@immersiveinfotech.com';
        $subject = 'Day book - '.date('d M, Y');
        $message = '';
        $data['title'] = 'Day book - '.date('d M, Y');

        $type = 'All';
        $start_date = date('d-m-Y');
        $end_date = date('d-m-Y');

        $student_all = $this->totalDayBookNStudentCount($type, $start_date, $end_date);
        $t_all = $this->totalDayBookN($type, $start_date, $end_date);
        $cash = $this->totalDayBookN('cash', $start_date, $end_date);
        $cheque = $this->totalDayBookN('cheque', $start_date, $end_date);
        $dd = $this->totalDayBookN('dd', $start_date, $end_date);
        $upi = $this->totalDayBookN('upi', $start_date, $end_date);
        $online = $this->totalDayBookN('online', $start_date, $end_date);
        $IMPS = $this->totalDayBookN('IMPS', $start_date, $end_date);
        $card = $this->totalDayBookN('card', $start_date, $end_date);
        $data = array(
                'student_count' => $student_all,
                't_all' => (!empty($t_all->total_amount)) ? $t_all->total_amount : '0',
                'cash' => (!empty($cash->total_amount)) ? $cash->total_amount : '0',
                'cheque' => (!empty($cheque->total_amount)) ? $cheque->total_amount : '0',
                'dd' => (!empty($dd->total_amount)) ? $dd->total_amount : '0',
                'upi' => (!empty($upi->total_amount)) ? $upi->total_amount : '0',
                'online' => (!empty($online->total_amount)) ? $online->total_amount : '0',
                'IMPS' => (!empty($IMPS->total_amount)) ? $IMPS->total_amount : '0',
                'card' => (!empty($card->total_amount)) ? $card->total_amount : '0',
                'n_start_date'=>$start_date,
                'n_end_date'=>$end_date,
            );

        $post['payment_mode_filter'] = 'All';
        $post['date_timepicker_start'] = date('d-m-Y');
        $post['date_timepicker_end'] = date('d-m-Y');
        $day_book_list = $this->dayBookReport($post);
        /*echo '<pre>'; print_r($day_book_list); die();*/
        $data['daybook_result'] = $day_book_list;
        $message .= $this->load->view('admin/dashboard/email/email-temp-daybook', $data, true);
        $params = array(
            'to'        => $email,
            'subject'   => $subject,
            'html'      => $message,
            'from'      => 'noreply.theisb@gmail.com',
            'fromname'  => 'The ISB',
        );

        $request = 'https://api.sendgrid.com/api/mail.send.json';
        $headr = array();
        //$pass = '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';
        $pass = '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';
        // set authorization header
        $headr[] = 'Authorization: Bearer '.$pass;

        $session = curl_init($request);
        curl_setopt ($session, CURLOPT_POST, true);
        curl_setopt ($session, CURLOPT_POSTFIELDS, $params);
        curl_setopt($session, CURLOPT_HEADER, false);
        curl_setopt($session, CURLOPT_RETURNTRANSFER, true);

        // add authorization header
        curl_setopt($session, CURLOPT_HTTPHEADER,$headr);

        $response = curl_exec($session);
        //echo '<pre>'; print_r($response); die();
        curl_close($session);
        return true;
    }    

     public function totalDayBookNStudentCount($type, $start_Date, $end_date){   
        $contact_tbl_name = 'tblcontacts'.$this->contact_tbl;      
        $this->db->select('a.*');
        $this->db->from('tblstudent_fees_deposit a');
        $this->db->join($contact_tbl_name.' b', 'a.userid=b.userid', 'inner');
        if(!empty($start_Date) && !empty($end_date))
        {
            $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($start_Date)));
            $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($end_date)));
        }
        elseif(!empty($start_Date) && empty($end_date))
        {
            $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($start_Date)));
            $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($start_Date)));
        }
        elseif(empty($start_Date) && !empty($end_date))
        {
            $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($end_date)));
            $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($end_date)));
        }
        else{
            
            $this->db->where('a.deposit_date >=', date('Y-m-d'));
            $this->db->where('a.deposit_date <=', date('Y-m-d'));
        }
        if($type != 'All'){
            $this->db->where('a.payment_mode', $type);
        }
        $this->db->where('a.academic_year',$this->academic_session);
        $ignore = array('07582970904', '9039524321');
        $this->db->where_not_in('b.Father_Mobile', $ignore);
        $this->db->group_by('a.userid');
        $query = $this->db->get()->num_rows();
        return  $query;
    }


    public function totalDayBookN($type, $start_Date, $end_date){ 
        $contact_tbl_name = 'tblcontacts'.$this->contact_tbl;        
        $this->db->select('SUM(a.deposit_amount) as total_amount');
        $this->db->from('tblstudent_fees_deposit a');
        $this->db->join($contact_tbl_name.' b', 'a.userid=b.userid', 'inner');
        if(!empty($start_Date) && !empty($end_date))
        {
            $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($start_Date)));
            $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($end_date)));
        }
        elseif(!empty($start_Date) && empty($end_date))
        {
            $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($start_Date)));
            $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($start_Date)));
        }
        elseif(empty($start_Date) && !empty($end_date))
        {
            $this->db->where('a.deposit_date >=', date('Y-m-d', strtotime($end_date)));
            $this->db->where('a.deposit_date <=', date('Y-m-d', strtotime($end_date)));
        }
        else{
            
            $this->db->where('a.deposit_date >=', date('Y-m-d'));
            $this->db->where('a.deposit_date <=', date('Y-m-d'));
        }
        if($type != 'All'){
            $this->db->where('a.payment_mode', $type);
        }
        $this->db->where('a.academic_year',$this->academic_session);
        $ignore = array('07582970904', '9039524321');
        $this->db->where_not_in('b.Father_Mobile', $ignore);
        $query = $this->db->get()->row();
        return  $query;
    }

    public function dayBookReport($post)
    {
        $query = $this->_get_query('show_list', $post);         
        return $result = $this->db->query($query)->result();
    }

    private function _get_query($param1 = NULL, $param2 = NULL)
    {  
         
        $sql = array();
        $f_sql = '';

        $date_timepicker_start   = $param2['date_timepicker_start'];
        $date_timepicker_end   = $param2['date_timepicker_end'];
        
        if(!empty($date_timepicker_start) && !empty($date_timepicker_end))
        {
            $sql[] = "a.deposit_date >= '".date('Y-m-d', strtotime($date_timepicker_start))."'";
            $sql[] = "a.deposit_date <= '".date('Y-m-d', strtotime($date_timepicker_end))."'";
        }
        elseif(!empty($date_timepicker_start) && empty($date_timepicker_end))
        {
            $sql[] = "a.deposit_date >= '".date('Y-m-d', strtotime($date_timepicker_start))."'";
            $sql[] = "a.deposit_date <= '".date('Y-m-d', strtotime($date_timepicker_start))."'";
        }
        elseif(empty($date_timepicker_start) && !empty($date_timepicker_end))
        {
            $sql[] = "a.deposit_date >= '".date('Y-m-d', strtotime($date_timepicker_end))."'";
            $sql[] = "a.deposit_date <= '".date('Y-m-d', strtotime($date_timepicker_end))."'";
        }
        else{
            $sql[] = "a.deposit_date >= '".date('Y-m-d')."'";
            $sql[] = "a.deposit_date <= '".date('Y-m-d')."'";
        }
        
        if(!empty($param2['payment_mode_filter'])){
            if($param2['payment_mode_filter'] != 'All'){
                $sql[] = "a.payment_mode = '".$param2['payment_mode_filter']."'";
            }
        }      
        $sql[] = "NOT ((b.Father_Mobile = '07582970904') OR (b.Father_Mobile = '9039524321'))";
        $order_by = 'a.deposit_date DESC';

        if(sizeof($sql) > 0)
        $f_sql = implode(' AND ', $sql);
        
        if($param1 == 'show_list' && isset($_POST["length"]) && $_POST["length"] != -1)  
        {  
            $limit = $_POST['length'];
            $offset = $_POST['start'];
            if($f_sql)
            {
                return "SELECT a.*, CONCAT(b.firstname, ' ', b.middlename, ' ', b.lastname) as student_name,b.Father_Name,b.Mother_Name,b.Father_Mobile,b.Mother_Mobile,b.email,b.paa,a.dd_upi_online,a.note, b.Class  FROM (`tblstudent_fees_deposit` a) INNER JOIN `tblcontacts".$this->contact_tbl."` b ON `a`.`userid` = `b`.`userid`  WHERE  $f_sql AND `a`.`academic_year`='$this->academic_session' ORDER BY $order_by LIMIT $limit OFFSET $offset";
            }
            else
            {
                return "SELECT a.*, CONCAT(b.firstname, ' ', b.middlename, ' ', b.lastname) as student_name,b.Father_Name,b.Mother_Name,b.Father_Mobile,b.Mother_Mobile,b.email,b.paa,a.dd_upi_online,a.note, b.Class  FROM (`tblstudent_fees_deposit` a) INNER JOIN `tblcontacts".$this->contact_tbl."` b ON `a`.`userid` = `b`.`userid` where  `a`.`academic_year`='$this->academic_session' ORDER BY $order_by LIMIT $limit OFFSET $offset";     
            }
        }  
        else
        {
            if($f_sql)
            {
                return "SELECT a.*, CONCAT(b.firstname, ' ', b.middlename, ' ', b.lastname) as student_name,b.Father_Name,b.Mother_Name,b.Father_Mobile,b.Mother_Mobile,b.email,b.paa,a.dd_upi_online,a.note, b.Class  FROM (`tblstudent_fees_deposit` a) INNER JOIN `tblcontacts".$this->contact_tbl."` b ON `a`.`userid` = `b`.`userid` WHERE  $f_sql AND  `a`.`academic_year`='$this->academic_session' ORDER BY $order_by";
            }
            else
            {
                return "SELECT a.*, CONCAT(b.firstname, ' ', b.middlename, ' ', b.lastname) as student_name,b.Father_Name,b.Mother_Name,b.Father_Mobile,b.Mother_Mobile,b.email,b.paa,a.dd_upi_online,a.note, b.Class  FROM (`tblstudent_fees_deposit` a) INNER JOIN `tblcontacts".$this->contact_tbl."` b ON `a`.`userid` = `b`.`userid` WHERE  `a`.`academic_year`='$this->academic_session'  ORDER BY $order_by";    
            }
        }
    }

    /***********************************************************
     * 
     * ************************************************************/
    public function complaintList(){
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'http://mobile.theisb.in/api/complaintList',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);

        curl_close($curl);		
        $result = json_decode($response); 
        $this->sendComplaintMail('tanmay@immersiveinfotech.com', $result);
        $this->sendComplaintMail('theisb.in@gmail.com', $result);
        //$ss = $this->sendComplaintMail('om@immersiveinfotech.com', $result);
        //echo $response;
    }

    public function sendComplaintMail($email, $result){
        //$email = 'tanmay@immersiveinfotech.com';
        $subject = 'The ISB - Complaint Report Status - '. date('D, d F, Y');
        $message = $this->load->view('admin/dashboard/email/complaint-query', $result, true);
        $params = array(
            'to'        => $email,
            'subject'   => $subject,
            'html'      => $message,
            'from'      => 'noreply.theisb@gmail.com',
            'fromname'  => 'The ISB',
        );

        $request = 'https://api.sendgrid.com/api/mail.send.json';
        $headr = array();
        #$pass = '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';
        //$pass = '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';
        $pass = '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';
        // set authorization header
        $headr[] = 'Authorization: Bearer '.$pass;

        $session = curl_init($request);
        curl_setopt ($session, CURLOPT_POST, true);
        curl_setopt ($session, CURLOPT_POSTFIELDS, $params);
        curl_setopt($session, CURLOPT_HEADER, false);
        curl_setopt($session, CURLOPT_RETURNTRANSFER, true);

        // add authorization header
        curl_setopt($session, CURLOPT_HTTPHEADER,$headr);

        $response = curl_exec($session);
        //echo '<pre>'; print_r($response); die();
        curl_close($session);
        return true;
    }
}
