<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Clients extends AdminController
{
    /* List all clients */
    public function index()
    {
        if (has_permission('customers', '', 'view')) {
            if (have_assigned_customers() && !has_permission('customers', '', 'create')) {
                access_denied('customers');
            }
        }

        $this->load->model('contracts_model');
        $data['contract_types'] = $this->contracts_model->get_contract_types();
        $data['groups']         = $this->clients_model->get_groups();
        
        $this->load->model('proposals_model');
        $data['proposal_statuses'] = $this->proposals_model->get_statuses();

        $this->load->model('invoices_model');
        $data['invoice_statuses'] = $this->invoices_model->get_statuses();

        $this->load->model('estimates_model');
        $data['estimate_statuses'] = $this->estimates_model->get_statuses();

        $this->load->model('projects_model');
        $data['project_statuses'] = $this->projects_model->get_project_statuses();

        $data['customer_admins'] = $this->clients_model->get_customers_admin_unique_ids();

        $whereContactsLoggedIn = '';
        if (!has_permission('customers', '', 'view')) {
            $whereContactsLoggedIn = ' AND userid IN (SELECT customer_id FROM ' . db_prefix() . 'customer_admins WHERE staff_id=' . get_staff_user_id() . ')';
        }

        $data['contacts_logged_in_today'] = $this->clients_model->get_contacts('', 'last_login LIKE "' . date('Y-m-d') . '%"' . $whereContactsLoggedIn);
        $data['countries'] = $this->clients_model->get_clients_distinct_countries();
               
        $header_text = title_text('aside_menu_active', 'customers');
        $data['heading_text'] = $header_text;
        $data['title']          = _l($header_text);
        if(get_staff_user_id() > 90){
            $this->load->view('admin/clients/manage-class-wise', $data);
        }
        else{
            $this->load->view('admin/clients/manage', $data);
        }
    }
    
    /**
    *   @Function: 
    */
    /*
    public function createRegs()
    {
        $result = $this->db->select('Class')->group_by('Class')->get_where(db_prefix().'contacts')->result();
        $reg2 = 'ISB1120';

        foreach($result as $val)
        {
            $resClass =  $this->db->select('Class,userid')->get_where(db_prefix().'contacts', array('Class' => $val->Class))->result();
            echo '<br>';
            echo $val->Class;
            $i = 1;
            foreach($resClass as $valClass)
            {
                
                if($valClass->Class=='Playgroup'){
                    $CID ='01';
                }   

                if($valClass->Class=='Nursery'){
                    $CID ='02';
                } 


                if($valClass->Class=='LKG'){
                    $CID ='03';
                } 

                if($valClass->Class=='UKG'){
                    $CID ='04';
                } 

                if($valClass->Class=='Class I'){
                    $CID ='05';
                } 
                if($val->Class=='Class II'){
                    $CID ='06';
                }

                if($val->Class=='Class III'){
                    $CID ='07';
                }


                if($valClass->Class=='Class IV'){
                    $CID ='08';
                }
                if($val->Class=='Class V'){
                    $CID ='09';
                }

                if($valClass->Class=='Class VI'){
                    $CID ='10';
                }
                if($valClass->Class=='Class VII'){
                    $CID ='11';
                }   
                if($valClass->Class=='Class VIII'){
                    $CID ='12';
                }
                $invID = str_pad($i, 3, '0', STR_PAD_LEFT);
                $reg = $reg2.$CID.$invID;
                echo '<br>';
                echo $updateArr['registration_id']  = $reg;
                $this->db->where('userid',$valClass->userid);
                $this->db->update('tblcontacts',$updateArr);
                $i++;
            }                    
        }   
    }*/
    
    /* Unpaid Student ID */
    public function unpaidStudentID()
    {
        //ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL); 
        $totalStudent = $this->db->get_where(db_prefix().'_section_b_to_a1215')->result();
       // echo '<pre>'; print_r($totalStudent);
        $response = [];
        $responseNomatch = [];
        foreach($totalStudent as $rrr)
        {
            $sid = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name,'Father_Mobile' => $rrr->Father_Mobile))->row();
            if($sid)
            {
                //array_push($response, $sid->userid);
                //echo $sid->userid.'<br>';
                $update['payment_status'] = 2;
                $this->db->where('userid', $sid->userid);
                $this->db->update(db_prefix().'contacts'.$this->contact_tbl, $update);
            }
            else
            {
                array_push($responseNomatch, $rrr->Father_Mobile);
            }
        }
        echo '<pre>'; print_r($response);
        echo '<pre>'; print_r($responseNomatch); die;
    }
    
    /* List all clients */
    public function studentList($classname)
    {
        if (!has_permission('customers', '', 'view')) {
            if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
                access_denied('customers');
            }
        }
        
        $classname_ = str_replace('_',' ',$classname);
        $data['classname'] = $classname_;
        $_SESSION['_classname'] = $classname_;
        if($classname_ == 'Playgroup')
        {
            $total_student = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => $classname_))->num_rows();
            $total_student_ = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'PG'))->num_rows();
            $data['total_student'] = $total_student + $total_student_;
            
            $total_activestudent = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => $classname_, 'active' => 1))->num_rows();
            $total_activestudent_ = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'PG', 'active' => 1))->num_rows();
            $data['total_activestudent'] = $total_activestudent + $total_activestudent_;
            
            $total_instudent = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => $classname_, 'active' => 0))->num_rows();
            $total_instudent_ = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'PG', 'active' => 0))->num_rows();
            $data['total_inactivestudent'] = $total_instudent + $total_instudent_;
        }
        else
        {
            $data['total_student'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => $classname_))->num_rows();
            $data['total_activestudent'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => $classname_, 'active' => 1))->num_rows();
            $data['total_inactivestudent'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => $classname_, 'active' => 0))->num_rows();
        }
        
        $header_text = title_text('aside_menu_active', 'customers');
        $data['heading_text'] = $header_text;
        $data['title']          = _l($header_text);
        $this->load->view('admin/clients/manage_class_wise', $data);
    }

    /**
    * @Function: paidStudent
    */
    public function paidStudent()
    {
        $header_text = setupTitle_text('aside_menu_active', 'customers','paidStudent');
        $data['heading_text'] = $header_text;
        $data['title']          = _l($header_text);
        $this->load->view('admin/clients/paidStudent', $data);
    }
    
    /**
    * @Function: unPaidStudent
    */
    public function unPaidStudent()
    {
        $header_text = setupTitle_text('aside_menu_active', 'customers','unPaidStudent');
        $data['heading_text'] = $header_text;
        $data['title']          = _l($header_text);
        $this->load->view('admin/clients/unPaidStudent', $data);
    }

    /*
    * @Function: TC-withdrawl
    */
    public function wtcStudentID()
    {
        $totalStudent = $this->db->get_where(db_prefix().'_tc_withdral_academic')->result();

        $response = [];
        $responseNomatch = [];
        foreach($totalStudent as $rrr)
        {
            $sid = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Mobile' => $rrr->Father_Mobile))->row();
            if($sid)
            {
                array_push($response, $sid->userid);
                //echo $sid->userid.'<br>';
                $this->delete_wtc($sid->userid); 
            }
            else
            {
                array_push($responseNomatch, $rrr->id);
            }
        }
        echo '<pre>'; print_r($response);
        echo '<pre>'; print_r($responseNomatch); die;
    }

    
    /* Delete client */
    public function delete_wtc($id)
    {
        if (!has_permission('customers', '', 'delete')) {
            access_denied('customers');
        }
        if (!$id) {
            redirect(admin_url('clients'));
        }
        $response = $this->clients_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('customer_delete_transactions_warning', _l('invoices') . ', ' . _l('estimates') . ', ' . _l('credit_notes')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('client')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('client_lowercase')));
        }
        //redirect(admin_url('clients'));
        return true;
    }

    public function table()
    {
        if (has_permission('customers', '', 'view')) {
            if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
                ajax_access_denied();
            }
        }
        if(get_staff_user_id() > 90){
            $this->app->get_table_data('clients-class-wise',[
                     'contact_tbl'=>$this->contact_tbl
                ]);       
        }
        else{
            $this->app->get_table_data('clients',[
                     'contact_tbl'=>$this->contact_tbl
                ]);            
        }
    }
    
    public function paidTable()
    {
        if (!has_permission('customers', '', 'view')) {
            if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
                ajax_access_denied();
            }
        }

        $this->app->get_table_data('paidStudent');
    }
    
    public function unPaidTable()
    {
        if (!has_permission('customers', '', 'view')) {
            if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
                ajax_access_denied();
            }
        }

        $this->app->get_table_data('unPaidTable');
    }
    
    public function table_()
    {
        if (!has_permission('customers', '', 'view')) {
            if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
                ajax_access_denied();
            }
        }

        $this->app->get_table_data('clients_classwise',[
                 'contact_tbl'=>$this->contact_tbl
            ]);
    }

    /**
    *   @function:classWiseStudent
    */
    public function classWise()
    {
        $total_playgrop_ = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Playgroup'))->num_rows();
        $total_playgrop = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'PG'))->num_rows();
        $data['total_playgrop'] = $total_playgrop + $total_playgrop_;
        
        $total_nursery = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Nursery'))->num_rows();
        $data['total_nursery'] = $total_nursery;
        
        $total_lkg = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'LKG'))->num_rows();
        $data['total_lkg'] = $total_lkg;
        
        $total_ukg = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'UKG'))->num_rows();
        $data['total_ukg'] = $total_ukg;
        
        $total_I = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class I'))->num_rows();
        $data['total_I'] = $total_I;
        
        $total_II = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class II'))->num_rows();
        $data['total_II'] = $total_II;
        
        $total_III = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class III'))->num_rows();
        $data['total_III'] = $total_III;
        
        $total_IV = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class IV'))->num_rows();
        $data['total_IV'] = $total_IV;
        
        $total_V = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class V'))->num_rows();
        $data['total_V'] = $total_V;
        
        $total_VI = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class VI'))->num_rows();
        $data['total_VI'] = $total_VI;
        
        $total_VII = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class VII'))->num_rows();
        $data['total_VII'] = $total_VII;
        
        $total_VIII = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => 'Class VIII'))->num_rows();
        $data['total_VIII'] = $total_VIII;
        
        
        $header_text = title_text('aside_menu_active', 'customers');
        $data['heading_text'] = $header_text;
        $this->load->view('admin/clients/classWise', $data);
    }

    /* Parent datails update */
    public function parentDetailsUpdate($userID)
    {
        if ($this->input->post()) {
            //$userID = $this->input->post('uId');
            $postData = $this->input->post();
            //echo '<pre>'; print_r($postData); die;
            
            $this->db->where('userid',$userID);
            $this->db->update(db_prefix().'contacts'.$this->contact_tbl,  $postData);
            
            set_alert('success', _l('Parent detaills update successful'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    
    /* Route update */
    public function transportDetailsUpdate($userID)
    {
        if ($this->input->post()) {
            $postData = $this->input->post();
            
            $this->db->where('userid',$userID);
            $this->db->update(db_prefix().'contacts'.$this->contact_tbl,  $postData);
            
            set_alert('success', _l('Route detaills update successful'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    
    /* address datails update */
    public function addressUpdate($userID)
    {
        if ($this->input->post()) {
            //$userID = $this->input->post('uId');
            $postData = $this->input->post();
            //echo '<pre>'; print_r($postData); die;
            
            $this->db->where('userid',$userID);
            $this->db->update(db_prefix().'contacts'.$this->contact_tbl,  $postData);
            
            set_alert('success', _l('Student address detaills update successful'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    
    /* address datails update */
    public function photosUpdate($userID)
    {
        if ($this->input->post()) {
            handle_contact_profile_image_upload();
            /*
            $name = $_FILES["profile_image"]["name"];
            if($name)
            {
                $ext  = end((explode(".", $name)));
                $logoname = 'profile_'.time().'.'.$ext;
                $allowed = array('gif', 'png', 'jpg', 'jpeg');
                $filename = $_FILES['profile_image']['name'];
                $ext = pathinfo($filename, PATHINFO_EXTENSION);
                if (!in_array($ext, $allowed)) {
                    set_alert('warning', 'Profile image extension are not allowed');
                    redirect($_SERVER['HTTP_REFERER']);
                }
                else
                {
                    move_uploaded_file($_FILES["profile_image"]['tmp_name'], 'uploads/student/'.$logoname);
                    $update_profile['profile_image'] = $logoname;
                    $this->db->where('userid',$userID);
                    $this->db->update(db_prefix().'contacts',  $update_profile);
                    $old_profie_img = $this->input->post('old_profile_img');
                    if($old_profie_img)
                    {
                        unlink('./uploads/student/'.$old_profie_img);
                    }
                }     
            }
            */
            
            $father_img = $_FILES["father_image"]["name"];
            if($father_img)
            {
                $ext  = end((explode(".", $father_img)));
                $logoname = 'father_'.time().'.'.$ext;
                $allowed = array('gif', 'png', 'jpg', 'jpeg');
                $filename = $_FILES['father_image']['name'];
                $ext = pathinfo($filename, PATHINFO_EXTENSION);
                if (!in_array($ext, $allowed)) {
                    set_alert('warning', 'Father image extension are not allowed');
                    redirect($_SERVER['HTTP_REFERER']);
                }
                else
                {
                    move_uploaded_file($_FILES["father_image"]['tmp_name'], 'uploads/student/'.$logoname);
                    $update_father_img['father_image'] = $logoname;
                    $this->db->where('userid',$userID);
                    $this->db->update(db_prefix().'contacts'.$this->contact_tbl,  $update_father_img);
                    $old_father_img = $this->input->post('old_father_img');
                    if($old_father_img)
                    {
                        unlink('./uploads/student/'.$old_father_img);
                    }
                }     
            }
            
            $mother_img = $_FILES["mother_image"]["name"];
            if($mother_img)
            {
                $ext  = end((explode(".", $mother_img)));
                $logoname = 'mother_'.time().'.'.$ext;
                $allowed = array('gif', 'png', 'jpg', 'jpeg');
                $filename = $_FILES['mother_image']['name'];
                $ext = pathinfo($filename, PATHINFO_EXTENSION);
                if (!in_array($ext, $allowed)) {
                    set_alert('warning', 'Mother image extension are not allowed');
                    redirect($_SERVER['HTTP_REFERER']);
                }
                else
                {
                    move_uploaded_file($_FILES["mother_image"]['tmp_name'], 'uploads/student/'.$logoname);
                    $update_mother_img['mother_image'] = $logoname;
                    $this->db->where('userid',$userID);
                    $this->db->update(db_prefix().'contacts'.$this->contact_tbl,  $update_mother_img);
                    $old_mother_img = $this->input->post('old_mother_img');
                    if($old_mother_img)
                    {
                        unlink('./uploads/student/'.$old_mother_img);
                    }
                }     
            }
            
            $gaurdian_img = $_FILES["gaurdian_image"]["name"];
            if($gaurdian_img)
            {
                $ext  = end((explode(".", $gaurdian_img)));
                $logoname = 'gaurdian_'.time().'.'.$ext;
                $allowed = array('gif', 'png', 'jpg', 'jpeg');
                $filename = $_FILES['gaurdian_image']['name'];
                $ext = pathinfo($filename, PATHINFO_EXTENSION);
                if (!in_array($ext, $allowed)) {
                    set_alert('warning', 'Gaurdian image extension are not allowed');
                    redirect($_SERVER['HTTP_REFERER']);
                }
                else
                {
                    move_uploaded_file($_FILES["gaurdian_image"]['tmp_name'], 'uploads/student/'.$logoname);
                    $update_gaurdian_img['gaurdian_image'] = $logoname;
                    $this->db->where('userid',$userID);
                    $this->db->update(db_prefix().'contacts'.$this->contact_tbl,  $update_gaurdian_img);
                    $old_guardian_img = $this->input->post('old_guardian_img');
                    if($old_guardian_img)
                    {
                        unlink('./uploads/student/'.$old_guardian_img);
                    }
                }     
            }
            
            set_alert('success', _l('Student photos detaills update successful'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    
   
    
    /* password update */
    public function passwordUpdate($userID)
    {
        if ($this->input->post()) {
            $confirm_ = $this->input->post('confirm_password');
            $newPassword = $this->input->post('new_password');
            if($newPassword == $confirm_)
            {
                $this->db->where('userid',$userID);
                $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, [
                    'last_password_change' => date('Y-m-d H:i:s'),
                    'password'             => app_hash_password($newPassword),
                ]);
        
                if ($this->db->affected_rows() > 0) {
                    set_alert('success', _l('{Password update successful'));
                }
            }
            else
            {
                set_alert('warning', _l('Password and confirm password are not match'));
            }
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function all_contacts()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('all_contacts');
        }

        if (is_gdpr() && get_option('gdpr_enable_consent_for_contacts') == '1') {
            $this->load->model('gdpr_model');
            $data['consent_purposes'] = $this->gdpr_model->get_consent_purposes();
        }
        $header_text = title_text('aside_menu_active', 'customers');
        $data['heading_text'] = $header_text;

        $data['title'] = _l($header_text);
        $this->load->view('admin/clients/all_contacts', $data);
    }

    /* Edit client or add new client*/
    public function client($id = '')
    {
        if (has_permission('customers', '', 'view')) {
            // if ($id != '' && !is_customer_admin($id)) {
            //     access_denied('customers');
            // }
        }
        /*if(get_staff_user_id() != 104){
            access_denied('customers');
        }*/
        $header_text = title_text('aside_menu_active', 'customers');
        $data['heading_text'] = $header_text;

        if ($this->input->post() && !$this->input->is_ajax_request()) {
            if ($id == '') {
                // if (!has_permission('customers', '', 'create')) {
                //     access_denied('customers');
                // }

                $data = $this->input->post();
               // echo '<pre>'; print_r($data); die;
                $save_and_add_contact = false;
                if (isset($data['save_and_add_contact'])) {
                    unset($data['save_and_add_contact']);
                    $save_and_add_contact = true;
                }
                $id = $this->clients_model->add($data);
                if (!has_permission('customers', '', 'view')) {
                    $assign['customer_admins']   = [];
                    $assign['customer_admins'][] = get_staff_user_id();
                    $this->clients_model->assign_admins($assign, $id);
                }
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('client')));
                    if ($save_and_add_contact == false) {
                        redirect(admin_url('clients/client/' . $id));
                    } else {
                        redirect(admin_url('clients/client/' . $id . '?group=contacts&new_contact=true'));
                    }
                }
            } else {
                // if (!has_permission('customers', '', 'edit')) {
                //     if (!is_customer_admin($id)) {
                //         access_denied('customers');
                //     }
                // }
                $success = $this->clients_model->update($this->input->post(), $id);
                if ($success == true) {
                    set_alert('success', _l('updated_successfully', _l('Student details ')));
                }
                /*redirect(admin_url('clients/client/' . $id));*/
                redirect(admin_url('clients'));
            }
        }
        
        $data['transport_result'] = $this->db->get_where(db_prefix().'transport')->result();
        
        //echo $this->input->get('group');
        //die;

        $group         = !$this->input->get('group') ? 'profile' : $this->input->get('group');
        $data['group'] = $group;

        if ($group != 'contacts' && $contact_id = $this->input->get('contactid')) {
            redirect(admin_url('clients/client/' . $id . '?group=contacts&contactid=' . $contact_id));
        }
                // Customer groups
        $data['groups'] = $this->clients_model->get_groups();

        if ($id == '') {
            $title = _l('add_new', _l('client_lowercase'));
        } else {
            $client                = $this->clients_model->get($id);
            $data['customer_tabs'] = get_customer_profile_tabs();

            if (!$client) {
                show_404();
            }
            
            $feesmodule = [];
            $studentshift = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $client->userid))->row('Shift');
            if($studentshift)
            {
                $feesmodule = $this->db->get_where(db_prefix().'school_fees', array('shift' => $studentshift))->row();
            }
            
            $data['school_fees'] = $feesmodule;
$where = array();
            $data['contacts'] = $this->clients_model->get_contacts($id,$where);
            $data['tab']      = isset($data['customer_tabs'][$group]) ? $data['customer_tabs'][$group] : null;

            if (!$data['tab']) {
                show_404();
            }

            // Fetch data based on groups
            if ($group == 'profile') {
                $data['customer_groups'] = $this->clients_model->get_customer_groups($id);
                $data['customer_admins'] = $this->clients_model->get_admins($id);
            } elseif ($group == 'attachments') {
                $data['attachments'] = get_all_customer_attachments($id);
            } elseif ($group == 'vault') {
                $data['vault_entries'] = hooks()->apply_filters('check_vault_entries_visibility', $this->clients_model->get_vault_entries($id));

                if ($data['vault_entries'] === -1) {
                    $data['vault_entries'] = [];
                }
            } elseif ($group == 'estimates') {
                $this->load->model('estimates_model');
                $data['estimate_statuses'] = $this->estimates_model->get_statuses();
            } elseif ($group == 'invoices') {
                $this->load->model('invoices_model');
                $data['invoice_statuses'] = $this->invoices_model->get_statuses();
            } elseif ($group == 'credit_notes') {
                $this->load->model('credit_notes_model');
                $data['credit_notes_statuses'] = $this->credit_notes_model->get_statuses();
                $data['credits_available']     = $this->credit_notes_model->total_remaining_credits_by_customer($id);
            } elseif ($group == 'payments') {
                $this->load->model('payment_modes_model');
                $data['payment_modes'] = $this->payment_modes_model->get();
            } elseif ($group == 'notes') {
                $data['user_notes'] = $this->misc_model->get_notes($id, 'customer');
            } elseif ($group == 'projects') {
                $this->load->model('projects_model');
                $data['project_statuses'] = $this->projects_model->get_project_statuses();
            } elseif ($group == 'statement') {
                if (!has_permission('invoices', '', 'view') && !has_permission('payments', '', 'view')) {
                    set_alert('danger', _l('access_denied'));
                    redirect(admin_url('clients/client/' . $id));
                }

                $data = array_merge($data, prepare_mail_preview_data('customer_statement', $id));
            } elseif ($group == 'map') {
                if (get_option('google_api_key') != '' && !empty($client->latitude) && !empty($client->longitude)) {
                    $this->app_scripts->add('map-js', base_url($this->app_scripts->core_file('assets/js', 'map.js')) . '?v=' . $this->app_css->core_version());

                    $this->app_scripts->add('google-maps-api-js', [
                        'path'       => 'https://maps.googleapis.com/maps/api/js?key=' . get_option('google_api_key') . '&callback=initMap',
                        'attributes' => [
                            'async',
                            'defer',
                            'latitude'       => "$client->latitude",
                            'longitude'      => "$client->longitude",
                            'mapMarkerTitle' => "$client->company",
                        ],
                        ]);
                }
            }

            $data['staff'] = $this->staff_model->get('', ['active' => 1]);
            //$data['user_result'] = $this->db->get_where(db_prefix.'contacts', array('userid' => $client->userid))->row();

            $data['client'] = $client;
            $title          = $client->company;

            // Get all active staff members (used to add reminder)
            $data['members'] = $data['staff'];

            if (!empty($data['client']->company)) {
                // Check if is realy empty client company so we can set this field to empty
                // The query where fetch the client auto populate firstname and lastname if company is empty
                if (is_empty_customer_company($data['client']->userid)) {
                    $data['client']->company = '';
                }
            }
        }

        $this->load->model('currencies_model');
        $data['currencies'] = $this->currencies_model->get();

        if ($id != '') {
            $customer_currency = $data['client']->default_currency;

            foreach ($data['currencies'] as $currency) {
                if ($customer_currency != 0) {
                    if ($currency['id'] == $customer_currency) {
                        $customer_currency = $currency;

                        break;
                    }
                } else {
                    if ($currency['isdefault'] == 1) {
                        $customer_currency = $currency;

                        break;
                    }
                }
            }

            if (is_array($customer_currency)) {
                $customer_currency = (object) $customer_currency;
            }

            $data['customer_currency'] = $customer_currency;

            $slug_zip_folder = (
                $client->company != ''
                ? $client->company
                : get_contact_full_name(get_primary_contact_user_id($client->userid))
            );

            $data['zip_in_folder'] = slug_it($slug_zip_folder);
        }

        $data['bodyclass'] = 'customer-profile dynamic-create-groups';
        $data['title']     = $title;

        $this->load->view('admin/clients/client', $data);
    }

    public function export($contact_id)
    {
        if (is_admin()) {
            $this->load->library('gdpr/gdpr_contact');
            $this->gdpr_contact->export($contact_id);
        }
    }

    // Used to give a tip to the user if the company exists when new company is created
    public function check_duplicate_customer_name()
    {
        if (has_permission('customers', '', 'create')) {
            $companyName = trim($this->input->post('company'));
            $response    = [
                'exists'  => (bool) total_rows(db_prefix() . 'clients', ['company' => $companyName]) > 0,
                'message' => _l('company_exists_info', '<b>' . $companyName . '</b>'),
            ];
            echo json_encode($response);
        }
    }

    public function save_longitude_and_latitude($client_id)
    {
        if (!has_permission('customers', '', 'edit')) {
            if (!is_customer_admin($client_id)) {
                ajax_access_denied();
            }
        }

        $this->db->where('userid', $client_id);
        $this->db->update(db_prefix() . 'clients', [
            'longitude' => $this->input->post('longitude'),
            'latitude'  => $this->input->post('latitude'),
        ]);
        if ($this->db->affected_rows() > 0) {
            echo 'success';
        } else {
            echo 'false';
        }
    }

    public function form_contact($customer_id, $contact_id = '')
    {
        if (!has_permission('customers', '', 'view')) {
            if (!is_customer_admin($customer_id)) {
                echo _l('access_denied');
                die;
            }
        }
        $data['customer_id'] = $customer_id;
        $data['contactid']   = $contact_id;
        if ($this->input->post()) {
            $data             = $this->input->post();
            $data['password'] = $this->input->post('password', false);

            unset($data['contactid']);
            if ($contact_id == '') {
                if (!has_permission('customers', '', 'create')) {
                    if (!is_customer_admin($customer_id)) {
                        header($_SERVER['SERVER_PROTOCOL'] . ' 400 Bad error');
                        echo json_encode([
                            'success' => false,
                            'message' => _l('access_denied'),
                        ]);
                        die;
                    }
                }
                $id      = $this->clients_model->add_contact($data, $customer_id);
                $message = '';
                $success = false;
                if ($id) {
                    handle_contact_profile_image_upload($id);
                    $success = true;
                    $message = _l('added_successfully', _l('contact'));
                }
                echo json_encode([
                    'success'             => $success,
                    'message'             => $message,
                    'has_primary_contact' => (total_rows(db_prefix() . 'contacts'.$this->contact_tbl, ['userid' => $customer_id, 'is_primary' => 1]) > 0 ? true : false),
                    'is_individual'       => is_empty_customer_company($customer_id) && total_rows(db_prefix() . 'contacts'.$this->contact_tbl, ['userid' => $customer_id]) == 1,
                ]);
                die;
            }
            if (!has_permission('customers', '', 'edit')) {
                if (!is_customer_admin($customer_id)) {
                    header($_SERVER['SERVER_PROTOCOL'] . ' 400 Bad error');
                    echo json_encode([
                            'success' => false,
                            'message' => _l('access_denied'),
                        ]);
                    die;
                }
            }
            $original_contact = $this->clients_model->get_contact($contact_id);
            $success          = $this->clients_model->update_contact($data, $contact_id);
            $message          = '';
            $proposal_warning = false;
            $original_email   = '';
            $updated          = false;
            if (is_array($success)) {
                if (isset($success['set_password_email_sent'])) {
                    $message = _l('set_password_email_sent_to_client');
                } elseif (isset($success['set_password_email_sent_and_profile_updated'])) {
                    $updated = true;
                    $message = _l('set_password_email_sent_to_client_and_profile_updated');
                }
            } else {
                if ($success == true) {
                    $updated = true;
                    $message = _l('updated_successfully', _l('contact'));
                }
            }
            if (handle_contact_profile_image_upload($contact_id) && !$updated) {
                $message = _l('updated_successfully', _l('contact'));
                $success = true;
            }
            if ($updated == true) {
                $contact = $this->clients_model->get_contact($contact_id);
                if (total_rows(db_prefix() . 'proposals', [
                        'rel_type' => 'customer',
                        'rel_id' => $contact->userid,
                        'email' => $original_contact->email,
                    ]) > 0 && ($original_contact->email != $contact->email)) {
                    $proposal_warning = true;
                    $original_email   = $original_contact->email;
                }
            }
            echo json_encode([
                    'success'             => $success,
                    'proposal_warning'    => $proposal_warning,
                    'message'             => $message,
                    'original_email'      => $original_email,
                    'has_primary_contact' => (total_rows(db_prefix() . 'contacts'.$this->contact_tbl, ['userid' => $customer_id, 'is_primary' => 1]) > 0 ? true : false),
                ]);
            die;
        }
        if ($contact_id == '') {
            $title = _l('add_new', _l('contact_lowercase'));
        } else {
            $data['contact'] = $this->clients_model->get_contact($contact_id);

            if (!$data['contact']) {
                header($_SERVER['SERVER_PROTOCOL'] . ' 400 Bad error');
                echo json_encode([
                    'success' => false,
                    'message' => 'Contact Not Found',
                ]);
                die;
            }
            $title = $data['contact']->firstname . ' ' . $data['contact']->lastname;
        }

        $data['customer_permissions'] = get_contact_permissions();
        $data['title']                = $title;
        $this->load->view('admin/clients/modals/contact', $data);
    }

    public function confirm_registration($client_id)
    {
        if (!is_admin()) {
            access_denied('Customer Confirm Registration, ID: ' . $client_id);
        }
        $this->clients_model->confirm_registration($client_id);
        set_alert('success', _l('customer_registration_successfully_confirmed'));
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function update_file_share_visibility()
    {
        if ($this->input->post()) {
            $file_id           = $this->input->post('file_id');
            $share_contacts_id = [];

            if ($this->input->post('share_contacts_id')) {
                $share_contacts_id = $this->input->post('share_contacts_id');
            }

            $this->db->where('file_id', $file_id);
            $this->db->delete(db_prefix() . 'shared_customer_files');

            foreach ($share_contacts_id as $share_contact_id) {
                $this->db->insert(db_prefix() . 'shared_customer_files', [
                    'file_id'    => $file_id,
                    'contact_id' => $share_contact_id,
                ]);
            }
        }
    }

    public function delete_contact_profile_image($contact_id)
    {
        hooks()->do_action('before_remove_contact_profile_image');
        if (file_exists(get_upload_path_by_type('contact_profile_images') . $contact_id)) {
            delete_dir(get_upload_path_by_type('contact_profile_images') . $contact_id);
        }
        $this->db->where('id', $contact_id);
        $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, [
            'profile_image' => null,
        ]);
    }

    public function mark_as_active($id)
    {
        $this->db->where('userid', $id);
        $this->db->update(db_prefix() . 'clients', [
            'active' => 1,
        ]);
        redirect(admin_url('clients/client/' . $id));
    }

    public function consents($id)
    {
        if (!has_permission('customers', '', 'view')) {
            if (!is_customer_admin(get_user_id_by_contact_id($id))) {
                echo _l('access_denied');
                die;
            }
        }

        $this->load->model('gdpr_model');
        $data['purposes']   = $this->gdpr_model->get_consent_purposes($id, 'contact');
        $data['consents']   = $this->gdpr_model->get_consents(['contact_id' => $id]);
        $data['contact_id'] = $id;
        $this->load->view('admin/gdpr/contact_consent', $data);
    }

    public function update_all_proposal_emails_linked_to_customer($contact_id)
    {
        $success = false;
        $email   = '';
        if ($this->input->post('update')) {
            $this->load->model('proposals_model');

            $this->db->select('email,userid');
            $this->db->where('id', $contact_id);
            $contact = $this->db->get(db_prefix() . 'contacts'.$this->contact_tbl)->row();

            $proposals = $this->proposals_model->get('', [
                'rel_type' => 'customer',
                'rel_id'   => $contact->userid,
                'email'    => $this->input->post('original_email'),
            ]);
            $affected_rows = 0;

            foreach ($proposals as $proposal) {
                $this->db->where('id', $proposal['id']);
                $this->db->update(db_prefix() . 'proposals', [
                    'email' => $contact->email,
                ]);
                if ($this->db->affected_rows() > 0) {
                    $affected_rows++;
                }
            }

            if ($affected_rows > 0) {
                $success = true;
            }
        }
        echo json_encode([
            'success' => $success,
            'message' => _l('proposals_emails_updated', [
                _l('contact_lowercase'),
                $contact->email,
            ]),
        ]);
    }

    public function assign_admins($id)
    {
        if (!has_permission('customers', '', 'create') && !has_permission('customers', '', 'edit')) {
            access_denied('customers');
        }
        $success = $this->clients_model->assign_admins($this->input->post(), $id);
        if ($success == true) {
            set_alert('success', _l('updated_successfully', _l('client')));
        }

        redirect(admin_url('clients/client/' . $id . '?tab=customer_admins'));
    }

    public function delete_customer_admin($customer_id, $staff_id)
    {
        if (!has_permission('customers', '', 'create') && !has_permission('customers', '', 'edit')) {
            access_denied('customers');
        }

        $this->db->where('customer_id', $customer_id);
        $this->db->where('staff_id', $staff_id);
        $this->db->delete(db_prefix() . 'customer_admins');
        redirect(admin_url('clients/client/' . $customer_id) . '?tab=customer_admins');
    }

    public function delete_contact($customer_id, $id)
    {
        if (!has_permission('customers', '', 'delete')) {
            if (!is_customer_admin($customer_id)) {
                access_denied('customers');
            }
        }
        $contact      = $this->clients_model->get_contact($id);
        $hasProposals = false;
        if ($contact && is_gdpr()) {
            if (total_rows(db_prefix() . 'proposals', ['email' => $contact->email]) > 0) {
                $hasProposals = true;
            }
        }

        $this->clients_model->delete_contact($id);
        if ($hasProposals) {
            $this->session->set_flashdata('gdpr_delete_warning', true);
        }
        redirect(admin_url('clients/client/' . $customer_id . '?group=contacts'));
    }

    public function contacts($client_id)
    {
        $this->app->get_table_data('contacts', [
            'client_id' => $client_id,
        ]);
    }

    public function upload_attachment($id)
    {
        handle_client_attachments_upload($id);
    }

    public function add_external_attachment()
    {
        if ($this->input->post()) {
            $this->misc_model->add_attachment_to_database($this->input->post('clientid'), 'customer', $this->input->post('files'), $this->input->post('external'));
        }
    }
    
    /**
    *   @Function: receipt
    */
    public function receipt($userid = null, $id = null)
    {
        $data['receipt_result'] = $this->db->get_where(db_prefix().'student_fees_deposit', array('id' => $id))->row();
        $data['student_result'] = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $userid))->row();
        $this->load->view('admin/clients/receipt', $data);
    }

    public function delete_attachment($customer_id, $id)
    {
        if (has_permission('customers', '', 'delete') || is_customer_admin($customer_id)) {
            $this->clients_model->delete_attachment($id);
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    /* Delete client */
    public function delete($id)
    {/*
        if (!has_permission('customers', '', 'delete')) {
            access_denied('customers');
        }*/
        if (!$id) {
            redirect(admin_url('clients'));
        }
        $response = $this->clients_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('customer_delete_transactions_warning', _l('invoices') . ', ' . _l('estimates') . ', ' . _l('credit_notes')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('client')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('client_lowercase')));
        }
        redirect(admin_url('clients'));
    }

    /* Staff can login as client */
    public function login_as_client($id)
    {
        if (is_admin()) {
            login_as_client($id);
        }
        hooks()->do_action('after_contact_login');
        redirect(site_url());
    }

    public function get_customer_billing_and_shipping_details($id)
    {
        echo json_encode($this->clients_model->get_customer_billing_and_shipping_details($id));
    }

    /* Change client status / active / inactive */
    public function change_contact_status($id, $status)
    {
        if (has_permission('customers', '', 'edit') || is_customer_admin(get_user_id_by_contact_id($id))) {
            if ($this->input->is_ajax_request()) {
                $this->clients_model->change_contact_status($id, $status);
            }
        }
    }
    
    /* Change client status / active / inactive */
    public function change_paiment_status()
    {
        $id = $_POST['id'];
        $status = $_POST['status'];
        $this->db->where('userid', $id);
        $this->db->update(db_prefix() . 'contacts'.$this->contact_tbl, [
            'payment_status' => $status,
        ]);
        echo 1;
    }

    /* Change client status / active / inactive */
    public function change_client_status($id, $status)
    {
        if ($this->input->is_ajax_request()) {
            $this->clients_model->change_client_status($id, $status);
        }
    }

    /* Zip function for credit notes */
    public function zip_credit_notes($id)
    {
        $has_permission_view = has_permission('credit_notes', '', 'view');

        if (!$has_permission_view && !has_permission('credit_notes', '', 'view_own')) {
            access_denied('Zip Customer Credit Notes');
        }

        if ($this->input->post()) {
            $this->load->library('app_bulk_pdf_export', [
                'export_type'       => 'credit_notes',
                'status'            => $this->input->post('credit_note_zip_status'),
                'date_from'         => $this->input->post('zip-from'),
                'date_to'           => $this->input->post('zip-to'),
                'redirect_on_error' => admin_url('clients/client/' . $id . '?group=credit_notes'),
            ]);

            $this->app_bulk_pdf_export->set_client_id($id);
            $this->app_bulk_pdf_export->in_folder($this->input->post('file_name'));
            $this->app_bulk_pdf_export->export();
        }
    }

    public function zip_invoices($id)
    {
        $has_permission_view = has_permission('invoices', '', 'view');
        if (!$has_permission_view && !has_permission('invoices', '', 'view_own')
            && get_option('allow_staff_view_invoices_assigned') == '0') {
            access_denied('Zip Customer Invoices');
        }

        if ($this->input->post()) {
            $this->load->library('app_bulk_pdf_export', [
                'export_type'       => 'invoices',
                'status'            => $this->input->post('invoice_zip_status'),
                'date_from'         => $this->input->post('zip-from'),
                'date_to'           => $this->input->post('zip-to'),
                'redirect_on_error' => admin_url('clients/client/' . $id . '?group=invoices'),
            ]);

            $this->app_bulk_pdf_export->set_client_id($id);
            $this->app_bulk_pdf_export->in_folder($this->input->post('file_name'));
            $this->app_bulk_pdf_export->export();
        }
    }

    /* Since version 1.0.2 zip client estimates */
    public function zip_estimates($id)
    {
        $has_permission_view = has_permission('estimates', '', 'view');
        if (!$has_permission_view && !has_permission('estimates', '', 'view_own')
            && get_option('allow_staff_view_estimates_assigned') == '0') {
            access_denied('Zip Customer Estimates');
        }

        if ($this->input->post()) {
            $this->load->library('app_bulk_pdf_export', [
                'export_type'       => 'estimates',
                'status'            => $this->input->post('estimate_zip_status'),
                'date_from'         => $this->input->post('zip-from'),
                'date_to'           => $this->input->post('zip-to'),
                'redirect_on_error' => admin_url('clients/client/' . $id . '?group=estimates'),
            ]);

            $this->app_bulk_pdf_export->set_client_id($id);
            $this->app_bulk_pdf_export->in_folder($this->input->post('file_name'));
            $this->app_bulk_pdf_export->export();
        }
    }

    public function zip_payments($id)
    {
        $has_permission_view = has_permission('payments', '', 'view');

        if (!$has_permission_view && !has_permission('invoices', '', 'view_own')
            && get_option('allow_staff_view_invoices_assigned') == '0') {
            access_denied('Zip Customer Payments');
        }

        $this->load->library('app_bulk_pdf_export', [
                'export_type'       => 'payments',
                'payment_mode'      => $this->input->post('paymentmode'),
                'date_from'         => $this->input->post('zip-from'),
                'date_to'           => $this->input->post('zip-to'),
                'redirect_on_error' => admin_url('clients/client/' . $id . '?group=payments'),
            ]);

        $this->app_bulk_pdf_export->set_client_id($id);
        $this->app_bulk_pdf_export->set_client_id_column(db_prefix() . 'clients.userid');
        $this->app_bulk_pdf_export->in_folder($this->input->post('file_name'));
        $this->app_bulk_pdf_export->export();
    }

    public function import()
    {
        if (!has_permission('customers', '', 'create')) {
            access_denied('customers');
        }
        
        /*
        $dbFields[0] = 'SN';
        $dbFields[1] = 'Date of Admission';
        $dbFields[2] = 'Recipt No.';
        $dbFields[3] = 'Form No.';
        $dbFields[4] = 'Admission Year';
        $dbFields[5] = 'Campus';
        $dbFields[6] = 'Old Student / New Student';
        $dbFields[7] = 'Shift';
        $dbFields[8] = 'Class';
        $dbFields[9] = 'Academic Year';

        $dbFields = array_merge($dbFields, $this->db->list_fields(db_prefix() . 'contacts'));
        */

        $dbFields = $this->db->list_fields(db_prefix() . 'contacts'.$this->contact_tbl);
        foreach ($dbFields as $key => $contactField) {
            if ($contactField == 'phonenumber') {
                $dbFields[$key] = 'contact_phonenumber';
            }
        }

        $dbFields = array_merge($dbFields, $this->db->list_fields(db_prefix() . 'clients'));

        $this->load->library('import/import_customers', [], 'import');

        $this->import->setDatabaseFields($dbFields)
                     ->setCustomFields(get_custom_fields('customers'));

        if ($this->input->post('download_sample') === 'true') {
            $this->import->downloadSample();
        }

        if ($this->input->post()
            && isset($_FILES['file_csv']['name']) && $_FILES['file_csv']['name'] != '') {
            $this->import->setSimulation($this->input->post('simulate'))
                          ->setTemporaryFileLocation($_FILES['file_csv']['tmp_name'])
                          ->setFilename($_FILES['file_csv']['name'])
                          ->perform();


            $data['total_rows_post'] = $this->import->totalRows();

            if (!$this->import->isSimulation()) {
                set_alert('success', _l('import_total_imported', $this->import->totalImported()));
            }
        }

        $data['groups']    = $this->clients_model->get_groups();
        $data['title']     = _l('import');
        $data['bodyclass'] = 'dynamic-create-groups';
        $this->load->view('admin/clients/import', $data);
    }

    public function customFields()
    {
        if (!is_admin()) {
            access_denied('Customer Groups');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('customer_custom_field');
        }

        if ($this->input->post())
        {
            $postData = $this->input->post();
            $this->db->empty_table('tblcustomer_selected_custom_field');

            $data['custom_field_id'] = implode(',', $postData['custome_field']);
            $data['custom_field_required'] = implode(',', $postData['required_field']);
            $data['selected_custom_field_id'] = 1;
            $this->db->insert('tblcustomer_selected_custom_field', $data);

            $before['required'] = 0;
            $before['active'] = 0;
            $this->db->update('tblcustomfields', $before);
            
            $custom_fieldvalue = array();
            $custom_fieldrequired = array();
            $custom_fieldvalue = $postData['custom_fieldvalue'];
            $custom_fieldrequired = $postData['custom_fieldrequired'];
            
            if($custom_fieldvalue)
            {
                foreach($custom_fieldvalue as $rr)
                {
                    $value_update['active'] = 1;
                    $this->db->where('id', $rr);
                    $this->db->update('tblcustomfields', $value_update);
                }
            }
            if($custom_fieldrequired)
            {
                foreach($custom_fieldrequired as $rr)
                {
                    $value_update_['required'] = 1;
                    $this->db->where('id', $rr);
                    $this->db->update('tblcustomfields', $value_update_);
                }
            }
            set_alert('success', 'Custom field add successful!');
            redirect(admin_url('clients/customFields'));
        }
        
        $subheader_text = setupTitle_text('setup_menu_active', 'customers', 'custom_fields');
        $data['subheading_text'] = $subheader_text;
        $data['subtext_'] = $subheader_text;
        
        $data['title'] = _l($subheader_text);
        $customeField_res = $this->db->get_where('tblcustomer_selected_custom_field')->row();
        $data['customfield_data'] = $this->db->get_where('tblcustomfields', array('fieldto' => 'customers'))->result();
        if($customeField_res)
        {
            $data['customFields_result'] = explode(',', $customeField_res->custom_field_id);
            $data['requiredFields_result'] = explode(',', $customeField_res->custom_field_required);
        }
        else
        {
            $data['customFields_result'] = array();
            $data['requiredFields_result'] = array();
        }
        $this->load->view('admin/clients/custom_field', $data);
    }

    public function addField($id = '')
    {
        $this->load->model('custom_fields_model');
        if ($this->input->post()) {
            if ($id == '') {
                $id = $this->custom_fields_model->add($this->input->post());
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('custom_field')));
                    //redirect(admin_url('clients/addField/' . $id));
                    redirect(admin_url('clients/customFields'));
                }
            } else {
                $success = $this->custom_fields_model->update($this->input->post(), $id);
                if (is_array($success) && isset($success['cant_change_option_custom_field'])) {
                    set_alert('warning', _l('cf_option_in_use'));
                } elseif ($success === true) {
                    set_alert('success', _l('updated_successfully', _l('custom_field')));
                }
                //redirect(admin_url('clients/addField/' . $id));
                redirect(admin_url('clients/customFields'));
            }
        }
        
        $subheader_text = setupTitle_text('setup_menu_active', 'customers', 'custom_fields');
        $data['subheading_text'] = $subheader_text;
        $data['subtext_'] = $subheader_text;
        
        if ($id == '') {
            $title = _l('add_new', _l($subheader_text));
        } else {
            $data['custom_field'] = $this->custom_fields_model->get($id);
            $title                = _l('edit', _l($subheader_text));
        }
        $data['pdf_fields']             = $this->pdf_fields;
        $data['client_portal_fields']   = $this->client_portal_fields;
        $data['client_editable_fields'] = $this->client_editable_fields;
        $data['title']                  = $title;
        $this->load->view('admin/clients/addCustomField', $data);
    }

    /**
    * @function: fieldsOption
    */
    function fieldsOption()
    {
        $id = $_POST['ID'];
        $val = $_POST['field_val'];
        $data['active']= $val;
        $this->db->where('id', $id);
        $this->db->update('tblcustomfields', $data);
        echo 1;
        
    }

    public function groups()
    {
        if (!is_admin()) {
            access_denied('Customer Groups');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('customers_groups');
        }
        $data['title'] = _l('customer_groups');
        $this->load->view('admin/clients/groups_manage', $data);
    }

    public function group()
    {
        if (!is_admin() && get_option('staff_members_create_inline_customer_groups') == '0') {
            access_denied('Customer Groups');
        }

        if ($this->input->is_ajax_request()) {
            $data = $this->input->post();
            if ($data['id'] == '') {
                $id      = $this->clients_model->add_group($data);
                $message = $id ? _l('added_successfully', _l('customer_group')) : '';
                echo json_encode([
                    'success' => $id ? true : false,
                    'message' => $message,
                    'id'      => $id,
                    'name'    => $data['name'],
                ]);
            } else {
                $success = $this->clients_model->edit_group($data);
                $message = '';
                if ($success == true) {
                    $message = _l('updated_successfully', _l('customer_group'));
                }
                echo json_encode([
                    'success' => $success,
                    'message' => $message,
                ]);
            }
        }
    }

    public function delete_group($id)
    {
        if (!is_admin()) {
            access_denied('Delete Customer Group');
        }
        if (!$id) {
            redirect(admin_url('clients/groups'));
        }
        $response = $this->clients_model->delete_group($id);
        if ($response == true) {
            set_alert('success', _l('deleted', _l('customer_group')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('customer_group_lowercase')));
        }
        redirect(admin_url('clients/groups'));
    }

    public function bulk_action()
    {
        hooks()->do_action('before_do_bulk_action_for_customers');
        $total_deleted = 0;
        if ($this->input->post()) {
            $ids    = $this->input->post('ids');
            $groups = $this->input->post('groups');

            if (is_array($ids)) {
                foreach ($ids as $id) {
                    if ($this->input->post('mass_delete')) {
                        if ($this->clients_model->delete($id)) {
                            $total_deleted++;
                        }
                    } else {
                        if (!is_array($groups)) {
                            $groups = false;
                        }
                        $this->client_groups_model->sync_customer_groups($id, $groups);
                    }
                }
            }
        }

        if ($this->input->post('mass_delete')) {
            set_alert('success', _l('total_clients_deleted', $total_deleted));
        }
    }

    public function changeStudentSection(){
        $data = $this->input->post();
        $this->db->where('userid',$data['sid']);
        $this->db->update(db_prefix().'contacts'.$this->contact_tbl,array('payment_status'=>$data['section']));
        return true;
    }

    public function vault_entry_create($customer_id)
    {
        $data = $this->input->post();

        if (isset($data['fakeusernameremembered'])) {
            unset($data['fakeusernameremembered']);
        }

        if (isset($data['fakepasswordremembered'])) {
            unset($data['fakepasswordremembered']);
        }

        unset($data['id']);
        $data['creator']      = get_staff_user_id();
        $data['creator_name'] = get_staff_full_name($data['creator']);
        $data['description']  = nl2br($data['description']);
        $data['password']     = $this->encryption->encrypt($this->input->post('password', false));

        if (empty($data['port'])) {
            unset($data['port']);
        }

        $this->clients_model->vault_entry_create($data, $customer_id);
        set_alert('success', _l('added_successfully', _l('vault_entry')));
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function vault_entry_update($entry_id)
    {
        $entry = $this->clients_model->get_vault_entry($entry_id);

        if ($entry->creator == get_staff_user_id() || is_admin()) {
            $data = $this->input->post();

            if (isset($data['fakeusernameremembered'])) {
                unset($data['fakeusernameremembered']);
            }
            if (isset($data['fakepasswordremembered'])) {
                unset($data['fakepasswordremembered']);
            }

            $data['last_updated_from'] = get_staff_full_name(get_staff_user_id());
            $data['description']       = nl2br($data['description']);

            if (!empty($data['password'])) {
                $data['password'] = $this->encryption->encrypt($this->input->post('password', false));
            } else {
                unset($data['password']);
            }

            if (empty($data['port'])) {
                unset($data['port']);
            }

            $this->clients_model->vault_entry_update($entry_id, $data);
            set_alert('success', _l('updated_successfully', _l('vault_entry')));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function vault_entry_delete($id)
    {
        $entry = $this->clients_model->get_vault_entry($id);
        if ($entry->creator == get_staff_user_id() || is_admin()) {
            $this->clients_model->vault_entry_delete($id);
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function vault_encrypt_password()
    {
        $id            = $this->input->post('id');
        $user_password = $this->input->post('user_password', false);
        $user          = $this->staff_model->get(get_staff_user_id());

        if (!app_hasher()->CheckPassword($user_password, $user->password)) {
            header('HTTP/1.1 401 Unauthorized');
            echo json_encode(['error_msg' => _l('vault_password_user_not_correct')]);
            die;
        }

        $vault    = $this->clients_model->get_vault_entry($id);
        $password = $this->encryption->decrypt($vault->password);

        $password = html_escape($password);

        // Failed to decrypt
        if (!$password) {
            header($_SERVER['SERVER_PROTOCOL'] . ' 400 Bad error');
            echo json_encode(['error_msg' => _l('failed_to_decrypt_password')]);
            die;
        }

        echo json_encode(['password' => $password]);
    }

    public function get_vault_entry($id)
    {
        $entry = $this->clients_model->get_vault_entry($id);
        unset($entry->password);
        $entry->description = clear_textarea_breaks($entry->description);
        echo json_encode($entry);
    }

    public function statement_pdf()
    {
        $customer_id = $this->input->get('customer_id');

        if (!has_permission('invoices', '', 'view') && !has_permission('payments', '', 'view')) {
            set_alert('danger', _l('access_denied'));
            redirect(admin_url('clients/client/' . $customer_id));
        }

        $from = $this->input->get('from');
        $to   = $this->input->get('to');

        $data['statement'] = $this->clients_model->get_statement($customer_id, to_sql_date($from), to_sql_date($to));

        try {
            $pdf = statement_pdf($data['statement']);
        } catch (Exception $e) {
            $message = $e->getMessage();
            echo $message;
            if (strpos($message, 'Unable to get the size of the image') !== false) {
                show_pdf_unable_to_get_image_size_error();
            }
            die;
        }

        $type = 'D';
        if ($this->input->get('print')) {
            $type = 'I';
        }

        $pdf->Output(slug_it(_l('customer_statement') . '-' . $data['statement']['client']->company) . '.pdf', $type);
    }

    public function send_statement()
    {
        $customer_id = $this->input->get('customer_id');

        if (!has_permission('invoices', '', 'view') && !has_permission('payments', '', 'view')) {
            set_alert('danger', _l('access_denied'));
            redirect(admin_url('clients/client/' . $customer_id));
        }

        $from = $this->input->get('from');
        $to   = $this->input->get('to');

        $send_to = $this->input->post('send_to');
        $cc      = $this->input->post('cc');

        $success = $this->clients_model->send_statement_to_email($customer_id, $send_to, $from, $to, $cc);
        // In case client use another language
        load_admin_language();
        if ($success) {
            set_alert('success', _l('statement_sent_to_client_success'));
        } else {
            set_alert('danger', _l('statement_sent_to_client_fail'));
        }

        redirect(admin_url('clients/client/' . $customer_id . '?group=statement'));
    }

    public function statement()
    {
        if (!has_permission('invoices', '', 'view') && !has_permission('payments', '', 'view')) {
            header($_SERVER['SERVER_PROTOCOL'] . ' 400 Bad error');
            echo _l('access_denied');
            die;
        }

        $customer_id = $this->input->get('customer_id');
        $from        = $this->input->get('from');
        $to          = $this->input->get('to');

        $data['statement'] = $this->clients_model->get_statement($customer_id, to_sql_date($from), to_sql_date($to));

        $data['from'] = $from;
        $data['to']   = $to;

        $viewData['html'] = $this->load->view('admin/clients/groups/_statement', $data, true);

        echo json_encode($viewData);
    }
    function insertPackageRefundableMoring_(){
      $res =   $this->db->query("SELECT *  FROM `tblmastersheet` WHERE `Scheme` LIKE 'Refundable ' AND `Shift` = 'Morning' AND `userid`!=0")->result();
      
      foreach($res as $rrr){
          $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = '10';
                $tblstudent_package['userid']  = $rrr->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;
                $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				$tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				$tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
				$this->db->insert('tblstudent_package',$tblstudent_package);
      }
    }
    
    function insertPackageRefundableAfternoon_(){
      $res =   $this->db->query("SELECT * FROM `tblmastersheet` WHERE `Scheme` LIKE 'Refundable ' AND `Shift` = 'Afternoon' AND `userid`!=0")->result();
      
      foreach($res as $rrr){
          $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = '9';
                $tblstudent_package['userid']  = $rrr->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;
                $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				$tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				$tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
				$this->db->insert('tblstudent_package',$tblstudent_package);
      }
    }
    
     function insertPackageAnnual_newMoring_(){
      $res =   $this->db->query("SELECT * FROM `tblmastersheet` WHERE `Scheme` LIKE 'Annual Scheme' AND `Shift` = 'Morning' AND `userid`!=0 AND `Fees_Status_2020_21`='New'")->result();
      
      foreach($res as $rrr){
          $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = '11';
                $tblstudent_package['userid']  = $rrr->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;
                $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				$tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				$tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
				$this->db->insert('tblstudent_package',$tblstudent_package);
      }
    }
    
    
    
     function insertPackageAnnual_newAfternoon(){
      $res =   $this->db->query("SELECT *  FROM `tblmastersheet` WHERE `Scheme` LIKE 'Annual Scheme' AND `Shift` = 'Afternoon' AND `userid`!=0 AND `Fees_Status_2020_21`='New'")->result();
      
      foreach($res as $rrr){
          $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = '14';
                $tblstudent_package['userid']  = $rrr->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;
                $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				$tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				$tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
				$this->db->insert('tblstudent_package',$tblstudent_package);
      }
    }
    
    function insertPackageHigherClassMorning_(){
      $res =   $this->db->query("SELECT * FROM `tblmastersheet` WHERE `Scheme` LIKE 'Higher Classes Package' AND `Shift` = 'Morning' AND `userid`!=0")->result();
      
      foreach($res as $rrr){
          $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = '8';
                $tblstudent_package['userid']  = $rrr->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;
                $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				$tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				$tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
				$this->db->insert('tblstudent_package',$tblstudent_package);
      }
    }
     function insertPackageHigherClassAfternoon_(){
      $res =   $this->db->query("SELECT * FROM `tblmastersheet` WHERE `Scheme` LIKE 'Higher Classes Package' AND `Shift` = 'Afternoon' AND `userid`!=0")->result();
      
      foreach($res as $rrr){
          $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = '7';
                $tblstudent_package['userid']  = $rrr->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;
                $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				$tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				$tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
				$this->db->insert('tblstudent_package',$tblstudent_package);
      }
    }
    
    function insertPackageAnnualExtingMoring_(){
      $res =   $this->db->query("SELECT * FROM `tblmastersheet` WHERE `Scheme` LIKE 'Annual Scheme' AND `Shift` = 'Morning' AND `userid`!=0 AND `Fees_Status_2020_21`='Existing'")->result();
      
      foreach($res as $rrr){
          $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = '12';
                $tblstudent_package['userid']  = $rrr->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;
                $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				$tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				$tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
				$this->db->insert('tblstudent_package',$tblstudent_package);
      }
    }
    
    function insertPackageAnnualExtingAfterNoon_(){
      $res =   $this->db->query("SELECT * FROM `tblmastersheet` WHERE `Scheme` LIKE 'Annual Scheme' AND `Shift` = 'Afternoon' AND `userid`!=0 AND `Fees_Status_2020_21`='Existing'")->result();
      
      foreach($res as $rrr){
          $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = '13';
                $tblstudent_package['userid']  = $rrr->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;
                $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				$tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				$tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
				$this->db->insert('tblstudent_package',$tblstudent_package);
      }
    }
    
    function insertPackageNonRefundableAfterNoon_(){
      $res =   $this->db->query("SELECT * FROM `tblmastersheet` WHERE `Scheme` LIKE 'Non-Refundable ' AND `Shift` = 'Afternoon' AND `userid`!=0")->result();
      
      foreach($res as $rrr){
          $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = '1';
                $tblstudent_package['userid']  = $rrr->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;
                $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				$tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				$tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
				$this->db->insert('tblstudent_package',$tblstudent_package);
      }
    }
    
    function insertPackageNonRefundableMorning_(){
      $res =   $this->db->query("SELECT * FROM `tblmastersheet` WHERE `Scheme` LIKE 'Non-Refundable ' AND `Shift` = 'Morning' AND `userid`!=0")->result();
      
      foreach($res as $rrr){
          $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = '2';
                $tblstudent_package['userid']  = $rrr->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;
                $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				$tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				$tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
				$this->db->insert('tblstudent_package',$tblstudent_package);
      }
    }
    
    
    function insertPackagePrePrimaryAfternoon_(){
      $res =   $this->db->query("SELECT * FROM `tblmastersheet` WHERE `Scheme` LIKE 'Pre-Primary Classes Package' AND `Shift` = 'Afternoon' AND `userid`!=0")->result();
      
      foreach($res as $rrr){
          $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = '3';
                $tblstudent_package['userid']  = $rrr->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;
                $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				$tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				$tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
				$this->db->insert('tblstudent_package',$tblstudent_package);
      }
    }
    
    function insertPackagePrePrimaryMorning_(){
      $res =   $this->db->query("SELECT * FROM `tblmastersheet` WHERE `Scheme` LIKE 'Pre-Primary Classes Package' AND `Shift` = 'Morning' AND `userid`!=0")->result();
      
      foreach($res as $rrr){
          $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = '4';
                $tblstudent_package['userid']  = $rrr->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;
                $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				$tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				$tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
				$this->db->insert('tblstudent_package',$tblstudent_package);
      }
    }
    
     function insertPackagePrimaryMorning_(){
      $res =   $this->db->query("SELECT * FROM `tblmastersheet` WHERE `Scheme` LIKE 'Primary Classes Package' AND `Shift` = 'Morning' AND `userid`!=0")->result();
      
      foreach($res as $rrr){
          $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = '6';
                $tblstudent_package['userid']  = $rrr->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;
                $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				$tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				$tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
				$this->db->insert('tblstudent_package',$tblstudent_package);
      }
    }
    
     function insertPackagePrimaryAfternoon_(){
      $res =   $this->db->query("SELECT * FROM `tblmastersheet` WHERE `Scheme` LIKE 'Primary Classes Package' AND `Shift` = 'Afternoon' AND `userid`!=0")->result();
      
      foreach($res as $rrr){
          $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = '5';
                $tblstudent_package['userid']  = $rrr->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;
                $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				$tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				$tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
				$this->db->insert('tblstudent_package',$tblstudent_package);
      }
    }
    
      function insertPackageRTE_(){
      $res =   $this->db->query("SELECT * FROM `tblmastersheet` WHERE `Scheme` LIKE 'RTE'  AND `userid`!=0")->result();
      
      foreach($res as $rrr){
          $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = '15';
                $tblstudent_package['userid']  = $rrr->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;
                $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				$tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				$tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
				$this->db->insert('tblstudent_package',$tblstudent_package);
      }
    }
    
    

    
    
    public function feesPaidStudent_v1__()
    {
        //ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL); 
        $totalStudent = $this->db->get_where(db_prefix().'mastersheet')->result();
    
        $response = [];
        $responseNomatch = [];
        foreach($totalStudent as $rrr)
        {
   /*     
Annual Scheme Afternoon 1467

Annual Scheme Morning 1343

Higher Classes Package Afternoon 14

Higher Classes Package Morning 14

Non-Refundable Afternoon 192

Non-Refundable Morning 52

Pre-Primary Classes Package Afternoon 3

Pre-Primary Classes Package Morning 5

Primary Classes Package Afternoon 7

Primary Classes Package Morning 9

Refundable Afternoon 199

Refundable Morning 95

RTE Afternoon 40

RTE Morning 11

*/
		    if($rrr->Scheme == 'Non-Refundable ' &&  $rrr->Shift =='Afternoon') {
				$package_id =  1;
				//200000

			}
			else if($rrr->Scheme == 'Non-Refundable ' &&  $rrr->Shift =='Morning') {
				$package_id =  2;
				//300000
			}
			else if($rrr->Scheme == 'Pre-Primary Classes Package' &&  $rrr->Shift =='Afternoon') {
				$package_id = 3;
				//80000
			}
			else if($rrr->Scheme == 'Pre-Primary Classes Package' &&  $rrr->Shift =='Morning') {
				$package_id = 4;
				//100000
			}
				else if($rrr->Scheme == 'Primary Classes Package' &&  $rrr->Shift =='Afternoon') {
				$package_id = 5;
				//80000
			}
			else if($rrr->Scheme == 'Primary Classes Package' &&  $rrr->Shift =='Morning') {
				$package_id = 6;
				//100000
			}
            else if($rrr->Scheme == 'Higher Classes Package' &&  $rrr->Shift =='Afternoon') {
				$package_id =  7;
			}
			else if($rrr->Scheme == 'Higher Classes Package' &&  $rrr->Shift =='Morning') {
				$package_id =  8;
			}
			else  if($rrr->Scheme == 'Refundable ' &&  $rrr->Shift =='Afternoon') {
				$package_id = 9;
				//400000
			}
			else if($rrr->Scheme == 'Refundable ' &&  $rrr->Shift =='Morning') {
				$package_id = 10;
				//500000
			}
			else if($rrr->Scheme == 'Annual Scheme' &&  $rrr->Fees_Status_2020_21 =='New' &&  $rrr->Shift =='Afternoon') {
				$package_id = 11;
				//500000
			}
			else if($rrr->Scheme == 'Annual Scheme' &&  $rrr->Fees_Status_2020_21 =='New' &&  $rrr->Shift =='Morning') {
				$package_id = 14;
				//500000
			}
			else if($rrr->Scheme == 'Annual Scheme' &&  $rrr->Shift =='Afternoon'){
				$package_id = 12;
			}else if($rrr->Scheme == 'Annual Scheme' &&  $rrr->Shift =='Morning'){
				$package_id = 13;
			}
			else if($rrr->Scheme == 'RTE') {
				$package_id = 15;
			}
			 
			
		
			
/*echo $rrr->Scheme ;
echo '<br>';
echo $package_id;*/

            $sid = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Fathers_Name,'Father_Mobile' => $rrr->Fathers_Mobile))->row();
            if($sid)
            {
                array_push($response, $sid->userid);
                //echo $sid->userid.'<br>';
                $tblstudent_fees_deposit['package_id']  = $package_id;
                $tblstudent_fees_deposit['userid']  = $sid->userid;
                $tblstudent_fees_deposit['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_fees_deposit['installment']  = 1;
                $tblstudent_fees_deposit['note']  = $rrr->Remark;
				
                $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = $package_id;
                $tblstudent_package['userid']  = $sid->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;
                $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				$tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				$tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
				$this->db->insert('tblstudent_package',$tblstudent_package);
				
				$this->db->where('id',$rrr->id);
				$this->db->update('tblmastersheet',array('userid'=>$sid->userid));
		 		//$this->db->insert('tblstudent_fees_deposit',$tblstudent_fees_deposit);
            }
            else
            {
                  $sid2 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Fathers_Name,'Mother_Mobile' => $rrr->Mothers_Mobile))->row();
                   
                    if($sid2)
                    {
                     //   array_push($response, $sid2->userid);
                        //echo $sid->userid.'<br>';
                        $tblstudent_fees_deposit['package_id']  = $package_id;
                        $tblstudent_fees_deposit['userid']  = $sid2->userid;
                        $tblstudent_fees_deposit['deposit_amount']  = $rrr->Fees_Received;
                        $tblstudent_fees_deposit['installment']  = 1;
                        $tblstudent_fees_deposit['note']  = $rrr->Remark;
        				
                        $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
        				$tblstudent_package['package_id']  = $package_id;
                        $tblstudent_package['userid']  = $sid2->userid;
                        $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                        $tblstudent_package['status']  = 1;
                        $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				        $tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				        $tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
        				
        				
				
				
        				$this->db->insert('tblstudent_package',$tblstudent_package);
        				
        					$this->db->where('id',$rrr->id);
				$this->db->update('tblmastersheet',array('userid'=>$sid2->userid));
        			 //	$this->db->insert('tblstudent_fees_deposit',$tblstudent_fees_deposit);
                    }else{
                        
                         $sid3 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Fathers_Name,'Mother_Name' => $rrr->Mothers_Name))->row();
                    
                            if($sid3)
                            {
                           //     array_push($response, $sid3->userid);
                                //echo $sid->userid.'<br>';
                                $tblstudent_fees_deposit['package_id']  = $package_id;
                                $tblstudent_fees_deposit['userid']  = $sid3->userid;
                                $tblstudent_fees_deposit['deposit_amount']  = $rrr->Fees_Received;
                                $tblstudent_fees_deposit['installment']  = 1;
                                $tblstudent_fees_deposit['note']  = $rrr->Remark;
                				
                                $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
                				$tblstudent_package['package_id']  = $package_id;
                                $tblstudent_package['userid']  = $sid3->userid;
                                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                                $tblstudent_package['status']  = 1;
                				$tblstudent_package['admission_year']  = $rrr->Admission_Year;
				                $tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				                $tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
                				 
                				$this->db->insert('tblstudent_package',$tblstudent_package);
                				
                					$this->db->where('id',$rrr->id);
				$this->db->update('tblmastersheet',array('userid'=>$sid3->userid));
                			 	//$this->db->insert('tblstudent_fees_deposit',$tblstudent_fees_deposit);
                            }else{
                                $sid4 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Fathers_Name))->row();
                    
                                if($sid4)
                                {
                               //     array_push($response, $sid3->userid);
                                    //echo $sid->userid.'<br>';
                                    $tblstudent_fees_deposit['package_id']  = $package_id;
                                    $tblstudent_fees_deposit['userid']  = $sid4->userid;
                                    $tblstudent_fees_deposit['deposit_amount']  = $rrr->Fees_Received;
                                    $tblstudent_fees_deposit['installment']  = 1;
                                    $tblstudent_fees_deposit['note']  = $rrr->Remark;
                    				
                                    $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
                    				$tblstudent_package['package_id']  = $package_id;
                                    $tblstudent_package['userid']  = $sid4->userid;
                                    $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                                    $tblstudent_package['status']  = 1;
                                    $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				                    $tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				                    $tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
                    				
                    				$this->db->insert('tblstudent_package',$tblstudent_package);
                    				
                    					$this->db->where('id',$rrr->id);
				$this->db->update('tblmastersheet',array('userid'=>$sid4->userid));
                    			 	//$this->db->insert('tblstudent_fees_deposit',$tblstudent_fees_deposit);
                                }else{
                                     $sid5 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Mother_Name' => $rrr->Mothers_Name))->row();
                    
                                        if($sid5)
                                        {
                                       //     array_push($response, $sid3->userid);
                                            //echo $sid->userid.'<br>';
                                            $tblstudent_fees_deposit['package_id']  = $package_id;
                                            $tblstudent_fees_deposit['userid']  = $sid5->userid;
                                            $tblstudent_fees_deposit['deposit_amount']  = $rrr->Fees_Received;
                                            $tblstudent_fees_deposit['installment']  = 1;
                                            $tblstudent_fees_deposit['note']  = $rrr->Remark;
                            				
                                            $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
                            				$tblstudent_package['package_id']  = $package_id;
                                            $tblstudent_package['userid']  = $sid5->userid;
                                            $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                                            $tblstudent_package['status']  = 1;
                                            $tblstudent_package['admission_year']  = $rrr->Admission_Year;
				                            $tblstudent_package['admission_date']  = date('Y-m-d',strtotime($rrr->Date_of_Admission));
				                            $tblstudent_package['yearly_amount'] = $rrr->Amount_2020_21;
                            				
                            				$this->db->insert('tblstudent_package',$tblstudent_package);
                            				
                            					$this->db->where('id',$rrr->id);
				$this->db->update('tblmastersheet',array('userid'=>$sid5->userid));
                            			 	//$this->db->insert('tblstudent_fees_deposit',$tblstudent_fees_deposit);
                                        }else{
                                             array_push($responseNomatch, $rrr->Fathers_Mobile);
                                        }
                                }
                            }
                    }
               
            }
        }
        
        print_r($responseNomatch);
     
    }
    
    
    
    
    public function feesPaidStudentDayWise__()
    {
         $totalStudent = $this->db->get_where(db_prefix().'day_booking')->result();
    
        $response = [];
        $responseNomatch = [];
        foreach($totalStudent as $rrr)
        {
        
        /*Higher Classes (N/R)-Afternoon
Higher Classes (N/R)-Morning
Non Refundable - Afternoon
Non Refundable - Morning
Non-Refundable

Normal - Afternoon
Normal - Morning

Pre-Primary Classes (N/R)-Afternoon
Pre-Primary Classes (N/R)-Morning
Primary Classes (N/R)-Afternoon
Primary Classes (N/R)-Morning
Refundable - Afternoon
Refundable - Morning*/
		 
			if($rrr->SCHEME == 'Non Refundable - Afternoon'){
				$package_id = 1;
				$ammount = '200000';
			}else if($rrr->SCHEME == 'Non Refundable - Morning') {
				$package_id =  2;
					$ammount = '300000';
			}
			else if($rrr->SCHEME == 'Pre-Primary Classes (N/R)-Afternoon') {
				$package_id = 3;
					$ammount = '80000';
			}
			
			else if($rrr->SCHEME == 'Pre-Primary Classes (N/R)-Morning') {
				$package_id = 4;
					$ammount = '100000';
			}
			else if($rrr->SCHEME == 'Primary Classes (N/R)-Afternoon') {
				$package_id = 5;
					$ammount = '100000';
			}
			else if($rrr->SCHEME == 'Primary Classes (N/R)-Morning') {
				$package_id = 6;
				$ammount = '125000';
			}
			else if($rrr->SCHEME == 'Higher Classes (N/R)-Afternoon') {
				$package_id = 7;
				$ammount = '140000';
					
			}
			else if($rrr->SCHEME == 'Higher Classes (N/R)-Morning') {
				$package_id =  8;
				$ammount = '175000';
			}
			else if($rrr->SCHEME == 'Refundable - Afternoon') {
				$package_id = 9;
				$ammount = '400000';
			}
			else if($rrr->SCHEME == 'Refundable - Morning') {
				$package_id = 10;
				$ammount = '500000';
			}
		
			else if($rrr->SCHEME == 'Normal - Afternoon') {
				$package_id = 12;
				$ammount = '29000';
			}
			
			else if($rrr->SCHEME == 'Normal - Morning') {
				$package_id = 13;
				$ammount = '35000';
			}
			else if($rrr->SCHEME == 'Non-Refundable ') {
				$package_id = 14;
				$ammount = '300000';
			}
			
			
		
			 
/*echo $rrr->Scheme ;
echo '<br>';
echo $package_id;*/

            $sid = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name,'Father_Mobile' => $rrr->Father_Mobile))->row();
            if($sid)
            {
                array_push($response, $sid->userid);
                //echo $sid->userid.'<br>';
                $tblstudent_fees_deposit['package_id']      = $package_id;
                $tblstudent_fees_deposit['userid']          = $sid->userid;
                $tblstudent_fees_deposit['deposit_amount']  = $rrr->Pay_Amount_Admission_Fee_Paid;
                $tblstudent_fees_deposit['installment']     = 1;
                $tblstudent_fees_deposit['note']            = $rrr->Payment_Detail;
                $tblstudent_fees_deposit['payment_mode']    = $rrr->Payment_Mode;
                $tblstudent_fees_deposit['deposit_date']    = date('Y-m-d', strtotime($rrr->date));
                  
                 
                /* $this->db->where('userid',$sid->userid);
                 $this->db->update('tblstudent_package',array('package_id'=>$package_id,'package_amount'=>$ammount));*/
                 
                 $deposit_amount =  $this->db->get_where('tblstudent_package',array('userid'=>$sid1->userid))->row('deposit_amount');
                        
                        if($deposit_amount!=''){
                            $deposit_amount += $rrr->Pay_Amount_Admission_Fee_Paid;
                            $this->db->where('userid',$sid1->userid);
                            $this->db->update('tblstudent_package',array('package_id'=>$package_id,'package_amount'=>$ammount,'deposit_amount'=>$deposit_amount));
                            
                        }else{
                           
                            $this->db->insert('tblstudent_package',array('package_id'=>$package_id,'package_amount'=>$ammount,'deposit_amount'=>$rrr->Pay_Amount_Admission_Fee_Paid,'userid'=>$sid1->userid));
                        }
        				
        				
                
				
              /*  $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
				$tblstudent_package['package_id']  = $package_id;
                $tblstudent_package['userid']  = $sid->userid;
                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                $tblstudent_package['status']  = 1;*/
				
			//	$this->db->insert('tblstudent_package',$tblstudent_package);
		 		$this->db->insert('tblstudent_fees_deposit',$tblstudent_fees_deposit);
            }
            else
            {
                  $sid2 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name,'Mother_Mobile' => $rrr->Mother_Mobile))->row();
                   
                    if($sid2)
                    {
                     //   array_push($response, $sid2->userid);
                        //echo $sid->userid.'<br>';
                        $tblstudent_fees_deposit['package_id']  = $package_id;
                        $tblstudent_fees_deposit['userid']  = $sid2->userid;
                        $tblstudent_fees_deposit['deposit_amount']  = $rrr->Pay_Amount_Admission_Fee_Paid;
                        $tblstudent_fees_deposit['installment']     = 1;
                        $tblstudent_fees_deposit['note']            = $rrr->Payment_Detail;
                        $tblstudent_fees_deposit['payment_mode']    = $rrr->Payment_Mode;
                         $tblstudent_fees_deposit['deposit_date']    = date('Y-m-d', strtotime($rrr->date));
                         
                           /* $this->db->where('userid',$sid2->userid);
                            $this->db->update('tblstudent_package',array('package_id'=>$package_id,'package_amount'=>$ammount));*/
                         
                        $deposit_amount =  $this->db->get_where('tblstudent_package',array('userid'=>$sid2->userid))->row('deposit_amount');
                        
                        if($deposit_amount!=''){
                            $deposit_amount += $rrr->Pay_Amount_Admission_Fee_Paid;
                            $this->db->where('userid',$sid2->userid);
                            $this->db->update('tblstudent_package',array('package_id'=>$package_id,'package_amount'=>$ammount,'deposit_amount'=>$deposit_amount));
                            
                        }else{
                           
                            $this->db->insert('tblstudent_package',array('package_id'=>$package_id,'package_amount'=>$ammount,'deposit_amount'=>$rrr->Pay_Amount_Admission_Fee_Paid,'userid'=>$sid2->userid));
                        }
        				
                      /*  $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
        				$tblstudent_package['package_id']  = $package_id;
                        $tblstudent_package['userid']  = $sid2->userid;
                        $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                        $tblstudent_package['status']  = 1;*/
        				
        			//	$this->db->insert('tblstudent_package',$tblstudent_package);
        			 	$this->db->insert('tblstudent_fees_deposit',$tblstudent_fees_deposit);
                    }else{
                        
                         $sid3 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name,'Mother_Name' => $rrr->Mother_Name))->row();
                    
                            if($sid3)
                            {
                           //     array_push($response, $sid3->userid);
                                //echo $sid->userid.'<br>';
                                $tblstudent_fees_deposit['package_id']  = $package_id;
                                $tblstudent_fees_deposit['userid']  = $sid3->userid;
                                $tblstudent_fees_deposit['deposit_amount']  = $rrr->Pay_Amount_Admission_Fee_Paid;
                                $tblstudent_fees_deposit['installment']     = 1;
                                $tblstudent_fees_deposit['note']            = $rrr->Payment_Detail;
                                $tblstudent_fees_deposit['payment_mode']    = $rrr->Payment_Mode;
                                $tblstudent_fees_deposit['deposit_date']    = date('Y-m-d', strtotime($rrr->date));
                                
                                
                                /*
                                $this->db->where('userid',$sid3->userid);
                                $this->db->update('tblstudent_package',array('package_id'=>$package_id,'package_amount'=>$ammount));
                         */
                                
                                 $deposit_amount =  $this->db->get_where('tblstudent_package',array('userid'=>$sid3->userid))->row('deposit_amount');
                        
                                if($deposit_amount!=''){
                                    $deposit_amount += $rrr->Pay_Amount_Admission_Fee_Paid;
                                    $this->db->where('userid',$sid3->userid);
                                    $this->db->update('tblstudent_package',array('package_id'=>$package_id,'package_amount'=>$ammount,'deposit_amount'=>$deposit_amount));
                                    
                                }else{
                                   
                                    $this->db->insert('tblstudent_package',array('package_id'=>$package_id,'package_amount'=>$ammount,'deposit_amount'=>$rrr->Pay_Amount_Admission_Fee_Paid,'userid'=>$sid3->userid));
                                }
                                
                        
                             /*   $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
                				$tblstudent_package['package_id']  = $package_id;
                                $tblstudent_package['userid']  = $sid3->userid;
                                $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                                $tblstudent_package['status']  = 1;*/
                				
                			//	$this->db->insert('tblstudent_package',$tblstudent_package);
                			 	$this->db->insert('tblstudent_fees_deposit',$tblstudent_fees_deposit);
                            }else{
                                $sid4 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name))->row();
                    
                                if($sid4)
                                {
                               //     array_push($response, $sid3->userid);
                                    //echo $sid->userid.'<br>';
                                    $tblstudent_fees_deposit['package_id']  = $package_id;
                                    $tblstudent_fees_deposit['userid']  = $sid4->userid;
                                    $tblstudent_fees_deposit['deposit_amount']  = $rrr->Pay_Amount_Admission_Fee_Paid;
                                    $tblstudent_fees_deposit['installment']     = 1;
                                    $tblstudent_fees_deposit['note']            = $rrr->Payment_Detail;
                                    $tblstudent_fees_deposit['payment_mode']    = $rrr->Payment_Mode;
                                    $tblstudent_fees_deposit['deposit_date']    = date('Y-m-d', strtotime($rrr->date));
                                    
                                    
                                    
                                    /*$this->db->where('userid',$sid4->userid);
                                    $this->db->update('tblstudent_package',array('package_id'=>$package_id,'package_amount'=>$ammount));*/
                                    
                                     $deposit_amount =  $this->db->get_where('tblstudent_package',array('userid'=>$sid4->userid))->row('deposit_amount');
                        
                                if($deposit_amount!=''){
                                    $deposit_amount += $rrr->Pay_Amount_Admission_Fee_Paid;
                                    $this->db->where('userid',$sid4->userid);
                                    $this->db->update('tblstudent_package',array('package_id'=>$package_id,'package_amount'=>$ammount,'deposit_amount'=>$deposit_amount));
                                    
                                }else{
                                   
                                    $this->db->insert('tblstudent_package',array('package_id'=>$package_id,'package_amount'=>$ammount,'deposit_amount'=>$rrr->Pay_Amount_Admission_Fee_Paid,'userid'=>$sid4->userid));
                                }
                                
                         
                    				
                                 /*   $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
                    				$tblstudent_package['package_id']  = $package_id;
                                    $tblstudent_package['userid']  = $sid4->userid;
                                    $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                                    $tblstudent_package['status']  = 1;*/
                    				
                    				//$this->db->insert('tblstudent_package',$tblstudent_package);
                    			 	$this->db->insert('tblstudent_fees_deposit',$tblstudent_fees_deposit);
                                }else{
                                     $sid5 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Mother_Name' => $rrr->Mother_Name))->row();
                    
                                        if($sid5)
                                        {
                                       //     array_push($response, $sid3->userid);
                                            //echo $sid->userid.'<br>';
                                            $tblstudent_fees_deposit['package_id']  = $package_id;
                                            $tblstudent_fees_deposit['userid']  = $sid5->userid;
                                            $tblstudent_fees_deposit['deposit_amount']  = $rrr->Pay_Amount_Admission_Fee_Paid;
                                            $tblstudent_fees_deposit['installment']     = 1;
                                            $tblstudent_fees_deposit['note']            = $rrr->Payment_Detail;
                                            $tblstudent_fees_deposit['payment_mode']    = $rrr->Payment_Mode;
                                            $tblstudent_fees_deposit['deposit_date']    = date('Y-m-d', strtotime($rrr->date));
                                            
                                        /*    $this->db->where('userid',$sid5->userid);
                                            $this->db->update('tblstudent_package',array('package_id'=>$package_id,'package_amount'=>$ammount));*/
                                            
                                            
                                             $deposit_amount =  $this->db->get_where('tblstudent_package',array('userid'=>$sid5->userid))->row('deposit_amount');
                        
                                if($deposit_amount!=''){
                                    $deposit_amount += $rrr->Pay_Amount_Admission_Fee_Paid;
                                    $this->db->where('userid',$sid5->userid);
                                    $this->db->update('tblstudent_package',array('package_id'=>$package_id,'package_amount'=>$ammount,'deposit_amount'=>$deposit_amount));
                                    
                                }else{
                                   
                                    $this->db->insert('tblstudent_package',array('package_id'=>$package_id,'package_amount'=>$ammount,'deposit_amount'=>$rrr->Pay_Amount_Admission_Fee_Paid,'userid'=>$sid5->userid));
                                }
                                    
                            				
                                /*            $tblstudent_package['package_amount']  = $rrr->Actual_Amount;
                            				$tblstudent_package['package_id']  = $package_id;
                                            $tblstudent_package['userid']  = $sid5->userid;
                                            $tblstudent_package['deposit_amount']  = $rrr->Fees_Received;
                                            $tblstudent_package['status']  = 1;*/
                            				
                            			//	$this->db->insert('tblstudent_package',$tblstudent_package);
                            			 	$this->db->insert('tblstudent_fees_deposit',$tblstudent_fees_deposit);
                                        }else{
                                             array_push($responseNomatch, $rrr->Fathers_Mobile);
                                        }
                                }
                            }
                    }
               
            }
            
            
        }
        
        print_r($responseNomatch);
     
    }
    
    
    
    public function feesPaidStudentDayWiseAddNewFees_()
    {
         $totalStudent = $this->db->get_where(db_prefix().'day_booking')->result();
    
        $response = [];
        $responseNomatch = [];
        foreach($totalStudent as $rrr)
        {
        
            $sid = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name,'Father_Mobile' => $rrr->Father_Mobile))->row();
            if($sid)
            {
                $tblstudent_fees_deposit['package_id']      = $package_id;
                $tblstudent_fees_deposit['userid']          = $sid->userid;
                $tblstudent_fees_deposit['deposit_amount']  = $rrr->Pay_Amount_Admission_Fee_Paid;
                $tblstudent_fees_deposit['installment']     = 1;
                $tblstudent_fees_deposit['note']            = $rrr->Payment_Detail;
                $tblstudent_fees_deposit['payment_mode']    = $rrr->Payment_Mode;
                $tblstudent_fees_deposit['deposit_date']    = date('Y-m-d', strtotime($rrr->date));
                  
                  
		 		$this->db->insert('tblstudent_fees_deposit',$tblstudent_fees_deposit);
            }
            else
            {
                  $sid2 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name,'Mother_Mobile' => $rrr->Mother_Mobile))->row();
                   
                    if($sid2)
                    {
                     //   array_push($response, $sid2->userid);
                        //echo $sid->userid.'<br>';
                        $tblstudent_fees_deposit['package_id']  = $package_id;
                        $tblstudent_fees_deposit['userid']  = $sid2->userid;
                        $tblstudent_fees_deposit['deposit_amount']  = $rrr->Pay_Amount_Admission_Fee_Paid;
                        $tblstudent_fees_deposit['installment']     = 1;
                        $tblstudent_fees_deposit['note']            = $rrr->Payment_Detail;
                        $tblstudent_fees_deposit['payment_mode']    = $rrr->Payment_Mode;
                        $tblstudent_fees_deposit['deposit_date']    = date('Y-m-d', strtotime($rrr->date));
                            
        			 	$this->db->insert('tblstudent_fees_deposit',$tblstudent_fees_deposit);
                    }else{
                        
                         $sid3 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name,'Mother_Name' => $rrr->Mother_Name))->row();
                    
                            if($sid3)
                            {
                           //     array_push($response, $sid3->userid);
                                //echo $sid->userid.'<br>';
                                $tblstudent_fees_deposit['package_id']  = $package_id;
                                $tblstudent_fees_deposit['userid']  = $sid3->userid;
                                $tblstudent_fees_deposit['deposit_amount']  = $rrr->Pay_Amount_Admission_Fee_Paid;
                                $tblstudent_fees_deposit['installment']     = 1;
                                $tblstudent_fees_deposit['note']            = $rrr->Payment_Detail;
                                $tblstudent_fees_deposit['payment_mode']    = $rrr->Payment_Mode;
                                $tblstudent_fees_deposit['deposit_date']    = date('Y-m-d', strtotime($rrr->date));
                                
                       			
                			//	$this->db->insert('tblstudent_package',$tblstudent_package);
                			 	$this->db->insert('tblstudent_fees_deposit',$tblstudent_fees_deposit);
                            }else{
                                $sid4 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name))->row();
                    
                                if($sid4)
                                {
                               //     array_push($response, $sid3->userid);
                                    //echo $sid->userid.'<br>';
                                    $tblstudent_fees_deposit['package_id']  = $package_id;
                                    $tblstudent_fees_deposit['userid']  = $sid4->userid;
                                    $tblstudent_fees_deposit['deposit_amount']  = $rrr->Pay_Amount_Admission_Fee_Paid;
                                    $tblstudent_fees_deposit['installment']     = 1;
                                    $tblstudent_fees_deposit['note']            = $rrr->Payment_Detail;
                                    $tblstudent_fees_deposit['payment_mode']    = $rrr->Payment_Mode;
                                    $tblstudent_fees_deposit['deposit_date']    = date('Y-m-d', strtotime($rrr->date));
                                    
                         			
                    				//$this->db->insert('tblstudent_package',$tblstudent_package);
                    			 	$this->db->insert('tblstudent_fees_deposit',$tblstudent_fees_deposit);
                                }else{
                                     $sid5 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Mother_Name' => $rrr->Mother_Name))->row();
                    
                                        if($sid5)
                                        {
                                       //     array_push($response, $sid3->userid);
                                            //echo $sid->userid.'<br>';
                                            $tblstudent_fees_deposit['package_id']  = $package_id;
                                            $tblstudent_fees_deposit['userid']  = $sid5->userid;
                                            $tblstudent_fees_deposit['deposit_amount']  = $rrr->Pay_Amount_Admission_Fee_Paid;
                                            $tblstudent_fees_deposit['installment']     = 1;
                                            $tblstudent_fees_deposit['note']            = $rrr->Payment_Detail;
                                            $tblstudent_fees_deposit['payment_mode']    = $rrr->Payment_Mode;
                                            $tblstudent_fees_deposit['deposit_date']    = date('Y-m-d', strtotime($rrr->date));
                                            
                             				
                            			//	$this->db->insert('tblstudent_package',$tblstudent_package);
                            			 	$this->db->insert('tblstudent_fees_deposit',$tblstudent_fees_deposit);
                                        }else{
                                             array_push($responseNomatch, $rrr->Fathers_Mobile);
                                        }
                                }
                        }
                    }
               
            }
            
            
        }
        
        print_r($responseNomatch);
     
    }
    
    
     public function dayBookingUpdate()
    {
         $totalStudent = $this->db->get_where(db_prefix().'day_booking_v2')->result();
    
        $response = [];
        $responseNomatch = [];
        foreach($totalStudent as $rrr)
        {
        
            $sid = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name,'Father_Mobile' => $rrr->Father_Mobile))->row();
            if($sid)
            {
               $this->db->where('id',$rrr->id);
               $this->db->update('tblday_booking_v2',array('userid'=> $sid->userid));
            }
            else
            {
                  $sid2 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name,'Mother_Mobile' => $rrr->Mother_Mobile))->row();
                   
                    if($sid2)
                    {
                      
                        $this->db->where('id',$rrr->id);
                        $this->db->update('tblday_booking_v2',array('userid'=> $sid2->userid));
               
                    }else{
                        
                         $sid3 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name,'Mother_Name' => $rrr->Mother_Name))->row();
                    
                            if($sid3)
                            {
                                        
                                    $this->db->where('id',$rrr->id);
                                    $this->db->update('tblday_booking_v2',array('userid'=> $sid3->userid));
                            }else{
                                $sid4 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name))->row();
                    
                                if($sid4)
                                {
                                                    
                                        $this->db->where('id',$rrr->id);
                                        $this->db->update('tblday_booking_v2',array('userid'=> $sid4->userid));
                                }else{
                                     $sid5 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('firstname' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Mother_Name' => $rrr->Mother_Name))->row();
                    
                                        if($sid5)
                                        {
                                                                
                                            $this->db->where('id',$rrr->id);
                                            $this->db->update('tblday_booking_v2',array('userid'=> $sid5->userid));
                                        }else{
                                             array_push($responseNomatch, $rrr->Fathers_Mobile);
                                        }
                                }
                        }
                    }
               
            }
            
            
        }
        
        print_r($responseNomatch);
     
    }
    
    
     public function dayBookingUpdateDeletedUpdate_()
    {
         $totalStudent = $this->db->get_where(db_prefix().'day_booking_v2')->result();
    
        $response = [];
        $responseNomatch = [];
        foreach($totalStudent as $rrr)
        {
        
            $sid = $this->db->get_where(db_prefix().'_tc_withdral_academic', array('First_Name' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name,'Father_Mobile' => $rrr->Father_Mobile))->row();
            if($sid)
            {
               $this->db->where('id',$rrr->id);
               $this->db->update('tblday_booking_v2',array('userid'=> $sid->userid));
            }
            else
            {
                  $sid2 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('First_Name' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name,'Mother_Mobile' => $rrr->Mother_Mobile))->row();
                   
                    if($sid2)
                    {
                      
                        $this->db->where('id',$rrr->id);
                        $this->db->update('tblday_booking_v2',array('userid'=> $sid2->userid));
               
                    }else{
                        
                         $sid3 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('First_Name' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name,'Mother_Name' => $rrr->Mother_Name))->row();
                    
                            if($sid3)
                            {
                                        
                                    $this->db->where('id',$rrr->id);
                                    $this->db->update('tblday_booking_v2',array('userid'=> $sid3->userid));
                            }else{
                                $sid4 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('First_Name' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Father_Name' => $rrr->Father_Name))->row();
                    
                                if($sid4)
                                {
                                                    
                                        $this->db->where('id',$rrr->id);
                                        $this->db->update('tblday_booking_v2',array('userid'=> $sid4->userid));
                                }else{
                                     $sid5 = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('First_Name' => $rrr->First_Name,'lastname' => $rrr->Last_Name,'Class' => $rrr->Class,'Mother_Name' => $rrr->Mother_Name))->row();
                    
                                        if($sid5)
                                        {
                                                                
                                            $this->db->where('id',$rrr->id);
                                            $this->db->update('tblday_booking_v2',array('userid'=> $sid5->userid));
                                        }else{
                                             array_push($responseNomatch, $rrr->Fathers_Mobile);
                                        }
                                }
                        }
                    }
               
            }
            
            
        }
        
        print_r($responseNomatch);
     
    }
    
    
    
     public function masterOrDayBooking__()
    {
         $totalStudent = $this->db->get_where(db_prefix().'student_package')->result();
    
        $response = [];
        $responseNomatch = [];
        foreach($totalStudent as $rrr)
        {
        
            $booking = $this->db->get_where(db_prefix().'day_booking_v2', array('userid' => $rrr->userid))->result();
            if(count($booking)>0){
                //$res = $this->db->get_where('tblstudent_fees_deposit',array('userid'=>$rrr->userid))->result();  
                
                $this->db->where('userid',$rrr->userid);
                $this->db->delete('tblstudent_fees_deposit');
            }
             foreach($booking as $boookingValue)
            {
                $tblstudent_fees_deposit['package_id']      = $rrr->package_id;
               $tblstudent_fees_deposit['userid']          = $rrr->userid;
                $tblstudent_fees_deposit['deposit_amount']  = $boookingValue->Pay_Amount_Admission_Fee_Paid;
                $tblstudent_fees_deposit['installment']     = 1;
                $tblstudent_fees_deposit['note']            = $boookingValue->Payment_Detail;
                $tblstudent_fees_deposit['payment_mode']    = $boookingValue->Payment_Mode;
                $tblstudent_fees_deposit['deposit_date']    = date('Y-m-d', strtotime($boookingValue->date));
                  $this->db->insert('tblstudent_fees_deposit',$tblstudent_fees_deposit);
               /* $res = $this->db->get_where('tblstudent_fees_deposit',array('userid'=>$sid->userid))->result();  
                if(count($res) > 0 ){
                    foreach($res as $resVal){
                        $this->db->where('id',$resVal->id);  
    		 		    $this->db->update('tblstudent_fees_deposit',$tblstudent_fees_deposit);
                    }
                }else{
                    
                }*/
            }
        }
    }
    
    function updateAdmissionYearOrAdmissionDate(){
        
        $res =   $this->db->query("SELECT * FROM `tblstudent_package`")->result();
      
      foreach($res as $rrr){
          $update['Academic_Year'] = $rrr->admission_year;
          $update['Admission_Year'] = $rrr->admission_year;
          
          $update['Date_of_Admission'] = $rrr->admission_date;
         // print_r($update);
          //die;
          $this->db->where('userid',$rrr->userid);
          $this->db->update('tblcontacts'.$this->contact_tbl,$update);
          echo $rrr->userid;
      }
        
    }
    
    function promoteClass__(){
      $res =   $this->db->select('classId')->group_by('classId')->get_where('tblcontacts'.$this->contact_tbl)->result();
     // echo  '<pre>';
     // print_r( $res);
       foreach($res  as $val){
           
           if($val->classId=='8'){
               $Class = 'Class II';
               $classId = '7';
               $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts'.$this->contact_tbl,array('Class'=>$Class,'classId'=>$classId));
           }
           
           if($val->classId=='7'){
                 $Class = 'Class III';
                  $classId = '6';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts'.$this->contact_tbl,array('Class'=>$Class,'classId'=>$classId));
           }
           
           
           if($val->classId=='6'){
                 $Class = 'Class IV';
                  $classId = '5';
                   $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts'.$this->contact_tbl,array('Class'=>$Class,'classId'=>$classId));
           }
           
           if($val->classId=='5'){
                 $Class = 'Class V';
                  $classId = '4';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts'.$this->contact_tbl,array('Class'=>$Class,'classId'=>$classId));
           }
           
           
           
           if($val->classId=='4'){
                 $Class = 'Class VI';
                  $classId = '3';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts'.$this->contact_tbl,array('Class'=>$Class,'classId'=>$classId));
           }
           
           
           if($val->classId=='3'){
                 $Class = 'Class VII';
                  $classId = '2';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts'.$this->contact_tbl,array('Class'=>$Class,'classId'=>$classId));
           }
           
           
           if($val->classId=='2'){
                 $Class = 'Class VIII';
                  $classId = '1';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts'.$this->contact_tbl,array('Class'=>$Class,'classId'=>$classId));
           }
           
           
           if($val->classId=='1'){
                 $Class = 'Class IX';
                  $classId = '13';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts'.$this->contact_tbl,array('Class'=>$Class,'classId'=>$classId));
           }
           
           
            if($val->classId=='10'){
                 $Class = 'UKG';
                  $classId = '9';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts'.$this->contact_tbl,array('Class'=>$Class,'classId'=>$classId));
           }
           
           
            if($val->classId=='11'){
                 $Class = 'LKG';
                  $classId = '10';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts'.$this->contact_tbl,array('Class'=>$Class,'classId'=>$classId));
           }
           
           
            if($val->classId=='12'){
                 $Class = 'Nursery';
                  $classId = '11';
                  $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts'.$this->contact_tbl,array('Class'=>$Class,'classId'=>$classId));
           }
           
            if($val->classId=='9'){
                 $Class = 'Class I';
                  $classId = '8';
                   $this->db->where('classId',$val->classId);
                    $this->db->update('tblcontacts'.$this->contact_tbl,array('Class'=>$Class,'classId'=>$classId));
                    echo  $this->db->last_query();
           }
          
            
       }
    }
    
    function promoteClassInContact___(){
      $res =   $this->db->select('Class,userid')->get_where('tblcontacts'.$this->contact_tbl)->result();
     // print_r( $res);
      foreach($res  as $val){
         // echo  $val->Class;
         $this->db->insert('tblpromote',array('userid'=>$val->userid,'session'=>'2020-21','class'=>$val->Class));
           
      }
    }
    
    /* New Student Add */
    public function newStudentAdd()
    {
        if($this->input->post())
        {
            $data = $this->input->post();
            //echo '<pre>'; print_r($data); die();
            //$sdata['password']                      = app_hash_password($data['password']);
            //$sdata['paa']                           = $data['password'];
			/*
			if($data['Father_Mobile'] != '')
			{
				
				$data['email'] = strtolower(substr($data['firstname'], 0, 3)).''.substr($data['Father_Mobile'], -5);
			}
			elseif($data['Mother_Mobile'] != '')
			{
				$data['email'] = strtolower(substr($data['firstname'], 0, 3)).''.substr($data['Mother_Mobile'], -5);
			}
			else
			{
				$data['email'] = strtolower(substr($data['firstname'], 0, 3)).''.rand(1000,9999);
			}
			$data['paa'] = strtolower($data['firstname'].'123');
			$data['password'] = app_hash_password(@$data['paa']);
            */
            $exApplicationForm = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Form_No' => $data['Form_No']))->num_rows();
            if($exApplicationForm > 0){
                $message = _l('This application number is already exist');
                echo json_encode([
                    'success' => false,
                    'message' => $message,
                ]);
                exit();
            }
            $sdata['invoice_emails']                = 1;
            $sdata['estimate_emails']               = 1;
            $sdata['credit_note_emails']            = 1;
            $sdata['contract_emails']               = 1;
            $sdata['task_emails']                   = 1;
            $sdata['project_emails']                = 1;
            $sdata['ticket_emails']                 = 1;
            $sdata['Form_No']                       = $data['Form_No'];
            $sdata['Academic_Year']                 = $data['Academic_Year'];
            $sdata['Admission_Year']                = $data['Admission_Year'];
            $sdata['scholar_no']                    = $data['scholar_no'];
            $sdata['TC']                            = $data['TC'];
            $sdata['caste_certificate']             = $data['caste_certificate'];
            $sdata['Pincode']                       = $data['zip_code'];
            $sdata['Date_of_Admission']             = $data['Date_of_Admission'];
			
			$sdata['firstname'] 					= ucwords(strtolower(@$data['first_name']));
			$sdata['middlename'] 					= ucwords(strtolower(@$data['middlename']));
			$sdata['lastname'] 						= ucwords(strtolower(@$data['last_name']));
						
            $sdata['Class']                         = $data['Class'];
            $sdata['Campus']                        = $data['Campus'];
            $sdata['Shift']                         = $data['Shift'];
            $sdata['Date_of_Birth']                 = $data['Date_of_Birth'];
            $sdata['Place_Of_Birth']                = $data['Place_Of_Birth'];
            $sdata['Religion']                      = $data['Religion'];
            $sdata['Nationality']                   = $data['Nationality'];
            $sdata['Caste']                         = $data['Caste'];
            $sdata['Mother_Tongue']                 = $data['Mother_Tongue'];
            $sdata['Birth_Certificate']             = $data['Birth_Certificate'];
            $sdata['Aadhar_Card']                   = $data['Aadhar_Card'];
            $sdata['Samagra_ID']                    = $data['Samagra_ID'];
            $sdata['phonenumber']                   = $data['phonenumber'];
            $sdata['student_address']               = $data['student_address'];
            $sdata['bank_name']                     = $data['bank_name'];
            $sdata['bank_account_number']           = $data['bank_account_number'];
            $sdata['IFSC_code']                     = $data['IFSC_code'];
            $sdata['Gender']                        = $data['Gender'];
			$sdata['email_verified_at'] 			= date('Y-m-d H:i:s');
			$sdata['datecreated'] 					= date('Y-m-d H:i:s');
            
            if($data['userid']!=''){
                $this->db->where('userid',$data['userid']);
                $this->db->update(db_prefix().'contacts'.$this->contact_tbl,$sdata);
                 $message = _l('Student update successfully');
                    echo json_encode([
                        'success' => true,
                        'message' => $message,
                        'userid'        => $data['userid'],
                    ]);
            
                exit();
            }
            
            $clientdata['company'] = $data['first_name'].' '.$data['middlename'].' '.$data['last_name'];
            $clientdata['phonenumber'] = $data['phonenumber'];
            $clientdata['zip'] = $data['zip_code'];
            $clientdata['datecreated'] = date('Y-m-d H:i:s');
            $clientdata['active'] = 1;
            $clientdata['registration_confirmed'] = 1;
            $clientdata['addedfrom'] = 1;
            
            $this->db->insert('tblclients', $clientdata);
            $uid = $this->db->insert_id();
            if($uid)
            {                  
				if($this->academic_session == '2022-23' || $this->academic_session == '2023-24' || $this->academic_session == '2024-25')
				{
					$sdata['id'] = $uid;					
				}
                $sdata['userid'] = $uid;
                $reg2 = 'ISB1120';
                
                if($data['Class']=='Playgroup'){
                    $CID ='01';
                }  
                if($data['Class']=='Nursery'){
                    $CID ='02';
                }
                if($data['Class']=='LKG'){
                    $CID ='03';
                } 
                if($data['Class']=='UKG'){
                    $CID ='04';
                } 
                if($data['Class']=='Class I'){
                    $CID ='05';
                } 
                if($data['Class']=='Class II'){
                    $CID ='06';
                }        
                if($data['Class']=='Class III'){
                    $CID ='07';
                }        
                if($data['Class']=='Class IV'){
                    $CID ='08';
                }
                if($data['Class']=='Class V'){
                    $CID ='09';
                }        
                if($data['Class']=='Class VI'){
                    $CID ='10';
                }
                if($data['Class']=='Class VII'){
                    $CID ='11';
                }   
                if($data['Class']=='Class VIII'){
                    $CID ='12';
                }  
                if($data['Class']=='Class IX'){
                    $CID ='13';
                }  
                if($data['Class']=='Class X'){
                    $CID ='14';
                }  
                if($data['Class']=='Class XI'){
                    $CID ='15';
                }  
                if($data['Class']=='Class XII'){
                    $CID ='16';
                }
                $resClass =  $this->db->order_by('id', 'desc')->get_where(db_prefix().'contacts'.$this->contact_tbl, array('Class' => $data['Class']))->row('registration_id');
                $resClass_ = substr($resClass, -3);
                $resClass_ = $resClass_ + 1;
                $invID = str_pad($resClass_, 3, '0', STR_PAD_LEFT);
                $reg = $reg2.$CID.$invID;
                
                $sdata['registration_id']  = $reg;
                $sdata['payment_status']  = 0;
                $sdata['Old_student_New_student']  = 'New';

                /*              
                $invID = str_pad($uid, 4, '0', STR_PAD_LEFT);
                $nemail = 'isb'.$invID;
                $sdata['email'] = $nemail;
                $new_password = str_replace(' ','',$data['first_name'].'123');
                $sdata['paa'] = $new_password;
                $sdata['password'] = app_hash_password(@$sdata['paa']);
                */
                
                $this->db->insert('tblcontacts'.$this->contact_tbl, $sdata);
                for($permission = 1; $permission < 7; $permission++)
                {
                    $this->db->insert(db_prefix() . 'contact_permissions', [
                        'userid'        => $uid,
                        'permission_id' => $permission,
                    ]);
                }
            }
            //$this->clients_model->add_($data, false);
            $message = _l('Student add successfully');
            echo json_encode([
                'success' => true,
                'message' => $message,
                'userid'  => $uid,
            ]);
        }
        else
        {
            $message = _l('Data not found');
            echo json_encode([
                'success' => false,
                'message' => $message,
            ]);
        }
    }
    
	function studentPassUpdate()
	{
		$studentData = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid >' => 3667, 'userid <' => 3802))->result_array();
		if($studentData)
		{
			foreach($studentData as $res)
			{
				if($res['Father_Mobile'] != '')
				{			
					$sdata['email'] = strtolower(substr($res['firstname'], 0, 3)).''.substr($res['Father_Mobile'], -5);
				}
				elseif($res['Mother_Mobile'] != '')
				{
					$sdata['email'] = strtolower(substr($res['firstname'], 0, 3)).''.substr($res['Mother_Mobile'], -5);
				}
				else
				{
					$sdata['email'] = strtolower(substr($res['firstname'], 0, 3)).''.rand(1000,9999);
				}
				$sdata['datecreated'] = date('Y-m-d H:i:s');
				$sdata['email_verified_at'] = date('Y-m-d H:i:s');
				$sdata['paa'] = str_replace(' ','', strtolower($res['firstname'].'123'));
				$sdata['password'] = app_hash_password(@$sdata['paa']);
				$this->db->where('userid',$res['userid']);
            	$this->db->update(db_prefix().'contacts'.$this->contact_tbl,$sdata);        
			}
		}
	}

    /************************************************************************************************************
     * @Function: Student password update
    ************************************************************************************************************/
    function studentPasswordUpdate()
    {
        $studentData = $this->db->limit(500, 5000)->get_where(db_prefix().'contacts'.$this->contact_tbl)->result_array();
        if($studentData)
        {
            foreach($studentData as $res)
            {
                $npass = preg_replace('/[^a-zA-Z0-9_\- ]/', '', strtolower($res['firstname']));
                $sdata['paa'] = str_replace(' ','', $npass.'123');
                $sdata['password'] = app_hash_password(@$sdata['paa']);
                $this->db->where('userid',$res['userid']);
                $this->db->update(db_prefix().'contacts'.$this->contact_tbl,$sdata);        
            }
        }
    }
	
    function updateParentDetail(){
    
        if($this->input->post())
        {
            $data = $this->input->post();
			$first_name = $this->db->get_where(db_prefix().'contacts'.$this->contact_tbl, array('userid' => $data['userid']))->row('firstname');
			/*if($data['Father_Mobile'] != '')
			{
				
				$sdata['email'] = strtolower(substr($first_name, 0, 3)).''.substr($data['Father_Mobile'], -5);
			}
			elseif($data['Mother_Mobile'] != '')
			{
				$sdata['email'] = strtolower(substr($first_name, 0, 3)).''.substr($data['Mother_Mobile'], -5);
			}
			else
			{
				$sdata['email'] = strtolower(substr($first_name, 0, 3)).''.rand(1000,9999);
			}*/
            $invID = str_pad($data['userid'], 4, '0', STR_PAD_LEFT);
            $nemail = 'isb'.$invID;
            $sdata['email'] = $nemail;
            
			$sdata['paa'] = strtolower($first_name.'123');
			$sdata['password'] = app_hash_password(@$sdata['paa']);
			
			$sdata['Father_Name'] 					= ucwords(strtolower(@$data['Father_Name']));
			$sdata['Mother_Name'] 					= ucwords(strtolower(@$data['Mother_Name']));
			$sdata['Father_Mobile'] 				= @$data['Father_Mobile'];
			$sdata['Mother_Mobile'] 				= @$data['Mother_Mobile'];
			
            $sdata['Father_Email']                      = $data['Father_Email'];
            $sdata['Father_Qualification']              = $data['Father_Qualification'];
            $sdata['Father_Others_Qualification']       = $data['Father_Others_Qualification'];
            $sdata['Father_Occupation']                 = $data['Father_Occupation'];
            $sdata['Father_Designation']                = $data['Father_Designation'];
            $sdata['Mother_Email']                      = $data['Mother_Email'];
            $sdata['Mother_Qualification']              = $data['Mother_Qualification'];
            $sdata['Mother_Others_Qualification']       = $data['Mother_Others_Qualification'];
            $sdata['Mother_Occupation']                 = $data['Mother_Occupation'];
            $sdata['Mother_Designation']                = $data['Mother_Designation'];
            $sdata['Gaurdian_Name']                     = $data['Gaurdian_Name'];
            $sdata['Gaurdian_Mobile_no']                = $data['Gaurdian_Mobile_no'];
            $sdata['Gaurdian_Qualification']            = $data['Gaurdian_Qualification'];
            $sdata['Gaurdian_Name_Of_Employer']         = $data['Gaurdian_Name_Of_Employer'];
            $sdata['Gaurdian_Occupation']               = $data['Gaurdian_Occupation'];
            $sdata['Gaurdian_Designation']              = $data['Gaurdian_Designation'];
            $sdata['Emergency_Communication_To']        = $data['Emergency_Communication_To'];
            $sdata['Emergency_Conatact_Mobile']         = $data['Emergency_Conatact_Mobile'];
            if($data['userid']!=''){
                $this->db->where('userid',$data['userid']);
                $this->db->update(db_prefix().'contacts'.$this->contact_tbl,$sdata);
                 $message = _l('Student detail updated successfully');
                    echo json_encode([
                        'success' => true,
                        'message' => $message,
                        'userid'        => $data['userid'],
                    ]);
            
                exit();
            } 
            else{
                $message = _l('Data not found');
                echo json_encode([
                    'success' => false,
                    'message' => $message,
                ]);
            }
        }    
        else
        {
            $message = _l('Data not found');
            echo json_encode([
                'success' => false,
                'message' => $message,
            ]);
        }
    }
    
     /* Miscellaneous datails update */
    public function miscellaneousDetailsUpdate($userID)
    {
        if ($this->input->post()) {
            $data = $this->input->post();
             if($userID!=''){
                $existResult = $this->db->get_where(db_prefix().'student_miscellaneous', array('userId' => $userID))->row('id');
                if($existResult)
                {
                    $postData = $this->input->post();
                    $this->db->where('userid',$userID);
                    $this->db->update(db_prefix().'student_miscellaneous',  $postData);
                    
                    $message = _l('Miscellaneous detail updated successfully');
                    // echo json_encode([
                    //     'success' => true,
                    //     'message' => $message,
                    //     'userid'  => $userID,
                    // ]);
            
                }
                else
                {
                    $postData = $this->input->post();
                    $postData['userId'] = $userID;
                    $this->db->insert(db_prefix().'student_miscellaneous',  $postData);
                    $this->db->insert_id();
                    
                    $message = _l('Miscellaneous detail added successfully');
                    // echo json_encode([
                    //     'success' => true,
                    //     'message' => $message,
                    //     'userid'  => $userID,
                    // ]);
                }
             }else{
                $message = _l('Data not found');
                // echo json_encode([
                //     'success' => false,
                //     'message' => $message,
                // ]);
            }  
        }else
        {
            $message = _l('Data not found');
            // echo json_encode([
            //     'success' => false,
            //     'message' => $message,
            // ]);
        }
        set_alert('success', $message);
        redirect($_SERVER['HTTP_REFERER']);
    }
    function studentFeesDeposite__12(){
        
        $res = $this->db->get_where('tblstudent_fees_deposit')->result();
        foreach($res as $vl){
            // // $this->db->insert('tblstudent_fees_invoice',array('package_id'=>$vl->package_id,'note'=>$vl->note,'deposit_amount'=>$vl->deposit_amount,'academic_year'=>$vl->academic_year,'userid'=>$vl->userid,'created_date'=>date('Y-m-d',strtotime($vl->deposit_date))));
            // // $insert_id =  $this->db->insert_id();
            
            // $this->db->where('id',$vl->id);
            // $this->db->update('tblstudent_fees_deposit',array('invoice_id'=>$insert_id));
            
            $this->db->where('id',$vl->invoice_id);
            $this->db->update('tblstudent_fees_invoice',array('deposit_date'=>$vl->deposit_date));
        }
    }
}
